/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.EndPoint;
import com.datastax.driver.core.exceptions.CoordinatorException;
import com.datastax.driver.core.exceptions.QueryValidationException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class UnpreparedException
extends QueryValidationException
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    private final EndPoint endPoint;

    public UnpreparedException(EndPoint endPoint, String message) {
        super(String.format("A prepared query was submitted on %s but was not known of that node: %s", endPoint, message));
        this.endPoint = endPoint;
    }

    private UnpreparedException(EndPoint endPoint, String message, UnpreparedException cause) {
        super(message, cause);
        this.endPoint = endPoint;
    }

    @Override
    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    @Override
    @Deprecated
    public InetSocketAddress getAddress() {
        return this.endPoint == null ? null : this.endPoint.resolve();
    }

    @Override
    @Deprecated
    public InetAddress getHost() {
        return this.endPoint == null ? null : this.endPoint.resolve().getAddress();
    }

    @Override
    public UnpreparedException copy() {
        return new UnpreparedException(this.endPoint, this.getMessage(), this);
    }
}

