/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase.model;

import com.couchbase.client.java.document.json.JsonObject;
import com.dbeaver.db.couchbase.model.CouchbaseDataSource;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class CouchbaseNode
implements DBSObject {
    private static final Log log = Log.getLog(CouchbaseNode.class);
    private static final String CAT_HEALTH = "Health";
    private static final String CAT_STATS = "Statistics";
    private final CouchbaseDataSource dataSource;
    private JsonObject nodeDesc;

    public CouchbaseNode(CouchbaseDataSource dataSource, JsonObject nodeDesc) {
        this.dataSource = dataSource;
        this.nodeDesc = nodeDesc;
    }

    @NotNull
    public CouchbaseDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return this.nodeDesc.getString("hostname");
    }

    @Property(viewable=true, editable=true, order=2)
    public String getStatus() {
        return this.nodeDesc.getString("status");
    }

    @Property(viewable=true, editable=true, order=3)
    public String getVersion() {
        return this.nodeDesc.getString("version");
    }

    @Property(viewable=true, editable=true, order=4)
    public String getOS() {
        return this.nodeDesc.getString("os");
    }

    @Property(viewable=true, editable=true, order=5)
    public String getUptime() {
        return this.nodeDesc.getString("uptime");
    }

    @Property(viewable=true, editable=true, category="Health", order=2)
    public Integer getCpuCount() {
        return this.nodeDesc.getInt("cpuCount");
    }

    @Property(viewable=true, editable=true, category="Health", order=20)
    public Number getMemoryFree() {
        return this.nodeDesc.getLong("memoryFree");
    }

    @Property(viewable=true, editable=true, category="Health", order=21)
    public Number getMemoryTotal() {
        return this.nodeDesc.getLong("memoryTotal");
    }

    @Property(viewable=true, editable=true, category="Health", order=22)
    public Number getMcdMemoryAllocated() {
        return this.nodeDesc.getLong("mcdMemoryAllocated");
    }

    @Property(viewable=true, editable=true, category="Health", order=23)
    public Number getMcdMemoryReserved() {
        return this.nodeDesc.getLong("mcdMemoryReserved");
    }

    @Property(viewable=true, editable=true, category="Statistics", order=51)
    public JsonObject getSystemStats() {
        return this.nodeDesc.getObject("systemStats");
    }

    @Property(viewable=true, editable=true, category="Statistics", order=52)
    public JsonObject getInterestingStats() {
        return this.nodeDesc.getObject("interestingStats");
    }

    @Property(viewable=true, editable=true, category="Statistics", order=53)
    public JsonObject getPorts() {
        return this.nodeDesc.getObject("ports");
    }

    @Property(viewable=true, editable=true, category="Statistics", order=54)
    public Number getClusterCompatibility() {
        return this.nodeDesc.getLong("clusterCompatibility");
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public boolean isPersisted() {
        return true;
    }
}

