/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase.model;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.bucket.BucketType;
import com.couchbase.client.java.cluster.BucketSettings;
import com.couchbase.client.java.cluster.CompressionMode;
import com.couchbase.client.java.cluster.EjectionMethod;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.N1qlQueryResult;
import com.couchbase.client.java.query.N1qlQueryRow;
import com.dbeaver.db.couchbase.CouchbaseUtils;
import com.dbeaver.db.couchbase.data.CouchbaseDocument;
import com.dbeaver.db.couchbase.exec.CouchbaseExecutionContext;
import com.dbeaver.db.couchbase.exec.CouchbaseQueryStatementN1;
import com.dbeaver.db.couchbase.exec.CouchbaseResultSetN1;
import com.dbeaver.db.couchbase.exec.CouchbaseSession;
import com.dbeaver.db.couchbase.model.CouchbaseBucketIndex;
import com.dbeaver.db.couchbase.model.CouchbaseDataSource;
import com.dbeaver.ee.model.document.DBAbstractDocumentContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBFetchProgress;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.BasicObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraint;

public class CouchbaseBucket
extends DBAbstractDocumentContainer<CouchbaseDataSource>
implements DBSEntity,
DBPSaveableObject,
DBPNamedObject2,
DBPRefreshableObject,
DBSDataContainer {
    private static final Log log = Log.getLog(CouchbaseBucket.class);
    private static final String CAT_MISC = "Misc";
    private static final String CAT_STORAGE = "Storage";
    private String tableName;
    private boolean persisted;
    private final IndexCache indexCache = new IndexCache();
    private volatile Bucket bucket;
    private volatile BucketSettings bucketSettings;
    private Long docCount;

    public CouchbaseBucket(CouchbaseDataSource dataSource, BucketSettings bucketSettings, boolean persisted) {
        super((DBPDataSource)dataSource);
        this.bucketSettings = bucketSettings;
        this.persisted = persisted;
    }

    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return this.bucketSettings.name();
    }

    public void setName(String newName) {
        this.tableName = newName;
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return ((CouchbaseDataSource)this.dataSource).getContainer();
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    @Property(viewable=true, order=2)
    public BucketType getBucketType() {
        return this.bucketSettings.type();
    }

    @Property(viewable=true, order=10)
    public int getQuota() {
        return this.bucketSettings.quota();
    }

    @Property(viewable=true, order=20, category="Misc")
    public int getPort() {
        return this.bucketSettings.port();
    }

    @Property(viewable=true, order=21, category="Misc")
    public String getPassword() {
        return this.bucketSettings.password();
    }

    @Property(viewable=true, order=30, category="Storage")
    public int getReplicas() {
        return this.bucketSettings.replicas();
    }

    @Property(viewable=true, order=31, category="Storage")
    public boolean getIndexReplicas() {
        return this.bucketSettings.indexReplicas();
    }

    @Property(viewable=true, order=32, category="Storage")
    public boolean getEnableFlush() {
        return this.bucketSettings.enableFlush();
    }

    @Property(viewable=true, order=33, category="Storage")
    public CompressionMode getCompressionMode() {
        return this.bucketSettings.compressionMode();
    }

    @Property(viewable=true, order=34, category="Storage")
    public EjectionMethod getEjectionMethod() {
        return this.bucketSettings.ejectionMethod();
    }

    @Property(viewable=true, order=25, category="Misc")
    public Map<String, Object> getCustomSettings() {
        return this.bucketSettings.customSettings();
    }

    public String toString() {
        return this.getName();
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.indexCache.clearCache();
        this.docCount = null;
        return this;
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.TABLE;
    }

    public Collection<? extends DBSTableConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getIndexes(monitor);
    }

    @Association
    @NotNull
    public Collection<? extends DBSTableConstraint> getIndexes(@NotNull DBRProgressMonitor monitor) throws DBCException {
        return this.indexCache.getAllObjects(monitor, this);
    }

    public int getSupportedFeatures() {
        return 5;
    }

    @NotNull
    public DBCStatistics readData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
        DBCStatistics statistics;
        block18: {
            statistics = new DBCStatistics();
            long startTime = System.currentTimeMillis();
            DBRProgressMonitor monitor = session.getProgressMonitor();
            monitor.beginTask("Read documents from bucket", 1);
            monitor.subTask("Open bucket '" + this.getName() + "'");
            try {
                monitor.subTask("Select documents");
                StringBuilder sql = new StringBuilder();
                sql.append("SELECT * FROM `").append(this.getName()).append("`");
                SQLUtils.appendQueryConditions((DBPDataSource)this.dataSource, (StringBuilder)sql, null, (DBDDataFilter)dataFilter);
                SQLUtils.appendQueryOrder((DBPDataSource)this.dataSource, (StringBuilder)sql, null, (DBDDataFilter)dataFilter);
                if (firstRow > 0L) {
                    sql.append(" OFFSET ").append(firstRow);
                }
                if (maxRows > 0L) {
                    sql.append(" LIMIT ").append(maxRows);
                }
                Throwable throwable = null;
                Object var18_15 = null;
                try (CouchbaseQueryStatementN1 statement = new CouchbaseQueryStatementN1((CouchbaseSession)session, this, sql.toString());){
                    statement.setLimit(firstRow, maxRows);
                    boolean hasResults = statement.executeStatement();
                    statistics.addExecuteTime(System.currentTimeMillis() - startTime);
                    if (!hasResults) break block18;
                    DBFetchProgress fetchProgress = new DBFetchProgress(session.getProgressMonitor());
                    CouchbaseResultSetN1 resultSetN1 = statement.openResultSet();
                    try {
                        dataReceiver.fetchStart(session, (DBCResultSet)resultSetN1, firstRow, maxRows);
                        while (resultSetN1.nextRow() && !monitor.isCanceled()) {
                            dataReceiver.fetchRow(session, (DBCResultSet)resultSetN1);
                            fetchProgress.monitorRowFetch();
                        }
                        fetchProgress.dumpStatistics(statistics);
                    }
                    finally {
                        dataReceiver.fetchEnd(session, (DBCResultSet)resultSetN1);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                monitor.done();
            }
        }
        return statistics;
    }

    public Bucket getBucket() {
        if (this.bucket != null) {
            return this.bucket;
        }
        this.bucket = ((CouchbaseExecutionContext)((CouchbaseDataSource)this.dataSource).getDefaultContext()).getCluster().openBucket(this.bucketSettings.name());
        return this.bucket;
    }

    public void close() {
        if (this.bucket != null) {
            try {
                this.bucket.close();
            }
            catch (Exception e) {
                log.debug((Object)"Error closing bucket", (Throwable)e);
            }
            this.bucket = null;
        }
    }

    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, DBDDataFilter dataFilter, long flags) throws DBCException {
        block27: {
            if (this.docCount != null) {
                return this.docCount;
            }
            DBRProgressMonitor monitor = session.getProgressMonitor();
            monitor.beginTask("Read documents from bucket", 1);
            monitor.subTask("Open bucket '" + this.getName() + "'");
            try {
                monitor.subTask("Select documents");
                StringBuilder sql = new StringBuilder();
                sql.append("SELECT COUNT(*) FROM `").append(this.getName()).append("`");
                SQLUtils.appendQueryConditions((DBPDataSource)this.dataSource, (StringBuilder)sql, null, (DBDDataFilter)dataFilter);
                SQLUtils.appendQueryOrder((DBPDataSource)this.dataSource, (StringBuilder)sql, null, (DBDDataFilter)dataFilter);
                Throwable throwable = null;
                Object var9_9 = null;
                try (CouchbaseQueryStatementN1 statement = new CouchbaseQueryStatementN1((CouchbaseSession)session, this, sql.toString());){
                    boolean hasResults = statement.executeStatement();
                    if (!hasResults) break block27;
                    new DBFetchProgress(session.getProgressMonitor());
                    Throwable throwable2 = null;
                    Object var13_15 = null;
                    try (CouchbaseResultSetN1 resultSetN1 = statement.openResultSet();){
                        if (resultSetN1.nextRow()) {
                            Object countValue = resultSetN1.getAttributeValue(0);
                            if (countValue instanceof CouchbaseDocument) {
                                countValue = ((CouchbaseDocument)((Object)countValue)).getAttributeValue("$1");
                            }
                            if (countValue instanceof Number) {
                                this.docCount = ((Number)countValue).longValue();
                            } else {
                                log.debug((Object)("Unsupported count value: " + countValue));
                                this.docCount = -1L;
                            }
                        } else {
                            log.debug((Object)"Can't retrieve document count");
                            this.docCount = -1L;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            finally {
                monitor.done();
            }
        }
        return this.docCount;
    }

    public class AttributeCache
    extends BasicObjectCache<CouchbaseBucket, DBSEntityAttribute> {
        @NotNull
        public List<DBSEntityAttribute> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable CouchbaseBucket table) throws DBCException {
            return this.getCachedObjects();
        }
    }

    public class IndexCache
    extends BasicObjectCache<CouchbaseBucket, CouchbaseBucketIndex> {
        @NotNull
        public List<CouchbaseBucketIndex> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable CouchbaseBucket bucket) throws DBCException {
            if (!this.isFullyCached()) {
                ArrayList<CouchbaseBucketIndex> result = new ArrayList<CouchbaseBucketIndex>();
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (CouchbaseSession session = ((CouchbaseExecutionContext)((CouchbaseDataSource)CouchbaseBucket.this.getDataSource()).getDefaultContext()).openSession(monitor, DBCExecutionPurpose.META, "Read bucket indexes");){
                        N1qlQueryResult query = CouchbaseBucket.this.getBucket().query((N1qlQuery)N1qlQuery.simple((String)("SELECT * FROM system:indexes where keyspace_id='" + CouchbaseBucket.this.getName() + "'")));
                        CouchbaseUtils.checkAndThrowError(session.getExecutionContext(), query.errors());
                        Iterator rows = query.rows();
                        while (rows.hasNext()) {
                            N1qlQueryRow indexRow = (N1qlQueryRow)rows.next();
                            CouchbaseBucketIndex index = new CouchbaseBucketIndex(CouchbaseBucket.this, indexRow.value().getObject("indexes"));
                            result.add(index);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable e) {
                    log.debug((Object)"Error reading bucket indexes", e);
                }
                result.sort(DBUtils.nameComparator());
                this.setCache(result);
            }
            return this.getCachedObjects();
        }
    }
}

