/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase.exec;

import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.N1qlQueryResult;
import com.dbeaver.db.couchbase.CouchbaseUtils;
import com.dbeaver.db.couchbase.exec.CouchbaseAbstractStatement;
import com.dbeaver.db.couchbase.exec.CouchbaseResultSetN1;
import com.dbeaver.db.couchbase.exec.CouchbaseSession;
import com.dbeaver.db.couchbase.model.CouchbaseBucket;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class CouchbaseQueryStatementN1
extends CouchbaseAbstractStatement {
    private static final Log log = Log.getLog(CouchbaseQueryStatementN1.class);
    private final CouchbaseBucket bucket;
    private final String queryText;
    private long offset;
    private long limit;
    private CouchbaseResultSetN1 resultSet;

    public CouchbaseQueryStatementN1(CouchbaseSession session, CouchbaseBucket bucket, String queryText) {
        super(session);
        this.bucket = bucket;
        this.queryText = queryText;
        if (session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementOpen((DBCStatement)this);
        }
    }

    public String getQueryString() {
        return this.queryText;
    }

    public boolean executeStatement() throws DBCException {
        if (((CouchbaseSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        Exception executeError = null;
        try {
            N1qlQueryResult query = this.bucket.getBucket().query((N1qlQuery)N1qlQuery.simple((String)this.queryText));
            CouchbaseUtils.checkAndThrowError(((CouchbaseSession)this.getSession()).getExecutionContext(), query.errors());
            this.resultSet = new CouchbaseResultSetN1(this, query.rows(), this.getLimit());
            return true;
        }
        catch (Exception e) {
            executeError = e;
            if (e instanceof DBCException) {
                throw (DBCException)e;
            }
            throw new DBCException(GeneralUtils.getRootCause((Throwable)e), (DBCExecutionContext)((CouchbaseSession)this.getSession()).getExecutionContext());
        }
        finally {
            if (((CouchbaseSession)this.getSession()).isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, (long)this.getUpdateRowCount(), (Throwable)executeError);
            }
        }
    }

    public void addToBatch() throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public int[] executeStatementBatch() throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public CouchbaseResultSetN1 openResultSet() throws DBCException {
        return this.resultSet;
    }

    public DBCResultSet openGeneratedKeysResultSet() throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public int getUpdateRowCount() {
        return -1;
    }

    public boolean nextResults() throws DBCException {
        return false;
    }

    public void close() {
        if (((CouchbaseSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementClose((DBCStatement)this, (long)this.getUpdateRowCount());
        }
    }

    public void setLimit(long offset, long limit) throws DBCException {
        this.offset = offset;
        this.limit = limit;
    }

    @Nullable
    public Throwable[] getStatementWarnings() throws DBCException {
        return null;
    }

    public void setStatementTimeout(int timeout) throws DBCException {
    }

    public void setResultsFetchSize(int fetchSize) throws DBCException {
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        if (blockThread != null) {
            blockThread.interrupt();
        } else if (this.bucket != null) {
            this.bucket.close();
        }
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLimit() {
        return this.limit;
    }

    @Override
    public String getEntityName() {
        return this.bucket.getName();
    }
}

