/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase;

import com.dbeaver.db.couchbase.model.CouchbaseDataSource;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceProvider;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class CouchbaseDataSourceProvider
implements DBPDataSourceProvider {
    private static final Log log = Log.getLog(CouchbaseDataSourceProvider.class);

    public void init(@NotNull DBPPlatform platform) {
    }

    public long getFeatures() {
        return 2L;
    }

    public DBPPropertyDescriptor[] getConnectionProperties(DBRProgressMonitor monitor, DBPDriver driver, DBPConnectionConfiguration connectionInfo) throws DBException {
        return new DBPPropertyDescriptor[]{new PropertyDescriptor("Timeouts", "couchbase.connectionTimeout", "Connection Timeout", "The default timeout for connect operations.", Long.class, false, (Object)5000, null, true), new PropertyDescriptor("Timeouts", "couchbase.analyticsTimeout", "Analytics Timeout", "The default timeout for analytics operations.", Long.class, false, (Object)75000, null, true), new PropertyDescriptor("Timeouts", "couchbase.kvTimeout", "KV Timeout", "The default timeout for binary (key/value) operations.", Long.class, false, (Object)2500, null, true), new PropertyDescriptor("Timeouts", "couchbase.queryTimeout", "Query Timeout", "The default timeout for query operations.", Long.class, false, (Object)75000, null, true), new PropertyDescriptor("Timeouts", "couchbase.managementTimeout", "Management Timeout", "The default timeout for management operations.", Long.class, false, (Object)75000, null, true), new PropertyDescriptor("Timeouts", "couchbase.searchTimeout", "Search Timeout", "The default timeout for search operations.", Long.class, false, (Object)75000, null, true), new PropertyDescriptor("Timeouts", "couchbase.viewTimeout", "View Timeout", "The default timeout for view operations.", Long.class, false, (Object)75000, null, true), new PropertyDescriptor("SSL", "couchbase.sslEnabled", "SSL enabled", "Enables SSL connection.", Boolean.class, false, (Object)false, null, true), new PropertyDescriptor("SSL", "couchbase.sslKeystoreFile", "Keystore file", "SSL keystore file.", String.class, false, null, null, true), new PropertyDescriptor("SSL", "couchbase.sslKeystorePassword", "Keystore password", "SSL keystore password.", String.class, false, null, null, true)};
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        return "couchbase://" + connectionInfo.getHostName() + ":" + connectionInfo.getHostPort();
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new CouchbaseDataSource(monitor, container);
    }
}

