/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import oracle.xml.util.XMLError;

public class XMLException
extends Exception {
    private XMLError error;
    private String mesg;
    private String sysId;
    private String pubId;
    private int type;
    private Exception exception;
    public static final int ERROR = 1;
    public static final int FATAL_ERROR = 0;
    public static final int WARNING = 2;

    XMLException() {
    }

    public XMLException(String string, Throwable throwable) {
        this.mesg = string;
        if (throwable instanceof Exception) {
            this.exception = (Exception)throwable;
        }
    }

    public XMLException(String string, String string2, String string3, int n, int n2, int n3) {
        super(string);
        this.pubId = string2;
        this.sysId = string3;
        this.mesg = string;
        this.type = n3;
    }

    public XMLException(XMLError xMLError, int n) {
        super(xMLError.formatErrorMesg(n));
        this.error = xMLError;
        this.exception = xMLError.getException(n);
    }

    public XMLException(XMLError xMLError, int n, Exception exception) {
        super(xMLError.formatErrorMesg(n));
        this.exception = exception;
        this.error = xMLError;
    }

    public XMLException(XMLError xMLError, Exception exception) {
        super(xMLError.formatErrorMesg(0));
        this.exception = exception;
        this.error = xMLError;
    }

    public int getNumMessages() {
        if (this.error == null) {
            return 1;
        }
        return this.error.nerrors;
    }

    public String getMessage(int n) {
        if (this.error == null) {
            return this.mesg;
        }
        return this.error.mesg[n];
    }

    public String formatErrorMessage(int n) {
        if (this.error == null) {
            return this.mesg;
        }
        return this.error.formatErrorMesg(n);
    }

    public int getLineNumber(int n) {
        if (this.error == null) {
            return 0;
        }
        return this.error.line[n];
    }

    public int getColumnNumber(int n) {
        if (this.error == null) {
            return 0;
        }
        return this.error.col[n];
    }

    public String getSystemId(int n) {
        if (this.error == null) {
            return null;
        }
        return this.error.sysId[n];
    }

    public String getPublicId(int n) {
        if (this.error == null) {
            return this.pubId;
        }
        return this.error.pubId[n];
    }

    public Exception getException(int n) {
        if (this.error == null) {
            return this.exception;
        }
        return this.error.exp[n];
    }

    @Override
    public Throwable getCause() {
        if (this.error == null) {
            return this.exception;
        }
        return this.error.lastExp;
    }

    public int getMessageType(int n) {
        if (this.error == null) {
            return this.type;
        }
        return this.error.types[n];
    }

    @Override
    public void printStackTrace() {
        if (this.exception != null) {
            this.exception.printStackTrace();
        } else {
            super.printStackTrace();
        }
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        if (this.exception != null) {
            this.exception.printStackTrace(printStream);
        } else {
            super.printStackTrace(printStream);
        }
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        if (this.exception != null) {
            this.exception.printStackTrace(printWriter);
        } else {
            super.printStackTrace(printWriter);
        }
    }

    @Override
    public String toString() {
        if (this.exception != null) {
            return this.exception.toString();
        }
        return super.toString();
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    @Override
    public Throwable initCause(Throwable throwable) {
        if (throwable instanceof Exception) {
            this.exception = (Exception)throwable;
        }
        return this;
    }

    public XMLError getXMLError() {
        return this.error;
    }
}

