/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.logging.impl;

import com.teradata.tdgss.logging.TdgssLogger;
import com.teradata.tdgss.logging.TdgssLoggingManager;
import com.teradata.tdgss.logging.impl.Delegate;
import com.teradata.tdgss.logging.impl.Level;
import com.teradata.tdgss.logging.impl.Manager;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

class Logger
implements TdgssLogger {
    private final Delegate listeners;
    private final Level level;
    private static final char[] HEXMAP = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    Logger(Delegate delegate, Level level) {
        this.listeners = delegate;
        this.level = level;
    }

    public void debug(String string) {
        if (Level.DEBUG.compareTo(this.level) == 0) {
            this.listeners.log(this.buildMsg(Level.DEBUG, string, new Object[0]));
        }
    }

    public void debug(String string, Object[] objectArray) {
        if (Level.DEBUG.compareTo(this.level) == 0) {
            this.listeners.log(this.buildMsg(Level.DEBUG, string, objectArray));
        }
    }

    public void debug(String string, Throwable throwable) {
        if (Level.DEBUG.compareTo(this.level) == 0) {
            this.listeners.log(this.buildMsg(Level.DEBUG, string, new Object[0]), throwable);
        }
    }

    public void debug(Throwable throwable, String string, Object[] objectArray) {
        if (Level.DEBUG.compareTo(this.level) == 0) {
            this.listeners.log(this.buildMsg(Level.DEBUG, string, objectArray), throwable);
        }
    }

    public void debug(String string, byte[] byArray) {
        if (Level.DEBUG.compareTo(this.level) == 0) {
            this.listeners.log(this.dump(Level.DEBUG, string, byArray, 0, byArray.length));
        }
    }

    public void debug(String string, byte[] byArray, int n) {
        if (Level.DEBUG.compareTo(this.level) == 0) {
            this.listeners.log(this.dump(Level.DEBUG, string, byArray, n, byArray.length - n));
        }
    }

    public void debug(String string, byte[] byArray, int n, int n2) {
        if (Level.DEBUG.compareTo(this.level) == 0) {
            this.listeners.log(this.dump(Level.DEBUG, string, byArray, n, n2));
        }
    }

    public void info(String string) {
        if (Level.INFO.compareTo(this.level) <= 0) {
            this.listeners.log(this.buildMsg(Level.INFO, string, new Object[0]));
        }
    }

    public void info(String string, Object[] objectArray) {
        if (Level.INFO.compareTo(this.level) <= 0) {
            this.listeners.log(this.buildMsg(Level.INFO, string, objectArray));
        }
    }

    public void info(String string, Throwable throwable) {
        if (Level.INFO.compareTo(this.level) <= 0) {
            this.listeners.log(this.buildMsg(Level.INFO, string, new Object[0]), throwable);
        }
    }

    public void info(Throwable throwable, String string, Object[] objectArray) {
        if (Level.INFO.compareTo(this.level) <= 0) {
            this.listeners.log(this.buildMsg(Level.INFO, string, objectArray), throwable);
        }
    }

    public void info(String string, byte[] byArray) {
        if (Level.INFO.compareTo(this.level) <= 0) {
            this.listeners.log(this.dump(Level.INFO, string, byArray, 0, byArray.length));
        }
    }

    public void info(String string, byte[] byArray, int n) {
        if (Level.INFO.compareTo(this.level) <= 0) {
            this.listeners.log(this.dump(Level.INFO, string, byArray, n, byArray.length - n));
        }
    }

    public void info(String string, byte[] byArray, int n, int n2) {
        if (Level.INFO.compareTo(this.level) <= 0) {
            this.listeners.log(this.dump(Level.INFO, string, byArray, n, n2));
        }
    }

    public void warn(String string) {
        if (Level.WARN.compareTo(this.level) <= 0) {
            this.listeners.log(this.buildMsg(Level.WARN, string, new Object[0]));
        }
    }

    public void warn(String string, Object[] objectArray) {
        if (Level.WARN.compareTo(this.level) <= 0) {
            this.listeners.log(this.buildMsg(Level.WARN, string, objectArray));
        }
    }

    public void warn(String string, Throwable throwable) {
        if (Level.WARN.compareTo(this.level) <= 0) {
            this.listeners.log(this.buildMsg(Level.WARN, string, new Object[0]), throwable);
        }
    }

    public void warn(Throwable throwable, String string, Object[] objectArray) {
        if (Level.WARN.compareTo(this.level) <= 0) {
            this.listeners.log(this.buildMsg(Level.WARN, string, objectArray), throwable);
        }
    }

    public void warn(String string, byte[] byArray) {
        if (Level.WARN.compareTo(this.level) <= 0) {
            this.listeners.log(this.dump(Level.WARN, string, byArray, 0, byArray.length));
        }
    }

    public void warn(String string, byte[] byArray, int n) {
        if (Level.WARN.compareTo(this.level) <= 0) {
            this.listeners.log(this.dump(Level.WARN, string, byArray, n, byArray.length - n));
        }
    }

    public void warn(String string, byte[] byArray, int n, int n2) {
        if (Level.WARN.compareTo(this.level) <= 0) {
            this.listeners.log(this.dump(Level.WARN, string, byArray, n, n2));
        }
    }

    public void error(String string) {
        if (Level.ERROR.compareTo(this.level) <= 0) {
            this.listeners.log(this.buildMsg(Level.ERROR, string, new Object[0]));
        }
    }

    public void error(String string, Object[] objectArray) {
        if (Level.ERROR.compareTo(this.level) <= 0) {
            this.listeners.log(this.buildMsg(Level.ERROR, string, objectArray));
        }
    }

    public void error(String string, Throwable throwable) {
        if (Level.ERROR.compareTo(this.level) <= 0) {
            this.listeners.log(this.buildMsg(Level.ERROR, string, new Object[0]), throwable);
        }
    }

    public void error(Throwable throwable, String string, Object[] objectArray) {
        if (Level.ERROR.compareTo(this.level) <= 0) {
            this.listeners.log(this.buildMsg(Level.ERROR, string, objectArray), throwable);
        }
    }

    public void error(String string, byte[] byArray) {
        if (Level.ERROR.compareTo(this.level) <= 0) {
            this.listeners.log(this.dump(Level.ERROR, string, byArray, 0, byArray.length));
        }
    }

    public void error(String string, byte[] byArray, int n) {
        if (Level.ERROR.compareTo(this.level) <= 0) {
            this.listeners.log(this.dump(Level.ERROR, string, byArray, n, byArray.length - n));
        }
    }

    public void error(String string, byte[] byArray, int n, int n2) {
        if (Level.ERROR.compareTo(this.level) <= 0) {
            this.listeners.log(this.dump(Level.ERROR, string, byArray, n, n2));
        }
    }

    public void fatal(String string) {
        if (Level.NONE.compareTo(this.level) != 0) {
            this.listeners.log(this.buildMsg(Level.FATAL, string, new Object[0]));
        }
    }

    public void fatal(String string, Object[] objectArray) {
        if (Level.NONE.compareTo(this.level) != 0) {
            this.listeners.log(this.buildMsg(Level.FATAL, string, objectArray));
        }
    }

    public void fatal(String string, Throwable throwable) {
        if (Level.NONE.compareTo(this.level) != 0) {
            this.listeners.log(this.buildMsg(Level.FATAL, string, new Object[0]), throwable);
        }
    }

    public void fatal(Throwable throwable, String string, Object[] objectArray) {
        if (Level.NONE.compareTo(this.level) != 0) {
            this.listeners.log(this.buildMsg(Level.FATAL, string, objectArray), throwable);
        }
    }

    public void fatal(String string, byte[] byArray) {
        if (Level.NONE.compareTo(this.level) != 0) {
            this.listeners.log(this.dump(Level.FATAL, string, byArray, 0, byArray.length));
        }
    }

    public void fatal(String string, byte[] byArray, int n) {
        if (Level.NONE.compareTo(this.level) != 0) {
            this.listeners.log(this.dump(Level.FATAL, string, byArray, n, byArray.length - n));
        }
    }

    public void fatal(String string, byte[] byArray, int n, int n2) {
        if (Level.NONE.compareTo(this.level) != 0) {
            this.listeners.log(this.dump(Level.FATAL, string, byArray, n, n2));
        }
    }

    private String buildMsg(Level level, String string, Object[] objectArray) {
        Date date = new Date();
        String string2 = objectArray == null || objectArray.length == 0 ? string : MessageFormat.format(string, objectArray);
        return " [" + level.name() + "] " + new SimpleDateFormat("MMM dd hh:mm:ss.SS ").format(date) + ((Manager)TdgssLoggingManager.getInstance()).getCaller().toString() + " (Thread # " + Thread.currentThread().getName() + ") : " + string2;
    }

    private String dump(Level level, String string, byte[] byArray, int n, int n2) {
        if (byArray == null || byArray.length == 0) {
            return this.buildMsg(level, string + '\n' + "*** Nothing to dump: The data to dump is either null or zero length", new Object[0]);
        }
        if (n < 0 || n >= byArray.length) {
            return this.buildMsg(level, string + '\n' + "*** Can't dump: offset (" + n + ") must be greater than zero and less than the length of the data (" + byArray.length + ")", new Object[0]);
        }
        if (n2 <= 0) {
            return this.buildMsg(level, string + '\n' + "*** Can't dump: the length (" + n2 + ") must not be less than or equal to 0", new Object[0]);
        }
        if (n + n2 > byArray.length) {
            return this.buildMsg(level, string + '\n' + "*** Can't dump: the sum of the offset (" + n + ") and length (" + n2 + ") must not be greater than the length of the data (" + byArray.length + ")", new Object[0]);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n >> 4 << 4;
        int n4 = n + n2;
        for (int i = n3; i < n4; i += 16) {
            int n5;
            int n6;
            if (i != n3) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(i == n3 ? this.toHex(n) : this.toHex(i));
            stringBuffer.append(": ");
            for (n6 = i; n6 < i + 16; ++n6) {
                if (n6 != i && n6 % 8 == 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(' ');
                stringBuffer.append(n6 < n4 && n6 >= n ? this.toHex(byArray[n6]) : "  ");
            }
            stringBuffer.append("  ");
            n6 = 0;
            if (i == n3) {
                n6 = n;
                for (n5 = i; n5 < n; ++n5) {
                    stringBuffer.append(' ');
                }
            } else {
                n6 = i;
            }
            stringBuffer.append("|");
            for (n5 = n6; n5 < i + 16; ++n5) {
                if (n5 >= n4) continue;
                stringBuffer.append(byArray[n5] < 32 || byArray[n5] > 126 ? (char)'.' : (char)byArray[n5]);
            }
            stringBuffer.append("|");
        }
        return this.buildMsg(level, string + '\n' + stringBuffer.toString(), new Object[0]);
    }

    private String toHex(byte by) {
        return this.toHex(by, 2);
    }

    private String toHex(int n) {
        return this.toHex(n, 8);
    }

    private String toHex(int n, int n2) {
        char[] cArray = new char[n2];
        for (int i = cArray.length - 1; i >= 0; --i) {
            int n3 = n & 0xF;
            cArray[i] = HEXMAP[n3];
            n >>= 4;
        }
        return new String(cArray);
    }
}

