/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.asn1.der;

import com.teradata.tdgss.asn1.der.DERASN1Type;
import com.teradata.tdgss.asn1.der.DERException;
import com.teradata.tdgss.asn1.der.DERInteger;
import com.teradata.tdgss.asn1.der.DERObjectIdentifier;
import com.teradata.tdgss.asn1.der.DEROctetString;
import com.teradata.tdgss.asn1.der.DERSequence;
import com.teradata.tdgss.asn1.der.DERTag;
import com.teradata.tdgss.asn1.der.DERUTF8String;
import com.teradata.tdgss.asn1.der.ListArray;
import org.ietf.jgss.Oid;

final class DERASN1Factory {
    DERASN1Factory() {
    }

    static DERASN1Type createASN1Type(long l) {
        return new DERInteger(l);
    }

    static DERASN1Type createASN1Type(String string) {
        return new DERUTF8String(string);
    }

    static DERASN1Type createASN1Type(Oid oid) {
        return new DERObjectIdentifier(oid);
    }

    static DERASN1Type createASN1Type(byte[] byArray) {
        return new DEROctetString(byArray);
    }

    static DERASN1Type createASN1Type(ListArray listArray) {
        return new DERSequence(listArray);
    }

    static DERASN1Type createASN1Type(DERTag dERTag, byte[] byArray, int n, int n2, boolean bl) {
        if (bl) {
            if (dERTag.isConstructed()) {
                return new DERSequence(byArray, n, n2, bl);
            }
            return new DEROctetString(byArray, n, n2, bl);
        }
        DERTag dERTag2 = new DERTag(byArray, n);
        switch (dERTag2.getTag()) {
            case 2: {
                return new DERInteger(byArray, n, n2, bl);
            }
            case 12: {
                return new DERUTF8String(byArray, n, n2, bl);
            }
            case 4: {
                return new DEROctetString(byArray, n, n2, bl);
            }
            case 6: {
                return new DERObjectIdentifier(byArray, n, n2, bl);
            }
            case 16: {
                return new DERSequence(byArray, n, n2, bl);
            }
        }
        throw new DERException("Invalid Universal tag octets.");
    }
}

