/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.ifsupport;

import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.ifsupport.Result;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.statemachine.PreparedStatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementContinueState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.util.Mutex;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

public class Results {
    private ArrayList results = new ArrayList();
    private int currentReadIndex = 0;
    private Log log;
    private StatementController m_controller = null;
    private boolean m_bRequestCompleted = false;

    public Results(Log log) {
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinit() {
        ArrayList arrayList = this.results;
        synchronized (arrayList) {
            this.results.clear();
        }
        this.currentReadIndex = 0;
        this.m_controller = null;
        this.m_bRequestCompleted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getAllResultSets() throws SQLException {
        ArrayList<TDResultSet> arrayList = new ArrayList<TDResultSet>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = this.results;
        synchronized (arrayList3) {
            arrayList2.addAll(this.results);
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            Result result = (Result)arrayList2.get(i);
            if (result.getType() != 2 && result.getType() != 3) continue;
            arrayList.add(result.getResultSet());
        }
        return arrayList;
    }

    public Result getResult() {
        return (Result)this.results.get(this.currentReadIndex);
    }

    public Result getResult(int n) {
        return (Result)this.results.get(n);
    }

    public void addBatchResults(ArrayList arrayList) {
        this.results.addAll(arrayList);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Results.addBatchResults this=" + this);
        }
    }

    public void addResult(StatementController statementController, Result result) {
        this.m_controller = statementController;
        this.results.add(result);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Results.addResult this=" + this);
        }
    }

    public void enableDynamicResultSets(StatementController statementController) {
        this.m_controller = statementController;
    }

    public int getResultType() {
        if (this.currentReadIndex < this.results.size()) {
            return ((Result)this.results.get(this.currentReadIndex)).getType();
        }
        return -1;
    }

    public int getResultType(int n) {
        if (n <= this.results.size() && n >= 0) {
            return ((Result)this.results.get(n)).getType();
        }
        return -1;
    }

    public int getResultsSize() {
        return this.results.size();
    }

    public boolean getMoreResults() throws SQLException {
        ++this.currentReadIndex;
        return this.moreResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moreResults() throws SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Results.moreResults this=" + this);
        }
        while (!this.m_bRequestCompleted && this.currentReadIndex >= this.results.size() && this.m_controller != null) {
            StatementController statementController = this.m_controller;
            statementController.getSession().acquireSessionLock(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
            try {
                if (!(statementController.getHistoricalState() instanceof StatementContinueState)) break;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Results.moreResults before run this=" + this);
                }
                if (statementController.getSession().isStatementPositioningSupported() && statementController.getStatement().getResultSetType() == 1004) {
                    int n = statementController.getCurrentStatementNumber();
                    StatementController statementController2 = null;
                    statementController2 = statementController instanceof PreparedStatementController ? new PreparedStatementController(statementController) : new StatementController(statementController);
                    StatementContinueState statementContinueState = (StatementContinueState)statementController2.getHistoricalState();
                    statementContinueState.setDesiredRowNumber(0L);
                    statementContinueState.setDesiredStatementNumber(++n);
                    try {
                        statementController2.runBody(statementContinueState);
                    }
                    catch (SQLException sQLException) {
                        if (sQLException.getErrorCode() == 3172) {
                            boolean bl = false;
                            statementController.getSession().releaseSessionLock();
                            return bl;
                        }
                        throw sQLException;
                    }
                } else {
                    statementController.run();
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Results.moreResults after run this=" + this);
            }
            finally {
                statementController.getSession().releaseSessionLock();
            }
        }
        return this.currentReadIndex < this.results.size();
    }

    public int[] getSmallUpdateCountArray() {
        long[] lArray = this.getLargeUpdateCountArray();
        int[] nArray = new int[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            long l = lArray[i];
            nArray[i] = l <= Integer.MAX_VALUE ? (int)l : Integer.MAX_VALUE;
        }
        return nArray;
    }

    public long[] getLargeUpdateCountArray() {
        long[] lArray = new long[this.results.size()];
        Iterator iterator = this.results.iterator();
        int n = 0;
        boolean bl = false;
        while (iterator.hasNext()) {
            Result result = (Result)iterator.next();
            lArray[n] = result.getBatchIndexLargeUpdateCount();
            if (result.getType() == 3) {
                bl = true;
            }
            ++n;
        }
        this.currentReadIndex = bl ? n - 1 : n;
        return lArray;
    }

    public void markRequestAsComplete() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Results.markRequestAsComplete this=" + this);
        }
        this.m_controller = null;
        this.m_bRequestCompleted = true;
    }

    public boolean requestComplete() {
        return this.m_bRequestCompleted;
    }

    public boolean areAllResultSetsClosed() throws SQLException {
        if (!this.m_bRequestCompleted) {
            return false;
        }
        for (int i = 0; i < this.results.size(); ++i) {
            Result result = (Result)this.results.get(i);
            if (result.getType() != 2 && result.getType() != 3 || result.getResultSet().isClosed()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return super.toString() + "(curidx=" + this.currentReadIndex + " rsize=" + this.results.size() + " results=" + this.results + " ctlr=" + this.m_controller + " complete=" + this.m_bRequestCompleted + ")";
    }
}

