/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.iam;

import com.dbeaver.net.auth.iam.AuthModelIAMAbstract;
import com.dbeaver.net.auth.iam.AuthModelIAMCredentials;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceURLProvider;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;

public class AuthModelIAMRedshift
extends AuthModelIAMAbstract
implements DBPDataSourceURLProvider {
    public static final String ID = "redshift_iam";

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, AuthModelIAMCredentials credentials, DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        credentials.setUserPassword(null);
        String userName = credentials.getUserName();
        if (!CommonUtils.isEmpty((String)userName)) {
            connProperties.put("user", userName);
        }
        AwsCredentialsProvider credentialsProvider = credentials.getAuthCredentialsProvider(configuration);
        AwsCredentials awsCredentials = credentialsProvider.resolveCredentials();
        connProperties.put("AccessKeyID", awsCredentials.accessKeyId());
        connProperties.put("SecretAccessKey", awsCredentials.secretAccessKey());
        if (awsCredentials instanceof AwsSessionCredentials) {
            connProperties.put("SessionToken", ((AwsSessionCredentials)awsCredentials).sessionToken());
        }
        return awsCredentials;
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        String url = "jdbc:redshift:iam://" + connectionInfo.getHostName() + ":" + connectionInfo.getHostPort() + "/";
        if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
            url = String.valueOf(url) + connectionInfo.getDatabaseName();
        }
        return url;
    }
}

