/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.iam;

import com.dbeaver.net.auth.iam.AuthModelIAMAbstract;
import com.dbeaver.net.auth.iam.AuthModelIAMCredentials;
import com.dbeaver.net.auth.iam.IAMUtils;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;

public class AuthModelIAMRDS
extends AuthModelIAMAbstract {
    public static final String ID = "iam";

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, AuthModelIAMCredentials credentials, DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        if (!CommonUtils.isEmpty((String)configuration.getUserPassword())) {
            return super.initAuthentication(monitor, dataSource, (AuthModelDatabaseNativeCredentials)credentials, configuration, connProperties);
        }
        String region = credentials.getRegion();
        if (CommonUtils.isEmpty((String)region)) {
            region = Region.AWS_GLOBAL.id();
        }
        String username = configuration.getUserName();
        String hostname = configuration.getHostName();
        int port = Integer.parseInt(configuration.getHostPort());
        AwsCredentialsProvider credentialsProvider = credentials.getAuthCredentialsProvider(configuration);
        AwsCredentials authCredentials = credentialsProvider.resolveCredentials();
        String newPassword = IAMUtils.generateIamPassword(region, hostname, port, username, authCredentials.accessKeyId(), authCredentials.secretAccessKey());
        credentials.setUserPassword(newPassword);
        return super.initAuthentication(monitor, dataSource, (AuthModelDatabaseNativeCredentials)credentials, configuration, connProperties);
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
        super.endAuthentication(dataSource, configuration, connProperties);
    }
}

