/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.gis.panel;

import java.util.Locale;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.gis.internal.GISMessages;
import org.jkiss.dbeaver.ui.gis.internal.GISViewerActivator;
import org.jkiss.utils.CommonUtils;

public class GISViewerConfigurationDialog
extends BaseDialog {
    private static final Log log = Log.getLog(GISViewerConfigurationDialog.class);
    private Text defaultSridText;
    private Text maxObjectsText;

    public GISViewerConfigurationDialog(Shell shell) {
        super(shell, GISMessages.panel_gis_viewer_config_dialog_title_configure, null);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite dialogArea = super.createDialogArea(parent);
        DBPPreferenceStore preferences = GISViewerActivator.getDefault().getPreferences();
        Group crsGroup = UIUtils.createControlGroup((Composite)dialogArea, (String)GISMessages.panel_gis_viewer_config_dialog_control_group_label, (int)2, (int)0, (int)0);
        crsGroup.setLayoutData((Object)new GridData(768));
        this.defaultSridText = UIUtils.createLabelText((Composite)crsGroup, (String)GISMessages.panel_gis_viewer_config_dialog_label_text_srid, (String)preferences.getString("gis.view.defaultSRID"), (int)2048);
        this.defaultSridText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.ENGLISH));
        this.maxObjectsText = UIUtils.createLabelText((Composite)crsGroup, (String)GISMessages.panel_gis_viewer_config_dialog_label_tixi_max_objects, (String)preferences.getString("gis.view.maxObjectsRender"), (int)2048);
        this.maxObjectsText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.ENGLISH));
        return dialogArea;
    }

    protected void okPressed() {
        DBPPreferenceStore preferences = GISViewerActivator.getDefault().getPreferences();
        preferences.setValue("gis.view.defaultSRID", this.defaultSridText.getText());
        preferences.setValue("gis.view.maxObjectsRender", CommonUtils.toInt((Object)this.maxObjectsText.getText()));
        super.okPressed();
    }
}

