/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.task;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.dbeaver.model.impl.preferences.AbstractPreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceMap;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class TaskPreferenceStore
extends AbstractPreferenceStore
implements DBPPreferenceMap {
    private DBPPreferenceStore parentStore = DBWorkbench.getPlatform().getPreferenceStore();
    private final DBTTask task;
    private Map<String, Object> properties;
    private boolean dirty = false;

    public TaskPreferenceStore(DBTTask task) {
        this.task = task;
        this.properties = new LinkedHashMap<String, Object>(task.getProperties());
    }

    public TaskPreferenceStore(Map<String, Object> properties) {
        this.task = null;
        this.properties = properties;
    }

    public DBPPreferenceStore getParentStore() {
        return this.parentStore;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void addPropertyChangeListener(DBPPreferenceListener listener) {
        this.addListenerObject(listener);
    }

    public void removePropertyChangeListener(DBPPreferenceListener listener) {
        this.removeListenerObject(listener);
    }

    public void save() throws IOException {
        if (this.task != null) {
            this.task.setProperties(this.properties);
        }
    }

    public boolean contains(String name) {
        return this.properties.containsKey(name);
    }

    public boolean getBoolean(String name) {
        return CommonUtils.toBoolean((Object)this.getValue(name));
    }

    public boolean getDefaultBoolean(String name) {
        return CommonUtils.toBoolean((Object)this.getValue(name));
    }

    public double getDouble(String name) {
        return CommonUtils.toDouble((Object)this.getValue(name));
    }

    public double getDefaultDouble(String name) {
        return CommonUtils.toDouble((Object)this.getValue(name));
    }

    public float getFloat(String name) {
        return (float)CommonUtils.toDouble((Object)this.getValue(name));
    }

    public float getDefaultFloat(String name) {
        return this.getFloat(name);
    }

    public int getInt(String name) {
        return CommonUtils.toInt((Object)this.getValue(name));
    }

    public int getDefaultInt(String name) {
        return this.getInt(name);
    }

    public long getLong(String name) {
        return CommonUtils.toLong((Object)this.getValue(name));
    }

    public long getDefaultLong(String name) {
        return this.getLong(name);
    }

    public String getString(String name) {
        return CommonUtils.toString((Object)this.getValue(name));
    }

    public Object getValue(String name) {
        Object value = this.properties.get(name);
        if (value == null) {
            value = this.parentStore.getString(name);
        }
        return value;
    }

    public String getDefaultString(String name) {
        return this.getString(name);
    }

    public boolean isDefault(String name) {
        return false;
    }

    public boolean isSet(String name) {
        return this.properties.containsKey(name);
    }

    public boolean needsSaving() {
        return this.dirty;
    }

    public void setDefault(String name, double value) {
    }

    public void setDefault(String name, float value) {
    }

    public void setDefault(String name, int value) {
    }

    public void setDefault(String name, long value) {
    }

    public void setDefault(String name, String value) {
    }

    public void setDefault(String name, boolean value) {
    }

    public void setToDefault(String name) {
        Object oldValue = this.properties.get(name);
        this.properties.remove(name);
        this.dirty = true;
        this.firePropertyChangeEvent(name, oldValue, null);
    }

    public void setValue(String name, double value) {
        double oldValue = this.getDouble(name);
        if (oldValue != value || !this.isSet(name)) {
            this.properties.put(name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, oldValue, value);
        }
    }

    public void setValue(String name, float value) {
        float oldValue = this.getFloat(name);
        if (oldValue != value || !this.isSet(name)) {
            this.properties.put(name, Float.valueOf(value));
            this.dirty = true;
            this.firePropertyChangeEvent(name, Float.valueOf(oldValue), Float.valueOf(value));
        }
    }

    public void setValue(String name, int value) {
        int oldValue = this.getInt(name);
        if (oldValue != value || !this.isSet(name)) {
            this.properties.put(name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, oldValue, value);
        }
    }

    public void setValue(String name, long value) {
        long oldValue = this.getLong(name);
        if (oldValue != value || !this.isSet(name)) {
            this.properties.put(name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, oldValue, value);
        }
    }

    public void setValue(String name, String value) {
        String oldValue = this.getString(name);
        if (oldValue == null || !oldValue.equals(value) || !this.isSet(name)) {
            this.properties.put(name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, oldValue, value);
        }
    }

    public void setValue(String name, boolean value) {
        boolean oldValue = this.getBoolean(name);
        if (oldValue != value || !this.isSet(name)) {
            this.properties.put(name, String.valueOf(value));
            this.dirty = true;
            this.firePropertyChangeEvent(name, oldValue ? Boolean.TRUE : Boolean.FALSE, value ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TaskPreferenceStore)) {
            return false;
        }
        TaskPreferenceStore copy = (TaskPreferenceStore)((Object)obj);
        return CommonUtils.equalObjects((Object)this.parentStore, (Object)copy.parentStore) && CommonUtils.equalObjects(this.properties, copy.properties);
    }

    public <T> T getObject(String name) {
        return (T)this.properties.get(name);
    }

    public Map<String, Object> getPropertyMap() {
        return this.properties;
    }
}

