/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util.security;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPartVariable;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.Tracer;
import com.sap.dbtech.util.security.AbstractAuthenticationMethod;
import com.sap.dbtech.util.security.SCRAMMD5;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.SQLException;

public class ScrammMD5Authentication
extends AbstractAuthenticationMethod {
    private byte[] salt1;
    protected byte[] clientchallenge = null;
    protected byte[] serverchallenge;
    private int maxpasswordLen = 0;
    protected static long internalseed = 17L;

    public byte[] getClientchallenge() throws SQLException {
        internalseed += System.currentTimeMillis();
        if (this.clientchallenge == null) {
            this.clientchallenge = new byte[64];
            int retrycount = 10;
            while (true) {
                try {
                    SecureRandom srnd = new SecureRandom();
                    srnd.setSeed(System.currentTimeMillis());
                    srnd.setSeed(Runtime.getRuntime().freeMemory());
                    srnd.setSeed(Runtime.getRuntime().totalMemory());
                    srnd.setSeed(internalseed);
                    srnd.nextBytes(this.clientchallenge);
                    return this.clientchallenge;
                }
                catch (Exception e) {
                    this.clientchallenge = null;
                    if (--retrycount > 0) continue;
                    throw SQLExceptionSapDB.generateSQLException("error.connection.challengeresponserandombytes", e.toString());
                }
                break;
            }
        }
        return this.clientchallenge;
    }

    private static byte[] preprocessPassword(String pwd, boolean isUnicode) {
        if (isUnicode) {
            StructuredBytes pwdBytes = new StructuredBytes(pwd.length() * 2);
            pwdBytes.putBigUnicode(pwd.toCharArray(), 0, pwd.length() * 2);
            return pwdBytes.getBytes(0, pwdBytes.size());
        }
        return pwd.getBytes();
    }

    protected byte[] getClientProof(String pass, boolean isUnicode) throws SQLException {
        try {
            byte[] passwdByte = ScrammMD5Authentication.preprocessPassword(pass, isUnicode);
            internalseed += System.currentTimeMillis();
            return SCRAMMD5.scrammMD5(this.salt1, passwdByte, this.getClientchallenge(), this.serverchallenge);
        }
        catch (NoSuchAlgorithmException ex) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", "NoSuchAlgorithmException - algorithm \"MD5\" not supported by the java vm");
        }
    }

    public void parseServerChallenge(byte[] vData) throws SQLException {
        internalseed += System.currentTimeMillis();
        DataPartVariable vd = new DataPartVariable((StructuredMem)new StructuredBytes(vData), 1);
        if (!vd.nextField()) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", Tracer.Hex2String(vData));
        }
        this.salt1 = vd.getBase().getBytes(vd.getCurrentOffset(), vd.getCurrentFieldLen());
        if (!vd.nextField()) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", Tracer.Hex2String(vData));
        }
        this.serverchallenge = vd.getBase().getBytes(vd.getCurrentOffset(), vd.getCurrentFieldLen());
        internalseed += System.currentTimeMillis();
    }

    public int getMaxPasswordLength() {
        return this.maxpasswordLen;
    }

    String getMethodName() {
        return "SCRAMMD5";
    }

    byte[] getInitialData() throws SQLException {
        return this.getClientchallenge();
    }

    byte[] evaluate(DataPartVariable vData, Tracer tracer) throws SQLException {
        internalseed += System.currentTimeMillis();
        if (vData.getCurrentFieldLen() == 40) {
            this.salt1 = vData.getBase().getBytes(vData.getCurrentOffset(), 8);
            this.serverchallenge = vData.getBase().getBytes(vData.getCurrentOffset() + 8, vData.getCurrentFieldLen() - 8);
        } else {
            DataPartVariable vd = new DataPartVariable((StructuredMem)new StructuredBytes(vData.getBase().getBytes(vData.getCurrentOffset(), vData.getCurrentFieldLen())), 1);
            if (!vd.nextField()) {
                throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", Tracer.Hex2String(vData.getBase().getBytes(0, vData.size())));
            }
            this.salt1 = vd.getBase().getBytes(vd.getCurrentOffset(), vd.getCurrentFieldLen());
            if (!vd.nextField()) {
                throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", Tracer.Hex2String(vData.getBase().getBytes(0, vData.size())));
            }
            this.serverchallenge = vd.getBase().getBytes(vd.getCurrentOffset(), vd.getCurrentFieldLen());
            if (vData.nextField()) {
                DataPartVariable mp_vd = new DataPartVariable((StructuredMem)new StructuredBytes(vData.getBase().getBytes(vData.getCurrentOffset(), vData.getCurrentFieldLen())), 1);
                if (!mp_vd.nextField()) {
                    throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", Tracer.Hex2String(vData.getBase().getBytes(0, vData.size())));
                }
                do {
                    if (mp_vd.getBase().getString(mp_vd.getCurrentOffset(), mp_vd.getCurrentFieldLen()).equals("maxpasswordlen")) {
                        if (!mp_vd.nextField()) {
                            throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", Tracer.Hex2String(vData.getBase().getBytes(0, vData.size())));
                        }
                        try {
                            this.maxpasswordLen = Integer.parseInt(mp_vd.getBase().getString(mp_vd.getCurrentOffset(), mp_vd.getCurrentFieldLen()));
                        }
                        catch (NumberFormatException e) {
                            throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", Tracer.Hex2String(vData.getBase().getBytes(0, vData.size())));
                        }
                    } else {
                        if (mp_vd.nextField()) continue;
                        throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", Tracer.Hex2String(vData.getBase().getBytes(0, vData.size())));
                    }
                } while (mp_vd.nextField());
            }
        }
        internalseed += System.currentTimeMillis();
        return null;
    }

    public byte[] getFinalData(String pass, boolean isUnicode) throws SQLException {
        if (pass == null) {
            throw SQLExceptionSapDB.generateSQLException("error.nopassword");
        }
        internalseed += System.currentTimeMillis();
        return this.getClientProof(pass, isUnicode);
    }
}

