/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class RawByteReader
extends Reader {
    private InputStream stream;

    public RawByteReader(InputStream stream) {
        this.stream = stream;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        try {
            byte[] bbuf = new byte[len];
            int result = this.stream.read(bbuf);
            if (result == -1) {
                return -1;
            }
            int off_i = off;
            int i = 0;
            while (i < result) {
                int current = bbuf[i] & 0xFF;
                cbuf[off_i] = (char)current;
                ++i;
                ++off_i;
            }
            return result;
        }
        catch (IOException ioEx) {
            throw ioEx;
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public long skip(long n) throws IOException {
        return this.stream.skip(n);
    }

    public boolean markSupported() {
        return this.stream.markSupported();
    }

    public void mark(int readAheadLimit) throws IOException {
        this.stream.mark(readAheadLimit);
    }

    public void reset() throws IOException {
        this.stream.reset();
    }

    public void close() throws IOException {
        this.stream.close();
    }
}

