/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.rte.comm;

import com.sap.dbtech.powertoys.LoaderException;
import com.sap.dbtech.rte.comm.CommunicationException;
import com.sap.dbtech.rte.comm.CserverPacketLayout;
import com.sap.dbtech.rte.comm.JdbcCommFactory;
import com.sap.dbtech.rte.comm.JdbcCommunication;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.rte.comm.RteC;
import com.sap.dbtech.rte.comm.RteSocketPacket;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.Tracer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class PipedCommunication
extends JdbcCommunication {
    private static final boolean isWindows = System.getProperty("os.name").toUpperCase().startsWith("WINDOWS");
    private static final int alignSizeC = 8;
    static final int indicatorLengthC = 4;
    private BufferedInputStream procout = null;
    private BufferedOutputStream procin = null;
    private BufferedInputStream procerr = null;
    private Process process = null;
    private Tracer tracer;
    public static final JdbcCommFactory factory = new JdbcCommFactory(){

        public JdbcCommunication open(String host, String dbname, Properties property, Tracer tracer) throws RTEException {
            return new PipedCommunication(host, dbname, property, tracer);
        }

        public JdbcCommunication xopen(String host, String db, String dbroot, String pgm, Properties properties, Tracer tracer) throws RTEException {
            return new PipedCommunication(host, db, properties, tracer);
        }
    };

    public PipedCommunication(String host, String dbname, Properties property, Tracer tracer) throws RTEException {
        String loaderStartCmd = property.getProperty("LOADERROOT", "");
        Properties myprops = (Properties)property.clone();
        myprops.remove("host");
        myprops.remove("dbname");
        myprops.remove("dbroot");
        myprops.remove("user");
        myprops.remove("password");
        myprops.remove("dbmsrv");
        myprops.remove("transport");
        myprops.remove("LOADERROOT");
        String[] env = null;
        try {
            String val;
            String key;
            Method meth = System.class.getMethod("getenv", new Class[0]);
            Class<?> clazz = Class.forName("java.lang.System");
            Map sysenv = (Map)meth.invoke(clazz, new Object[0]);
            env = new String[sysenv.size() + myprops.size()];
            Iterator<Object> keys = sysenv.keySet().iterator();
            int i = 0;
            while (keys.hasNext()) {
                key = (String)keys.next();
                val = (String)sysenv.get(key);
                env[i] = key + "=" + val;
                ++i;
            }
            keys = myprops.keySet().iterator();
            i = sysenv.size();
            while (keys.hasNext()) {
                key = (String)keys.next();
                val = (String)myprops.get(key);
                env[i] = key + "=" + val;
                ++i;
            }
        }
        catch (Exception e) {
            env = new String[myprops.size()];
            Iterator<Object> keys = myprops.keySet().iterator();
            int i = 0;
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String val = (String)myprops.get(key);
                env[i] = key + "=" + val;
                ++i;
            }
        }
        tracer.println("dump of environment [");
        for (int i = 0; i < env.length; ++i) {
            tracer.println("    " + env[i]);
        }
        tracer.println("]");
        if (loaderStartCmd.length() != 0) {
            loaderStartCmd = loaderStartCmd + File.separator;
        }
        loaderStartCmd = loaderStartCmd + "loadercli";
        if (isWindows) {
            loaderStartCmd = loaderStartCmd + ".exe";
        }
        loaderStartCmd = loaderStartCmd + " -j";
        Runtime rt = Runtime.getRuntime();
        try {
            this.process = rt.exec(loaderStartCmd, env);
            this.procout = new BufferedInputStream(this.process.getInputStream());
            this.procin = new BufferedOutputStream(this.process.getOutputStream());
            this.procerr = new BufferedInputStream(this.process.getErrorStream());
            this.procerr.close();
            if (0 != dbname.length()) {
                this.requestCMD("USE SERVERDB " + dbname);
                this.receiveCMD();
            }
        }
        catch (Exception e) {
            throw new RTEException("Error open PipedCommunication " + e.toString(), tracer, 1);
        }
    }

    public void cancel() throws SQLException {
        try {
            if (!this.isConnected()) {
                throw new RTEException("Error session not connected", this.tracer, 1);
            }
            StructuredBytes rawRequest = new StructuredBytes(24);
            this.buildRTEHeader(rawRequest, 65, 0);
            this.senddata(rawRequest.bytes(), 24);
        }
        catch (RTEException e) {
            throw new SQLException(e.toString());
        }
    }

    private void receiveCMD() throws LoaderException, RTEException {
        StructuredMem reply = this.receive();
        String errorIndicator = reply.getString(0, Math.min(4, reply.size()));
        if (!errorIndicator.startsWith("OK")) {
            throw LoaderException.create(reply);
        }
    }

    private void requestCMD(String cmdString) throws RTEException {
        if (this.isConnected()) {
            try {
                StructuredMem request = this.getRequestPacket();
                request.putString(cmdString, 0);
                int alignedLen = (cmdString.length() + 8 - 1) / 8 * 8;
                this.request(request, alignedLen);
            }
            catch (Exception e) {
                throw new RTEException(e.toString(), this.tracer, 1);
            }
        }
    }

    public int getKernelTaskID() {
        return -666;
    }

    public StructuredMem getRequestPacket() {
        RteSocketPacket result = new RteSocketPacket(new CserverPacketLayout().maxCmdDataLength());
        return result;
    }

    public boolean isAdvancedAuthenticationSupported() throws SQLException {
        return false;
    }

    public boolean isConnected() {
        return this.process != null;
    }

    public StructuredMem receive() throws RTEException {
        if (!this.isConnected()) {
            throw new RTEException("Error session not connected", this.tracer, 1);
        }
        byte[] header = new byte[24];
        int dataLength = 0;
        int bytesRead = 0;
        byte[] readBuf = null;
        StructuredBytes replyHeader = null;
        StructuredBytes result = null;
        try {
            int headerLength = this.procout.read(header, 0, 24);
            if (headerLength != 24) {
                RTEException rteExc = new RTEException(MessageTranslator.translate("error.data.receivefailed"), RteC.CommunicationErrorCodeMap_C[8], this.tracer, 8);
                throw rteExc;
            }
            replyHeader = new StructuredBytes(header);
            int rteRC = replyHeader.getInt2(16);
            if (rteRC != 0) {
                throw new CommunicationException(rteRC, this.tracer);
            }
            dataLength = replyHeader.getInt4(20) - headerLength;
            readBuf = new byte[dataLength];
            result = new StructuredBytes(readBuf);
            int actSendLength = replyHeader.getInt4(0) - headerLength;
            int chunkRead = this.procout.read(readBuf, bytesRead, actSendLength);
            if (chunkRead < 0) {
                throw new RTEException(MessageTranslator.translate("error.data.receivefailed"), RteC.CommunicationErrorCodeMap_C[8], this.tracer, 8);
            }
            return result;
        }
        catch (IOException ioexc) {
            throw new RTEException(MessageTranslator.translate("error.data.receivefailed.reason", ioexc.getMessage()), RteC.CommunicationErrorCodeMap_C[8], this.tracer, 8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.isConnected()) {
            try {
                this.procin.close();
                this.procout.close();
                this.process.waitFor();
            }
            catch (Exception exception) {
            }
            finally {
                this.process = null;
            }
        }
    }

    protected void buildRTEHeader(StructuredBytes packet, int messClass, int sendLen) {
        packet.putInt4(sendLen, 0);
        packet.putInt1(3, 4);
        packet.putInt1(messClass, 5);
        packet.putInt1(0, 6);
        packet.putInt1(0, 7);
        packet.putInt4(42, 8);
        packet.putInt4(42, 12);
        packet.putInt2(0, 16);
        packet.putInt2(0, 18);
        packet.putInt4(sendLen, 20);
    }

    public void request(StructuredMem userPacket, int len) throws RTEException {
        if (!this.isConnected()) {
            throw new RTEException("Error session not connected", this.tracer, 1);
        }
        StructuredBytes rawPacket = ((RteSocketPacket)userPacket).rteHeader;
        this.buildRTEHeader(rawPacket, 63, len);
        this.senddata(rawPacket.bytes(), len + 24);
    }

    private void senddata(byte[] data, int len) throws RTEException {
        try {
            this.procin.write(data, 0, len);
            this.procin.flush();
        }
        catch (Exception e) {
            throw new RTEException("Error piped request failed " + e.toString(), this.tracer, 1);
        }
    }
}

