/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.rte.comm;

import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.rte.comm.BasicSocketComm;
import com.sap.dbtech.rte.comm.JdbcCommFactory;
import com.sap.dbtech.rte.comm.JdbcCommunication;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.rte.comm.RteC;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.Tracer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class NiCommunication
extends BasicSocketComm {
    private static final String NiHandle_Class_C = "com.sap.ni.NiHandle";
    private static final String NiRoute_Class_C = "com.sap.ni.NiRoute";
    private static final String Ni_Class_C = "com.sap.ni.NI";
    private static final String JCO_Class_C = "com.sap.mw.jco.JCO";
    private static final String JCO_Client_Class_C = "com.sap.mw.jco.JCO$Client";
    private static final String JCO_Repository_Class_C = "com.sap.mw.jco.JCO$Repository";
    private static final String JCO_IFunctionTemplate_Class_C = "com.sap.mw.jco.IFunctionTemplate";
    private static final String JCO_Function_Class_C = "com.sap.mw.jco.JCO$Function";
    private static final String JCO_ParameterList_Class_C = "com.sap.mw.jco.JCO$ParameterList";
    private static final String JCO_DsrIPassport_Class_C = "com.sap.jdsr.writer.DsrIPassport";
    private static Class niRoute;
    private static Class niHandle;
    private static Class ni;
    private static Class jco;
    private static Class jco_client;
    private static Class jco_repository;
    private static Class jco_IFunctionTemplate;
    private static Class jco_Function;
    private static Class jco_ParameterList;
    private static Class jco_DsrIPassport;
    private static final String JCO_VAL_KEY = "IV_DBKEY";
    private static final String JCO_VAL_PW = "IV_PW";
    private static final String JCO_VAL_RESULT = "EV_RSTRING";
    String ni_sap_logon_client;
    String ni_sap_logon_user;
    String ni_sap_logon_auth;
    String ni_sap_logon_lang;
    String ni_sap_logon_host;
    String ni_sap_logon_system;
    String ni_sap_logon_group;
    String ni_sap_logon_trans;
    String initialRouterString;
    String sapNiKey;
    String m_lastRouterString = "";
    public static final JdbcCommFactory factory;

    static Class loadClass(String name) throws RTEException {
        try {
            return Class.forName(name);
        }
        catch (Exception ex) {
            throw new RTEException(MessageTranslator.translate("error.host.niloadlibrary", name, ex.toString()), -709, DriverSapDB.pptracer.tracer, 1);
        }
        catch (Error ex) {
            throw new RTEException(MessageTranslator.translate("error.host.niloadlibrary", name, ex.toString()), -709, DriverSapDB.pptracer.tracer, 1);
        }
    }

    public NiCommunication(Properties properties) throws RTEException {
        super(null, properties, 0, DriverSapDB.openTrace((Properties)properties).tracer);
        niRoute = NiCommunication.loadClass(NiRoute_Class_C);
        niHandle = NiCommunication.loadClass(NiHandle_Class_C);
        ni = NiCommunication.loadClass(Ni_Class_C);
        jco = NiCommunication.loadClass(JCO_Class_C);
        jco_client = NiCommunication.loadClass(JCO_Client_Class_C);
        jco_repository = NiCommunication.loadClass(JCO_Repository_Class_C);
        jco_IFunctionTemplate = NiCommunication.loadClass(JCO_IFunctionTemplate_Class_C);
        jco_Function = NiCommunication.loadClass(JCO_Function_Class_C);
        jco_ParameterList = NiCommunication.loadClass(JCO_ParameterList_Class_C);
        jco_DsrIPassport = NiCommunication.loadClass(JCO_DsrIPassport_Class_C);
        this.initialRouterString = properties.getProperty("ni_init_router_string", null);
        if (this.initialRouterString != null && this.initialRouterString.startsWith("sapni:")) {
            int endPattern = this.initialRouterString.indexOf(":inpas", 6);
            if (-1 == endPattern) {
                throw new RTEException(MessageTranslator.translate("error.host.wrongconnecturl", "closing token \":inpas\" not found for SAP routerstring"), -709, this.m_tracer, 1);
            }
            this.initialRouterString = this.initialRouterString.substring(6, endPattern);
            properties.setProperty("ni_init_router_string", this.initialRouterString);
        }
        this.setProperties(properties);
    }

    private void setProperties(Properties properties) {
        if (properties != null) {
            this.ni_sap_logon_client = properties.getProperty("ni_sap_logon_client", "001");
            this.ni_sap_logon_user = properties.getProperty("ni_sap_logon_user", "");
            this.ni_sap_logon_auth = properties.getProperty("ni_sap_logon_auth", "");
            this.ni_sap_logon_lang = properties.getProperty("ni_sap_logon_lang", "en");
            this.ni_sap_logon_host = properties.getProperty("ni_sap_logon_host", "servprod.wdf.sap.corp");
            this.ni_sap_logon_system = properties.getProperty("ni_sap_logon_system", "CSS");
            this.ni_sap_logon_group = properties.getProperty("ni_sap_logon_group", "PUBLIC");
            this.ni_sap_logon_trans = properties.getProperty("ni_sap_logon_trans", "/SPN/SCN_DBCON_NEXT_RSTR");
            this.initialRouterString = properties.getProperty("ni_init_router_string", null);
            this.sapNiKey = properties.getProperty("ni_sap_key", null);
        }
    }

    public NiCommunication(String hostPort, Properties properties, int aServiceType, Tracer tracer) throws RTEException {
        super(hostPort, properties, aServiceType, tracer);
        niRoute = NiCommunication.loadClass(NiRoute_Class_C);
        niHandle = NiCommunication.loadClass(NiHandle_Class_C);
        ni = NiCommunication.loadClass(Ni_Class_C);
        jco = NiCommunication.loadClass(JCO_Class_C);
        jco_client = NiCommunication.loadClass(JCO_Client_Class_C);
        jco_repository = NiCommunication.loadClass(JCO_Repository_Class_C);
        jco_IFunctionTemplate = NiCommunication.loadClass(JCO_IFunctionTemplate_Class_C);
        jco_Function = NiCommunication.loadClass(JCO_Function_Class_C);
        jco_ParameterList = NiCommunication.loadClass(JCO_ParameterList_Class_C);
        jco_DsrIPassport = NiCommunication.loadClass(JCO_DsrIPassport_Class_C);
        this.setProperties(properties);
        try {
            this.initialRouterString = hostPort;
            Constructor cst = niRoute.getConstructor(String.class);
            Object niR = cst.newInstance(hostPort);
            Vector routeEntries = (Vector)niRoute.getField("route_entries").get(niR);
            Object lastEntry = routeEntries.lastElement();
            String curPort = (String)lastEntry.getClass().getMethod("getPort", new Class[0]).invoke(lastEntry, new Object[0]);
            if (curPort == null || curPort.equals("") || curPort.equals("3299")) {
                this.initialRouterString = this.initialRouterString + "/S/" + this.getDefaultPort();
            }
        }
        catch (Exception ioexc) {
            String text = ioexc instanceof InvocationTargetException ? ((InvocationTargetException)ioexc).getTargetException().toString() : ioexc.toString();
            throw new RTEException(MessageTranslator.translate("error.host.niconnect", this.host + ":" + this.port, text, new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5);
        }
        this.openSocket();
    }

    protected BasicSocketComm getNewCommunication() throws RTEException {
        if (this.sapNiKey == null) {
            throw new RTEException(MessageTranslator.translate("error.host.niconnect", this.host + ":" + this.port, "No more connects possible with this sap router string", new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5);
        }
        Properties reconn_prop = new Properties();
        reconn_prop.setProperty("ni_sap_logon_client", this.ni_sap_logon_client);
        reconn_prop.setProperty("ni_sap_logon_user", this.ni_sap_logon_user);
        reconn_prop.setProperty("ni_sap_logon_auth", this.ni_sap_logon_auth);
        reconn_prop.setProperty("ni_sap_logon_lang", this.ni_sap_logon_lang);
        reconn_prop.setProperty("ni_sap_logon_host", this.ni_sap_logon_host);
        reconn_prop.setProperty("ni_sap_logon_system", this.ni_sap_logon_system);
        reconn_prop.setProperty("ni_sap_logon_group", this.ni_sap_logon_group);
        reconn_prop.setProperty("ni_sap_logon_trans", this.ni_sap_logon_trans);
        reconn_prop.setProperty("ni_sap_key", this.sapNiKey);
        return new NiCommunication(this.initialRouterString, reconn_prop, this.m_serviceType, this.m_tracer);
    }

    public String getNewRouterString() throws RTEException {
        if (this.sapNiKey == null) {
            return this.initialRouterString;
        }
        String router = null;
        do {
            try {
                String[] passwordList = this.getPasswordListFromRouterString(this.initialRouterString);
                Method meth = jco.getMethod("createClient", class$java$lang$String == null ? NiCommunication.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? NiCommunication.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? NiCommunication.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? NiCommunication.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? NiCommunication.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? NiCommunication.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? NiCommunication.class$("java.lang.String") : class$java$lang$String);
                Object client = meth.invoke(null, this.ni_sap_logon_client, this.ni_sap_logon_user, this.ni_sap_logon_auth, this.ni_sap_logon_lang, this.ni_sap_logon_host, this.ni_sap_logon_system, this.ni_sap_logon_group);
                meth = jco_client.getMethod("connect", new Class[0]);
                meth.invoke(client, new Object[0]);
                Constructor cst = jco_repository.getConstructor(class$java$lang$String == null ? NiCommunication.class$("java.lang.String") : class$java$lang$String, jco_client);
                Object repository = cst.newInstance("MYRepository", client);
                meth = jco_repository.getMethod("getFunctionTemplate", class$java$lang$String == null ? NiCommunication.class$("java.lang.String") : class$java$lang$String);
                Object template = meth.invoke(repository, this.ni_sap_logon_trans);
                cst = jco_Function.getConstructor(jco_IFunctionTemplate);
                Object function = cst.newInstance(template);
                meth = jco_Function.getMethod("getImportParameterList", new Class[0]);
                Object input = meth.invoke(function, new Object[0]);
                meth = jco_ParameterList.getMethod("setValue", class$java$lang$String == null ? NiCommunication.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? NiCommunication.class$("java.lang.String") : class$java$lang$String);
                meth.invoke(input, this.sapNiKey, JCO_VAL_KEY);
                for (int i = 0; i < passwordList.length; ++i) {
                    if (passwordList[i] == null) continue;
                    String pw = JCO_VAL_PW + (i + 1);
                    meth.invoke(input, passwordList[i], pw);
                }
                meth = jco_client.getMethod("execute", jco_Function);
                meth.invoke(client, function);
                meth = jco_Function.getMethod("getExportParameterList", new Class[0]);
                Object output = meth.invoke(function, new Object[0]);
                meth = jco_ParameterList.getMethod("getString", class$java$lang$String == null ? NiCommunication.class$("java.lang.String") : class$java$lang$String);
                router = (String)meth.invoke(output, JCO_VAL_RESULT);
                meth = jco_client.getMethod("disconnect", new Class[0]);
                meth.invoke(client, new Object[0]);
            }
            catch (Exception ioexc) {
                String text = ioexc instanceof InvocationTargetException ? ((InvocationTargetException)ioexc).getTargetException().toString() : ioexc.toString();
                throw new RTEException(MessageTranslator.translate("error.host.niconnect", this.host + ":" + this.port, text, new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5);
            }
        } while (this.m_lastRouterString.equals(router));
        this.m_lastRouterString = router;
        return router;
    }

    public String[] getPasswordListFromRouterString(String routerString) {
        ArrayList<String> pwList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(routerString, "/");
        int index = 0;
        while (st.hasMoreTokens()) {
            String element = st.nextToken();
            ++index;
            char c = element.charAt(0);
            switch (c) {
                case 'P': 
                case 'W': 
                case 'p': 
                case 'w': {
                    if (index % 2 == 0) break;
                    String password = new String(st.nextToken());
                    pwList.add(password);
                    ++index;
                    break;
                }
            }
        }
        String[] erg = pwList.toArray(new String[pwList.size()]);
        return erg;
    }

    protected void openSocket() throws RTEException {
        try {
            Object talkmode = ni.getField("NI_TALK_NATIVE").get(null);
            Constructor cst = niHandle.getConstructor(String.class, Integer.TYPE, Byte.TYPE);
            Object niHdl = cst.newInstance(this.getNewRouterString(), new Integer(0), talkmode);
            this.socket = (Socket)niHandle.getMethod("getSocket", new Class[0]).invoke(niHdl, new Object[0]);
            try {
                this.socket.setKeepAlive(true);
            }
            catch (SocketException socketEx) {
                // empty catch block
            }
            this.instream = this.socket.getInputStream();
            this.outstream = this.socket.getOutputStream();
        }
        catch (UnknownHostException uhexc) {
            throw new RTEException(MessageTranslator.translate("error.host.niconnect", this.host + ":" + this.port, uhexc.toString(), new Integer(RteC.CommunicationErrorCodeMap_C[13])), RteC.CommunicationErrorCodeMap_C[13], this.m_tracer, 13);
        }
        catch (IOException ioexc) {
            throw new RTEException(MessageTranslator.translate("error.host.niconnect", this.host + ":" + this.port, ioexc.toString(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5);
        }
        catch (Exception ioexc) {
            String text = ioexc instanceof InvocationTargetException ? ((InvocationTargetException)ioexc).getTargetException().toString() : ioexc.toString();
            throw new RTEException(MessageTranslator.translate("error.host.niconnect", this.host, text, new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5);
        }
        try {
            this.socket.setSoLinger(true, 15);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    protected int getDefaultPort() {
        return 7269;
    }

    protected boolean supportsInfoRequest() {
        return true;
    }

    protected int getInitialRequestType() {
        return 51;
    }

    protected boolean closeSocketAfterInfoRequest() {
        return false;
    }

    static {
        factory = new JdbcCommFactory(){

            public JdbcCommunication open(String host, String dbname, Properties properties, Tracer tracer) throws RTEException {
                NiCommunication sc = new NiCommunication(host, properties, 0, tracer);
                sc.connectDB(dbname);
                return sc;
            }

            public JdbcCommunication xopen(String host, String db, String dbroot, String pgm, Properties properties, Tracer tracer) throws RTEException {
                NiCommunication sc = new NiCommunication(host, properties, 4, tracer);
                sc.connectAdmin(db, dbroot, pgm);
                return sc;
            }
        };
    }
}

