/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.rte.comm;

import com.sap.dbtech.rte.comm.JdbcCommFactory;
import com.sap.dbtech.rte.comm.JdbcCommunication;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.Tracer;
import java.sql.SQLException;
import java.util.Properties;

public class NativeComm
extends JdbcCommunication {
    private byte[] nativeStruct;
    private String host;
    private String dbname;
    private String dbroot;
    private String pgm;
    public static final JdbcCommFactory factory = new JdbcCommFactory(){

        public JdbcCommunication open(String host, String dbname, Properties property, Tracer tracer) throws RTEException {
            return new NativeComm(host, dbname);
        }

        public JdbcCommunication xopen(String host, String db, String dbroot, String pgm, Properties properties, Tracer tracer) throws RTEException {
            return new NativeComm(host, db, dbroot, pgm);
        }
    };

    public NativeComm(String host, String dbname) throws RTEException {
        this.host = host;
        this.dbname = dbname;
        this.connect();
    }

    public NativeComm(String host, String dbname, String dbroot, String pgm) throws RTEException {
        this.host = host;
        this.dbname = dbname;
        this.dbroot = dbroot;
        this.pgm = pgm;
        this.connectX();
    }

    public native boolean isChallengeResponseSupportedNative() throws SQLException;

    public native void connect() throws RTEException;

    public native void connectX() throws RTEException;

    public native void cancel() throws SQLException;

    public native StructuredMem getRequestPacket();

    public native boolean isConnected();

    public native StructuredMem receive() throws RTEException;

    public native void reconnect() throws RTEException;

    public native void release();

    public void request(StructuredMem userPacket, int len) throws RTEException {
        this.rawRequest(userPacket.getBytes(0, len), len);
    }

    public native void rawRequest(byte[] var1, int var2) throws RTEException;

    public void finalize() {
        this.release();
    }

    public boolean isAdvancedAuthenticationSupported() throws SQLException {
        try {
            return this.isChallengeResponseSupportedNative();
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
    }

    public int getKernelTaskID() {
        return -42;
    }
}

