/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbcext;

import com.sap.dbtech.jdbcext.XAConnectionSapDB;
import com.sap.dbtech.jdbcext.XADataSourceSapDB;
import com.sap.dbtech.jdbcext.XAResourceHandler;
import com.sap.dbtech.jdbcext.XATransaction;
import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class XAResourceHandlerSimpleImpl
implements XAResourceHandler {
    private XAConnectionSapDB xaConnectionSapDB;

    public boolean isConnectionValidAfterGlobalTransEnd() {
        return false;
    }

    public XAResourceHandlerSimpleImpl(XAConnectionSapDB xaConnectionSapDB) {
        this.xaConnectionSapDB = xaConnectionSapDB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase, XATransaction tx) throws XAException {
        try {
            XATransaction xATransaction = tx;
            synchronized (xATransaction) {
                Connection c = tx.physicalConnection;
                if (c != null) {
                    c.commit();
                    c.close();
                    tx.physicalConnection = null;
                    tx.setStatus(1);
                }
            }
        }
        catch (SQLException sqlEx) {
            this.rollback(xid, tx);
            this.xaConnectionSapDB.xaerror(xid, 6, sqlEx);
        }
    }

    public void end(Xid xid, int flags, XATransaction tx) throws XAException {
    }

    public void forget(Xid xid, XATransaction tx) throws XAException {
        this.rollback(xid, tx);
    }

    public int prepare(Xid xid, XATransaction tx) throws XAException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xid[] recover(int flag) throws XAException {
        XADataSourceSapDB xADataSourceSapDB = this.xaConnectionSapDB.ds;
        synchronized (xADataSourceSapDB) {
            return this.xaConnectionSapDB.ds.getAllPrepared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid, XATransaction tx) throws XAException {
        try {
            XAResourceHandlerSimpleImpl xAResourceHandlerSimpleImpl = this;
            synchronized (xAResourceHandlerSimpleImpl) {
                Connection c = tx.physicalConnection;
                if (c != null) {
                    c.rollback();
                    c.close();
                }
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            tx.physicalConnection = null;
            tx.setStatus(2);
        }
    }

    public void join(Xid xid, XATransaction tx) throws XAException {
        if (tx == null) {
            this.xaConnectionSapDB.xaerror(xid, -5);
        }
        this.xaConnectionSapDB.currentTransaction = tx;
    }

    public void start(Xid xid, XATransaction tx) throws XAException {
    }

    public void resume(Xid xid, XATransaction tx) throws XAException {
    }
}

