/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbcext;

import com.sap.dbtech.jdbcext.XAConnectionSapDB;
import com.sap.dbtech.jdbcext.XAResourceHandler;
import com.sap.dbtech.jdbcext.XATransaction;
import com.sap.dbtech.jdbcext.XidSapDB;
import com.sap.dbtech.util.Tracer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class XAResourceHandlerImpl
implements XAResourceHandler {
    private XAConnectionSapDB xaConnectionSapDB;
    static final char[] HEXdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public boolean isConnectionValidAfterGlobalTransEnd() {
        return true;
    }

    public XAResourceHandlerImpl(XAConnectionSapDB xaConnectionSapDB) {
        this.xaConnectionSapDB = xaConnectionSapDB;
    }

    public void commit(Xid xid, boolean onePhase, XATransaction tx) throws XAException {
        try {
            String sql = "XACOMMIT " + this.XID2String(xid);
            if (onePhase) {
                sql = sql + " TMONEPHASE";
            }
            this.executeSQL(sql);
            tx.setStatus(1);
        }
        catch (SQLException e) {
            this.handleError(e, xid);
        }
    }

    public void end(Xid xid, int flags, XATransaction tx) throws XAException {
        try {
            String sql = "XAEND " + this.XID2String(xid);
            if (flags == 0x4000000) {
                sql = sql + " TMSUCCESS";
            }
            sql = flags == 0x2000000 ? sql + " TMSUSPEND" : sql + " TMFAIL";
            this.executeSQL(sql, tx.physicalConnection);
        }
        catch (SQLException e) {
            this.handleError(e, xid);
        }
    }

    public void forget(Xid xid, XATransaction tx) throws XAException {
        String sql = "XAFORGET " + this.XID2String(xid);
        try {
            this.executeSQL(sql);
        }
        catch (SQLException e) {
            this.handleError(e, xid);
        }
    }

    public int prepare(Xid xid, XATransaction tx) throws XAException {
        String sql = "XAPREPARE " + this.XID2String(xid);
        try {
            this.executeSQL(sql);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == -27647) {
                return 3;
            }
            this.handleError(e, xid);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xid[] recover(int flag) throws XAException {
        switch (flag) {
            case 0x1000000: {
                String sql = "SELECT FORMATID, GLOBALTRANSACTIONID, BRANCHQUALIFIER  FROM DISTRIBUTEDTRANSACTIONS WHERE STATUS = 'PREPARED'    OR STATUS = 'HEURISTICALROLLBACKED'    OR STATUS = 'HEURISTICALCOMMITTED' ";
                Statement stmt = null;
                try {
                    stmt = this.executeSQL(sql);
                    ResultSet rs = stmt.getResultSet();
                    ArrayList<XidSapDB> result = new ArrayList<XidSapDB>();
                    while (rs.next()) {
                        XidSapDB x = new XidSapDB(rs.getBytes(1), Tracer.String2Hex(rs.getString(2)), Tracer.String2Hex(rs.getString(3)));
                        result.add(x);
                    }
                    Xid[] xidArray = result.toArray(new Xid[result.size()]);
                    return xidArray;
                }
                catch (SQLException e) {
                    this.handleError(e, null);
                }
                finally {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e) {}
                    }
                }
            }
            case 0: 
            case 0x800000: {
                return new Xid[0];
            }
        }
        return new Xid[0];
    }

    public void rollback(Xid xid, XATransaction tx) throws XAException {
        String sql = "XAROLLBACK " + this.XID2String(xid);
        try {
            this.executeSQL(sql);
            tx.setStatus(2);
        }
        catch (SQLException e) {
            this.handleError(e, xid);
        }
    }

    public void join(Xid xid, XATransaction tx) throws XAException {
        if (tx == null) {
            try {
                Connection c = this.xaConnectionSapDB.getNonTxConnection();
                if (c != null) {
                    c.setAutoCommit(false);
                } else {
                    c = this.xaConnectionSapDB.ds.openPhysicalConnection(this.xaConnectionSapDB.connectProperties);
                }
                long timeout = System.currentTimeMillis() + (long)(1000 * this.xaConnectionSapDB.transactionTimeout);
                this.xaConnectionSapDB.currentTransaction = tx = new XATransaction(xid, c, timeout, this);
                this.xaConnectionSapDB.ds.addXATransaction(tx);
            }
            catch (SQLException sqlEx) {
                this.xaConnectionSapDB.xaerror(xid, -3, sqlEx);
            }
        }
        String sql = "XASTART " + this.XID2String(xid) + " TMJOIN";
        try {
            this.executeSQL(sql, tx.physicalConnection);
        }
        catch (SQLException e) {
            this.handleError(e, xid);
        }
    }

    public void start(Xid xid, XATransaction tx) throws XAException {
        String sql = "XASTART " + this.XID2String(xid);
        try {
            this.executeSQL(sql);
        }
        catch (SQLException e) {
            this.handleError(e, xid);
        }
    }

    public void resume(Xid xid, XATransaction tx) throws XAException {
        String sql = "XASTART " + this.XID2String(xid) + " TMRESUME";
        try {
            this.executeSQL(sql, tx.physicalConnection);
        }
        catch (SQLException e) {
            this.handleError(e, xid);
        }
    }

    private Statement executeSQL(String sql) throws SQLException {
        Connection conn = this.xaConnectionSapDB.getNonTxConnectionAndOpenOnDemand();
        try {
            return this.executeSQL(sql, conn);
        }
        catch (SQLException e) {
            if (conn.isClosed()) {
                this.xaConnectionSapDB.reconnectNonTxConnection();
                return this.executeSQL(sql, conn);
            }
            throw e;
        }
    }

    private Statement executeSQL(String sql, Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        if (stmt.execute(sql)) {
            return stmt;
        }
        stmt.close();
        return null;
    }

    private String XID2String(Xid xid) {
        int i = xid.getFormatId();
        char[] xidHex = new char[8];
        for (int j = 7; j >= 0; --j) {
            xidHex[j] = HEXdigits[i & 0xF];
            i >>>= 4;
        }
        StringBuffer sb = new StringBuffer(160);
        sb.append("XID_FORMAT x'");
        sb.append(xidHex);
        sb.append("' XID_TRANSACTION x'");
        sb.append(Tracer.Hex2String(xid.getGlobalTransactionId()));
        sb.append("' XID_BRANCH x'");
        sb.append(Tracer.Hex2String(xid.getBranchQualifier()));
        sb.append('\'');
        return sb.toString();
    }

    private void handleError(SQLException e, Xid xid) throws XAException {
        int errorCode = e.getErrorCode();
        switch (errorCode) {
            case -27659: {
                this.xaConnectionSapDB.xaerror(xid, -9, e);
                break;
            }
            case -27658: {
                this.xaConnectionSapDB.xaerror(xid, -8, e);
                break;
            }
            case -27656: {
                this.xaConnectionSapDB.xaerror(xid, -6, e);
                break;
            }
            case -27655: {
                this.xaConnectionSapDB.xaerror(xid, -5, e);
                break;
            }
            case -27654: {
                this.xaConnectionSapDB.xaerror(xid, -4, e);
                break;
            }
            case -27653: {
                this.xaConnectionSapDB.xaerror(xid, -3, e);
                break;
            }
            case -27647: {
                this.xaConnectionSapDB.xaerror(xid, 3, e);
                break;
            }
            case -27550: {
                this.xaConnectionSapDB.xaerror(xid, 100, e);
                break;
            }
            case -4001: 
            case -904: 
            case -813: 
            case -709: 
            case -708: 
            case -75: 
            case -71: 
            case -70: 
            case 700: 
            case 710: 
            case 750: {
                this.xaConnectionSapDB.xaerror(xid, -7, e);
                break;
            }
            default: {
                System.out.println(e.toString());
                this.xaConnectionSapDB.xaerror(xid, -3, e);
            }
        }
    }
}

