/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.DateTranslator;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.util.UnicodeUtil;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Calendar;

public class UnicodeDateTranslator
extends DateTranslator {
    public UnicodeDateTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        String result = null;
        if (!this.isNull(controller, mem)) {
            result = mem.getString(this.bufpos_output, this.physicalLength - 1);
        }
        return result;
    }

    public Date getDate(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        Date result = null;
        if (!this.isNull(controller, mem)) {
            byte[] raw = mem.getBytes(this.bufpos_output, this.physicalLength - 1);
            int year = (raw[1] - 48) * 1000;
            year += (raw[3] - 48) * 100;
            year += (raw[5] - 48) * 10;
            year += raw[7] - 48;
            int month = (raw[11] - 48) * 10;
            month += raw[13] - 48;
            int day = (raw[17] - 48) * 10;
            day += raw[19] - 48;
            if (cal == null) {
                result = new Date(year - 1900, month - 1, day);
            } else {
                cal.clear();
                cal.set(year, month - 1, day, 0, 0, 0);
                result = DBTechTranslator.CalendarUtil.getDateFromCalendar(cal);
            }
        }
        return result;
    }

    protected void putSpecific(DataPart dataPart, Object data) {
        dataPart.putDefineByte(1, this.bufpos_input - 1);
        dataPart.putUnicodeBytes((byte[])data, this.bufpos_input, this.physicalLength - 1);
    }

    public Object transDateForInput(Date arg, Calendar cal) throws SQLException {
        if (arg == null) {
            return null;
        }
        byte[] chars = (byte[])super.transDateForInput(arg, cal);
        byte[] bytes = UnicodeUtil.bytes2BigUnicode(chars);
        this.checkFieldLimits(bytes.length);
        return bytes;
    }
}

