/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import java.io.IOException;
import java.io.InputStream;

public class InputStreamFilter
extends InputStream {
    private long maxlength;
    private InputStream ips;
    private long readlength = 0L;
    private long markedlength = 0L;

    public InputStreamFilter(InputStream ips, long length) {
        this.maxlength = length;
        this.ips = ips;
    }

    public int read() throws IOException {
        if (this.maxlength <= this.readlength++) {
            return -1;
        }
        return this.ips.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.readlength >= this.maxlength) {
            return -1;
        }
        if (this.readlength + (long)len > this.maxlength) {
            len = (int)(this.maxlength - this.readlength);
        }
        if (len <= 0) {
            return 0;
        }
        len = this.ips.read(b, off, len);
        this.readlength += (long)len;
        return len;
    }

    public boolean markSupported() {
        return this.ips.markSupported();
    }

    public void mark(int readlimit) {
        this.ips.mark(readlimit);
        this.markedlength = this.readlength;
    }

    public void reset() throws IOException {
        this.ips.reset();
        this.readlength = this.markedlength;
    }

    public void close() throws IOException {
        this.ips.close();
    }

    public int available() throws IOException {
        return this.ips.available();
    }
}

