/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.packet;

import com.sap.dbtech.jdbc.exceptions.UnicodeConversionException;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.util.StructuredMem;

public class RequestPacketUnicode
extends RequestPacket {
    public RequestPacketUnicode(StructuredMem rawPacket, String applID, String applVers) {
        super(rawPacket, 20, applID, applVers);
    }

    public void addDataString(String data) {
        this.mem.putInt1(1, this.dataPos());
        ++this.partLength;
        this.addString(data);
    }

    public void addStringThrowExc(String data) throws UnicodeConversionException {
        this.addString(data);
    }

    public void addString(String data) {
        char[] chars = data.toCharArray();
        int lenInBytes = chars.length * 2;
        this.mem.putBigUnicode(chars, this.dataPos(), lenInBytes);
        this.partLength += lenInBytes;
    }

    public int putString(String value, int offset) {
        return this.putString(value, offset, value.length());
    }

    public int putString(String value, int offset, int len) {
        char[] chars = value.toCharArray();
        int lenInBytes = 2;
        this.mem.putBigUnicode(chars, offset, len);
        return lenInBytes;
    }

    public boolean isUnicodePacket() {
        return true;
    }
}

