/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.ColumnInfo;
import com.sap.dbtech.jdbc.ConnectionItem;
import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.jdbc.FetchInfo;
import com.sap.dbtech.jdbc.MemoryResultSetSapDB;
import com.sap.dbtech.jdbc.ResultSetSapDB;
import com.sap.dbtech.jdbc.ResultSetSapDBFinalize;
import com.sap.dbtech.jdbc.UpdatableResultSetSapDB;
import com.sap.dbtech.jdbc.UpdatableResultSetSapDBFinalize;
import com.sap.dbtech.jdbc.exceptions.BatchUpdateExceptionSapDB;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.exceptions.UnicodeConversionException;
import com.sap.dbtech.jdbc.packet.PartEnumeration;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.util.MessageTranslator;
import java.lang.ref.WeakReference;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;

public class StatementSapDB
extends ConnectionItem
implements Statement {
    protected ResultSet currentResultSet;
    protected int rowsAffected = -1;
    protected String cursorName;
    protected String defaultCursorName;
    protected final int resultSetType;
    protected int resultSetConcurrency = 1007;
    protected int resultSetHoldability = 1;
    protected int fetchDirection = 1000;
    protected int fetchSize;
    protected Vector batchItems;
    protected int maxRows = 0;
    protected int maxFieldSize = 0;
    protected int queryTimeout = 0;
    protected boolean setWithInfo = false;
    protected boolean hasRowCount = false;
    protected boolean canceled = false;
    protected boolean packetEncodingUnicode = false;
    protected int cursorUsage;
    protected boolean isPoolable = false;
    static final int Cursor_not_used = 0;
    static final int Cursor_in_use = 1;
    static final int Cursor_show = 2;
    static final int Cursor_memory_resultset = 3;
    static final int Cursor_Resurrected = 4;
    static final int Cursor_forward_only = 5;
    static final int Cursor_implicitly_closed = 6;
    protected int statementType;
    static final int Statement_User = 0;
    static final int Statement_Internal = 1;
    static final int Statement_UpdatableResultSet = 2;
    protected static final int defaultConcurrency_C = 1007;
    protected static final int defaultHoldability_C = 1;
    public static final int BATCH_SUCCESS_NO_INFO_C = -2;
    public static final int BATCH_EXECUTE_FAILED_C = -3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatementSapDB(ConnectionSapDB connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(connection);
        this.defaultCursorName = this.cursorName = connection.nextCursorName();
        switch (resultSetType) {
            case 1003: 
            case 1004: 
            case 1005: {
                break;
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue.wexample", "resultSetType", "TYPE_FORWARD_ONLY, TYPE_SCROLL_INSENSITIVE, TYPE_SCROLL_SENSITIVE");
            }
        }
        switch (resultSetConcurrency) {
            case 1007: {
                break;
            }
            case 1008: {
                if (resultSetType != 1003) break;
                resultSetType = 1005;
                break;
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue.wexample", "resultSetConcurrency", "CONCUR_READ_ONLY, CONCUR_UPDATABLE");
            }
        }
        switch (resultSetHoldability) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue.wexample", "resultSetHoldability", "CLOSE_CURSORS_AT_COMMIT, HOLD_CURSORS_OVER_COMMIT");
            }
        }
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.statementType = 0;
        if (this.resultSetHoldability == 2) {
            ArrayList arrayList = connection.statementContainer;
            synchronized (arrayList) {
                connection.statementContainer.add(new WeakReference<StatementSapDB>(this));
            }
        }
    }

    public void addBatch(String sql) throws SQLException {
        if (this.batchItems == null) {
            this.batchItems = new Vector();
        }
        this.batchItems.addElement(sql);
    }

    public void cancel() throws SQLException {
        this.assertOpen();
        this.canceled = true;
        if (this.currentResultSet != null) {
            ((ResultSetSapDB)this.currentResultSet).cancel();
            try {
                ResultSetSapDB rs = (ResultSetSapDB)this.currentResultSet;
                this.connection.cancel(this, rs.getExecutingObject());
            }
            catch (ClassCastException e) {
                this.connection.cancel(this);
            }
        } else {
            this.connection.cancel(this);
        }
    }

    public void clearBatch() throws SQLException {
        this.batchItems = null;
    }

    public void close() throws SQLException {
        if (this.connection != null) {
            this.closeResultSet(false);
            this.connection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeResultSet(boolean restore) throws SQLException {
        if (this.currentResultSet != null) {
            ConnectionSapDB connectionSapDB = this.connection;
            synchronized (connectionSapDB) {
                this.currentResultSet.close();
            }
        }
        if (this.cursorUsage == 2) {
            this.cursorName = this.defaultCursorName;
        }
        if (restore) {
            this.cursorUsage = this.connection.restoreCursor(this.cursorName) ? 4 : 0;
            this.currentResultSet = null;
        } else {
            this.cursorUsage = 0;
            this.currentResultSet = null;
        }
    }

    public boolean execute(String sql) throws SQLException {
        boolean isQuery = false;
        this.setWithInfo = true;
        return this.execute(sql, isQuery, this.resultSetType, this.resultSetConcurrency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean execute(String sql, boolean forQuery, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            boolean isQuery;
            this.canceled = false;
            this.clearWarnings();
            this.assertOpen();
            boolean inTrans = this.connection.isInTransaction();
            if (sql == null) {
                throw SQLExceptionSapDB.generateSQLException("error.sqlstatement.null");
            }
            try {
                this.closeResultSet(true);
                if (this.connection.dbsCache != null) {
                    this.connection.dbsCache.use(sql);
                }
                ReplyPacket replyPacket = this.sendSQL(sql, resultSetType, resultSetConcurrency, false);
                isQuery = this.parseResult(replyPacket, sql, null, null);
            }
            catch (SQLException timeout) {
                if (timeout.getErrorCode() != 700 || inTrans) {
                    throw timeout;
                }
                isQuery = this.execute(sql, forQuery, resultSetType, resultSetConcurrency);
            }
            boolean bl = isQuery;
            return bl;
        }
        finally {
            this.canceled = false;
        }
    }

    protected String getUpdTablename(String sqlCmd) throws SQLException {
        String tabname = null;
        byte[] parseid = null;
        RequestPacket requestPacket = this.connection.getRequestPacket(this.packetEncodingUnicode);
        try {
            requestPacket.initParseCommand(sqlCmd + " FOR UPDATE OF ", true, false, this.resultSetType);
        }
        catch (UnicodeConversionException e1) {
            throw SQLExceptionSapDB.generateSQLException("error.unicodetoAscii", sqlCmd + " FOR UPDATE OF ");
        }
        ReplyPacket replyPacket = this.connection.execute(requestPacket, this, 1);
        PartEnumeration enume = replyPacket.partEnumeration();
        while (enume.hasMoreElements()) {
            enume.nextElement();
            switch (enume.partKind()) {
                case 10: {
                    int parseidPos = replyPacket.getPartDataPos();
                    parseid = replyPacket.getBytes(parseidPos, 12);
                    break;
                }
                case 19: {
                    tabname = replyPacket.getString(replyPacket.getPartDataPos(), replyPacket.partLength());
                }
            }
        }
        this.connection.dropParseid(parseid);
        return tabname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        if (this.batchItems == null) {
            return new int[0];
        }
        this.setWithInfo = false;
        boolean inTrans = this.connection.isInTransaction();
        int count = this.batchItems.size();
        int[] result = new int[count];
        Vector items = this.batchItems;
        this.batchItems = null;
        try {
            this.canceled = false;
            int inputCursor = 0;
            int receiveCursor = 0;
            this.packetEncodingUnicode = false;
            while (inputCursor < count) {
                RequestPacket requestPacket = this.connection.getRequestPacket(this.packetEncodingUnicode);
                try {
                    requestPacket.initDbsCommand(this.connection.autocommit, (String)items.elementAt(inputCursor), 1003);
                }
                catch (UnicodeConversionException e) {
                    this.connection.freeRequestPacket(requestPacket);
                    requestPacket = this.connection.getRequestPacket(true);
                    this.packetEncodingUnicode = true;
                    requestPacket.initDbsCommandThrowSQLExc(this.connection.autocommit, (String)items.elementAt(inputCursor), 1003);
                }
                requestPacket.setMaxSegment((short)Short.MAX_VALUE);
                ++inputCursor;
                try {
                    while (inputCursor < count && requestPacket.initDbsCommand((String)items.elementAt(inputCursor), false, this.connection.autocommit, 1003)) {
                        ++inputCursor;
                    }
                }
                catch (UnicodeConversionException e) {
                    requestPacket.dropSegment();
                    this.packetEncodingUnicode = true;
                }
                ReplyPacket replyPacket = this.connection.execute(requestPacket, true, false, this, 2);
                while (receiveCursor < inputCursor) {
                    if (replyPacket.weakReturnCode() != 0) {
                        int[] resArr = new int[receiveCursor];
                        System.arraycopy(result, 0, resArr, 0, receiveCursor);
                        throw new BatchUpdateExceptionSapDB(resArr, replyPacket.createException());
                    }
                    int functionCode = replyPacket.functionCode();
                    if (functionCode == 4 || functionCode == 216 || functionCode == 27) {
                        int[] resArr = new int[receiveCursor];
                        System.arraycopy(result, 0, resArr, 0, receiveCursor);
                        throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batchresultset.withnumber", Integer.toString(receiveCursor + 1)), "2A000", resArr);
                    }
                    result[receiveCursor] = replyPacket.resultCount(false);
                    if (result[receiveCursor] == -1) {
                        result[receiveCursor] = -2;
                    }
                    replyPacket.nextSegment();
                    ++receiveCursor;
                }
            }
            int[] nArray = result;
            return nArray;
        }
        catch (SQLException timeout) {
            if (timeout.getErrorCode() != 700 || inTrans) {
                throw timeout;
            }
            this.batchItems = items;
            int[] nArray = this.executeBatch();
            return nArray;
        }
        finally {
            this.canceled = false;
        }
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        if (!this.cmdIsQuery(sql)) {
            throw SQLExceptionSapDB.generateSQLException("error.sqlstatement.rowcount");
        }
        this.setWithInfo = true;
        this.execute(sql, true, this.resultSetType, this.resultSetConcurrency);
        return this.currentResultSet;
    }

    public ResultSetSapDB executeQuerySap(String sql) throws SQLException {
        return (ResultSetSapDB)this.executeQuery(sql);
    }

    public int executeUpdate(String sql) throws SQLException {
        this.setWithInfo = false;
        boolean isQuery = this.execute(sql, false, 1003, 1007);
        if (isQuery) {
            throw SQLExceptionSapDB.generateSQLException("error.sqlstatement.resultset");
        }
        if (this.hasRowCount) {
            return this.rowsAffected;
        }
        return 0;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public boolean getMoreResults() throws SQLException {
        this.assertOpen();
        this.rowsAffected = -1;
        return false;
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public ResultSet getResultSet() throws SQLException {
        this.assertOpen();
        return this.currentResultSet;
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    public int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    public int getUpdateCount() throws SQLException {
        this.assertOpen();
        return this.rowsAffected;
    }

    protected boolean isQuerySQL(String sql) {
        if (sql.startsWith("SELECT") || sql.startsWith("DECLARE")) {
            return true;
        }
        String begin = sql.substring(0, Math.min(30, sql.length())).trim().toLowerCase();
        return begin.startsWith("select") || begin.startsWith("declare");
    }

    protected boolean parseResult(ReplyPacket replyPacket, String sqlCmd, DBTechTranslator[] infos, ColumnInfo[] columnNames) throws SQLException {
        String tableName = null;
        boolean isQuery = false;
        boolean rowNotFound = false;
        boolean dataPartFound = false;
        boolean outputColumnNamesPartFound = false;
        this.rowsAffected = -1;
        this.hasRowCount = false;
        int functionCode = replyPacket.functionCode();
        switch (functionCode) {
            case 4: 
            case 27: 
            case 216: 
            case 248: {
                isQuery = true;
                break;
            }
            case 54: {
                if (this.connection.closeCursorAtCommit()) {
                    this.connection.isClosed();
                }
                this.connection.setInTransaction(false);
                break;
            }
            case 241: {
                this.connection.setInTransaction(false);
                this.connection.releaseSession();
                break;
            }
            case 55: {
                this.connection.setInTransaction(false);
                break;
            }
            case 242: {
                this.connection.setInTransaction(false);
                this.connection.releaseSession();
            }
        }
        PartEnumeration enume = replyPacket.partEnumeration();
        while (enume.hasMoreElements()) {
            enume.nextElement();
            int partKind = enume.partKind();
            switch (partKind) {
                case 2: {
                    if (columnNames != null && !outputColumnNamesPartFound) break;
                    columnNames = replyPacket.parseColumnNames(columnNames);
                    break;
                }
                case 14: {
                    if (infos != null) break;
                    infos = replyPacket.parseShortFields(this.connection, false, null, false);
                    break;
                }
                case 32: {
                    if (infos != null) break;
                    infos = replyPacket.parseShortFields(this.connection, false, null, true);
                    break;
                }
                case 12: {
                    if (isQuery) break;
                    this.rowsAffected = replyPacket.resultCount(true);
                    this.hasRowCount = true;
                    break;
                }
                case 13: {
                    String cname = replyPacket.getCursorName();
                    if (cname.length() <= 0) break;
                    this.cursorName = cname;
                    break;
                }
                case 5: 
                case 33: {
                    dataPartFound = true;
                    break;
                }
                case 6: {
                    if (replyPacket.returnCode() != 100) break;
                    this.rowsAffected = -1;
                    rowNotFound = true;
                    if (isQuery) break;
                    this.rowsAffected = 0;
                    break;
                }
                case 19: {
                    tableName = replyPacket.getString(replyPacket.getPartDataPos(), replyPacket.partLength());
                    break;
                }
                case 36: {
                    outputColumnNamesPartFound = true;
                    columnNames = replyPacket.parseSchemaTableColumnNames(columnNames);
                    break;
                }
                case 11: {
                    break;
                }
            }
        }
        if (isQuery) {
            if (this.connection.picky && !outputColumnNamesPartFound && this.connection.isKernelFeaturesupported(9) && sqlCmd != null && functionCode != 248 && functionCode != 27) {
                this.connection.addWarning(new SQLWarning("Output column names part is missing for statement \"" + sqlCmd + "\"."));
            }
            if (functionCode == 27 && this.cursorName.equals("SHOW")) {
                this.cursorUsage = 2;
            } else {
                int n = this.cursorUsage = this.resultSetType == 1003 && this.connection.isKernelFeaturesupported(5) && functionCode != 248 && dataPartFound ? 5 : 1;
                if (replyPacket.isResultSetClosed()) {
                    this.cursorUsage = 0;
                }
            }
            if (replyPacket.nextSegment() != -1 && replyPacket.functionCode() == 224) {
                boolean newSFI = true;
                enume = replyPacket.partEnumeration();
                while (enume.hasMoreElements()) {
                    enume.nextElement();
                    int partKind = enume.partKind();
                    switch (partKind) {
                        case 2: {
                            if (columnNames != null) break;
                            columnNames = replyPacket.parseColumnNames(columnNames);
                            break;
                        }
                        case 14: {
                            if (infos != null) break;
                            infos = replyPacket.parseShortFields(this.connection, false, null, false);
                            break;
                        }
                        case 32: {
                            if (infos != null) break;
                            infos = replyPacket.parseShortFields(this.connection, false, null, true);
                            break;
                        }
                        case 36: {
                            columnNames = replyPacket.parseSchemaTableColumnNames(columnNames);
                            break;
                        }
                        case 6: {
                            newSFI = false;
                            break;
                        }
                    }
                }
                if (newSFI) {
                    this.updateFetchInfo(infos, columnNames);
                }
            }
            if (dataPartFound) {
                this.createResultSet(sqlCmd, tableName, this.cursorName, infos, columnNames, rowNotFound, replyPacket);
            } else {
                this.createResultSet(sqlCmd, tableName, this.cursorName, infos, columnNames, rowNotFound, null);
            }
        } else if (this.cursorUsage == 4) {
            this.connection.dropCursor(this.cursorName, false);
            this.cursorUsage = 0;
        }
        return isQuery;
    }

    protected void createResultSet(String sqlCmd, String tableName, String cursorName, DBTechTranslator[] infos, ColumnInfo[] columnNames, boolean rowNotFound, ReplyPacket reply) throws SQLException {
        try {
            FetchInfo fetchInfo = this.getFetchInfo(cursorName, infos, columnNames);
            if (this.resultSetConcurrency == 1008) {
                if (tableName == null) {
                    tableName = this.getUpdTablename(sqlCmd);
                }
                this.currentResultSet = DriverSapDB.getBooleanProperty(this.connection.getConnectProperties(), "closehandlesonfinalize", true) ? new UpdatableResultSetSapDBFinalize(this.connection, fetchInfo, this, this.fetchSize, this.maxRows, tableName, this.cursorUsage, reply) : new UpdatableResultSetSapDB(this.connection, fetchInfo, this, this.fetchSize, this.maxRows, tableName, this.cursorUsage, reply);
            } else {
                this.currentResultSet = DriverSapDB.getBooleanProperty(this.connection.getConnectProperties(), "closehandlesonfinalize", true) ? new ResultSetSapDBFinalize(this.connection, fetchInfo, this, this.fetchSize, this.maxRows, this.cursorUsage, reply) : new ResultSetSapDB(this.connection, fetchInfo, this, this.fetchSize, this.maxRows, this.cursorUsage, reply);
            }
        }
        catch (SQLException sqlExc) {
            if (sqlExc.getErrorCode() == -4000) {
                this.currentResultSet = new MemoryResultSetSapDB(new String[]{"ROW NOT FOUND"}, new Object[0][]);
                this.cursorUsage = 3;
            }
            throw sqlExc;
        }
        if (this.fetchDirection == 1001) {
            this.currentResultSet.setFetchDirection(this.fetchDirection);
        }
        if (rowNotFound && this.currentResultSet instanceof ResultSetSapDB) {
            ((ResultSetSapDB)this.currentResultSet).setEmpty(true);
        }
    }

    protected FetchInfo getFetchInfo(String cursorName, DBTechTranslator[] infos, ColumnInfo[] columnNames) throws SQLException {
        FetchInfo result = new FetchInfo(this.connection, cursorName, infos, columnNames, this.packetEncodingUnicode);
        return result;
    }

    ReplyPacket sendCommand(RequestPacket requestPacket, String sqlCmd, int gcFlags, boolean parseAgain) throws SQLException, UnicodeConversionException {
        requestPacket.initDbsCommand(this.connection.autocommit, sqlCmd, this.resultSetType);
        if (this.setWithInfo) {
            requestPacket.setWithInfo();
        }
        requestPacket.addCursorPart(this.cursorName);
        ReplyPacket replyPacket = this.connection.execute(requestPacket, this, gcFlags);
        return replyPacket;
    }

    protected ReplyPacket sendSQL(String sql, int resultSetType, int resultSetConcurrency, boolean parseAgain) throws SQLException {
        ReplyPacket replyPacket;
        block25: {
            String actualSQL = sql;
            boolean touchedCommand = false;
            if (resultSetConcurrency == 1008) {
                actualSQL = actualSQL + " FOR UPDATE OF ";
                touchedCommand = true;
            }
            if (resultSetType == 1004) {
                actualSQL = actualSQL + " FOR REUSE";
                touchedCommand = true;
            }
            try {
                if (touchedCommand) {
                    RequestPacket requestPacket = this.connection.getRequestPacket(false);
                    this.packetEncodingUnicode = false;
                    try {
                        try {
                            replyPacket = this.sendCommand(requestPacket, actualSQL, 1, parseAgain);
                            this.packetEncodingUnicode = false;
                            break block25;
                        }
                        catch (UnicodeConversionException e) {
                            this.connection.freeRequestPacket(requestPacket);
                            requestPacket = this.connection.getRequestPacket(true);
                            this.packetEncodingUnicode = true;
                            try {
                                replyPacket = this.sendCommand(requestPacket, actualSQL, 1, parseAgain);
                                break block25;
                            }
                            catch (UnicodeConversionException e1) {
                                throw SQLExceptionSapDB.generateSQLException("error.unicodetoAscii", actualSQL);
                            }
                        }
                        catch (SQLException e) {
                            if (e.getErrorCode() != -8046) {
                                throw e;
                            }
                            this.connection.freeRequestPacket(requestPacket);
                            requestPacket = this.connection.getRequestPacket(true);
                            this.packetEncodingUnicode = true;
                            try {
                                replyPacket = this.sendCommand(requestPacket, actualSQL, 1, parseAgain);
                                break block25;
                            }
                            catch (UnicodeConversionException e1) {
                                throw SQLExceptionSapDB.generateSQLException("error.unicodetoAscii", actualSQL);
                            }
                        }
                    }
                    catch (SQLException sqlExc) {
                        requestPacket = this.connection.getRequestPacket(this.packetEncodingUnicode);
                        try {
                            replyPacket = this.sendCommand(requestPacket, sql, 1, parseAgain);
                            break block25;
                        }
                        catch (UnicodeConversionException e1) {
                            throw SQLExceptionSapDB.generateSQLException("error.unicodetoAscii", sql);
                        }
                    }
                }
                RequestPacket requestPacket = this.connection.getRequestPacket(false);
                try {
                    replyPacket = this.sendCommand(requestPacket, sql, 1, parseAgain);
                    this.packetEncodingUnicode = false;
                }
                catch (UnicodeConversionException e) {
                    this.connection.freeRequestPacket(requestPacket);
                    requestPacket = this.connection.getRequestPacket(true);
                    this.packetEncodingUnicode = true;
                    try {
                        replyPacket = this.sendCommand(requestPacket, sql, 1, parseAgain);
                    }
                    catch (UnicodeConversionException e1) {
                        throw SQLExceptionSapDB.generateSQLException("error.unicodetoAscii", sql);
                    }
                }
                catch (SQLException e) {
                    if (e.getErrorCode() != -8046) {
                        throw e;
                    }
                    this.connection.freeRequestPacket(requestPacket);
                    requestPacket = this.connection.getRequestPacket(true);
                    this.packetEncodingUnicode = true;
                    try {
                        replyPacket = this.sendCommand(requestPacket, actualSQL, 1, parseAgain);
                    }
                    catch (UnicodeConversionException e1) {
                        throw SQLExceptionSapDB.generateSQLException("error.unicodetoAscii", actualSQL);
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw SQLExceptionSapDB.generateSQLException("error.sqlstatement.toolong");
            }
        }
        return replyPacket;
    }

    public void setCursorName(String name) throws SQLException {
        this.assertOpen();
        if (name != null && name.length() > 0) {
            this.defaultCursorName = this.cursorName = name;
        }
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.assertOpen();
    }

    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                break;
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue.wexample", "direction", "FETCH_FORWARD, FETCH_REVERSE, FETCH_UNKNOWN");
            }
        }
        this.fetchDirection = direction;
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw SQLExceptionSapDB.generateSQLException("error.invalid.fetchsize", Integer.toString(rows));
        }
        this.fetchSize = rows;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        if (max < 0) {
            throw SQLExceptionSapDB.generateSQLException("error.invalid.maxfieldsize", Integer.toString(max));
        }
        this.assertOpen();
        this.maxFieldSize = max;
    }

    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw SQLExceptionSapDB.generateSQLException("error.invalid.maxrows", Integer.toString(max));
        }
        this.assertOpen();
        this.maxRows = max > 0 ? max : Integer.MAX_VALUE;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw SQLExceptionSapDB.generateSQLException("error.invalid.querytimeout", Integer.toString(seconds));
        }
        this.assertOpen();
        this.queryTimeout = seconds;
    }

    private boolean cmdIsQuery(String sql) {
        String[] keywords = new String[]{"SELECT", "CALL", "DECLARE", "SHOW", "EXPLAIN"};
        int pos = 0;
        if (sql == null) {
            return false;
        }
        char current = sql.charAt(pos);
        while (current == '(' || Character.isWhitespace(current)) {
            current = sql.charAt(++pos);
        }
        for (int i = 0; i < keywords.length; ++i) {
            if (!sql.regionMatches(true, pos, keywords[i], 0, keywords[i].length())) continue;
            return true;
        }
        return false;
    }

    protected void updateFetchInfo(DBTechTranslator[] infos, ColumnInfo[] columnNames) throws SQLException {
    }

    public boolean getMoreResults(int parm1) throws SQLException {
        return this.getMoreResults();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.autogenkeys.retrieval.unsupported");
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys == 1) {
            throw SQLExceptionSapDB.generateSQLException("error.autogenkeys.retrieval.unsupported");
        }
        return this.executeUpdate(sql);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes.length != 0) {
            throw SQLExceptionSapDB.generateSQLException("error.autogenkeys.retrieval.unsupported");
        }
        return this.executeUpdate(sql);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (columnNames.length != 0) {
            throw SQLExceptionSapDB.generateSQLException("error.autogenkeys.retrieval.unsupported");
        }
        return this.executeUpdate(sql);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys == 1) {
            throw SQLExceptionSapDB.generateSQLException("error.autogenkeys.retrieval.unsupported");
        }
        return this.execute(sql);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes.length != 0) {
            throw SQLExceptionSapDB.generateSQLException("error.autogenkeys.retrieval.unsupported");
        }
        return this.execute(sql);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (columnNames.length != 0) {
            throw SQLExceptionSapDB.generateSQLException("error.autogenkeys.retrieval.unsupported");
        }
        return this.execute(sql);
    }

    public int getResultSetHoldability() throws SQLException {
        return this.resultSetHoldability;
    }

    public boolean isPacketEncodingUnicode() {
        return this.packetEncodingUnicode;
    }

    public String toString() {
        if (this.connection != null && this.connection.session != null) {
            return super.toString() + "[T" + this.connection.session.getKernelTaskID() + "]";
        }
        return super.toString() + "[closed]";
    }

    public boolean isClosed() throws SQLException {
        return this.connection == null || this.connection.session == null;
    }

    public boolean isPoolable() throws SQLException {
        this.assertOpen();
        return this.isPoolable;
    }

    public void setPoolable(boolean poolable) throws SQLException {
        this.assertOpen();
        this.isPoolable = poolable;
    }
}

