/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects;

import com.jalapeno.ObjectManager;
import com.jalapeno.tools.SchemaBuilder;
import com.jalapeno.tools.objects.ClassIterationTask;
import com.jalapeno.tools.objects.ant.Connection;
import com.jalapeno.tools.objects.ant.IntrospectionOptions;
import com.jalapeno.tools.objects.ant.NamedEntity;
import com.jalapeno.tools.objects.ant.RoundTripProjectionOptions;
import com.jalapeno.tools.objects.common.PersisterProperties;
import java.io.File;
import java.net.URL;
import java.util.Properties;
import org.apache.tools.ant.BuildException;

public class SchemaBuilderTask
extends ClassIterationTask {
    private boolean merge = false;
    private boolean rebuildIndices = true;
    private String underscoreReplacement;
    private String dollarReplacement;
    private String mMaxStringLength;
    private String mMaxStringLengthInKey;
    private Connection connection;
    private IntrospectionOptions introspectionOptions;
    private RoundTripProjectionOptions roundTripProjectionOptions;

    @Override
    protected void performOneAction(ObjectManager objectManager, Class clazz, Object object) throws Exception {
    }

    @Override
    public void execute() throws BuildException {
        String[] stringArray;
        Object object;
        System.out.println("Beginning class generation in ant task...");
        Properties properties = new Properties();
        if (this.mClasses == null) {
            throw new BuildException("fatal error no classes element");
        }
        if (this.connection == null) {
            throw new BuildException("fatal error no connection element");
        }
        if (this.introspectionOptions == null) {
            this.introspectionOptions = new IntrospectionOptions();
        }
        if (this.roundTripProjectionOptions == null) {
            this.roundTripProjectionOptions = new RoundTripProjectionOptions();
        }
        properties.setProperty("com.intersys.schemabuilder.namespace", this.connection.getNamespace());
        URL[] uRLArray = null;
        try {
            if (this.getClasspath() != null) {
                object = this.getClasspath().list();
                uRLArray = new URL[((String[])object).length];
                for (int i = 0; i < ((String[])object).length; ++i) {
                    uRLArray[i] = new File(object[i]).toURL();
                }
            }
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
        object = "";
        if (this.getClasspath() != null) {
            String[] stringArray2 = this.getClasspath().list();
            String string = "";
            for (int i = 0; i < stringArray2.length; ++i) {
                object = (String)object + stringArray2[i] + string;
                string = File.pathSeparator;
            }
        } else {
            System.out.println("In " + ((Object)((Object)this)).getClass().toString() + " getClassPath() is null");
        }
        properties.setProperty("com.intersys.schemabuilder.classpath", (String)object);
        properties.setProperty("com.intersys.schemabuilder.host", this.connection.getHost());
        properties.setProperty("com.intersys.schemabuilder.defaultaccesslevel", this.introspectionOptions.getDefaultAccessLevel());
        properties.setProperty("user", this.connection.getUser());
        properties.setProperty("com.intersys.schemabuilder.port", this.connection.getPort());
        properties.setProperty("com.intersys.schemabuilder.metadata", this.introspectionOptions.getMetadata());
        properties.setProperty("com.intersys.schemabuilder.logfile", this.connection.getLogfile());
        properties.setProperty("com.intersys.schemabuilder.exclude", this.introspectionOptions.getExclude());
        properties.setProperty("com.intersys.schemabuilder.defaultaccesstype", this.introspectionOptions.getDefaultAccessType());
        properties.setProperty("com.intersys.schemabuilder.defaultjavaprojectionpackage", this.roundTripProjectionOptions.getDefaultJavaProjectionPackage());
        properties.setProperty("com.intersys.schemabuilder.generationtype", this.roundTripProjectionOptions.getGenerationType());
        if (this.getClasses() != null) {
            stringArray = new String[this.getClasses().size()];
            for (int i = 0; i < this.getClasses().size(); ++i) {
                stringArray[i] = ((NamedEntity)this.getClasses().get(i)).getName();
            }
        } else {
            System.out.println("In " + ((Object)((Object)this)).getClass().toString() + " getClasses() is null, no class names to process");
            return;
        }
        properties.setProperty("com.intersys.schemabuilder.classes", "");
        properties.setProperty("password", this.connection.getPassword());
        properties.setProperty(PersisterProperties.IS_MERGE, new Boolean(this.merge).toString());
        properties.setProperty("com.intersys.schemabuilder.projectiondir", this.roundTripProjectionOptions.getProjectionDir());
        properties.setProperty(PersisterProperties.IS_REBUILD_INDICES, String.valueOf(this.rebuildIndices));
        if (this.dollarReplacement != null) {
            properties.setProperty(PersisterProperties.DOLLAR_REPL, this.dollarReplacement);
        }
        if (this.underscoreReplacement != null) {
            properties.setProperty(PersisterProperties.UNDERSCORE_REPL, this.underscoreReplacement);
        }
        if (this.mMaxStringLength != null) {
            properties.setProperty(PersisterProperties.STRING_MAX_LEN, this.mMaxStringLength);
        }
        if (this.mMaxStringLengthInKey != null) {
            properties.setProperty(PersisterProperties.KEY_MAX_LEN, this.mMaxStringLengthInKey);
        }
        SchemaBuilder schemaBuilder = SchemaBuilder.getRunPersister(properties);
        try {
            schemaBuilder.run(schemaBuilder.getDB(), null, this.roundTripProjectionOptions.getGenerationType(), System.out, uRLArray, stringArray);
            schemaBuilder.close();
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    @Override
    public void addConnection(Connection connection) {
        this.connection = connection;
    }

    public void addIntrospectionOptions(IntrospectionOptions introspectionOptions) {
        this.introspectionOptions = introspectionOptions;
    }

    public void addRoundTripProjectionOptions(RoundTripProjectionOptions roundTripProjectionOptions) {
        this.roundTripProjectionOptions = roundTripProjectionOptions;
    }

    public void setMerge(boolean bl) {
        this.merge = bl;
    }

    public void setRebuildIndices(boolean bl) {
        this.rebuildIndices = bl;
    }

    public void setDollarReplacement(String string) {
        this.dollarReplacement = string;
    }

    public void setUnderscoreReplacement(String string) {
        this.underscoreReplacement = string;
    }

    public void setDefaultStringLength(String string) {
        this.mMaxStringLength = string;
    }

    public void setDefaultKeyLength(String string) {
        this.mMaxStringLengthInKey = string;
    }
}

