/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects;

import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.jalapeno.tools.objects.RefactoringTask;
import com.jalapeno.tools.objects.refactoring.Property;
import org.apache.tools.ant.BuildException;

public class RenamePropertyTask
extends RefactoringTask {
    private String mOldPropName;
    private String mNewPropName;

    public String getNewname() {
        return this.mNewPropName;
    }

    public void setNewname(String string) {
        this.mNewPropName = string;
    }

    public String getProperty() {
        return this.mOldPropName;
    }

    public void setProperty(String string) {
        this.mOldPropName = string;
    }

    @Override
    public void checkAttributes() throws BuildException {
        if (this.mOldPropName == null) {
            throw new BuildException("Missing required attribute: property");
        }
        if (this.mNewPropName == null) {
            throw new BuildException("Missing required attribute: newname");
        }
    }

    @Override
    public String execute(Database database) throws BuildException {
        try {
            return Property.rename(database, this.mClassName, this.mOldPropName, this.mNewPropName);
        }
        catch (CacheException cacheException) {
            cacheException.printFullTrace(System.err);
            throw new BuildException("Failed to rename property " + this.mOldPropName + " to " + this.mNewPropName + " in class " + this.mClassName, (Throwable)cacheException);
        }
    }
}

