/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects;

import com.intersys.objects.CacheDatabase;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.jalapeno.tools.objects.ant.Connection;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class RefactoringTask
extends Task {
    protected Connection mConnection;
    protected String mClassName;

    public void addConnection(Connection connection) {
        this.mConnection = connection;
    }

    public String getClassname() {
        return this.mClassName;
    }

    public void setClassname(String string) {
        this.mClassName = string;
    }

    protected Database getDatabase() throws BuildException {
        String string = "jdbc:Cache://" + this.mConnection.getHost() + ":" + this.mConnection.getPort() + "/" + this.mConnection.getNamespace();
        try {
            return CacheDatabase.getDatabase(string, this.mConnection.getUser(), this.mConnection.getPassword());
        }
        catch (CacheException cacheException) {
            cacheException.printFullTrace(System.err);
            throw new BuildException("Failed to connect to the database at " + string + " as " + this.mConnection.getUser() + ": " + cacheException.getMessage());
        }
    }

    public void execute() throws BuildException {
        Database database = this.getDatabase();
        try {
            database.transactionStart();
        }
        catch (CacheException cacheException) {
            cacheException.printFullTrace(System.err);
            throw new BuildException("Error starting transaction: " + cacheException.getMessage(), (Throwable)cacheException);
        }
        String string = null;
        try {
            string = this.execute(database);
            database.utilities().compileCacheClass(string, "+db");
        }
        catch (Throwable throwable) {
            try {
                database.transactionRollback();
            }
            catch (CacheException cacheException) {
                cacheException.printFullTrace(System.err);
                throw new BuildException("Error rolling back transaction: " + cacheException.getMessage(), (Throwable)cacheException);
            }
            if (throwable instanceof BuildException) {
                throw (BuildException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof CacheException) {
                ((CacheException)throwable).printFullTrace(System.err);
                throw new BuildException("Error compiling classes: " + string, throwable);
            }
            throw new BuildException(throwable);
        }
        try {
            database.transactionCommit();
        }
        catch (CacheException cacheException) {
            cacheException.printFullTrace(System.err);
            throw new BuildException("Error committing transaction: " + cacheException.getMessage(), (Throwable)cacheException);
        }
        try {
            database.utilities().rebuildIndices(string);
        }
        catch (CacheException cacheException) {
            cacheException.printFullTrace(System.err);
            throw new BuildException("Error rebuilding indices: " + cacheException.getMessage(), (Throwable)cacheException);
        }
    }

    protected abstract String execute(Database var1);

    protected void checkAttributes() throws BuildException {
        if (this.mClassName == null) {
            throw new BuildException("Missing required attribute: classname");
        }
    }
}

