/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects;

import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.jalapeno.tools.objects.RefactoringTask;
import com.jalapeno.tools.objects.refactoring.Property;
import org.apache.tools.ant.BuildException;

public class PullUpTask
extends RefactoringTask {
    private String mSuperclass;
    private String[] mProperties;
    private boolean mPullIndices = true;

    public String getProperties() {
        String string = this.mProperties[0];
        for (int i = 1; i < this.mProperties.length; ++i) {
            string = string + "," + this.mProperties[i];
        }
        return string;
    }

    public void setProperties(String string) {
        this.mProperties = string.split(",", 0);
    }

    public String getSuperclass() {
        return this.mSuperclass;
    }

    public void setSuperclass(String string) {
        this.mSuperclass = string;
    }

    public boolean isPullIndices() {
        return this.mPullIndices;
    }

    public void setPullindices(boolean bl) {
        this.mPullIndices = bl;
    }

    @Override
    protected void checkAttributes() throws BuildException {
        super.checkAttributes();
        if (this.mProperties == null) {
            throw new BuildException("Missing required attribute: properties");
        }
        if (this.mSuperclass == null) {
            throw new BuildException("Missing required attribute: superclass");
        }
    }

    @Override
    public String execute(Database database) throws BuildException {
        try {
            return Property.pullUp(database, this.mClassName, this.mSuperclass, this.mProperties, this.mPullIndices);
        }
        catch (CacheException cacheException) {
            cacheException.printFullTrace(System.err);
            throw new BuildException("Failed to pull up properties " + this.getProperties() + " to " + this.getSuperclass() + " from class " + this.mClassName, (Throwable)cacheException);
        }
    }
}

