/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects;

import com.jalapeno.tools.objects.Configurator;
import java.io.File;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class DefaultConfigurator
implements Configurator {
    public static final String INCLUDE = "";
    public static final String EXCLUDE = "";
    public static final String DEFAULT_JAVA_PROJECTION_PACKAGE = "";
    public static final String DEFAULT_ACCESS_LEVEL = "protected";
    public static final String DEFAULT_ACCESS_TYPE = "";
    public static final String USE_ANNOTATIONS = "true";
    public static final String OPTIMISTIC_CONCURRENCY = "false";
    public SortedSet mExcludeList;
    int mDefaultAccessLevel = DefaultConfigurator.calcDefaultAccessLevel("protected");
    int mDefaultAccessType = DefaultConfigurator.calcDefaultAccessType("");
    String mDefaultJavaProjectionPackage = "";
    private boolean mExcludeJava = false;

    @Override
    public Collection getExclusions() {
        if (this.mExcludeJava) {
            return this.getJavaExclusions();
        }
        return this.mExcludeList;
    }

    public Collection getJavaExclusions() {
        if (this.mExcludeList == null) {
            this.mExcludeList = new TreeSet();
        }
        if (!this.mExcludeList.contains("java.")) {
            this.mExcludeList.add("java.");
        }
        if (!this.mExcludeList.contains("javax.")) {
            this.mExcludeList.add("javax.");
        }
        if (!this.mExcludeList.contains("sun.")) {
            this.mExcludeList.add("sun.");
        }
        return this.mExcludeList;
    }

    @Override
    public int getDefaultAccessLevel() {
        return this.mDefaultAccessLevel;
    }

    @Override
    public boolean enableOptimisticConcurrency() {
        return true;
    }

    @Override
    public int getDefaultAccessType() {
        return this.mDefaultAccessType;
    }

    @Override
    public String getDefaultJavaProjectionPackage() {
        if (this.mDefaultJavaProjectionPackage != null && this.mDefaultJavaProjectionPackage.length() == 0) {
            return null;
        }
        return this.mDefaultJavaProjectionPackage;
    }

    @Override
    public String getJavaSourceDir() {
        String string = System.getProperty("user.dir");
        return string + File.separator + "src";
    }

    @Override
    public boolean generateForGettersOnly() {
        return this.mDefaultAccessType == -1 || this.mDefaultAccessType == 12002;
    }

    @Override
    public ClassLoader getLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public String getDollarReplacement() {
        return null;
    }

    @Override
    public String getUnderscoreReplacement() {
        return null;
    }

    @Override
    public boolean rebuildIndices() {
        return true;
    }

    @Override
    public int getMaxStringLength() {
        return 4096;
    }

    @Override
    public int getMaxStringLengthInKey() {
        return 128;
    }

    public void addExcludeString(String string) {
        if (this.mExcludeList == null) {
            this.mExcludeList = new TreeSet();
        }
        this.mExcludeList.add(string);
    }

    public void setExcludeJava(boolean bl) {
        this.mExcludeJava = bl;
    }

    public void setDefaultAccessLevel(int n) {
        this.mDefaultAccessLevel = n;
    }

    public void setDefaultAccessType(int n) {
        this.mDefaultAccessType = n;
    }

    public static int calcDefaultAccessLevel(String string) {
        int n = 4;
        n = string.equals("private") ? 2 : (string.equals("public") ? 1 : 4);
        return n;
    }

    public static int calcDefaultAccessType(String string) {
        if (string.equals("fields")) {
            return 12001;
        }
        if (string.equals("getters")) {
            return 12002;
        }
        if (string.equals("setters")) {
            return 12002;
        }
        if (string.equals("getters and setters")) {
            return 12006;
        }
        return -1;
    }
}

