/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.runtime;

import com.intersys.cache.CacheObject;
import com.intersys.cache.LazyList;
import com.intersys.cache.quick.QuickEmbeddedObject;
import com.intersys.classes.CacheRootObject;
import com.intersys.classes.Persistent;
import com.intersys.classes.RelationshipObject;
import com.intersys.objects.CacheException;
import com.intersys.objects.Id;
import com.intersys.objects.Oid;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import com.jalapeno.runtime.DetachedObjectsManager;
import com.jalapeno.runtime.JalapenoHelperInterface;
import com.jalapeno.runtime.ObjectCopierUtil;
import com.jalapeno.runtime.ObjectFactory;
import com.jalapeno.runtime.PojoOperations;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ObjectCopierFromPojo
extends ObjectCopierUtil {
    private boolean mDeep;

    public ObjectCopierFromPojo(DetachedObjectsManager detachedObjectsManager, ClassLoader classLoader, Map map, boolean bl) {
        super(detachedObjectsManager, classLoader, map);
        this.mDeep = bl;
    }

    public void copyFrom(CacheRootObject cacheRootObject, Object object, CacheField cacheField) throws Exception {
        if (this.mTraversedObjects != null) {
            this.mTraversedObjects.put(object, cacheRootObject);
        }
        CacheClass cacheClass = cacheRootObject.getProxy().getCacheClass();
        CacheField[][] cacheFieldArray = cacheClass.getFieldsByOrder();
        for (int i = 0; i < cacheFieldArray.length; ++i) {
            this.doCopyStep(cacheRootObject, object, cacheFieldArray[i], cacheField);
        }
    }

    public void copyRequiredFrom(CacheRootObject cacheRootObject, Object object, CacheField cacheField) throws Exception {
        if (this.mTraversedObjects != null) {
            this.mTraversedObjects.put(object, cacheRootObject);
        }
        CacheClass cacheClass = cacheRootObject.getProxy().getCacheClass();
        CacheField[][] cacheFieldArray = cacheClass.getFieldsByOrder();
        for (int i = 0; i < cacheFieldArray.length - 1; ++i) {
            this.doCopyStep(cacheRootObject, object, cacheFieldArray[i], cacheField);
        }
    }

    private static boolean hasAllRequiredFields(CacheRootObject cacheRootObject) throws Exception {
        CacheClass cacheClass = cacheRootObject.getProxy().getCacheClass();
        CacheField[][] cacheFieldArray = cacheClass.getFieldsByOrder();
        for (int i = 0; i < cacheFieldArray.length - 1; ++i) {
            int n = 0;
            while (i < cacheFieldArray[i].length) {
                CacheField cacheField = cacheFieldArray[i][n];
                Object object = cacheField.get(cacheRootObject);
                if (object == null) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private void doCopyStep(CacheRootObject cacheRootObject, Object object, CacheField[] cacheFieldArray, CacheField cacheField) throws Exception {
        JalapenoHelperInterface jalapenoHelperInterface = this.getHelper(cacheRootObject);
        for (int i = 0; i < cacheFieldArray.length; ++i) {
            CacheField cacheField2 = cacheFieldArray[i];
            if (cacheField2.equals(cacheField)) continue;
            this.copyField(cacheRootObject, object, cacheField2, jalapenoHelperInterface);
        }
    }

    private void copyField(CacheRootObject cacheRootObject, Object object, CacheField cacheField, JalapenoHelperInterface jalapenoHelperInterface) throws Exception {
        Object object2 = jalapenoHelperInterface.get(object, cacheField.getII());
        if (cacheField.isLiteral()) {
            cacheField.set(cacheRootObject, object2);
        } else if (cacheField.isRelationship()) {
            ObjectCopierFromPojo.ensureSaved(cacheRootObject);
            RelationshipObject relationshipObject = (RelationshipObject)cacheField.get(cacheRootObject);
            List list = relationshipObject.asList();
            Collection collection = object2 != null && object2.getClass().isArray() ? PojoOperations.arrayToList(object2) : (Collection)object2;
            if (collection instanceof LazyList && !((LazyList)collection).isLoaded()) {
                return;
            }
            this.copyRelationshipListFrom(cacheRootObject, collection, list, cacheField);
        } else if (cacheField.isList()) {
            List list = (List)cacheField.get(cacheRootObject);
            Collection collection = object2 != null && object2.getClass().isArray() ? PojoOperations.arrayToList(object2) : (Collection)object2;
            if (collection instanceof LazyList && !((LazyList)collection).isLoaded()) {
                return;
            }
            if (cacheField.isListOfDatatypes()) {
                list.clear();
                if (collection != null) {
                    list.addAll(collection);
                }
            } else if (cacheField.isElementPersistent()) {
                this.copyPersistentListFrom(collection, list);
            } else {
                this.copySerialListFrom(collection, list);
            }
        } else if (cacheField.isArray()) {
            Map map = (Map)cacheField.get(cacheRootObject);
            Map map2 = (Map)object2;
            if (cacheField.isArrayOfDatatypes()) {
                map.clear();
                if (map2 != null) {
                    map.putAll(map2);
                }
            } else if (cacheField.isElementPersistent()) {
                this.copyPersistentArrayFrom(map2, map);
            } else {
                this.copySerialArrayFrom(map2, map);
            }
        } else if (cacheField.isSerial()) {
            if (object2 == null) {
                cacheField.set(cacheRootObject, null);
            } else {
                CacheRootObject cacheRootObject2 = (CacheRootObject)cacheField.get(cacheRootObject);
                if (cacheRootObject2 != null) {
                    this.copyFrom(cacheRootObject2, object2, null);
                } else {
                    cacheField.set(cacheRootObject, this.copySerial(object2));
                }
            }
        } else if (cacheField.getType().isPersistent()) {
            this.copyPersistentField(cacheRootObject, cacheField, object2);
        } else if (cacheField.isStream()) {
            cacheField.set(cacheRootObject, object2);
        } else {
            throw new CacheException("Can not merge in field " + cacheField.getName() + " in Cache class " + cacheField.getDeclaringCacheClass().getName());
        }
    }

    private void copyPersistentField(CacheRootObject cacheRootObject, CacheField cacheField, Object object) throws Exception {
        if (object == null) {
            cacheField.set(cacheRootObject, null);
            return;
        }
        Persistent persistent = (Persistent)cacheField.get(cacheRootObject);
        Persistent persistent2 = !ObjectFactory.isUnswizzledShadow(object) ? this.copyPersistentFrom(persistent, object, false, null, null) : this.findProxy(object);
        if (!persistent2.equals(persistent)) {
            cacheField.set(cacheRootObject, (Object)persistent2);
        }
    }

    private Persistent copyPersistentFrom(Persistent persistent, Object object, boolean bl, CacheField cacheField, CacheRootObject cacheRootObject) throws Exception {
        Id id;
        if (object == null) {
            return null;
        }
        Persistent persistent2 = (Persistent)this.mTraversedObjects.get(object);
        if (persistent2 != null) {
            if (cacheField != null) {
                cacheField.set(persistent2, (Object)cacheRootObject);
            }
            return persistent2;
        }
        boolean bl2 = false;
        persistent2 = this.findProxy(object);
        if (persistent2 != null && cacheField != null) {
            cacheField.set(persistent2, (Object)cacheRootObject);
        }
        Id id2 = id = persistent2 == null ? null : persistent2.getId();
        if (persistent == null) {
            bl2 = true;
        } else {
            Id id3 = persistent.getId();
            if (id3 == null || !id3.equals(id)) {
                bl2 = true;
            }
        }
        if (bl2) {
            boolean bl3 = false;
            if (persistent2 == null) {
                CacheClass cacheClass = this.cacheClassFor(object);
                persistent2 = (Persistent)cacheClass.newInstance((String)null);
                if (!bl) {
                    bl3 = true;
                }
                if (cacheField != null) {
                    cacheField.set(persistent2, (Object)cacheRootObject);
                }
            }
            if (!this.mTraversedObjects.containsKey(object)) {
                if (this.mDeep) {
                    this.copyFrom(persistent2, object, cacheField);
                } else if (bl3 && (persistent2.getId() == null || !ObjectCopierFromPojo.hasAllRequiredFields(persistent2))) {
                    this.copyRequiredFrom(persistent2, object, cacheField);
                }
            }
            if (bl3) {
                this.mManager.register(persistent2, object);
            }
            this.mTraversedObjects.put(object, persistent2);
            return persistent2;
        }
        if (this.mDeep && !this.mTraversedObjects.containsKey(object)) {
            this.copyFrom(persistent, object, null);
        }
        this.mTraversedObjects.put(object, persistent);
        return persistent;
    }

    private Persistent findProxy(Object object) throws Exception {
        return this.mManager.findProxy(object, false);
    }

    private void copyPersistentListFrom(Collection collection, List list) throws Exception {
        list.clear();
        if (collection == null) {
            return;
        }
        for (Object e : collection) {
            Persistent persistent = this.copyPersistentFrom(null, e, false, null, null);
            list.add(persistent);
        }
        if (list.size() != collection.size()) {
            throw new SystemError("Collection size mismatch!");
        }
    }

    private void copyRelationshipListFrom(CacheRootObject cacheRootObject, Collection collection, List list, CacheField cacheField) throws Exception {
        String string = cacheField.getInverseFieldName();
        CacheClass cacheClass = cacheRootObject.getDatabase().getCacheClass(cacheField.getElementTypeName());
        CacheField cacheField2 = cacheClass.getField(string);
        list.clear();
        if (collection == null) {
            return;
        }
        HashSet<Persistent> hashSet = new HashSet<Persistent>(collection.size());
        for (Object e : collection) {
            Persistent persistent = this.copyPersistentFrom(null, e, false, cacheField2, cacheRootObject);
            if (persistent.getId() == null) {
                this.mManager.register(persistent, e);
            }
            if (list.contains(persistent)) continue;
            hashSet.add(persistent);
        }
        list.addAll(hashSet);
        if (list.size() != collection.size()) {
            throw new SystemError("Collection size mismatch!");
        }
    }

    private void copySerialListFrom(Collection collection, List list) throws Exception {
        list.clear();
        if (collection == null) {
            return;
        }
        for (Object e : collection) {
            Object object = this.copySerial(e);
            list.add(object);
        }
    }

    private void copyPersistentArrayFrom(Map map, Map map2) throws Exception {
        map2.clear();
        if (map == null) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            Object v = entry.getValue();
            Persistent persistent = this.copyPersistentFrom(null, v, false, null, null);
            map2.put(entry.getKey(), persistent);
        }
    }

    private void copySerialArrayFrom(Map map, Map map2) throws Exception {
        map2.clear();
        if (map == null) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            Object v = entry.getValue();
            Object object = this.copySerial(v);
            map2.put(entry.getKey(), object);
        }
    }

    private Object copySerial(Object object) throws Exception {
        CacheClass cacheClass = this.cacheClassFor(object);
        CacheRootObject cacheRootObject = (CacheRootObject)cacheClass.newInstance("");
        if (this.mDeep) {
            this.copyFrom(cacheRootObject, object, null);
        } else {
            ObjectCopierFromPojo objectCopierFromPojo = new ObjectCopierFromPojo(this.mManager, this.mLoader, null, true);
            objectCopierFromPojo.copyFrom(cacheRootObject, object, null);
        }
        return cacheRootObject;
    }

    protected static void ensureSaved(CacheRootObject cacheRootObject) throws CacheException {
        if (cacheRootObject instanceof Persistent) {
            Persistent persistent = (Persistent)cacheRootObject;
            Oid oid = persistent.getOid();
            if (oid == null || oid.undefined()) {
                persistent.save(false);
            }
            return;
        }
        CacheObject cacheObject = cacheRootObject.getProxy();
        if (cacheObject instanceof QuickEmbeddedObject) {
            ((QuickEmbeddedObject)cacheObject).ensureSaved();
        }
    }
}

