/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.runtime;

import com.intersys.cache.ClassAnalizer;
import com.intersys.cache.Dataholder;
import com.intersys.cache.StreamAccessHelper;
import com.intersys.cache.quick.ColumnOnlyField;
import com.intersys.cache.quick.TableBasedClass;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.CandidateKey;
import com.intersys.objects.Id;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.CandidateKeyInfo;
import com.intersys.objects.reflect.SQLColumn;
import com.jalapeno.Adaptor;
import com.jalapeno.ObjectManager;
import com.jalapeno.runtime.EmbeddedObjectAccessor;
import com.jalapeno.runtime.JalapenoBasicHelper;
import com.jalapeno.runtime.JalapenoHelperInterface;
import com.jalapeno.runtime.ObjectFactory;
import com.jalapeno.runtime.PojoOperations;
import com.jalapeno.runtime.dynamic.Shadow;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class JalapenoReflectionHelper
extends JalapenoBasicHelper {
    private static final Member[] EMPTY_MEMBER_ARRAY = new Member[0];
    public static final long UNDEFINED_VERSION = -1L;
    public static final Object NULL = null;
    private static final Field UNDEFINED_VERSION_FIELD;
    private static final Field NULL_FIELD;
    private static final Method NULL_SETTER;
    private static final Method ID_PK_GETTER;
    private static final int ALWAYS_ELIGIBLE = 101;
    private static final int NEVER_ELIGIBLE = 102;
    private static final int CHECK_ELIGIBILITY = 103;
    private int mEligibilityCheck = -1;
    private CacheField[] mFieldsToCheckForEligibility;
    private Member[] mPKFieldGetters;
    private CandidateKeyInfo mPKInfo = null;
    private Class mJavaClass;
    private Map mGetterMap;
    private Map mSetterMap;
    private Member mIdGetter;
    private Member mIdSetter;
    private Member mVersionGetter;
    private Member mVersionSetter;
    private Set mAdaptors;
    public static final String DEFAULT_ROW_ID_FIELD = "rowId";
    private Map mDTMap;
    private CacheField[] mFieldsAsColumns;
    private Map mEmbeddedAccessorMap;

    public JalapenoReflectionHelper(CacheClass cacheClass, ClassLoader classLoader, Set set) throws Exception {
        super(cacheClass);
        String string = this.mCacheClass.getJavaPojoName();
        this.mJavaClass = Class.forName(string, false, classLoader);
        int n = this.mCacheClass.getFields().length;
        this.mGetterMap = new HashMap(n);
        this.mSetterMap = new HashMap(n);
        this.mDTMap = new HashMap();
        this.mAdaptors = set;
    }

    protected void setAdaptors(Set set) {
        if (this.mAdaptors != null) {
            throw new IllegalStateException();
        }
        this.mAdaptors = set;
    }

    @Override
    public Object get(Object object, int n) throws Exception {
        Member member = this.getGetter(n);
        return this.get(object, member, n);
    }

    @Override
    public void set(Object object, int n, Object object2) throws Exception {
        SetData setData = this.getSetter(n);
        this.set(object, setData.mutator, object2, setData.isStream, setData.type1);
    }

    @Override
    public Serializable getPojoId(Object object) throws Exception {
        this.checkIdGetter();
        if (this.mIdGetter instanceof Field && ObjectFactory.isProxy(object)) {
            ((Shadow)object).shadowObject_fetchData();
        }
        if (this.mIdGetter == ID_PK_GETTER) {
            return ((CandidateKey)this.getPrimaryKey(object)).toIdValue();
        }
        return (Serializable)this.get(object, this.mIdGetter, 0);
    }

    @Override
    public boolean setPojoId(Object object, Serializable serializable) throws Exception {
        this.checkIdSetter();
        if (this.mIdSetter == NULL_SETTER) {
            return false;
        }
        if (this.mIdSetter instanceof Field) {
            PojoOperations.setValueToField(object, serializable, (Field)this.mIdSetter);
        } else {
            PojoOperations.setPojoIdAsMethod(object, serializable, (Method)this.mIdSetter);
        }
        return true;
    }

    @Override
    public Object getVersionProperty(Object object) throws Exception {
        if (this.mVersionGetter == null) {
            String string = this.mCacheClass.getVersionPropertyName();
            if (string == null) {
                this.mVersionGetter = NULL_FIELD;
            } else {
                CacheField cacheField = this.mCacheClass.getField(string);
                this.mVersionGetter = this.getGetter(cacheField.getII());
            }
        }
        return this.get(object, this.mVersionGetter, 0);
    }

    @Override
    public void setVersionProperty(Object object, Object object2) throws Exception {
        if (this.mVersionSetter == null) {
            String string = this.mCacheClass.getVersionPropertyName();
            if (string == null) {
                this.mVersionSetter = NULL_SETTER;
            } else {
                CacheField cacheField = this.mCacheClass.getField(string);
                this.mVersionSetter = this.getGetter(cacheField.getII());
            }
        }
        this.set(object, this.mVersionSetter, object2, false, null);
    }

    @Override
    public boolean hasIdPlaceholder() throws CacheException {
        this.checkIdGetter();
        return this.mIdGetter != NULL_FIELD && this.mIdGetter != ID_PK_GETTER;
    }

    @Override
    public boolean eligibleForQuickSave(Object object, ObjectManager objectManager, boolean bl, boolean bl2) throws Exception {
        this.setUpEligibilityCheck();
        switch (this.mEligibilityCheck) {
            case 101: {
                return true;
            }
            case 102: {
                return false;
            }
        }
        for (int i = 0; i < this.mFieldsToCheckForEligibility.length; ++i) {
            Object object2;
            CacheField cacheField = this.mFieldsToCheckForEligibility[i];
            if (bl2 && !cacheField.isRequired() || (object2 = this.get(object, cacheField.getII())) == null) continue;
            if (cacheField.isCollection()) {
                if (!(object2 instanceof Collection ? !((Collection)object2).isEmpty() : (object2 instanceof Map ? !((Map)object2).isEmpty() : object2.getClass().isArray() && ((Object[])object2).length != 0))) continue;
                return false;
            }
            if (bl) {
                return false;
            }
            Serializable serializable = objectManager.getId(object2);
            if (serializable != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public Class getJavaType(int n) throws CacheException {
        Member member = this.getGetter(n);
        if (member == null || member == NULL_FIELD) {
            return null;
        }
        if (member instanceof Field) {
            return ((Field)member).getType();
        }
        return ((Method)member).getReturnType();
    }

    @Override
    public Object newInstance() throws IllegalAccessException, InstantiationException {
        return this.mJavaClass.newInstance();
    }

    @Override
    public Object getPrimaryKey(Object object) throws Exception {
        if (this.mPKFieldGetters == null) {
            this.initPKFields();
        }
        if (this.mPKFieldGetters.length == 0) {
            return null;
        }
        CandidateKey candidateKey = new CandidateKey(this.mPKInfo);
        for (int i = 0; i < this.mPKFieldGetters.length; ++i) {
            Object object2 = this.get(object, this.mPKFieldGetters[i], 0);
            String string = object2 == null ? null : object2.toString();
            candidateKey.set(i, string);
        }
        return candidateKey;
    }

    @Override
    public void stuff(Object object, Object object2, ObjectManager objectManager) throws Exception {
        if (!(this.mCacheClass instanceof TableBasedClass) || !this.mCacheClass.isPersistent()) {
            return;
        }
        this.setUpEligibilityCheck();
        if (this.mEligibilityCheck == 102) {
            return;
        }
        if (this.mFieldsAsColumns == null) {
            this.mFieldsAsColumns = ((TableBasedClass)this.mCacheClass).getAllSettableFieldsArray();
        }
        int n = ((TableBasedClass)this.mCacheClass).getNumberOfColumnsForSet() - 1;
        SysListProxy.setInteger(object, n);
        for (int i = 1; i < this.mFieldsAsColumns.length; ++i) {
            CacheField cacheField = this.mFieldsAsColumns[i];
            SQLColumn sQLColumn = cacheField.getSQLColumn();
            if (sQLColumn == null) continue;
            Object object3 = sQLColumn.isForEmbeddedObject() ? null : (sQLColumn.isFromEmbeddedObject() ? this.getFromEmbeddedObject(cacheField, object2) : (cacheField instanceof ColumnOnlyField ? null : this.get(object2, cacheField.getII())));
            if (cacheField.isCollection()) {
                Dataholder dataholder = Dataholder.create(object3);
                dataholder.stuff(object);
                continue;
            }
            if (cacheField.isPersistent()) {
                if (object3 != null) {
                    object3 = this.getPersistentId(cacheField, object3, objectManager);
                }
                SysListProxy.setObject(object, object3);
                continue;
            }
            SysListProxy.setObject(object, object3);
        }
    }

    private synchronized Object getFromEmbeddedObject(CacheField cacheField, Object object) throws Exception {
        String string = cacheField.getSQLColumn().getName();
        EmbeddedObjectAccessor embeddedObjectAccessor = null;
        if (this.mEmbeddedAccessorMap == null) {
            this.mEmbeddedAccessorMap = new HashMap();
        } else {
            embeddedObjectAccessor = (EmbeddedObjectAccessor)this.mEmbeddedAccessorMap.get(string);
        }
        if (embeddedObjectAccessor == null) {
            embeddedObjectAccessor = new EmbeddedObjectAccessor(cacheField);
            this.mEmbeddedAccessorMap.put(string, embeddedObjectAccessor);
        }
        return embeddedObjectAccessor.get(object);
    }

    private synchronized Object getPersistentId(CacheField cacheField, Object object, ObjectManager objectManager) throws Exception {
        Object object2;
        String string = cacheField.getSQLColumn().getName();
        JalapenoHelperInterface jalapenoHelperInterface = null;
        if (this.mEmbeddedAccessorMap == null) {
            this.mEmbeddedAccessorMap = new HashMap();
        } else {
            object2 = this.mEmbeddedAccessorMap.get(string);
            if (object2 instanceof JalapenoHelperInterface) {
                jalapenoHelperInterface = (JalapenoHelperInterface)object2;
            } else {
                Object object3 = objectManager.getId(object);
                if (object3 != null && object3 instanceof Id) {
                    object3 = object3.toString();
                }
                return object3;
            }
        }
        if (jalapenoHelperInterface == null) {
            jalapenoHelperInterface = EmbeddedObjectAccessor.getHelper(cacheField);
            this.mEmbeddedAccessorMap.put(string, jalapenoHelperInterface);
        }
        if (jalapenoHelperInterface.hasIdPlaceholder()) {
            return jalapenoHelperInterface.getPojoId(object);
        }
        object2 = objectManager.getId(object);
        if (object2 != null && object2 instanceof Id) {
            object2 = object2.toString();
        }
        return object2;
    }

    private void initPKFields() throws Exception {
        this.mPKInfo = this.mCacheClass.getBestCandidateKey();
        if (this.mPKInfo == null) {
            this.mPKFieldGetters = EMPTY_MEMBER_ARRAY;
            return;
        }
        SQLColumn[] sQLColumnArray = this.mPKInfo.getColumns();
        if (sQLColumnArray == null) {
            this.mPKFieldGetters = EMPTY_MEMBER_ARRAY;
            return;
        }
        this.mPKFieldGetters = new Member[sQLColumnArray.length];
        for (int i = 0; i < sQLColumnArray.length; ++i) {
            CacheField cacheField = sQLColumnArray[i].getField();
            if (cacheField == null || sQLColumnArray[i].isFromEmbeddedObject() || sQLColumnArray[i].isReference()) {
                this.mPKFieldGetters = EMPTY_MEMBER_ARRAY;
                return;
            }
            this.mPKFieldGetters[i] = this.getGetter(cacheField.getII());
        }
    }

    private Object get(Object object, Member member, int n) throws Exception {
        Integer n2;
        Object object2;
        Class<?> clazz;
        if (member == null || member == NULL_FIELD) {
            return null;
        }
        if (member instanceof Method) {
            clazz = ((Method)member).getReturnType();
            try {
                object2 = ((Method)member).invoke(object, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new CacheException(invocationTargetException.getTargetException());
            }
        } else {
            clazz = ((Field)member).getType();
            object2 = ((Field)member).get(object);
        }
        if (object2 != null && PojoOperations.isJDK5 && PojoOperations.isEnum(object2.getClass()) && (n2 = (Integer)this.mDTMap.get(new Integer(n))) != null) {
            switch (n2) {
                case 4: {
                    object2 = PojoOperations.enumGetOrdinal(object2);
                    break;
                }
                case 2: {
                    object2 = PojoOperations.enumGetName(object2);
                }
            }
        }
        return this.customConvertOnGet(member, clazz, object2);
    }

    private void set(Object object, Member member, Object object2, boolean bl, Class clazz) throws Exception {
        Class<?> clazz2;
        if (member == null || member == NULL_SETTER) {
            return;
        }
        if (bl) {
            if (member instanceof Method && member.getName().startsWith("get")) {
                Object object3 = this.get(object, member, 0);
                StreamAccessHelper.copyStream(object2, object3);
                return;
            }
            object2 = StreamAccessHelper.copyStream(object2, clazz);
        }
        if ((object2 = this.customConvertOnSet(member, clazz2 = member instanceof Method ? ((Method)member).getParameterTypes()[0] : ((Field)member).getType(), object2)) == null && clazz2.isPrimitive()) {
            throw new NullPointerException("Attempt to set null value for property " + this.mJavaClass.getName() + "#" + member.getName());
        }
        if (!clazz2.isInstance(object2)) {
            object2 = PojoOperations.tryConvertValue(clazz2, object2, clazz);
        }
        if (member instanceof Method) {
            try {
                ((Method)member).invoke(object, object2);
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new CacheException(invocationTargetException.getTargetException());
            }
        }
        ((Field)member).set(object, object2);
    }

    private synchronized Member getGetter(int n) throws CacheException {
        Member member = (Member)this.mGetterMap.get(new Integer(n));
        if (member == null) {
            Class<?> clazz;
            CacheField cacheField = this.getField(n);
            String string = cacheField.getJavaName();
            if (cacheField.isStream()) {
                member = this.getGetterMethod(string + "In", false);
            }
            if (member == null) {
                member = this.getGetterMethod(string, true);
            }
            if (member == null) {
                member = this.getField(string, JalapenoReflectionHelper.canBeIgnored(cacheField));
            }
            ((AccessibleObject)((Object)member)).setAccessible(true);
            Integer n2 = new Integer(n);
            this.mGetterMap.put(n2, member);
            Class<?> clazz2 = clazz = member instanceof Field ? ((Field)member).getType() : ((Method)member).getReturnType();
            if (PojoOperations.isEnum(clazz)) {
                CacheClass cacheClass = cacheField.getType().getSuperclass();
                String string2 = cacheClass == null ? null : cacheClass.getName();
                int n3 = 2;
                if (string2 != null && string2.startsWith("%") && string2.endsWith("Integer")) {
                    n3 = 4;
                }
                this.mDTMap.put(n2, new Integer(n3));
            }
        }
        return member;
    }

    private static boolean canBeIgnored(CacheField cacheField) {
        return !cacheField.isRequiredInProjection() || cacheField.isStream();
    }

    private synchronized SetData getSetter(int n) throws Exception {
        SetData setData = (SetData)this.mSetterMap.get(new Integer(n));
        if (setData == null) {
            Class clazz;
            AccessibleObject accessibleObject = null;
            CacheField cacheField = this.getField(n);
            String string = cacheField.getJavaName();
            if (cacheField.isStream()) {
                accessibleObject = this.getGetterMethod(string + "Out", false);
            }
            if (accessibleObject == null) {
                accessibleObject = this.getSetterMethod(string, this.getJavaType(n));
            }
            if (accessibleObject == null) {
                accessibleObject = this.getField(string, JalapenoReflectionHelper.canBeIgnored(cacheField));
            }
            if (accessibleObject == NULL_FIELD) {
                accessibleObject = NULL_SETTER;
            }
            ((AccessibleObject)accessibleObject).setAccessible(true);
            if (cacheField.isStream()) {
                String string2 = cacheField.getJavaTypeName();
                clazz = string2 != null && string2.startsWith("com.intersys.classes") ? null : this.getJavaType(n);
            } else if (this.isAbstractCollection(n)) {
                String string3 = cacheField.getJavaTypeName();
                ClassLoader classLoader = string3.startsWith("com.intersys.classes") ? this.getClass().getClassLoader() : this.mJavaClass.getClassLoader();
                clazz = PojoOperations.classForName(string3, classLoader);
            } else {
                clazz = null;
            }
            setData = new SetData((Member)((Object)accessibleObject), cacheField.isStream(), clazz);
            this.mSetterMap.put(new Integer(n), setData);
        }
        return setData;
    }

    private boolean isAbstractCollection(int n) throws CacheException {
        Class clazz = this.getJavaType(n);
        if (!Modifier.isAbstract(clazz.getModifiers())) {
            return false;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return true;
        }
        return Map.class.isAssignableFrom(clazz);
    }

    private CacheField getField(int n) throws CacheException {
        CacheField cacheField = null;
        CacheField[] cacheFieldArray = this.mCacheClass.getFields();
        for (int i = 0; i < cacheFieldArray.length; ++i) {
            if (cacheFieldArray[i].getII() != n) continue;
            cacheField = cacheFieldArray[i];
            break;
        }
        if (cacheField == null) {
            throw new SystemError("Wrong ii for class " + this.mCacheClass.getName());
        }
        return cacheField;
    }

    private synchronized void checkIdGetter() throws CacheException {
        if (this.mIdGetter == null) {
            this.mIdGetter = this.calculateIdGetter();
            ((AccessibleObject)((Object)this.mIdGetter)).setAccessible(true);
        }
    }

    private synchronized void checkIdSetter() throws CacheException {
        if (this.mIdSetter == null) {
            this.mIdSetter = PojoOperations.lookupPojoIdSetter(this.mJavaClass, this.mCacheClass);
            if (this.mIdSetter == null) {
                this.mIdSetter = NULL_SETTER;
            }
        }
    }

    private synchronized Member calculateIdGetter() throws CacheException {
        CandidateKeyInfo candidateKeyInfo;
        Field field;
        String string = this.mCacheClass.getIdPlaceholder();
        if (string != null) {
            if (string.startsWith("get")) {
                try {
                    return this.mJavaClass.getMethod(string, new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return this.getField(string, false);
        }
        CacheField cacheField = this.mCacheClass.getField("id");
        if (cacheField != null) {
            cacheField = this.mCacheClass.getField(DEFAULT_ROW_ID_FIELD);
            if (cacheField != null) {
                return NULL_FIELD;
            }
            field = this.getField(DEFAULT_ROW_ID_FIELD, true);
        } else {
            try {
                return this.mJavaClass.getMethod("getId", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                field = this.getField(DEFAULT_ROW_ID_FIELD, true);
            }
        }
        if (field == NULL_FIELD && (candidateKeyInfo = this.mCacheClass.getBestCandidateKey()) != null && candidateKeyInfo.isIdKey()) {
            return ID_PK_GETTER;
        }
        return field;
    }

    private Method getGetterMethod(String string, boolean bl) {
        Method method;
        Class[] classArray = new Class[]{};
        String string2 = ClassAnalizer.propertyName2GetterName(string, false);
        try {
            method = this.mJavaClass.getMethod(string2, classArray);
            if (bl) {
                method = this.matchWithSetter(string, string2, method.getReturnType(), method);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            string2 = ClassAnalizer.propertyName2GetterName(string, true);
            try {
                method = this.mJavaClass.getMethod(string2, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                try {
                    method = this.mJavaClass.getMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException3) {
                    return null;
                }
            }
        }
        return method;
    }

    private Method matchWithSetter(String string, String string2, Class clazz, Method method) {
        Method method2 = this.getSetterMethod(string, clazz);
        if (method2 != null) {
            return method;
        }
        Class[] classArray = new Class[]{};
        for (Class clazz2 = this.mJavaClass.getSuperclass(); clazz2 != null && !Object.class.equals(clazz2); clazz2 = clazz2.getSuperclass()) {
            Method method3;
            try {
                method3 = clazz2.getMethod(string2, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            method2 = this.getSetterMethod(string, method3.getReturnType());
            if (method2 == null) continue;
            return method3;
        }
        return method;
    }

    private Method getSetterMethod(String string, Class clazz) {
        Method method;
        Class[] classArray = new Class[]{clazz};
        String string2 = ClassAnalizer.propertyName2SetterName(string);
        try {
            method = this.mJavaClass.getMethod(string2, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                method = this.mJavaClass.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                return null;
            }
        }
        return method;
    }

    private Field getField(String string, boolean bl) throws CacheException {
        Field field;
        try {
            field = this.mJavaClass.getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            try {
                field = PojoOperations.getPrivateField(this.mJavaClass, string);
            }
            catch (NoSuchFieldException noSuchFieldException2) {
                if (string.equals("Id")) {
                    return NULL_FIELD;
                }
                if (bl) {
                    return NULL_FIELD;
                }
                if (string.equals("_Version")) {
                    return UNDEFINED_VERSION_FIELD;
                }
                throw new CacheException("Neither accessor method nor field is found for property " + string + " in class " + this.mJavaClass.getName());
            }
        }
        return field;
    }

    private void setUpEligibilityCheck() throws CacheException {
        if (this.mEligibilityCheck > 0) {
            return;
        }
        ArrayList<CacheField> arrayList = new ArrayList<CacheField>();
        CacheField[] cacheFieldArray = this.mCacheClass.getFields();
        for (int i = 0; i < cacheFieldArray.length; ++i) {
            CacheClass cacheClass;
            CacheField cacheField = cacheFieldArray[i];
            if (cacheField.isLiteral()) continue;
            if (cacheField.isChildTable()) {
                arrayList.add(cacheField);
                continue;
            }
            if (cacheField.isStream()) {
                this.mEligibilityCheck = 102;
                return;
            }
            if (cacheField.isCollection() && cacheField.isElementDatatype()) continue;
            if (cacheField.isCollection()) {
                arrayList.add(cacheField);
                continue;
            }
            if (cacheField.isPersistent()) {
                arrayList.add(cacheField);
                continue;
            }
            if (!cacheField.isSerial() || JalapenoReflectionHelper.checkIfSerialObjectLiteral(cacheClass = cacheField.getType())) continue;
            this.mEligibilityCheck = 102;
            return;
        }
        if (arrayList.isEmpty()) {
            this.mEligibilityCheck = 101;
            return;
        }
        this.mFieldsToCheckForEligibility = new CacheField[arrayList.size()];
        this.mFieldsToCheckForEligibility = arrayList.toArray(this.mFieldsToCheckForEligibility);
        this.mEligibilityCheck = 103;
    }

    public static void doNothingMethod(Object object) {
    }

    private Object customConvertOnSet(Member member, Class clazz, Object object) {
        if (this.mAdaptors == null || this.mAdaptors.isEmpty()) {
            return object;
        }
        for (Adaptor adaptor : this.mAdaptors) {
            if (!adaptor.acceptToRetrieve(member, clazz, object)) continue;
            return adaptor.fromStoredValue(member, object);
        }
        return object;
    }

    private Object customConvertOnGet(Member member, Class clazz, Object object) {
        if (this.mAdaptors == null || this.mAdaptors.isEmpty()) {
            return object;
        }
        for (Adaptor adaptor : this.mAdaptors) {
            if (!adaptor.acceptToStore(member, clazz, object)) continue;
            return adaptor.toStoredValue(member, object);
        }
        return object;
    }

    static {
        try {
            Class<JalapenoReflectionHelper> clazz = JalapenoReflectionHelper.class;
            UNDEFINED_VERSION_FIELD = clazz.getField("UNDEFINED_VERSION");
            NULL_FIELD = clazz.getField("NULL");
            Class[] classArray = new Class[]{Object.class};
            NULL_SETTER = clazz.getMethod("doNothingMethod", classArray);
            ID_PK_GETTER = clazz.getMethod("getPrimaryKey", classArray);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new NoSuchFieldError(noSuchFieldException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchMethodError(noSuchMethodException.getMessage());
        }
    }

    private static class SetData {
        public Member mutator;
        public boolean isStream;
        public Class type1;

        public SetData(Member member, boolean bl, Class clazz) {
            this.isStream = bl;
            this.mutator = member;
            this.type1 = clazz;
        }
    }
}

