/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.runtime;

import com.intersys.cache.quick.LightDatabase;
import com.intersys.objects.Database;
import com.intersys.objects.reflect.CacheClass;
import com.jalapeno.MapFactory;
import com.jalapeno.runtime.CacheObjectManager;
import com.jalapeno.runtime.ObjectBackedMap;
import java.util.Map;

public class CacheMapFactory
implements MapFactory {
    private CacheObjectManager mObjectManager;
    private boolean mAllowUndeclaredKeys;

    public CacheMapFactory(CacheObjectManager cacheObjectManager) {
        this.mObjectManager = cacheObjectManager;
        this.mAllowUndeclaredKeys = false;
    }

    public CacheMapFactory(CacheObjectManager cacheObjectManager, boolean bl) {
        this.mObjectManager = cacheObjectManager;
        this.mAllowUndeclaredKeys = bl;
    }

    @Override
    public Map getMap(Class clazz) throws Exception {
        return this.getMap(clazz, this.mAllowUndeclaredKeys);
    }

    @Override
    public Map getMap(String string) throws Exception {
        return this.getMap(string, this.mAllowUndeclaredKeys);
    }

    @Override
    public Map getMapForTable(String string) throws Exception {
        return this.getMapForTable(string, this.mAllowUndeclaredKeys);
    }

    @Override
    public Map getMap(Class clazz, boolean bl) throws Exception {
        if (bl) {
            throw new UnsupportedOperationException("Flexible mape are not yet implemented");
        }
        CacheClass cacheClass = this.mObjectManager.findImplementation(clazz);
        return new ObjectBackedMap(this.mObjectManager, cacheClass);
    }

    @Override
    public Map getMap(String string, boolean bl) throws Exception {
        if (bl) {
            throw new UnsupportedOperationException("Flexible mape are not yet implemented");
        }
        Database database = this.mObjectManager.mDB;
        CacheClass cacheClass = database.getCacheClass(string);
        return new ObjectBackedMap(this.mObjectManager, cacheClass);
    }

    @Override
    public Map getMapForTable(String string, boolean bl) throws Exception {
        if (bl) {
            throw new UnsupportedOperationException("Flexible mape are not yet implemented");
        }
        Database database = this.mObjectManager.mDB;
        if (!database.isLightConnection()) {
            throw new IllegalStateException("This method allowed only fro light connection");
        }
        CacheClass cacheClass = ((LightDatabase)database).getCacheClassByTableName(string);
        return new ObjectBackedMap(this.mObjectManager, cacheClass);
    }

    @Override
    public MapFactory setAllowUndecalredKeys(boolean bl) {
        if (bl) {
            throw new UnsupportedOperationException("Flexible mape are not yet implemented");
        }
        return this;
    }

    @Override
    public boolean isAllowUndecalredKeys() {
        return this.mAllowUndeclaredKeys;
    }
}

