/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.xep.internal;

import com.intersys.xep.XEPException;
import com.intersys.xep.annotations.Serialized;
import com.intersys.xep.internal.Generator;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class TypeMap {
    static String getCOSType(Field field, Class clazz) throws XEPException {
        if (field.isAnnotationPresent(Serialized.class)) {
            Class clazz2 = field.getType();
            if (clazz2.isArray()) {
                clazz2 = TypeMap.getArrayType(clazz2);
            } else if (!Serializable.class.isAssignableFrom(clazz2)) {
                throw new XEPException("Field marked with @Serialized but does not implement java.io.Serializable");
            }
            return "%Binary";
        }
        if (clazz.isArray()) {
            Class clazz3 = TypeMap.getArrayType(clazz);
            if (TypeMap.setArrayDimension(clazz) > 1) {
                return "%Binary";
            }
            String string = TypeMap.getCOSType(field, clazz3);
            if (string.equals("%Binary")) {
                return "%Binary";
            }
            if (clazz3 == Byte.TYPE || clazz3 == Byte.class) {
                return "%Binary";
            }
            if (clazz3 == Character.TYPE || clazz3 == Character.class) {
                return "%String";
            }
            return "list " + string;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class || clazz == Long.TYPE || clazz == Long.class || clazz == Short.TYPE || clazz == Short.class || clazz == Boolean.TYPE || clazz == Boolean.class || clazz == Byte.TYPE || clazz == Byte.class) {
            return "%Integer";
        }
        if (clazz == Float.TYPE || clazz == Float.class || clazz == Double.TYPE || clazz == Double.class) {
            return "%Double";
        }
        if (clazz == String.class || clazz == Date.class || clazz == Time.class || clazz == Timestamp.class || clazz == java.util.Date.class || clazz == Character.TYPE || clazz == Character.class) {
            return "%String";
        }
        if (clazz.isEnum()) {
            return "%Integer";
        }
        if (List.class.isAssignableFrom(clazz) || Set.class.isAssignableFrom(clazz)) {
            Type type = field.getGenericType();
            if (!(type instanceof ParameterizedType)) {
                return "%Binary";
            }
            if ((type = ((ParameterizedType)type).getActualTypeArguments()[0]) instanceof Class) {
                return "list " + TypeMap.getCOSType(field, (Class)type);
            }
            return "%Binary";
        }
        if (Map.class.isAssignableFrom(clazz)) {
            Type type = field.getGenericType();
            if (!(type instanceof ParameterizedType)) {
                return "%Binary";
            }
            if ((type = ((ParameterizedType)type).getActualTypeArguments()[1]) instanceof Class) {
                return "array " + TypeMap.getCOSType(field, (Class)type);
            }
            return "%Binary";
        }
        return TypeMap.normalizeName(clazz.getName()) + "Serial";
    }

    static int getType(Class clazz) {
        if (Map.class.isAssignableFrom(clazz)) {
            return 530;
        }
        if (List.class.isAssignableFrom(clazz)) {
            return 528;
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return 529;
        }
        if (clazz.isArray()) {
            return TypeMap.setArrayType(TypeMap.getArrayType(clazz));
        }
        if (clazz == String.class) {
            return 0;
        }
        if (clazz == Boolean.TYPE) {
            return 1;
        }
        if (clazz == Boolean.class) {
            return 65;
        }
        if (clazz == Integer.TYPE) {
            return 133;
        }
        if (clazz == Long.TYPE) {
            return 134;
        }
        if (clazz == Integer.class) {
            return 197;
        }
        if (clazz == Long.class) {
            return 198;
        }
        if (clazz == Short.TYPE) {
            return 132;
        }
        if (clazz == Short.class) {
            return 196;
        }
        if (clazz == Float.TYPE) {
            return 263;
        }
        if (clazz == Float.class) {
            return 327;
        }
        if (clazz == Double.TYPE) {
            return 264;
        }
        if (clazz == Double.class) {
            return 328;
        }
        if (clazz == Byte.TYPE) {
            return 130;
        }
        if (clazz == Byte.class) {
            return 194;
        }
        if (clazz == Character.TYPE) {
            return 131;
        }
        if (clazz == Character.class) {
            return 195;
        }
        if (clazz == Time.class) {
            return 75;
        }
        if (clazz == Date.class) {
            return 74;
        }
        if (clazz == Timestamp.class) {
            return 76;
        }
        if (clazz == java.util.Date.class) {
            return 77;
        }
        if (clazz.isEnum()) {
            return 14;
        }
        return 9;
    }

    static int setArrayType(Class clazz) {
        if (clazz.isEnum()) {
            return 46;
        }
        if (clazz == String.class) {
            return 32;
        }
        if (clazz == Boolean.TYPE) {
            return 33;
        }
        if (clazz == Boolean.class) {
            return 97;
        }
        if (clazz == Integer.TYPE) {
            return 165;
        }
        if (clazz == Long.TYPE) {
            return 166;
        }
        if (clazz == Integer.class) {
            return 229;
        }
        if (clazz == Long.class) {
            return 230;
        }
        if (clazz == Short.TYPE) {
            return 164;
        }
        if (clazz == Short.class) {
            return 228;
        }
        if (clazz == Float.TYPE) {
            return 295;
        }
        if (clazz == Float.class) {
            return 359;
        }
        if (clazz == Double.TYPE) {
            return 296;
        }
        if (clazz == Double.class) {
            return 360;
        }
        if (clazz == Byte.TYPE) {
            return 162;
        }
        if (clazz == Byte.class) {
            return 226;
        }
        if (clazz == Character.TYPE) {
            return 163;
        }
        if (clazz == Character.class) {
            return 227;
        }
        if (clazz == Date.class) {
            return 106;
        }
        if (clazz == Time.class) {
            return 107;
        }
        if (clazz == Timestamp.class) {
            return 108;
        }
        if (clazz == java.util.Date.class) {
            return 109;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return 562;
        }
        if (List.class.isAssignableFrom(clazz)) {
            return 560;
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return 561;
        }
        return 41;
    }

    private static boolean isPrimitiveWrapper(Class clazz) {
        return clazz == Boolean.class || clazz == Integer.class || clazz == Long.class || clazz == Short.class || clazz == Float.class || clazz == Double.class || clazz == Byte.class || clazz == Character.class;
    }

    private static boolean isTemporal(Class clazz) {
        return clazz == Date.class || clazz == Time.class || clazz == Timestamp.class || clazz == java.util.Date.class;
    }

    private static boolean isDatatype(Class clazz) {
        return clazz.isPrimitive() || TypeMap.isPrimitiveWrapper(clazz) || clazz == String.class || TypeMap.isTemporal(clazz);
    }

    public static void isEvent(Class clazz, Stack<Class> stack) throws XEPException {
        if (stack.search(clazz) != -1) {
            throw new XEPException("\r\nNot an Event - Circular reference detected:\r\n Class: " + clazz.getName());
        }
        if (TypeMap.isDatatype(clazz) || clazz.isEnum()) {
            return;
        }
        if (clazz == Object.class) {
            throw new XEPException("\r\nNot an event - java.lang.Object is not supported");
        }
        stack.push(clazz);
        ArrayList<Field> arrayList = Generator.getAllFields(clazz);
        for (int i = 0; i < arrayList.size(); ++i) {
            Type type;
            Field field = arrayList.get(i);
            Class clazz2 = field.getType();
            if (field.isAnnotationPresent(Serialized.class)) continue;
            if (clazz2.isArray()) {
                clazz2 = clazz2.getComponentType();
            }
            if (List.class.isAssignableFrom(clazz2) || Set.class.isAssignableFrom(clazz2)) {
                type = field.getGenericType();
                if (!(type instanceof ParameterizedType)) {
                    if (type instanceof GenericArrayType) {
                        type = TypeMap.getParameterizedArrayType(type);
                    } else {
                        throw new XEPException("\r\nNot an Event - Lists have to be typed \r\n Class: " + field.getDeclaringClass() + "\r\n Field: " + field.getName());
                    }
                }
                clazz2 = TypeMap.getBaseType(type, 0);
                TypeMap.isEvent(clazz2, stack);
                continue;
            }
            if (Map.class.isAssignableFrom(clazz2)) {
                type = field.getGenericType();
                if (!(type instanceof ParameterizedType)) {
                    if (type instanceof GenericArrayType) {
                        type = TypeMap.getParameterizedArrayType(type);
                    } else {
                        throw new XEPException("\r\nNot an Event - Maps have to be typed \r\n Class: " + field.getDeclaringClass() + "\r\n Field: " + field.getName());
                    }
                }
                TypeMap.isEvent(TypeMap.getBaseType(type, 0), stack);
                TypeMap.isEvent(TypeMap.getBaseType(type, 1), stack);
                continue;
            }
            if (TypeMap.isDatatype(clazz2) || clazz2.isEnum() || field.isSynthetic()) continue;
            if (clazz == clazz2) {
                throw new XEPException("Not an event: " + clazz2);
            }
            TypeMap.isEvent(clazz2, stack);
        }
        stack.pop();
    }

    public static String normalizeName(String string) {
        return string.replace('_', 'u').replace('$', 'd');
    }

    static boolean isValidKey(Type type) {
        if (!(type instanceof Class)) {
            return false;
        }
        Class clazz = (Class)type;
        return TypeMap.isTemporal(clazz) || TypeMap.isPrimitiveWrapper(clazz) || clazz == String.class;
    }

    static int setArrayDimension(Class clazz) {
        int n = 1;
        while ((clazz = clazz.getComponentType()).isArray()) {
            ++n;
        }
        return n;
    }

    static Class getArrayType(Class clazz) {
        while ((clazz = clazz.getComponentType()).isArray()) {
        }
        return clazz;
    }

    static int setParameterizedArrayDimension(Type type) {
        int n = 1;
        while ((type = ((GenericArrayType)type).getGenericComponentType()) instanceof GenericArrayType) {
            ++n;
        }
        return n;
    }

    static Type getParameterizedArrayType(Type type) {
        while ((type = ((GenericArrayType)type).getGenericComponentType()) instanceof GenericArrayType) {
        }
        return type;
    }

    static String getShortPrimitiveSignature(Class clazz) throws XEPException {
        if (clazz == Boolean.TYPE) {
            return "Z";
        }
        if (clazz == Byte.TYPE) {
            return "B";
        }
        if (clazz == Character.TYPE) {
            return "C";
        }
        if (clazz == Short.TYPE) {
            return "S";
        }
        if (clazz == Integer.TYPE) {
            return "I";
        }
        if (clazz == Long.TYPE) {
            return "J";
        }
        if (clazz == Float.TYPE) {
            return "F";
        }
        if (clazz == Double.TYPE) {
            return "D";
        }
        throw new XEPException("Not a primitive type: " + clazz.getName());
    }

    static Class getBaseType(Type type, int n) throws XEPException {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            return (Class)TypeMap.getParameterizedArrayType(type);
        }
        if (!(type instanceof ParameterizedType)) {
            throw new XEPException("Unrecognized type: " + type);
        }
        Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
        return TypeMap.getBaseType(typeArray[n], 0);
    }
}

