/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.xep;

import com.intersys.gateway.ImportClassLoader;
import com.intersys.mds.MDSException;
import com.intersys.mds.MDSSessionFactory;
import com.intersys.mds.internal.MDSClassInternal;
import com.intersys.mds.internal.MDSInputStream;
import com.intersys.mds.internal.MDSNodeReferenceInternal;
import com.intersys.mds.internal.MDSObjectInputStream;
import com.intersys.mds.internal.MDSObjectOutputStream;
import com.intersys.mds.internal.MDSOutputStream;
import com.intersys.mds.jni.MDSSessionJNI;
import com.intersys.xep.Event;
import com.intersys.xep.InterfaceResolver;
import com.intersys.xep.XEPException;
import com.intersys.xep.internal.Generator;
import com.intersys.xep.internal.ObjectEventGenerator;
import com.intersys.xep.internal.TypeMap;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;

public class EventPersister {
    public static final int OPTION_IMPORT = 0;
    public static final int OPTION_INDEXING_GET_EVENT = 1;
    public static final int OPTION_INDEXING_CLOSE_EVENT = 2;
    public static final int OPTION_ECP_MODE = 3;
    public static final int OPTION_IMPORT_PRESERVE_EXTENT = 1;
    public static final int OPTION_IMPORT_DELETE_EXTENT = 2;
    public static final int OPTION_INDEXING_GET_EVENT_ON = 6;
    public static final int OPTION_INDEXING_GET_EVENT_OFF = 7;
    public static final int OPTION_INDEXING_GET_EVENT_NO_CHANGE = 8;
    public static final int OPTION_INDEXING_CLOSE_EVENT_OFF = 9;
    public static final int OPTION_INDEXING_CLOSE_EVENT_NO_CHANGE = 10;
    public static final int OPTION_ECP_MODE_ON = 11;
    public static final int OPTION_ECP_MODE_OFF = 12;
    private int ecpMode = 0;
    private int ecpRangeSize = 0;
    private int deleteExtentOnImport = 1;
    private int getEventIndexing = 6;
    private int closeEventIndexing = 10;
    private boolean closed = true;
    private MDSSessionJNI session;
    private HashMap<String, MDSClassInternal> eventClassMap = new HashMap();
    private ArrayList<Event> eventList = new ArrayList();
    private Connection jdbcConnection = null;

    public EventPersister() throws XEPException {
        try {
            this.session = MDSSessionFactory.createJNISession();
        }
        catch (Exception exception) {
            throw new XEPException(exception);
        }
        this.initializeDefaultObjectStreams();
    }

    public synchronized void setOption(int n, int n2) throws XEPException {
        switch (n) {
            case 0: {
                this.deleteExtentOnImport = n2;
                return;
            }
            case 1: {
                this.getEventIndexing = n2;
                return;
            }
            case 2: {
                this.closeEventIndexing = n2;
                return;
            }
            case 3: {
                if (this.closed) {
                    this.ecpMode = n2 == 11 ? 1 : 0;
                } else {
                    throw new XEPException("Cannot set ECP mode as the session has already been started");
                }
                return;
            }
        }
        throw new XEPException("Invalid option: " + n);
    }

    public int getOption(int n) throws XEPException {
        switch (n) {
            case 0: {
                return this.deleteExtentOnImport;
            }
            case 1: {
                return this.getEventIndexing;
            }
            case 2: {
                return this.closeEventIndexing;
            }
            case 3: {
                if (this.ecpMode == 1) {
                    return 11;
                }
                return 12;
            }
        }
        throw new XEPException("Invalid option: " + n);
    }

    public synchronized void connect(String string, String string2, String string3) throws XEPException {
        try {
            this.session.connect(string, string2, string3);
        }
        catch (Exception exception) {
            throw new XEPException(exception);
        }
        this.closed = false;
    }

    public synchronized void close() throws XEPException {
        try {
            this.eventClassMap.clear();
            if (this.session != null) {
                this.session.end();
            }
        }
        catch (Exception exception) {
            throw new XEPException(exception);
        }
        this.closed = true;
    }

    public synchronized String[] importSchema(String[] stringArray, InterfaceResolver interfaceResolver) throws XEPException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.addAll(this.generate(stringArray[i], interfaceResolver));
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return stringArray2;
    }

    public synchronized String[] importSchema(String string, InterfaceResolver interfaceResolver) throws XEPException {
        if (string.endsWith(".jar")) {
            return this.importJarFile(string);
        }
        ArrayList<String> arrayList = this.generate(string, interfaceResolver);
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public synchronized String[] importSchema(String string) throws XEPException {
        return this.importSchema(string, null);
    }

    public synchronized String[] importSchema(String[] stringArray) throws XEPException {
        return this.importSchema(stringArray, null);
    }

    public synchronized void setECPMode(int n, int n2) throws XEPException {
        if (!this.closed) {
            throw new XEPException("Cannot set ECP mode as the session has already been started");
        }
        this.ecpMode = n;
        this.ecpRangeSize = n2;
    }

    public synchronized Connection getJDBCConnection() throws XEPException {
        try {
            if (this.jdbcConnection == null) {
                this.jdbcConnection = this.session.getJDBCConnection();
            }
            return this.jdbcConnection;
        }
        catch (Exception exception) {
            throw new XEPException(exception);
        }
    }

    public synchronized void executeUpdate(String string) throws XEPException {
        try {
            this.getJDBCConnection();
            Statement statement = this.jdbcConnection.createStatement();
            statement.executeUpdate(string);
        }
        catch (Exception exception) {
            throw new XEPException(exception);
        }
    }

    public synchronized void startTransaction() throws XEPException {
        try {
            this.session.startTransaction();
        }
        catch (Exception exception) {
            throw new XEPException(exception);
        }
    }

    public synchronized void commit() throws XEPException {
        try {
            this.session.commit();
        }
        catch (Exception exception) {
            throw new XEPException(exception);
        }
    }

    public synchronized void rollback() throws XEPException {
        try {
            this.session.rollback();
        }
        catch (Exception exception) {
            throw new XEPException(exception);
        }
    }

    public synchronized void rollback(int n) throws XEPException {
        try {
            this.session.rollback(n);
        }
        catch (Exception exception) {
            throw new XEPException(exception);
        }
    }

    public synchronized int getTransactionLevel() throws XEPException {
        try {
            return this.session.transactionLevel();
        }
        catch (Exception exception) {
            throw new XEPException(exception);
        }
    }

    public synchronized Event getEvent(String string) throws XEPException {
        Event event = new Event(this, string, this.getEventClass(string));
        this.eventList.add(event);
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized MDSClassInternal getEventClass(String string) throws XEPException {
        MDSClassInternal mDSClassInternal = this.eventClassMap.get(string);
        if (mDSClassInternal != null) {
            return mDSClassInternal;
        }
        try {
            MDSClassInternal mDSClassInternal2 = mDSClassInternal = this.session.createClassInternal(string, this.ecpMode, this.ecpRangeSize);
            synchronized (mDSClassInternal2) {
                mDSClassInternal.loadTypeInfo(ObjectEventGenerator.getMDSTypeInfo(string, false, null));
                this.eventClassMap.put(string, mDSClassInternal);
            }
            return mDSClassInternal;
        }
        catch (MDSException mDSException) {
            throw new XEPException(mDSException);
        }
    }

    private String[] importJarFile(String string) throws XEPException {
        try {
            return this.importSchema(ImportClassLoader.newInstance(string).getAllClassNames());
        }
        catch (Exception exception) {
            throw new XEPException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> generate(String string, InterfaceResolver interfaceResolver) throws XEPException {
        try {
            MDSClassInternal mDSClassInternal;
            Class<?> clazz = Class.forName(string);
            TypeMap.isEvent(clazz, new Stack<Class>());
            if (Generator.eventUpToDate(this.session, clazz, string)) {
                MDSClassInternal mDSClassInternal2;
                EventPersister.checkExtent(this.session, string, this.deleteExtentOnImport == 2);
                MDSClassInternal mDSClassInternal3 = mDSClassInternal2 = this.session.createClassInternal(string, this.ecpMode, this.ecpRangeSize);
                synchronized (mDSClassInternal3) {
                    if (mDSClassInternal2.loadTypeInfo(null) == null) {
                        mDSClassInternal2.storeTypeInfo(ObjectEventGenerator.getMDSTypeInfo(string, true, interfaceResolver));
                    }
                }
                return new ArrayList<String>();
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            ObjectEventGenerator.generate(string, this, this.session, false, arrayList, interfaceResolver);
            MDSClassInternal mDSClassInternal4 = mDSClassInternal = this.session.createClassInternal(string, this.ecpMode, this.ecpRangeSize);
            synchronized (mDSClassInternal4) {
                mDSClassInternal.storeTypeInfo(ObjectEventGenerator.getMDSTypeInfo(string, true, interfaceResolver));
            }
            return arrayList;
        }
        catch (XEPException xEPException) {
            throw xEPException;
        }
        catch (Exception exception) {
            throw new XEPException(exception);
        }
    }

    private static void checkExtent(MDSSessionJNI mDSSessionJNI, String string, boolean bl) throws Exception {
        MDSClassInternal mDSClassInternal = mDSSessionJNI.createClassInternal(string);
        MDSNodeReferenceInternal mDSNodeReferenceInternal = mDSClassInternal.createNodeReferenceInternal();
        if (mDSNodeReferenceInternal.data() == 0) {
            return;
        }
        if (bl) {
            mDSClassInternal.killExtent();
            return;
        }
        throw new XEPException("Extent for " + string + " not empty");
    }

    private void initializeDefaultObjectStreams() throws XEPException {
        try {
            this.session.setObjectStreams(new MDSObjectInputStream(new MDSInputStream()), new MDSObjectOutputStream(new MDSOutputStream()));
        }
        catch (Exception exception) {
            throw new XEPException(exception);
        }
    }
}

