/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.transaction.xa;

import com.intersys.jdbc.CacheConnection;
import java.sql.SQLException;
import java.util.HashMap;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class CacheXAResource
implements XAResource {
    private CacheConnection conn;
    private Xid currentXid;
    private int timeout;
    private HashMap xidToConnectionMap;
    XAConnection xacon;
    String user;
    String password;

    public CacheXAResource(XAConnection xAConnection, String string, String string2) {
        this.xacon = xAConnection;
        this.currentXid = null;
        this.user = string;
        this.password = string2;
        this.xidToConnectionMap = new HashMap();
        try {
            this.conn = (CacheConnection)xAConnection.getConnection();
            if (this.conn == null) {
                throw new XAException("Physical connection closed!");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public final void commit(Xid xid, boolean bl) throws XAException {
        if (this.conn.logFile != null) {
            this.conn.logFile.logApi("XA commit xid = " + xid.toString() + " onePhase = " + bl);
        }
        if (this.currentXid != xid) {
            this.conn.logFile.logApi("Warning: interleaved/nested xids - old Xid: " + this.currentXid + " new Xid: " + xid);
        }
        try {
            int n = this.conn.sendXAMessage(CacheConnection.XA_COMMIT, xid.toString());
            if (n != 0) {
                throw new XAException("XA Commit returned: " + n);
            }
        }
        catch (SQLException sQLException) {
            throw new XAException("Communication link failure");
        }
    }

    @Override
    public final void end(Xid xid, int n) throws XAException {
        if (this.conn.logFile != null) {
            this.conn.logFile.logApi("XA end xid = " + xid.toString() + " flags = " + n);
        }
        if (this.currentXid != xid) {
            this.conn.logFile.logApi("Warning: interleaved/nested xids - old Xid: " + this.currentXid + " new Xid: " + xid);
        }
        try {
            int n2 = this.conn.sendXAMessage(CacheConnection.XA_END, xid.toString());
            if (n2 != 0) {
                throw new XAException("XA End returned: " + n2);
            }
        }
        catch (SQLException sQLException) {
            throw new XAException("Communication link failure");
        }
    }

    @Override
    public final void forget(Xid xid) throws XAException {
        if (this.conn.logFile != null) {
            this.conn.logFile.logApi("XA forget xid = " + xid.toString());
        }
        if (this.currentXid != xid) {
            this.conn.logFile.logApi("Warning: interleaved/nested xids - old Xid: " + this.currentXid + " new Xid: " + xid);
        }
        try {
            int n = this.conn.sendXAMessage(CacheConnection.XA_FORGET, xid.toString());
            if (n != 0) {
                throw new XAException("XA Forget returned: " + n);
            }
        }
        catch (SQLException sQLException) {
            throw new XAException("Communication link failure");
        }
    }

    @Override
    public final int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    @Override
    public final boolean isSameRM(XAResource xAResource) throws XAException {
        return this == xAResource;
    }

    @Override
    public final int prepare(Xid xid) throws XAException {
        if (this.conn.logFile != null) {
            this.conn.logFile.logApi("XA prepare xid = " + xid.toString());
        }
        if (this.currentXid != xid) {
            this.conn.logFile.logApi("Warning: interleaved/nested xids - old Xid: " + this.currentXid + " new Xid: " + xid);
        }
        try {
            int n = this.conn.sendXAMessage(CacheConnection.XA_PREPARE, xid.toString());
            return 0;
        }
        catch (SQLException sQLException) {
            throw new XAException("Communication link failure");
        }
    }

    @Override
    public final Xid[] recover(int n) throws XAException {
        if (this.conn.logFile != null) {
            this.conn.logFile.logApi("XA recover flag = " + n);
        }
        try {
            int n2 = this.conn.sendXAMessage(CacheConnection.XA_RECOVER, null);
            if (n2 != 0) {
                throw new XAException("XA Recover returned: " + n2);
            }
        }
        catch (SQLException sQLException) {
            throw new XAException("Communication link failure");
        }
        return null;
    }

    @Override
    public final void rollback(Xid xid) throws XAException {
        if (this.conn.logFile != null) {
            this.conn.logFile.logApi("XA rollback xid = " + xid.toString());
        }
        if (this.currentXid != xid) {
            this.conn.logFile.logApi("Warning: interleaved/nested xids - old Xid: " + this.currentXid + " new Xid: " + xid);
        }
        try {
            int n = this.conn.sendXAMessage(CacheConnection.XA_ROLLBACK, xid.toString());
            if (n != 0) {
                throw new XAException("XA Rollback returned: " + n);
            }
        }
        catch (SQLException sQLException) {
            throw new XAException("Communication link failure");
        }
    }

    @Override
    public final boolean setTransactionTimeout(int n) throws XAException {
        this.timeout = n;
        return true;
    }

    @Override
    public final void start(Xid xid, int n) throws XAException {
        if (this.conn.logFile != null) {
            this.conn.logFile.logApi("XA start xid = " + xid.toString() + " flags = " + n);
        }
        this.currentXid = xid;
        try {
            int n2 = this.conn.sendXAMessage(CacheConnection.XA_START, xid.toString());
            if (n2 != 0) {
                throw new XAException("XA Start returned: " + n2);
            }
            this.xidToConnectionMap.put(xid, this.conn);
        }
        catch (SQLException sQLException) {
            throw new XAException("Communication link failure");
        }
    }
}

