/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.transaction;

import com.intersys.transaction.CacheTransaction;
import com.intersys.transaction.CacheXid;
import com.intersys.transaction.ExecutionContext;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class CacheTransactionManager
implements TransactionManager {
    private static CacheTransactionManager transactionManager = null;
    private Transaction txn;

    private CacheTransactionManager() {
    }

    public static final CacheTransactionManager getTransactionManager() {
        if (transactionManager == null) {
            transactionManager = new CacheTransactionManager();
        }
        return transactionManager;
    }

    public final void begin() throws NotSupportedException, SystemException {
        this.txn = this.getTransaction();
        if (this.txn != null) {
            throw new NotSupportedException("Nested transactions not supported");
        }
        CacheXid cacheXid = new CacheXid();
        this.txn = new CacheTransaction(this, cacheXid);
        ExecutionContext.setProperty("transaction", this.txn);
        ((CacheTransaction)this.txn).start();
    }

    public final void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.txn = this.getTransaction();
        if (this.txn == null) {
            throw new IllegalStateException("Current thread not associated with transaction");
        }
        this.txn.commit();
        ExecutionContext.removeProperty("transaction");
    }

    public final int getStatus() throws SystemException {
        this.txn = this.getTransaction();
        return this.txn.getStatus();
    }

    public final Transaction getTransaction() throws SystemException {
        return (CacheTransaction)ExecutionContext.getProperty("transaction");
    }

    public final void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.txn = this.getTransaction();
        if (this.txn != null) {
            throw new IllegalStateException("Thread already associated with another transaction");
        }
        int n = ExecutionContext.resumeTransaction(transaction);
        if (n == 0) {
            return;
        }
        if (n == 1) {
            throw new SystemException("No suspended transactions");
        }
        if (n == 2) {
            throw new InvalidTransactionException("Cannot resume non-innermost transaction");
        }
        throw new InvalidTransactionException("Invalid transaction specified");
    }

    public final void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.txn = this.getTransaction();
        if (this.txn == null) {
            throw new IllegalStateException("Current thread not associated with transaction");
        }
        this.txn.rollback();
        ExecutionContext.removeProperty("transaction");
    }

    public final void setRollbackOnly() throws IllegalStateException, SystemException {
        this.txn = this.getTransaction();
        if (this.txn == null) {
            throw new IllegalStateException("Current thread not associated with transaction");
        }
        this.txn.setRollbackOnly();
    }

    public final void setTransactionTimeout(int n) throws SystemException {
        throw new SystemException("Not suppored");
    }

    public final Transaction suspend() throws SystemException {
        this.txn = this.getTransaction();
        ExecutionContext.suspendTransaction();
        return this.txn;
    }
}

