/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.mds.internal;

import java.io.IOException;
import java.io.OutputStream;

public class MDSOutputStream
extends OutputStream {
    private byte[] buffer;
    private boolean startOver = true;

    @Override
    public void write(int n) throws IOException {
        if (this.startOver) {
            this.buffer = new byte[1];
            this.buffer[0] = (byte)n;
            this.startOver = false;
            return;
        }
        this.expandBuffer(1);
        this.buffer[this.buffer.length - 1] = (byte)n;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        if (this.startOver) {
            this.buffer = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.buffer, 0, byArray.length);
            this.startOver = false;
            return;
        }
        int n = this.buffer.length;
        this.expandBuffer(byArray.length);
        System.arraycopy(byArray, 0, this.buffer, n, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 1) {
            return;
        }
        if (this.startOver) {
            this.buffer = new byte[n2];
            System.arraycopy(byArray, n, this.buffer, 0, n2);
            this.startOver = false;
            return;
        }
        int n3 = this.buffer.length;
        this.expandBuffer(n2);
        System.arraycopy(byArray, n, this.buffer, n3, n2);
    }

    public final byte[] getBytes() {
        this.startOver = true;
        return this.buffer;
    }

    private void expandBuffer(int n) {
        byte[] byArray = new byte[this.buffer.length + n];
        System.arraycopy(this.buffer, 0, byArray, 0, this.buffer.length);
        this.buffer = byArray;
    }
}

