/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jsp;

import com.intersys.classes.ArrayOfDataTypes;
import com.intersys.classes.ArrayOfObjects;
import com.intersys.classes.ListOfDataTypes;
import com.intersys.classes.ListOfObjects;
import com.intersys.classes.ObjectHandle;
import com.intersys.classes.Persistent;
import com.intersys.classes.RegisteredObject;
import com.intersys.jsp.DBHelper;
import com.intersys.jsp.ListTag;
import com.intersys.jsp.ObjectTagSupport;
import com.intersys.objects.CacheException;
import com.intersys.objects.ObjectDump;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.CacheModifier;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.Tag;

public class DumpTag
extends ObjectTagSupport {
    private static final int COLLECTION_LIST = 1;
    private static final int COLLECTION_ARRAY = 2;
    private String mEditPar;
    private String mOriginURL;
    private String mOriginText;
    private boolean mEdit;
    private boolean mReadonly;
    private boolean mSave;
    private int mInCollection;
    private String mEditText = "Edit Object";
    private String mViewText = "View Object";
    private ObjectDump mObjectDump;
    private String mCurrentCollection;
    protected Persistent beingDumped;

    public DumpTag() {
        this.setDumpTagInitialState();
    }

    @Override
    public void releaseRequestAttributes() {
        this.setDumpTagInitialState();
        super.releaseRequestAttributes();
    }

    private final void setDumpTagInitialState() {
        this.mEditPar = null;
        this.mOriginURL = null;
        this.mOriginText = null;
        this.mEdit = false;
        this.mSave = true;
        this.mInCollection = 0;
        this.beingDumped = null;
    }

    protected void setEdit(boolean bl) {
        this.mEdit = bl;
    }

    protected void setSave(boolean bl) {
        this.mSave = bl;
    }

    public String getEdittext() {
        return this.mEditText;
    }

    public void setEdittext(String string) {
        this.mEditText = string;
    }

    public String getViewtext() {
        return this.mViewText;
    }

    public void setViewtext(String string) {
        this.mViewText = string;
    }

    public String getSave() {
        return String.valueOf(this.mSave);
    }

    public void setSave(String string) {
        this.mSave = Boolean.valueOf(string);
    }

    public String getReadonly() {
        return String.valueOf(this.mReadonly);
    }

    public void setReadonly(String string) {
        this.mReadonly = Boolean.valueOf(string);
    }

    public int doStartTag() throws JspException {
        return 0;
    }

    public int doEndTag() throws JspException {
        try {
            String string;
            this.setAttributesFromRequest();
            if (this.mEditPar == null) {
                this.mEditPar = DBHelper.getRequestParameter(this.pageContext, "edit");
            }
            if (this.mEditPar != null) {
                this.mEdit = Boolean.valueOf(this.mEditPar);
            }
            if ((string = DBHelper.getRequestParameter(this.pageContext, "save")) != null) {
                this.setSave(string);
            }
            this.dumpObject();
        }
        catch (CacheException cacheException) {
            JspWriter jspWriter = this.pageContext.getOut();
            try {
                jspWriter.println(cacheException.getMessage());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            cacheException.printFullTrace((Writer)jspWriter);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new JspException("Exception dumping object", (Throwable)exception);
        }
        finally {
            this.releaseRequestAttributes();
        }
        return 6;
    }

    private synchronized void dumpObject() throws Exception {
        if (this.mReadonly) {
            this.mEdit = false;
        }
        this.beingDumped = this.openObject();
        this.mObjectDump = new ObjectDump(this.beingDumped);
        HtmlDumper htmlDumper = new HtmlDumper();
        this.writeEditRef();
        this.writeOriginRef();
        this.mObjectDump.dump(htmlDumper);
        htmlDumper.close();
        this.writeEditRef();
        this.writeOriginRef();
        if (this.mEdit && !this.mSave) {
            this.printSaveForm();
        }
    }

    private void writeEditRef() throws Exception {
        if (this.mReadonly) {
            return;
        }
        JspWriter jspWriter = this.pageContext.getOut();
        String string = DBHelper.getURL(this.pageContext);
        int n = string.indexOf("&edit=");
        if (n >= 0) {
            int n2 = string.indexOf(38, n + 1);
            String string2 = n2 > 0 ? string.substring(n2) : null;
            string = string.substring(0, n);
            if (string2 != null) {
                string = string + string2;
            }
        }
        if (this.mEdit) {
            jspWriter.println("<a href=\"" + string + "&edit=false\">" + this.getViewtext() + "</a>");
        } else {
            jspWriter.println("<a href=\"" + string + "&edit=true\">" + this.getEdittext() + "</a>");
        }
    }

    protected void writeOriginRef() throws Exception {
        if (this.mOriginURL == null) {
            return;
        }
        JspWriter jspWriter = this.pageContext.getOut();
        String string = this.mOriginText == null ? "Back" : this.mOriginText;
        jspWriter.println("<br>");
        jspWriter.println("<a href=\"" + this.mOriginURL + "\">" + string + "</a>");
    }

    protected String getOriginRef() {
        if (this.mOriginURL == null) {
            return null;
        }
        String string = "origin=" + DumpTag.encodeURL(this.mOriginURL);
        if (this.mOriginText == null) {
            return string;
        }
        return string + "&origintext=" + DumpTag.encodeURL(this.mOriginText);
    }

    protected static String encodeURL(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                stringBuffer.append('+');
                continue;
            }
            if (Character.isLetter(c)) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append("%" + Integer.toHexString(c));
        }
        return stringBuffer.toString();
    }

    protected String getNewObjectURL() throws Exception {
        return "new.jsp";
    }

    protected String getEditURL() throws IOException {
        try {
            return DBHelper.getURL(this.pageContext);
        }
        catch (JspException jspException) {
            JspWriter jspWriter = this.pageContext.getOut();
            jspWriter.println("ERROR: Can not determine my URL");
            return "";
        }
    }

    void printSaveForm() throws IOException {
        JspWriter jspWriter = this.pageContext.getOut();
        jspWriter.println("<form action=\"set.jsp\" method=\"post\">");
        jspWriter.println("<input type=\"hidden\" name=\"classname\" value=\"" + this.getClassname() + "\">");
        jspWriter.println("<input type=\"hidden\" name=\"id\" value=\"" + this.getId() + "\">");
        jspWriter.println("<input type=\"hidden\" name=\"url\" value=\"" + this.getEditURL() + "\">");
        jspWriter.println("<button type=\"submit\">Save Object</button>");
        jspWriter.println("</form>");
    }

    @Override
    protected void setAttributesFromRequest() throws JspException {
        super.setAttributesFromRequest();
        this.mOriginURL = DBHelper.getRequestParameter(this.pageContext, "origin");
        if (this.mOriginURL != null) {
            this.mOriginText = DBHelper.getRequestParameter(this.pageContext, "origintext");
        }
    }

    private ListTag getListTag(String string, String string2) throws Exception {
        ListTag listTag = new ListTag();
        listTag.setParent((Tag)this);
        listTag.setPageContext(this.pageContext);
        listTag.setTable(string);
        listTag.setProperty(string2);
        listTag.setName(string2);
        return listTag;
    }

    protected class HtmlDumper
    implements ObjectDump.Dumper {
        JspWriter out;

        public HtmlDumper() throws IOException {
            this.out = DumpTag.this.pageContext.getOut();
            this.out.println("<table  CELLSPACING=4 CELLPADDING=4 border=\"2\">");
            this.out.println("<tr>");
        }

        public void close() throws IOException {
            this.out.println("</tr></table>");
        }

        @Override
        public void print(Object object) throws IOException {
            this.out.print("<td>" + object + "</td>");
        }

        @Override
        public void println(Object object) throws IOException {
            if (object instanceof Map.Entry) {
                RegisteredObject registeredObject;
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                Object v = entry.getValue();
                this.out.print("<td><table><tr><td>");
                if (v instanceof Persistent) {
                    registeredObject = (RegisteredObject)v;
                    try {
                        object = "{" + k + ';' + ObjectTagSupport.getDisplayName(registeredObject) + "}";
                    }
                    catch (Exception exception) {
                        object = "ERROR: " + exception.getMessage();
                        exception.printStackTrace(System.out);
                    }
                    this.out.print(object);
                } else if (v instanceof RegisteredObject) {
                    registeredObject = (RegisteredObject)v;
                    this.out.println(k);
                    this.out.println("</td><td><table>");
                    try {
                        ObjectDump objectDump = new ObjectDump(registeredObject, DumpTag.this.mObjectDump);
                        objectDump.dump(this);
                    }
                    catch (Exception exception) {
                        this.out.println("ERROR: " + exception.getMessage());
                        exception.printStackTrace(System.out);
                    }
                    this.out.println("</table>");
                } else {
                    this.out.print(object);
                }
                if (DumpTag.this.mEdit) {
                    this.out.println("</td><td>");
                    try {
                        this.printDeleteArrayButton((String)k);
                    }
                    catch (Exception exception) {
                        this.out.println("ERROR: " + exception.getMessage());
                        exception.printStackTrace(System.out);
                    }
                }
                this.out.print("</td></tr></table></td></tr>");
                return;
            }
            if (DumpTag.this.mEdit && DumpTag.this.mInCollection == 1) {
                this.out.println("<td>" + object + "</td><td>");
                this.printDeleteListButton(object);
                this.out.println("</td></tr>");
                return;
            }
            this.out.println("<td>" + object + "</td></tr>");
            this.out.print("<tr>");
        }

        @Override
        public void dump(String string, Object object, ObjectHandle objectHandle) throws IOException {
            if (DumpTag.this.mEdit) {
                try {
                    this.printEditForm(string, object, objectHandle);
                    return;
                }
                catch (CacheException cacheException) {
                    this.println(string + ": ERROR: " + cacheException.getMessage());
                    cacheException.printStackTrace(System.out);
                }
            } else {
                this.println(string + "</td><td>" + object + "</td>");
            }
        }

        private void printEditForm(String string, Object object, ObjectHandle objectHandle) throws CacheException, IOException {
            String string2;
            RegisteredObject registeredObject = (RegisteredObject)objectHandle;
            CacheClass cacheClass = registeredObject.getCacheClass();
            CacheField cacheField = cacheClass.getField(string);
            boolean bl = DumpTag.this.isStream(cacheField.getType());
            boolean bl2 = cacheField != null && CacheModifier.isReadOnly(cacheField.getModifiers());
            String string3 = cacheClass.getName();
            try {
                string2 = this.storeObject(string3, registeredObject);
            }
            catch (JspException jspException) {
                this.out.print("ERROR: " + jspException.getMessage());
                jspException.printStackTrace();
                string2 = null;
            }
            this.print(string);
            this.out.println("<td>");
            this.printFormCommonElements(false, bl);
            this.out.println("<input type=\"hidden\" name=\"orefclass\" value=\"" + string3 + "\">");
            this.out.println("<input type=\"hidden\" name=\"oref\" value=\"" + string2 + "\">");
            this.out.println("<input type=\"hidden\" name=\"field\" value=\"" + string + "\">");
            if (bl) {
                this.out.println("<textarea rows=\"5\" cols=\"25\"");
            } else {
                this.out.println("<input type=\"text\" value=\"" + object + "\"");
            }
            if (bl2) {
                this.out.println(" disabled ");
            }
            this.out.println(" name = \"" + string + "\">");
            if (bl) {
                this.out.println(object);
                this.out.println("</textarea>");
            }
            this.out.println("<button type=\"submit\">Change Value</button>");
            this.out.println("</form>");
            this.out.println("</td>");
            this.out.println("</tr>");
            this.out.print("<tr>");
        }

        private void printFormCommonElements(boolean bl, boolean bl2) throws IOException {
            this.out.print("<form action=\"set.jsp\" ");
            if (bl2) {
                this.out.println("method=\"post\">");
            } else {
                this.out.println("method=\"get\">");
            }
            this.out.println("<input type=\"hidden\" name=\"classname\" value=\"" + DumpTag.this.getClassname() + "\">");
            this.out.println("<input type=\"hidden\" name=\"id\" value=\"" + DumpTag.this.getId() + "\">");
            String string = DumpTag.this.getEditURL();
            if (DumpTag.this.mSave && bl) {
                string = string + "&save=false";
            }
            this.out.println("<input type=\"hidden\" name=\"url\" value=\"" + string + "\">");
            if (!DumpTag.this.mSave || bl) {
                this.out.println("<input type=\"hidden\" name=\"save\" value=\"false\"\">");
            }
        }

        private void printDeleteListButton(RegisteredObject registeredObject, String string) throws Exception {
            CacheClass cacheClass = registeredObject.getCacheClass();
            String string2 = cacheClass.getName();
            CacheField cacheField = ObjectTagSupport.getDisplayNameField(cacheClass);
            String string3 = cacheField == null ? "ID" : cacheField.getName();
            boolean bl = registeredObject instanceof Persistent;
            this.printFormCommonElements(false, false);
            this.out.println("<input type=\"hidden\" name=\"oref\" value=\"" + DumpTag.this.mCurrentCollection + "\">");
            this.out.println("<input type=\"hidden\" name=\"tablename\" value=\"" + string2 + "\">");
            this.out.println("<input type=\"hidden\" name=\"columnname\" value=\"" + string3 + "\">");
            this.out.println("<input type=\"hidden\" name=\"value\" value=\"" + string + "\">");
            if (bl) {
                this.out.println("<input type=\"hidden\" name=\"elementtype\" value=\"persistent\">");
            }
            this.out.println("<input type=\"hidden\" name=\"action\" value=\"delete\">");
            this.out.println("<button type=\"submit\">Delete</button>");
            this.out.println("</form>");
        }

        private void printDeleteListButton(Object object) throws IOException {
            this.printFormCommonElements(false, false);
            this.out.println("<input type=\"hidden\" name=\"oref\" value=\"" + DumpTag.this.mCurrentCollection + "\">");
            this.out.println("<input type=\"hidden\" name=\"value\" value=\"" + object + "\">");
            this.out.println("<input type=\"hidden\" name=\"action\" value=\"delete\">");
            this.out.println("<button type=\"submit\">Delete</button>");
            this.out.println("</form>");
        }

        private void printDeleteArrayButton(String string) throws Exception {
            this.printFormCommonElements(false, false);
            this.out.println("<input type=\"hidden\" name=\"oref\" value=\"" + DumpTag.this.mCurrentCollection + "\">");
            this.out.println("<input type=\"hidden\" name=\"value\" value=\"" + string + "\">");
            this.out.println("<input type=\"hidden\" name=\"action\" value=\"delete\">");
            this.out.println("<button type=\"submit\">Delete</button>");
            this.out.println("</form>");
        }

        private void printAddForm(String string, String string2, boolean bl) throws Exception {
            CacheClass cacheClass;
            CacheClass cacheClass2 = cacheClass = string2 != null ? DumpTag.this.getCacheClass(string2) : null;
            if (string2 == null || DumpTag.this.isPersistent(cacheClass)) {
                this.printFormCommonElements(false, false);
            } else {
                this.printFormCommonElements(true, false);
            }
            this.out.println("<input type=\"hidden\" name=\"oref\" value=\"" + string + "\">");
            this.out.println("<input type=\"hidden\" name=\"action\" value=\"add\">");
            if (bl) {
                this.out.println("<input type=\"text\" size=\"8\" name = \"key\">");
            }
            if (string2 == null) {
                this.out.println("<input type=\"text\" size=\"12\" name = \"value\">");
            } else if (DumpTag.this.isPersistent(cacheClass)) {
                String string3 = ObjectTagSupport.getDisplayName(cacheClass);
                ListTag listTag = DumpTag.this.getListTag(string2, string3);
                listTag.setName("value");
                this.out.println("<input type=\"hidden\" name=\"elementtype\" value=\"persistent\">");
                this.out.println("<input type=\"hidden\" name=\"tablename\" value=\"" + string2 + "\">");
                this.out.println("<input type=\"hidden\" name=\"columnname\" value=\"" + string3 + "\">");
                listTag.writeList("None");
            } else {
                RegisteredObject registeredObject = (RegisteredObject)cacheClass.newInstance("");
                String string4 = this.storeObject(cacheClass.getName(), registeredObject);
                this.out.println("<input type=\"hidden\" name=\"elementtype\" value=\"serial\">");
                this.out.println("<input type=\"hidden\" name=\"value\" value=\"" + string4 + "\">");
            }
            this.out.println("<button type=\"submit\">Add</button>");
            this.out.println("</form>");
        }

        private void printAddListButton(List list, String string) throws IOException {
            try {
                String string2 = this.storeCollection(list);
                this.printAddForm(string2, string, false);
            }
            catch (Exception exception) {
                this.out.println("ERROR: " + exception.getMessage());
                exception.printStackTrace(System.out);
            }
        }

        private void printAddMapButton(Map map, String string) throws IOException {
            try {
                String string2 = this.storeCollection(map);
                this.printAddForm(string2, string, true);
            }
            catch (Exception exception) {
                this.out.println("ERROR: " + exception.getMessage());
                exception.printStackTrace(System.out);
            }
        }

        private String storeCollection(Object object) throws JspException, CacheException {
            DumpTag.this.mCurrentCollection = this.storeObject("List", object);
            return DumpTag.this.mCurrentCollection;
        }

        private String storeObject(String string, Object object) throws JspException, CacheException {
            String string2 = null;
            string2 = object instanceof ObjectHandle ? string + "." + String.valueOf(((ObjectHandle)object).getOref()) : String.valueOf(System.currentTimeMillis());
            DBHelper.storeInSession(DumpTag.this.pageContext, string2, object);
            return "session." + string2;
        }

        @Override
        public void handleNullObject(ObjectHandle objectHandle, String string) throws IOException {
            boolean bl = false;
            try {
                RegisteredObject registeredObject = (RegisteredObject)objectHandle;
                CacheClass cacheClass = registeredObject.getCacheClass();
                CacheField cacheField = cacheClass.getField(string);
                CacheClass cacheClass2 = cacheField.getType();
                ObjectTagSupport.checkPersistentClass(registeredObject.getDatabase());
                if (ObjectTagSupport.PERSISTENT.isAssignableFrom(cacheClass2)) {
                    bl = true;
                }
                if (bl) {
                    this.printReference(null, objectHandle, string);
                } else {
                    this.out.print("<td>" + null + "</td></tr>");
                }
            }
            catch (Exception exception) {
                this.out.println("ERROR: " + exception.getMessage());
                exception.printStackTrace(System.out);
            }
        }

        private boolean indentRegisteredObject(RegisteredObject registeredObject, ObjectHandle objectHandle, String string) throws IOException {
            boolean bl = false;
            if (registeredObject instanceof Persistent) {
                bl = true;
            }
            try {
                if (bl) {
                    this.out.print("<td><table><tr><td>");
                    String string2 = ObjectTagSupport.getDisplayName(registeredObject);
                    this.out.print(string2);
                    this.out.println("</td><td>");
                    if (DumpTag.this.mEdit && DumpTag.this.mInCollection == 1) {
                        this.printDeleteListButton(registeredObject, string2);
                    }
                    this.out.print("</td></tr></table></td></tr>");
                    return false;
                }
                this.out.print("<td><table  CELLSPACING=2 CELLPADDING=2 border=\"1\">");
                this.out.println("<tr>");
                return true;
            }
            catch (Exception exception) {
                this.out.println("ERROR: " + exception.getMessage());
                exception.printStackTrace(System.out);
                return false;
            }
        }

        private boolean indentPersistentObject(Persistent persistent, ObjectHandle objectHandle, String string) throws IOException {
            try {
                this.printReference(persistent, objectHandle, string);
            }
            catch (Exception exception) {
                this.out.println("ERROR: " + exception.getMessage());
                exception.printStackTrace(System.out);
            }
            return false;
        }

        @Override
        public boolean indent(Object object, ObjectHandle objectHandle, String string) throws IOException {
            if (object == null) {
                this.out.print("<td>" + object + "</td></tr>");
                return false;
            }
            if (DumpTag.this.mInCollection > 0 && object instanceof RegisteredObject) {
                RegisteredObject registeredObject = (RegisteredObject)object;
                return this.indentRegisteredObject(registeredObject, objectHandle, string);
            }
            if (object instanceof Persistent) {
                Persistent persistent = (Persistent)object;
                return this.indentPersistentObject(persistent, objectHandle, string);
            }
            this.out.print("<td><table  CELLSPACING=2 CELLPADDING=2 border=\"1\">");
            this.out.println("<tr>");
            if (DumpTag.this.mEdit && object instanceof List) {
                CacheClass cacheClass = this.getCollectionElementTypeName(object, objectHandle, string);
                String string2 = cacheClass == null ? null : cacheClass.getName();
                this.printAddListButton((List)object, string2);
                DumpTag.this.mInCollection = 1;
            } else if (DumpTag.this.mEdit && object instanceof Map) {
                CacheClass cacheClass = this.getCollectionElementTypeName(object, objectHandle, string);
                String string3 = cacheClass == null ? null : cacheClass.getName();
                this.printAddMapButton((Map)object, string3);
                DumpTag.this.mInCollection = 2;
            }
            return true;
        }

        @Override
        public void undent() throws IOException {
            DumpTag.this.mInCollection = 0;
            this.out.println("</tr>");
            this.out.println("</table></td></tr>");
        }

        @Override
        public void printReference(ObjectHandle objectHandle, ObjectHandle objectHandle2, String string) throws IOException {
            if (objectHandle instanceof Persistent) {
                Persistent persistent = (Persistent)objectHandle;
                try {
                    this.printReference(persistent, objectHandle2, string);
                    return;
                }
                catch (Exception exception) {
                    this.out.println("ERROR: " + exception.getMessage());
                    exception.printStackTrace(System.out);
                }
            }
            this.out.println(" ^");
        }

        private void printReference(Persistent persistent, ObjectHandle objectHandle, String string) throws Exception {
            CacheClass cacheClass = ((RegisteredObject)objectHandle).getCacheClass();
            CacheField cacheField = cacheClass.getField(string);
            if (DumpTag.this.mEdit) {
                String string2 = cacheField.getElementTypeName();
                CacheClass cacheClass2 = string2 == null ? cacheField.getType() : objectHandle.getDatabase().getCacheClass(string2);
                CacheField cacheField2 = ObjectTagSupport.getDisplayNameField(cacheClass2);
                String string3 = ObjectTagSupport.getDisplayName(cacheClass2);
                String string4 = persistent == null ? "None" : (cacheField2 != null ? cacheField2.get(persistent).toString() : persistent.getId().toString());
                RegisteredObject registeredObject = (RegisteredObject)objectHandle;
                this.printObjectChangeForm(registeredObject, string3, string4, cacheClass2.getName(), string);
            } else {
                if (persistent == null) {
                    String string5 = null;
                    this.out.println("<td>" + string5 + "</td></tr>");
                    return;
                }
                CacheClass cacheClass3 = persistent.getCacheClass();
                CacheField cacheField3 = ObjectTagSupport.getDisplayNameField(cacheClass3);
                String string6 = cacheField3 != null ? cacheField3.get(persistent).toString() + "[ID=" + persistent.getId() + ']' : "<" + cacheClass3.getName() + ">[" + persistent.getId() + ']';
                String string7 = DBHelper.getURI(DumpTag.this.pageContext);
                String string8 = string7 + "?classname=" + cacheClass3.getName() + "&" + "id=" + persistent.getId();
                this.out.println("<td><a href=\"" + string8 + "\">" + string6 + "</a></td></tr>");
            }
        }

        private void printObjectChangeForm(RegisteredObject registeredObject, String string, String string2, String string3, String string4) throws Exception {
            ListTag listTag = DumpTag.this.getListTag(string3, string);
            listTag.setName(string4);
            this.out.print("<td>");
            this.printFormCommonElements(false, false);
            this.out.println("<input type=\"hidden\" name=\"orefclass\" value=\"" + registeredObject.getCacheClass().getName() + "\">");
            this.out.println("<input type=\"hidden\" name=\"oref\" value=\"" + registeredObject.getOref() + "\">");
            this.out.println("<input type=\"hidden\" name=\"field\" value=\"" + string4 + "\">");
            this.out.println("<input type=\"hidden\" name=\"tablename\" value=\"" + string3 + "\">");
            this.out.println("<input type=\"hidden\" name=\"columnname\" value=\"" + string + "\">");
            listTag.writeList(string2);
            this.out.println("<button type=\"submit\">Change Value</button>");
            this.out.println("</form>");
            this.out.println("<form action=\"" + DumpTag.this.getNewObjectURL() + "\" method=\"get\">");
            this.out.println("<input type=\"hidden\" name=\"origin\" value=\"" + DBHelper.getURL(DumpTag.this.pageContext) + "\">");
            this.out.println("<input type=\"hidden\" name=\"origintext\" value=\"Back to original object\">");
            this.out.println("<input type=\"hidden\" name=\"classname\" value=\"" + string3 + "\">");
            this.out.println("<button type=\"submit\">New</button>");
            this.out.println("</form></td></tr>");
        }

        private CacheClass getCollectionElementTypeName(Object object, ObjectHandle objectHandle, String string) throws IOException {
            try {
                if (object instanceof ArrayOfDataTypes || object instanceof ListOfDataTypes) {
                    return null;
                }
                if (object instanceof ArrayOfObjects || object instanceof ListOfObjects) {
                    CacheClass cacheClass = ((RegisteredObject)objectHandle).getCacheClass();
                    CacheField cacheField = cacheClass.getField(string);
                    String string2 = cacheField.getElementTypeName();
                    return objectHandle.getDatabase().getCacheClass(string2);
                }
                throw new Exception("Unsupported collection type.");
            }
            catch (Exception exception) {
                this.out.println("ERROR: " + exception.getMessage());
                exception.printStackTrace(System.out);
                return null;
            }
        }
    }
}

