/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jgss;

import com.intersys.jgss.GSSSocket;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class GSSSocketInputStream
extends InputStream {
    private GSSSocket s;
    private byte[] buf = new byte[0];
    private int offset = 0;

    public GSSSocketInputStream(GSSSocket gSSSocket) {
        this.s = gSSSocket;
    }

    @Override
    public synchronized int read() throws IOException {
        byte[] byArray = new byte[1];
        if (this.read(byArray, 0, 1) == -1) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    @Override
    public synchronized int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return 0;
        }
        int n3 = 0;
        if (this.buf.length - this.offset >= n2) {
            System.arraycopy(this.buf, this.offset, byArray, n, n2);
            this.offset += n2;
            return n2;
        }
        if (this.buf.length - this.offset > 0) {
            System.arraycopy(this.buf, this.offset, byArray, n, this.buf.length - this.offset);
            n3 += this.buf.length - this.offset;
            this.offset = this.buf.length;
        }
        GSSSocket gSSSocket = this.s;
        synchronized (gSSSocket) {
            while (n3 < n2 && this.s.tokenAvailable() || n3 == 0) {
                try {
                    this.buf = this.s.receiveToken();
                }
                catch (EOFException eOFException) {
                    return -1;
                }
                if (this.buf.length > n2 - n3) {
                    System.arraycopy(this.buf, 0, byArray, n + n3, n2 - n3);
                    this.offset = n2 - n3;
                    return n2;
                }
                System.arraycopy(this.buf, 0, byArray, n + n3, this.buf.length);
                n3 += this.buf.length;
                this.offset = this.buf.length;
            }
        }
        return n3;
    }
}

