/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheBlob;
import com.intersys.jdbc.CacheClob;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheInputStream;
import com.intersys.jdbc.CachePreparedStatement;
import com.intersys.jdbc.CacheReader;
import com.intersys.jdbc.CacheResultSet;
import com.intersys.jdbc.CacheStatement;
import com.intersys.jdbc.Descriptor;
import com.intersys.jdbc.ExecParameter;
import com.intersys.jdbc.ObjectFactory;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;

public final class CacheCallableStatement
extends CachePreparedStatement
implements CallableStatement {
    static final int RESULT_SET_TYPE = -51;

    CacheCallableStatement(CacheConnection cacheConnection, String string) throws SQLException {
        super(cacheConnection, 1003, 1007, string, null);
    }

    CacheCallableStatement(CacheConnection cacheConnection, String string, int n, long l) throws SQLException {
        super(cacheConnection, 1003, string, n, l);
    }

    CacheCallableStatement(CacheConnection cacheConnection) throws SQLException {
        super(cacheConnection);
    }

    @Override
    public synchronized void registerOutParameter(int n, int n2) throws SQLException {
        if (this.execParams != null) {
            this.setExecParamMode(n, -1);
            return;
        }
        this.setParameterMode(this.getAbsoluteParameterIndex(n));
    }

    @Override
    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        if (this.execParams != null) {
            this.setExecParamMode(n, n3);
            return;
        }
        this.setParameterModeAndScale(this.getAbsoluteParameterIndex(n), n3);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.outputParameterList.wasNull();
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        if (this.execParams != null) {
            return this.getBoolean(this.getExecParam((int)n).name);
        }
        return this.outputParameterList.getBoolean(this.getListPosition(n));
    }

    @Override
    public byte getByte(int n) throws SQLException {
        if (this.execParams != null) {
            return this.getByte(this.getExecParam((int)n).name);
        }
        return this.outputParameterList.getOneByte(this.getListPosition(n));
    }

    @Override
    public short getShort(int n) throws SQLException {
        if (this.execParams != null) {
            return this.getShort(this.getExecParam((int)n).name);
        }
        return this.outputParameterList.getShort(this.getListPosition(n));
    }

    @Override
    public int getInt(int n) throws SQLException {
        if (this.execParams != null) {
            return this.getInt(this.getExecParam((int)n).name);
        }
        return this.outputParameterList.getInt(this.getListPosition(n));
    }

    @Override
    public long getLong(int n) throws SQLException {
        if (this.execParams != null) {
            return this.getLong(this.getExecParam((int)n).name);
        }
        return this.outputParameterList.getLong(this.getListPosition(n));
    }

    @Override
    public float getFloat(int n) throws SQLException {
        return (float)this.getDouble(n);
    }

    @Override
    public double getDouble(int n) throws SQLException {
        if (this.execParams != null) {
            return this.getDouble(this.getExecParam((int)n).name);
        }
        return this.outputParameterList.getDouble((Descriptor)this.parameters.elementAt(n - 1), this.getListPosition(n));
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (this.execParams != null) {
            return this.getBigDecimal(this.getExecParam((int)n).name);
        }
        return this.outputParameterList.getBigDecimalScale(this.getListPosition(n), n2);
    }

    @Override
    public String getString(int n) throws SQLException {
        if (this.execParams != null) {
            return this.getString(this.getExecParam((int)n).name);
        }
        String string = this.outputParameterList.getString((Descriptor)this.parameters.elementAt(n - 1), this.getListPosition(n));
        if (string == null) {
            return null;
        }
        int n2 = this.getParameterTypeAbsolute(n);
        if (n2 == -4) {
            CacheInputStream cacheInputStream = new CacheInputStream(this.connection, string.getBytes(), this.serverCursorNumber, 1);
            if (cacheInputStream.isNull()) {
                return null;
            }
            return cacheInputStream.toUnicodeString();
        }
        if (n2 == -1) {
            CacheReader cacheReader = new CacheReader(this.connection, string.getBytes(), this.serverCursorNumber);
            if (cacheReader.isNull()) {
                return null;
            }
            return cacheReader.toUnicodeString();
        }
        return string;
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        if (this.execParams != null) {
            return this.getBytes(this.getExecParam((int)n).name);
        }
        int n2 = this.getParameterTypeAbsolute(n);
        if (n2 == -1 || n2 == -4) {
            String string = this.outputParameterList.getString((Descriptor)this.parameters.elementAt(n - 1), this.getListPosition(n));
            if (string == null) {
                return null;
            }
            CacheInputStream cacheInputStream = new CacheInputStream(this.connection, string.getBytes(), this.serverCursorNumber, 1);
            if (cacheInputStream.isNull()) {
                return null;
            }
            return cacheInputStream.toByte();
        }
        return this.outputParameterList.getByte((Descriptor)this.parameters.elementAt(n - 1), this.getListPosition(n));
    }

    @Override
    public Date getDate(int n) throws SQLException {
        if (this.execParams != null) {
            return this.getDate(this.getExecParam((int)n).name);
        }
        return this.outputParameterList.getDate(this.getListPosition(n));
    }

    @Override
    public Time getTime(int n) throws SQLException {
        if (this.execParams != null) {
            return this.getTime(this.getExecParam((int)n).name);
        }
        return this.outputParameterList.getTime(this.getListPosition(n));
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        if (this.execParams != null) {
            return this.getTimestamp(this.getExecParam((int)n).name);
        }
        return this.outputParameterList.getTimestamp(this.getListPosition(n));
    }

    @Override
    public synchronized Object getObject(int n) throws SQLException {
        if (this.execParams != null) {
            return this.getObject(this.getExecParam((int)n).name);
        }
        Descriptor descriptor = (Descriptor)this.parameters.elementAt(n - 1);
        int n2 = this.getListPosition(n);
        switch (descriptor.type) {
            case 12: {
                return this.outputParameterList.getString(descriptor, n2);
            }
            case -6: 
            case 4: 
            case 5: {
                return this.outputParameterList.getIntegerWrapper(n2);
            }
            case 8: {
                return this.outputParameterList.getDoubleWrapper(descriptor, n2);
            }
            case 2: {
                return this.outputParameterList.getBigDecimal(descriptor, n2);
            }
            case -7: {
                return this.outputParameterList.getBooleanWrapper(n2);
            }
            case 91: {
                return this.outputParameterList.getDate(n2);
            }
            case 92: {
                return this.outputParameterList.getTime(n2);
            }
            case 93: {
                return this.outputParameterList.getTimestamp(n2);
            }
            case -3: 
            case -2: {
                return this.outputParameterList.getByte(n2);
            }
            case -5: {
                return this.outputParameterList.getLongWrapper(n2);
            }
            case -1: {
                return this.getCharacterStream(n);
            }
            case -4: {
                return this.getBinaryStream(n);
            }
            case -51: {
                return this.getResultSet(this.outputParameterList.getString(descriptor, n2));
            }
            case 2002: {
                return this.fetchStruct(this.outputParameterList.getString(descriptor, n2));
            }
        }
        return this.outputParameterList.getString(descriptor, n2);
    }

    @Override
    final synchronized void prepare(String string, int n, long l) throws SQLException {
        this.preparse(string, n, l);
        if (!this.getCachedInfo(this.sqlText)) {
            this.prepareStoredProcedure();
        }
    }

    @Override
    final synchronized void prepare(String string) throws SQLException {
        this.preparse(string);
        if (!this.getCachedInfo(this.sqlText)) {
            this.prepareStoredProcedure();
        }
    }

    private int getListPosition(int n) throws SQLException {
        if (n > this.parameters.size()) {
            throw new SQLException("Invalid parameter number", "S1093", 466);
        }
        if (n == 1 && this.hasReturnValue == 2) {
            if (!this.isOutParameter(0)) {
                throw new SQLException("Invalid parameter number", "S1093", 466);
            }
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = n;
        if (this.hasReturnValue == 1) {
            n3 = 1;
            n2 = 1;
        } else {
            --n4;
        }
        while (n3 < this.parameters.size()) {
            int n5 = this.getParameterMode(n3);
            if (n5 != 5) {
                if (n2 == n4) {
                    if (!this.isOutParameter(n3)) {
                        throw new SQLException("Invalid parameter number", "S1093", 466);
                    }
                    return n3;
                }
                ++n2;
            }
            ++n3;
        }
        throw new SQLException("Invalid parameter number " + n, "S1093", 466);
    }

    private int getParameterNumber(String string) throws SQLException {
        this.namedParameters = true;
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (!string.equalsIgnoreCase(((CacheStatement.Parameter)this.parameters.elementAt((int)i)).name)) continue;
            return i;
        }
        throw new SQLException("No such parameter: " + string, "S1093", 466);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ResultSet getResultSet(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        CacheStatement cacheStatement = new CacheStatement(this.connection, 1003, 1007, null);
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            cacheStatement.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.GET_CACHE_RESULT_SET_OBJECT);
            cacheStatement.output.wire.set(string);
            cacheStatement.output.wire.set(0);
            cacheStatement.output.send(this.connection.messageCount.getCount());
            int n = cacheStatement.input.readHeader(this.serverCursorNumber, 0, 100);
            if (n == 100) {
                cacheStatement.fetchDone = true;
            }
            cacheStatement.columnInfo(cacheStatement.input.wire);
        }
        return new CacheResultSet(cacheStatement, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Object fetchStruct(String string) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.serverCursorNumber, CacheConnection.GET_STRUCT_OBJECT);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            this.connection.inMessage.readHeader(this.serverCursorNumber, 0, 0);
            ObjectFactory objectFactory = this.connection.registerDatabase().getObjectFactory(this.connection);
            return objectFactory.deserialize(this.connection.inMessage.wire);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        if (this.execParams != null) {
            return this.getBigDecimal(this.getExecParam((int)n).name);
        }
        return this.outputParameterList.getBigDecimal((Descriptor)this.parameters.elementAt(n - 1), this.getListPosition(n));
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        if (this.execParams != null) {
            return this.getDate(this.getExecParam((int)n).name, calendar);
        }
        return this.outputParameterList.getDate(this.getListPosition(n), calendar);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        if (this.execParams != null) {
            return this.getTime(this.getExecParam((int)n).name, calendar);
        }
        return this.outputParameterList.getTime(this.getListPosition(n), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (this.execParams != null) {
            return this.getTimestamp(this.getExecParam((int)n).name, calendar);
        }
        return this.outputParameterList.getTimestamp(this.getListPosition(n), calendar);
    }

    @Override
    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        if (this.execParams != null) {
            this.setExecParamMode(n, -1);
            return;
        }
        if (n2 == 2002 || n2 == 2001 || n2 == 2000 || n2 == 2006) {
            throw new SQLException("Type not supported: " + n2, "IM001");
        }
        this.registerOutParameter(n, n2);
    }

    @Override
    public Array getArray(int n) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        if (this.execParams != null) {
            return this.getBlob(this.getExecParam((int)n).name);
        }
        if (this.getParameterTypeAbsolute(n) != -4) {
            throw new SQLException("Restricted data type attribute violation", "07006", 7006);
        }
        String string = this.outputParameterList.getString((Descriptor)this.parameters.elementAt(n - 1), this.getListPosition(n));
        if (string == null) {
            return null;
        }
        CacheBlob cacheBlob = new CacheBlob(this.connection, string.getBytes(), this.serverCursorNumber);
        if (cacheBlob.isNull()) {
            this.input.wire.isNull = true;
            return null;
        }
        return cacheBlob;
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        if (this.execParams != null) {
            return this.getClob(this.getExecParam((int)n).name);
        }
        if (this.getParameterTypeAbsolute(n) != -1) {
            throw new SQLException("Restricted data type attribute violation", "07006", 7006);
        }
        String string = this.outputParameterList.getString((Descriptor)this.parameters.elementAt(n - 1), this.getListPosition(n));
        if (string == null) {
            return null;
        }
        CacheClob cacheClob = new CacheClob(this.connection, string.getBytes(), this.serverCursorNumber);
        if (cacheClob.isNull()) {
            this.input.wire.isNull = true;
            return null;
        }
        return cacheClob;
    }

    private void setExecParamMode(int n, int n2) throws SQLException {
        ExecParameter execParameter = this.getExecParam(n);
        if (execParameter.mode == 1 || execParameter.mode == 2) {
            execParameter.mode = 2;
        } else if (execParameter.mode == 0 || execParameter.mode == 4) {
            execParameter.mode = 4;
        }
        execParameter.bound = true;
        execParameter.scale = n2;
    }

    private void setExecParamMode(String string, int n) throws SQLException {
        ExecParameter execParameter = this.getExecParamByName(string);
        if (execParameter == null) {
            throw new SQLException("No such parameter: " + string);
        }
        execParameter.mode = 2;
        execParameter.bound = true;
        execParameter.scale = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setNamedGeneric(String string, Object object, Object object2) throws SQLException {
        if (this.execParams != null) {
            ExecParameter execParameter = this.getExecParamByName(string);
            if (execParameter == null) {
                throw new SQLException("No such parameter: " + string);
            }
            execParameter.value = object;
            execParameter.bound = true;
            return;
        }
        int n = this.getParameterNumber(string);
        Vector vector = this.parameters;
        synchronized (vector) {
            ((CacheStatement.Parameter)this.parameters.elementAt(n)).bind(object, object2, this.parameterSets);
        }
    }

    @Override
    public void registerOutParameter(String string, int n) throws SQLException {
        if (this.execParams != null) {
            this.setExecParamMode(string, -1);
            return;
        }
        this.setParameterMode(this.getParameterNumber(string));
    }

    @Override
    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        if (this.execParams != null) {
            this.setExecParamMode(string, n2);
            return;
        }
        this.setParameterModeAndScale(this.getParameterNumber(string), n2);
    }

    @Override
    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        if (this.execParams != null) {
            this.setExecParamMode(string, -1);
            return;
        }
        this.setParameterMode(this.getParameterNumber(string));
    }

    @Override
    public void setNull(String string, int n) throws SQLException {
        this.setNamedGeneric(string, null, null);
    }

    @Override
    public void setNull(String string, int n, String string2) throws SQLException {
        this.setNamedGeneric(string, null, null);
    }

    @Override
    public void setBoolean(String string, boolean bl) throws SQLException {
        this.setNamedGeneric(string, bl, null);
    }

    @Override
    public void setByte(String string, byte by) throws SQLException {
        this.setNamedGeneric(string, by, null);
    }

    @Override
    public void setShort(String string, short s) throws SQLException {
        this.setNamedGeneric(string, s, null);
    }

    @Override
    public void setInt(String string, int n) throws SQLException {
        this.setNamedGeneric(string, n, null);
    }

    @Override
    public void setLong(String string, long l) throws SQLException {
        this.setNamedGeneric(string, l, null);
    }

    @Override
    public void setFloat(String string, float f) throws SQLException {
        this.setNamedGeneric(string, Float.valueOf(f), null);
    }

    @Override
    public void setDouble(String string, double d) throws SQLException {
        this.setNamedGeneric(string, d, null);
    }

    @Override
    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.setNamedGeneric(string, bigDecimal, null);
    }

    @Override
    public void setString(String string, String string2) throws SQLException {
        this.setNamedGeneric(string, string2, null);
    }

    @Override
    public void setBytes(String string, byte[] byArray) throws SQLException {
        this.setNamedGeneric(string, byArray, null);
    }

    @Override
    public void setDate(String string, Date date) throws SQLException {
        this.setNamedGeneric(string, date, null);
    }

    @Override
    public void setTime(String string, Time time) throws SQLException {
        this.setNamedGeneric(string, time, null);
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.setNamedGeneric(string, timestamp, null);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        if (inputStream == null) {
            this.setNamedGeneric(string, null, null);
            return;
        }
        if (inputStream.markSupported()) {
            inputStream.mark(0);
        }
        this.setNamedGeneric(string, new CacheStatement.StreamWrapper(inputStream, 0, n), null);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        if (inputStream == null) {
            this.setNamedGeneric(string, null, null);
            return;
        }
        if (n == 0) {
            throw new SQLException("Cache currently does not support empty binary streams", "S1000");
        }
        if (((CacheStatement.Parameter)this.parameters.elementAt((int)this.getParameterNumber((String)string))).type == -1) {
            throw new SQLException("Unsupported type conversion: (binary) InputStream to java.sql.Types.LONGVARCHAR", "S1000");
        }
        if (inputStream.markSupported()) {
            inputStream.mark(0);
        }
        this.setNamedGeneric(string, new CacheStatement.StreamWrapper(inputStream, 1, n), null);
    }

    @Override
    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        if (object == null) {
            this.setNamedGeneric(string, null, null);
            return;
        }
        if (n == 2 || n == 3) {
            this.setNamedGeneric(string, object, new Integer(n2));
        } else {
            this.setNamedGeneric(string, object, null);
        }
    }

    @Override
    public void setObject(String string, Object object, int n) throws SQLException {
        this.setNamedGeneric(string, object, null);
    }

    @Override
    public void setObject(String string, Object object) throws SQLException {
        this.setNamedGeneric(string, object, null);
    }

    @Override
    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        if (reader == null) {
            this.setNamedGeneric(string, null, null);
            return;
        }
        this.setNamedGeneric(string, new CacheStatement.StreamWrapper(reader, 4, n), null);
    }

    @Override
    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        this.setNamedGeneric(string, date, calendar);
    }

    @Override
    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        this.setNamedGeneric(string, time, calendar);
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setNamedGeneric(string, timestamp, calendar);
    }

    @Override
    public String getString(String string) throws SQLException {
        int n = this.getParameterNumber(string);
        String string2 = this.outputParameterList.getString((Descriptor)this.parameters.elementAt(n), n);
        if (string2 == null) {
            return null;
        }
        int n2 = ((CacheStatement.Parameter)this.parameters.elementAt((int)n)).type;
        if (n2 == -4) {
            CacheInputStream cacheInputStream = new CacheInputStream(this.connection, string2.getBytes(), this.serverCursorNumber, 1);
            if (cacheInputStream.isNull()) {
                return null;
            }
            return cacheInputStream.toUnicodeString();
        }
        if (n2 == -1) {
            CacheReader cacheReader = new CacheReader(this.connection, string2.getBytes(), this.serverCursorNumber);
            if (cacheReader.isNull()) {
                return null;
            }
            return cacheReader.toUnicodeString();
        }
        return string2;
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.outputParameterList.getBoolean(this.getParameterNumber(string));
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.outputParameterList.getOneByte(this.getParameterNumber(string));
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.outputParameterList.getShort(this.getParameterNumber(string));
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.outputParameterList.getInt(this.getParameterNumber(string));
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.outputParameterList.getLong(this.getParameterNumber(string));
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.outputParameterList.getFloat(this.getParameterNumber(string));
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.outputParameterList.getDouble(this.getParameterNumber(string));
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.outputParameterList.getByte(this.getParameterNumber(string));
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.outputParameterList.getDate(this.getParameterNumber(string));
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.outputParameterList.getTime(this.getParameterNumber(string));
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.outputParameterList.getTimestamp(this.getParameterNumber(string));
    }

    @Override
    public Object getObject(String string) throws SQLException {
        int n = this.getParameterNumber(string);
        Descriptor descriptor = (Descriptor)this.parameters.elementAt(n);
        switch (descriptor.type) {
            case 12: {
                return this.outputParameterList.getString(descriptor, n);
            }
            case -6: 
            case 4: 
            case 5: {
                return this.outputParameterList.getIntegerWrapper(n);
            }
            case 8: {
                return this.outputParameterList.getDoubleWrapper(descriptor, n);
            }
            case 2: {
                return this.outputParameterList.getBigDecimal(descriptor, n);
            }
            case -7: {
                return this.outputParameterList.getBooleanWrapper(n);
            }
            case 91: {
                return this.outputParameterList.getDate(n);
            }
            case 92: {
                return this.outputParameterList.getTime(n);
            }
            case 93: {
                return this.outputParameterList.getTimestamp(n);
            }
            case -3: 
            case -2: {
                return this.outputParameterList.getByte(n);
            }
            case -5: {
                return this.outputParameterList.getLongWrapper(n);
            }
            case -1: {
                return this.getCharacterStream(string);
            }
            case -51: {
                return this.getResultSet(this.outputParameterList.getString(descriptor, n));
            }
            case 2002: {
                return this.fetchStruct(this.outputParameterList.getString(descriptor, n));
            }
        }
        return this.outputParameterList.getString(descriptor, n);
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        int n = this.getParameterNumber(string);
        int n2 = ((CacheStatement.Parameter)this.parameters.elementAt((int)n)).scale;
        return this.outputParameterList.getBigDecimalScale(n, n2);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.outputParameterList.getDate(this.getParameterNumber(string), calendar);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.outputParameterList.getTime(this.getParameterNumber(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.outputParameterList.getTimestamp(this.getParameterNumber(string), calendar);
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        int n = this.getParameterNumber(string);
        if (((CacheStatement.Parameter)this.parameters.elementAt((int)n)).type != -4) {
            throw new SQLException("Restricted data type attribute violation", "07006", 7006);
        }
        String string2 = this.outputParameterList.getString((Descriptor)this.parameters.elementAt(n), n);
        if (string2 == null) {
            return null;
        }
        CacheBlob cacheBlob = new CacheBlob(this.connection, string2.getBytes(), this.serverCursorNumber);
        if (cacheBlob.isNull()) {
            this.input.wire.isNull = true;
            return null;
        }
        return cacheBlob;
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        int n = this.getParameterNumber(string);
        if (((CacheStatement.Parameter)this.parameters.elementAt((int)n)).type != -1) {
            throw new SQLException("Restricted data type attribute violation", "07006", 7006);
        }
        String string2 = this.outputParameterList.getString((Descriptor)this.parameters.elementAt(n), n);
        if (string2 == null) {
            return null;
        }
        CacheClob cacheClob = new CacheClob(this.connection, string2.getBytes(), this.serverCursorNumber);
        if (cacheClob.isNull()) {
            this.input.wire.isNull = true;
            return null;
        }
        return cacheClob;
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    @Override
    public Array getArray(String string) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    @Override
    public URL getURL(int n) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    @Override
    public void setURL(String string, URL uRL) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        CacheInputStream cacheInputStream;
        if (this.execParams != null) {
            return this.getBinaryStream(this.getExecParam((int)n).name);
        }
        String string = this.outputParameterList.getString((Descriptor)this.parameters.elementAt(n - 1), this.getListPosition(n));
        if (string == null) {
            return null;
        }
        int n2 = this.getParameterTypeAbsolute(n);
        switch (n2) {
            case -4: 
            case -1: {
                cacheInputStream = new CacheInputStream(this.connection, string.getBytes(), this.serverCursorNumber, 1);
                break;
            }
            case -3: {
                cacheInputStream = new CacheInputStream(this.getBytes(n), 1, n2, this.input.wire.getMaxFieldSize());
                break;
            }
            default: {
                throw new SQLException("Restricted data type attribute violation", "07006", 7006);
            }
        }
        if (cacheInputStream.isNull()) {
            this.input.wire.isNull = true;
            return null;
        }
        return cacheInputStream;
    }

    public synchronized InputStream getBinaryStream(String string) throws SQLException {
        CacheInputStream cacheInputStream;
        int n = this.getParameterNumber(string);
        String string2 = this.outputParameterList.getString((Descriptor)this.parameters.elementAt(n), n);
        if (string2 == null) {
            return null;
        }
        int n2 = ((CacheStatement.Parameter)this.parameters.elementAt((int)n)).type;
        switch (n2) {
            case -4: 
            case -1: {
                cacheInputStream = new CacheInputStream(this.connection, string2.getBytes(), this.serverCursorNumber, 1);
                break;
            }
            case -3: {
                cacheInputStream = new CacheInputStream(this.getBytes(string), 1, n2, this.input.wire.getMaxFieldSize());
                break;
            }
            default: {
                throw new SQLException("Restricted data type attribute violation", "07006", 7006);
            }
        }
        if (cacheInputStream.isNull()) {
            this.input.wire.isNull = true;
            return null;
        }
        return cacheInputStream;
    }

    @Override
    public synchronized Reader getCharacterStream(int n) throws SQLException {
        CacheReader cacheReader;
        if (this.execParams != null) {
            return this.getCharacterStream(this.getExecParam((int)n).name);
        }
        String string = this.outputParameterList.getString((Descriptor)this.parameters.elementAt(n - 1), this.getListPosition(n));
        if (string == null) {
            return null;
        }
        switch (this.getParameterTypeAbsolute(n)) {
            case -4: 
            case -1: {
                cacheReader = new CacheReader(this.connection, string.getBytes(), this.serverCursorNumber);
                break;
            }
            case -3: 
            case 12: {
                cacheReader = new CacheReader(string);
                break;
            }
            default: {
                throw new SQLException("Restricted data type attribute violation", "07006", 7006);
            }
        }
        if (cacheReader.isNull()) {
            this.input.wire.isNull = true;
            return null;
        }
        return cacheReader;
    }

    @Override
    public void setClob(String string, Reader reader, long l) throws SQLException {
        if (reader == null) {
            this.setNamedGeneric(string, null, null);
            return;
        }
        int n = this.getParameterNumber(string);
        if (((CacheStatement.Parameter)this.parameters.elementAt((int)n)).type != -1) {
            throw new SQLException("Restricted data type attribute violation", "07006", 7006);
        }
        this.setCharacterStream(string, reader);
    }

    @Override
    public void setBlob(String string, InputStream inputStream, long l) throws SQLException {
        if (inputStream == null) {
            this.setNamedGeneric(string, null, null);
            return;
        }
        int n = this.getParameterNumber(string);
        if (((CacheStatement.Parameter)this.parameters.elementAt((int)n)).type != -4) {
            throw new SQLException("Restricted data type attribute violation", "07006", 7006);
        }
        this.setBinaryStream(string, inputStream, l);
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        CacheReader cacheReader;
        int n = this.getParameterNumber(string);
        String string2 = this.outputParameterList.getString((Descriptor)this.parameters.elementAt(n), n);
        if (string2 == null) {
            return null;
        }
        switch (((CacheStatement.Parameter)this.parameters.elementAt((int)n)).type) {
            case -4: 
            case -1: {
                cacheReader = new CacheReader(this.connection, string2.getBytes(), this.serverCursorNumber);
                break;
            }
            case -3: 
            case 12: {
                cacheReader = new CacheReader(string2);
                break;
            }
            default: {
                throw new SQLException("Restricted data type attribute violation", "07006", 7006);
            }
        }
        if (cacheReader.isNull()) {
            this.input.wire.isNull = true;
            return null;
        }
        return cacheReader;
    }

    @Override
    public void setBlob(String string, Blob blob) throws SQLException {
        if (blob == null) {
            this.setNamedGeneric(string, null, null);
            return;
        }
        int n = this.getParameterNumber(string);
        if (((CacheStatement.Parameter)this.parameters.elementAt((int)n)).type != -4) {
            throw new SQLException("Restricted data type attribute violation", "07006", 7006);
        }
        this.setBinaryStream(string, blob.getBinaryStream(), (int)blob.length());
    }

    @Override
    public void setClob(String string, Clob clob) throws SQLException {
        if (clob == null) {
            this.setNamedGeneric(string, null, null);
            return;
        }
        int n = this.getParameterNumber(string);
        if (((CacheStatement.Parameter)this.parameters.elementAt((int)n)).type != -1) {
            throw new SQLException("Restricted data type attribute violation", "07006", 7006);
        }
        this.setCharacterStream(string, clob.getCharacterStream(), (int)clob.length());
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            int n = 0;
            try {
                n = inputStream.available();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n == 0 || n > Integer.MAX_VALUE) {
                throw new SQLException("Stream too long: " + l);
            }
            l = n;
        }
        this.setAsciiStream(string, inputStream, (int)l);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            int n = 0;
            try {
                n = inputStream.available();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n == 0 || n > Integer.MAX_VALUE) {
                throw new SQLException("Stream too long: " + l);
            }
            l = n;
        }
        this.setBinaryStream(string, inputStream, (int)l);
    }

    @Override
    public void setCharacterStream(String string, Reader reader, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw new SQLException("Stream too long: " + l);
        }
        this.setCharacterStream(string, reader, (int)l);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.setNamedGeneric(string, null, null);
            return;
        }
        if (inputStream.markSupported()) {
            inputStream.mark(0);
        }
        this.setNamedGeneric(string, new CacheStatement.StreamWrapper(inputStream, 0, -1), null);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.setNamedGeneric(string, null, null);
            return;
        }
        int n = this.getParameterNumber(string);
        if (((CacheStatement.Parameter)this.parameters.elementAt((int)n)).type == -1) {
            throw new SQLException("Unsupported type conversion: (binary) InputStream to java.sql.Types.LONGVARCHAR", "S1000");
        }
        if (inputStream.markSupported()) {
            inputStream.mark(0);
        }
        this.setNamedGeneric(string, new CacheStatement.StreamWrapper(inputStream, 1, -1), null);
    }

    @Override
    public void setCharacterStream(String string, Reader reader) throws SQLException {
        if (reader == null) {
            this.setNamedGeneric(string, null, null);
            return;
        }
        this.setNamedGeneric(string, new CacheStatement.StreamWrapper(reader, 4, -1), null);
    }

    @Override
    public void setClob(String string, Reader reader) throws SQLException {
        if (reader == null) {
            this.setNamedGeneric(string, null, null);
            return;
        }
        int n = this.getParameterNumber(string);
        if (((CacheStatement.Parameter)this.parameters.elementAt((int)n)).type != -1) {
            throw new SQLException("Restricted data type attribute violation", "07006", 7006);
        }
        this.setCharacterStream(string, reader);
    }

    @Override
    public void setBlob(String string, InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.setNamedGeneric(string, null, null);
            return;
        }
        int n = this.getParameterNumber(string);
        if (((CacheStatement.Parameter)this.parameters.elementAt((int)n)).type != -4) {
            throw new SQLException("Restricted data type attribute violation", "07006", 7006);
        }
        this.setBinaryStream(string, inputStream);
    }

    @Override
    public void setNString(String string, String string2) throws SQLException {
        if (!this.connection.connectionInfo.isUnicodeServer) {
            throw new SQLException("Not connected to Unicode server");
        }
        this.setString(string, string2);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader, long l) throws SQLException {
        if (!this.connection.connectionInfo.isUnicodeServer) {
            throw new SQLException("Not connected to Unicode server");
        }
        this.setCharacterStream(string, reader, l);
    }

    @Override
    public String getNString(int n) throws SQLException {
        if (!this.connection.connectionInfo.isUnicodeServer) {
            throw new SQLException("Not connected to Unicode server");
        }
        return this.getString(n);
    }

    @Override
    public String getNString(String string) throws SQLException {
        if (!this.connection.connectionInfo.isUnicodeServer) {
            throw new SQLException("Not connected to Unicode server");
        }
        return this.getString(string);
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        if (!this.connection.connectionInfo.isUnicodeServer) {
            throw new SQLException("Not connected to Unicode server");
        }
        return this.getCharacterStream(n);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        if (!this.connection.connectionInfo.isUnicodeServer) {
            throw new SQLException("Not connected to Unicode server");
        }
        this.setCharacterStream(string, reader);
    }

    @Override
    public void setNClob(String string, Reader reader, long l) throws SQLException {
        throw new SQLException("Not supported.", "IM001");
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        if (!this.connection.connectionInfo.isUnicodeServer) {
            throw new SQLException("Not connected to Unicode server");
        }
        return this.getCharacterStream(string);
    }

    @Override
    public void setNClob(String string, Reader reader) throws SQLException {
        throw new SQLException("Not supported.", "IM001");
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        throw new SQLException("Not supported.", "IM001");
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw new SQLException("Not supported.", "IM001");
    }

    @Override
    public void setRowId(String string, RowId rowId) throws SQLException {
        throw new SQLException("Not supported.", "IM001");
    }

    @Override
    public void setNClob(String string, NClob nClob) throws SQLException {
        throw new SQLException("Not supported.", "IM001");
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        throw new SQLException("Not supported.", "IM001");
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        throw new SQLException("Not supported.", "IM001");
    }

    @Override
    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw new SQLException("Not supported.", "IM001");
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        throw new SQLException("Not supported.", "IM001");
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        throw new SQLException("Not supported.", "IM001");
    }
}

