/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.classes;

import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.jbind.JBindDatabase;
import com.intersys.classes.AbstractCacheList;
import com.intersys.classes.ItemOfObjects;
import com.intersys.classes.ListBuffer;
import com.intersys.classes.ObjectListBuffer;
import com.intersys.classes.Persistent;
import com.intersys.classes.RegisteredObject;
import com.intersys.classes.SerialObject;
import com.intersys.classes.SysListOfObjects;
import com.intersys.objects.CacheCollectionException;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.intersys.objects.Id;
import com.intersys.objects.Oid;
import java.util.Collection;

public class ListOfObjects
extends AbstractCacheList {
    public ListOfObjects(CacheObject cacheObject) throws CacheException {
        this.mInternal = new SysListOfObjects(cacheObject);
        this.setupBuffer();
    }

    public ListOfObjects(Database database) throws CacheException {
        this.mInternal = new SysListOfObjects(database);
    }

    protected ListOfObjects() throws CacheException {
    }

    protected void setupBuffer() throws CacheException {
        SysListOfObjects sysListOfObjects = this.getInternal();
        int n = sysListOfObjects.getDatabase().getCacheType();
        if (ListBuffer.getDefaultBufferSize() > 1 && n > 0) {
            Object object = sysListOfObjects.getUserData();
            if (object != null && object instanceof ListBuffer) {
                this.setBuffer((ListBuffer)object);
            } else {
                ObjectListBuffer objectListBuffer = new ObjectListBuffer(sysListOfObjects);
                this.setBuffer(objectListBuffer);
                sysListOfObjects.setUserData(objectListBuffer);
            }
        }
    }

    public static String getCacheClassName() {
        return SysListOfObjects.getCacheClassName();
    }

    public String getElementType() throws CacheException {
        return this.getInternal().get_elementType();
    }

    void setKeyType(String string) throws CacheException {
        this.getInternal().set_elementType(string == null ? "" : string);
    }

    @Override
    protected Object valueExternal2internal(Object object) {
        return object;
    }

    @Override
    protected Object valueInternal2external(Object object) throws CacheException {
        if (object instanceof Dataholder) {
            Dataholder dataholder = (Dataholder)object;
            return dataholder.getOid();
        }
        return object;
    }

    @Override
    public void _insert(Object object) throws CacheException {
        this.invalidateCache();
        Object object2 = ItemOfObjects.getSettableObject(object);
        if (object2 instanceof RegisteredObject) {
            this.getInternal()._insert((RegisteredObject)object2);
            return;
        }
        String string = object2 instanceof Oid ? ((Oid)object2).getId().toString() : ((Id)object2).toString();
        this.getInternal()._insertObjectId(string);
    }

    @Override
    public void _insertAt(Integer n, Object object) throws CacheException {
        this.invalidateCache();
        Object object2 = ItemOfObjects.getSettableObject(object);
        if (object2 instanceof RegisteredObject) {
            this.getInternal()._insertAt(n, (RegisteredObject)object2);
            return;
        }
        String string = object2 instanceof Oid ? ((Oid)object2).getId().toString() : ((Id)object2).toString();
        this.getInternal()._insertObjectIdAt(n, string);
    }

    @Override
    public void _setAt(Integer n, Object object) throws CacheException {
        this.invalidateCache();
        Object object2 = ItemOfObjects.getSettableObject(object);
        if (object2 instanceof RegisteredObject) {
            this.getInternal()._setAt(n, (RegisteredObject)object2);
            return;
        }
        String string = object2 instanceof Oid ? ((Oid)object2).getId().toString() : ((Id)object2).toString();
        this.getInternal()._setObjectIdAt(n, string);
    }

    @Override
    public Object _removeAt(Integer n) throws CacheException {
        Object object = this._getAt(n);
        Object object2 = super._removeAt(n);
        if (object != null && object2 instanceof Oid) {
            Oid oid;
            Oid oid2 = (Oid)object2;
            if (object instanceof Persistent) {
                oid = ((Persistent)object).getOid();
            } else if (object instanceof SerialObject) {
                oid = ((SerialObject)object).getOid();
            } else {
                return object2;
            }
            if (oid2.equals(oid)) {
                return object;
            }
            if (oid == null) {
                return object2;
            }
            if (oid2.getClassName().length() == 0 && oid2.getId().equals(oid.getId())) {
                return object;
            }
        }
        return object2;
    }

    @Override
    public Integer _find(Object object, Integer n) throws CacheException {
        Id id = ItemOfObjects.getObjectId(object);
        return this.getInternal()._findObjectId(id.toString(), n);
    }

    @Override
    public boolean addAll(Collection collection) {
        JBindDatabase jBindDatabase = (JBindDatabase)this.mInternal.getDatabase();
        try {
            jBindDatabase.putObjListElements(this.mInternal.getOref(), collection);
        }
        catch (CacheException cacheException) {
            throw new CacheCollectionException(cacheException);
        }
        return collection.size() > 0;
    }

    private SysListOfObjects getInternal() {
        return (SysListOfObjects)this.mInternal;
    }
}

