/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.classes;

import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.jbind.JBindDatabase;
import com.intersys.classes.AbstractCacheList;
import com.intersys.classes.DataConverter;
import com.intersys.classes.ListBuffer;
import com.intersys.classes.StringListBuffer;
import com.intersys.classes.SysListOfDataTypes;
import com.intersys.objects.CacheCollectionException;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import java.util.Collection;

public class ListOfDataTypes
extends AbstractCacheList {
    private String mElementType = "";

    public ListOfDataTypes(CacheObject cacheObject) throws CacheException {
        this.mInternal = new SysListOfDataTypes(cacheObject);
        if (ListBuffer.getDefaultBufferSize() > 1) {
            Object object = cacheObject.getUserData();
            if (object != null && object instanceof String) {
                this.setElementType((String)object);
                object = null;
            }
            if (object != null && object instanceof ListBuffer) {
                String string;
                this.setBuffer((ListBuffer)object);
                if (object instanceof StringListBuffer && (string = ((StringListBuffer)object).mElementType) != null) {
                    this.mElementType = string;
                }
            } else {
                StringListBuffer stringListBuffer = new StringListBuffer(this.mInternal);
                stringListBuffer.mElementType = this.mElementType;
                this.setBuffer(stringListBuffer);
                cacheObject.setUserData(stringListBuffer);
            }
        }
    }

    public ListOfDataTypes(Database database) throws CacheException {
        this.mInternal = new SysListOfDataTypes(database);
    }

    public String getElementType() {
        return this.mElementType;
    }

    public void setElementType(String string) throws CacheException {
        if (string == null) {
            this.mElementType = "";
            return;
        }
        this.mElementType = DataConverter.convertClassName(string, this.getDatabase());
    }

    @Override
    public boolean addAll(Collection collection) {
        JBindDatabase jBindDatabase = (JBindDatabase)this.mInternal.getDatabase();
        try {
            jBindDatabase.putListElements(this.mInternal.getOref(), collection);
            this.invalidateCache();
        }
        catch (CacheException cacheException) {
            throw new CacheCollectionException(cacheException);
        }
        return !collection.isEmpty();
    }

    @Override
    protected Object valueExternal2internal(Object object) {
        return object;
    }

    public static String getCacheClassName() {
        return SysListOfDataTypes.getCacheClassName();
    }

    @Override
    protected Object valueInternal2external(Object object) throws CacheException {
        if (object instanceof Dataholder) {
            Dataholder dataholder = (Dataholder)object;
            if (this.mElementType == null || this.mElementType.length() == 0) {
                return dataholder.getString();
            }
            return dataholder.getObject(this.mElementType);
        }
        if (this.mElementType == null || this.mElementType.length() == 0) {
            return object;
        }
        return DataConverter.string2datatype(object, this.mElementType);
    }
}

