/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.Dataholder;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.jbind.ReadOnlyDatabase;
import com.intersys.cache.jdbcutil.ConnectionUtils;
import com.intersys.cache.jdbcutil.JDBCAdapter;
import com.intersys.cache.quick.ChidTableClass;
import com.intersys.cache.quick.ColumnBasedField;
import com.intersys.cache.quick.LightDatabase;
import com.intersys.cache.quick.QuickCacheClassNew;
import com.intersys.cache.quick.QuickDBAdapter;
import com.intersys.cache.quick.QuickPersistentObject;
import com.intersys.cache.quick.TableBasedClass;
import com.intersys.cache.serial.CacheMetadataFactory;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheResultSet;
import com.intersys.jdbc.ConnectionInfo;
import com.intersys.jdbc.QuickStatement;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheServerException;
import com.intersys.objects.CandidateKey;
import com.intersys.objects.Logger;
import com.intersys.objects.SystemError;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class QuickDatabase
extends LightDatabase {
    private static final int QTYPE_NAMED = 1;
    private static final int QTYPE_SQL = 2;
    private static final int QTYPE_SHORT = 3;
    private ReadOnlyDatabase mMetadataConnection = null;
    private int mReflectionVersion;
    private ConnectionInfo mConnectionInfo = null;

    public QuickDatabase(String string, String string2, String string3) throws CacheException {
        this.mURL = ConnectionUtils.createURLString(string);
        CacheConnection cacheConnection = ConnectionUtils.staticInitConnection(this.mURL, string2, string3);
        this.amIConnectionOwner = true;
        this.initClientDatabase(cacheConnection, cacheConnection);
    }

    protected QuickDatabase(CacheConnection cacheConnection, Connection connection) throws CacheException {
        super(cacheConnection, connection);
    }

    @Override
    protected final void onInitDatabase(Connection connection) throws CacheException {
        CacheConnection cacheConnection = connection instanceof CacheConnection ? (CacheConnection)connection : JDBCAdapter.getCacheConnection(connection);
        this.mAdapter = new QuickDBAdapter(cacheConnection, this.mInfo);
        ((JDBCAdapter)((Object)this.myAdapter())).setupServerInfo(this.mInfo);
        this.mProcess = this.mInfo.processNumberString;
        cacheConnection.registerDatabase().register(this);
        this.mReflectionVersion = ((JDBCAdapter)((Object)this.myAdapter())).getReflectionVersion();
    }

    @Override
    protected Iterator getResultSetIterator(ResultSet resultSet, TableBasedClass tableBasedClass, int n) {
        return new CacheResultSetIterator(resultSet, tableBasedClass, n);
    }

    @Override
    public ReadOnlyDatabase getReadOnlyDatabase() throws CacheException {
        if (this.mMetadataConnection == null) {
            this.mMetadataConnection = new ReadOnlyDatabase(this.myConnection(), (SysDatabase)this, true);
            return this.mMetadataConnection;
        }
        return this.mMetadataConnection.getReadOnlyDatabase();
    }

    public JDBCAdapter getAdapter() {
        return (JDBCAdapter)((Object)this.myAdapter());
    }

    @Override
    protected boolean commaSeparatedCollectionsInRS() {
        if (this.mInfo.getMajorObjectVersion() > 5) {
            return false;
        }
        return this.mInfo.getMinorObjectVersion() < 1;
    }

    @Override
    public final ConnectionInfo getConnectionInfo() {
        if (this.mConnectionInfo == null) {
            this.mConnectionInfo = ((CacheConnection)this.myConnection()).getConnectionInfo();
        }
        return this.mConnectionInfo;
    }

    @Override
    public String getCacheClassForJavaClassSQL() {
        return CacheMetadataFactory.getCacheClassForJavaClassSQL();
    }

    @Override
    protected void onClose() {
        ((CacheConnection)this.mAdapter.getConnection()).registerDatabase().unregister(this);
    }

    @Override
    public int getReflectionVersion() {
        return this.mReflectionVersion;
    }

    @Override
    public TableBasedClass createQuickCacheClass(String string, boolean bl) throws CacheException {
        return new QuickCacheClassNew(this, string, bl, false);
    }

    @Override
    public TableBasedClass createQuickCacheClassByTable(String string, boolean bl) throws CacheException {
        return new QuickCacheClassNew(this, string, bl, true);
    }

    @Override
    protected TableBasedClass createQuickCacheClass(ColumnBasedField columnBasedField) throws CacheException {
        QuickCacheClassNew quickCacheClassNew = (QuickCacheClassNew)this.getCacheClass(columnBasedField.getElementTypeName());
        ChidTableClass chidTableClass = new ChidTableClass((LightDatabase)this, quickCacheClassNew, columnBasedField.getChildTableMetadata(), columnBasedField.getCollectionType());
        this.mClassMap.put(columnBasedField.getChildTableName(), chidTableClass);
        return chidTableClass;
    }

    public void saveObjectsByPK(String string, Map map, boolean bl) throws CacheException {
        Object sQLException;
        Object object;
        Object object2;
        this.invalidateLoadInterceptors(string);
        int n = map.size();
        if (Logger.getDebugCache()) {
            Logger.out.println("Saving " + n + " objects of type " + string + " using PK");
        }
        Object object5 = this.createSysList();
        try {
            SysListProxy.setInteger(object5, n);
        }
        catch (SQLException sQLException2) {
            throw new SystemError(sQLException2, "Weird error: empty list is corrupted.");
        }
        int n2 = 0;
        ArrayList arrayList = new ArrayList();
        Object object6 = SysListProxy.createSysList(this.getConnectionInfo());
        boolean[] blArray = new boolean[n];
        for (Map.Entry object42 : map.entrySet()) {
            object2 = (CandidateKey)object42.getKey();
            object = (QuickPersistentObject)object42.getValue();
            if (n2 > 0) {
                SysListProxy.clearList(object6);
            }
            try {
                sQLException = ((CandidateKey)object2).toSysList();
                SysListProxy.setSysList(object6, sQLException);
            }
            catch (SQLException sQLException3) {
                throw new SystemError(sQLException3, "List is corrupted.");
            }
            if (!this.mPKIdMap.containsKey(object2)) {
                this.mPKIdMap.put(object2, UNKNOWN_ID);
            }
            switch (((QuickPersistentObject)object).save(object6, true, false, bl)) {
                case 2: {
                    arrayList.add(object42);
                }
                case 1: {
                    blArray[n2] = true;
                }
                case 0: {
                    try {
                        SysListProxy.concatenate(object5, object6);
                        break;
                    }
                    catch (SQLException sQLException4) {
                        throw new SystemError(sQLException4, "List is corrupted.");
                    }
                }
                default: {
                    throw new SystemError("Unknown code from save.");
                }
            }
            if (Logger.getDebugCache()) {
                Logger.out.println(n2 + ": values: " + object6.toString());
            }
            ++n2;
        }
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClass(string);
        if (tableBasedClass == null) {
            throw new CacheException("Cache class " + string + " does not exist");
        }
        String string2 = tableBasedClass.getSchemaName();
        object2 = tableBasedClass.getSQLTableName();
        object = ((QuickDBAdapter)this.myAdapter()).bulkSaveByPK(string2, (String)object2, object5, this.mNoLock);
        if (Logger.getDebugCache()) {
            Logger.out.println("Scheduling for second save: " + arrayList.size() + " objects");
        }
        for (QuickPersistentObject bl2 : arrayList) {
            bl2.save(false);
        }
        sQLException = tableBasedClass.getIdField();
        boolean bl2 = sQLException.getSQLColumn().getJDBCType() == 4;
        Object object3 = SysListProxy.createSysList(SysListProxy.getConnectionInfo(object));
        n2 = 0;
        for (Map.Entry entry : map.entrySet()) {
            Object object4;
            Object object7 = (CandidateKey)entry.getKey();
            QuickPersistentObject quickPersistentObject = (QuickPersistentObject)entry.getValue();
            try {
                Object object8;
                if (!bl2 && (object8 = SysListProxy.getObject(object)) != null) {
                    throw new SystemError("Null Expected");
                }
                object4 = SysListProxy.getObject(object);
                if (!bl2) {
                    SysListProxy.setObject(object3, object4);
                }
            }
            catch (SQLException sQLException5) {
                throw new CacheServerException(sQLException5, "Invalid response from BULK SAVE BY PK request.");
            }
            if (object4 instanceof Number && ((Number)object4).intValue() < 0) {
                throw new CacheServerException("Unidentified error occured storing object with Priamry Key " + object7);
            }
            quickPersistentObject.setProperty((ColumnBasedField)sQLException, Dataholder.create(object4), false, true);
            this.mPKIdMap.put(object7, object4);
            ++n2;
        }
        if (!bl2) {
            object = object3;
        }
        LightDatabase.LoadInterceptor loadInterceptor = new LightDatabase.LoadInterceptor(tableBasedClass, n, object);
        this.addLoadInterceptor(loadInterceptor);
        n2 = 0;
        for (Object object7 : map.values()) {
            if (blArray[n2]) {
                ((QuickPersistentObject)object7).afterSave(null, true);
            }
            ++n2;
        }
    }

    @Override
    public int transactionLevel(boolean bl) throws CacheException {
        CacheConnection cacheConnection = (CacheConnection)this.myConnection();
        int n = 0;
        try {
            int n2 = n = cacheConnection.getAutoCommit() ? 0 : 1;
            if (bl && cacheConnection.getProtocolVersion() >= 41) {
                int n3;
                int n4 = n3 = cacheConnection.inTransaction() ? 1 : 0;
                if (n3 != n) {
                    n = n3;
                    if (Logger.debugOn()) {
                        Logger.out.println("WARN: Transaction level changed from: " + n + " to " + n3);
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to determine transaction level.");
        }
        return n;
    }

    @Override
    public Iterator openByQuery(String string, Object[] objectArray) throws CacheException {
        boolean bl;
        if (string == null) {
            throw new NullPointerException("Query can not be null.");
        }
        String string2 = string.trim().toUpperCase();
        boolean bl2 = bl = !string2.startsWith("SELECT");
        if (bl) {
            return this.openByQuery(1, null, string, objectArray);
        }
        return this.openByQuery(2, null, string, objectArray);
    }

    @Override
    public Map getSentMessages(int n) {
        return QuickDBAdapter.getMessagesSent(n);
    }

    @Override
    public Iterator openByQuery(String string, String string2, Object[] objectArray) throws CacheException {
        return this.openByQuery(3, string, string2, objectArray);
    }

    private Iterator openByQuery(int n, String string, String string2, Object[] objectArray) throws CacheException {
        Object object = this.createSysList();
        try {
            int n2 = objectArray != null ? objectArray.length : 0;
            SysListProxy.setInteger(object, n2);
            for (int i = 0; i < n2; ++i) {
                SysListProxy.setObject(object, objectArray[i]);
            }
        }
        catch (SQLException sQLException) {
            throw new CacheException("Failed to set parameters to query");
        }
        return new QueryIterator(n, string, string2, object);
    }

    private class CacheResultSetIterator
    extends LightDatabase.ResultSetIterator {
        public CacheResultSetIterator(ResultSet resultSet, TableBasedClass tableBasedClass, int n) {
            super(resultSet, tableBasedClass, n);
        }

        @Override
        protected Object getWire() throws SQLException {
            return ((CacheResultSet)this.mRS).getWire();
        }
    }

    private class QueryIterator
    implements Iterator {
        private static final int OBJECT_COUNT = 10;
        private Object wire;
        private QuickStatement mStatement;
        private final int queryType;

        public QueryIterator(int n, String string, String string2, Object object) throws CacheException {
            this.queryType = n;
            try {
                this.mStatement = ((CacheConnection)QuickDatabase.this.myConnection()).createQuickStatement();
            }
            catch (SQLException sQLException) {
                throw new CacheServerException(sQLException);
            }
            if (string2 == null) {
                string2 = "";
            }
            this.wire = this.qa().queryLoad(this.mStatement, this.queryType, string2, string, 10, object);
        }

        private QuickDBAdapter qa() {
            return (QuickDBAdapter)QuickDatabase.this.myAdapter();
        }

        @Override
        public boolean hasNext() {
            if (SysListProxy.atEnd(this.wire)) {
                this.nextQuery();
                if (SysListProxy.isUndefined(this.wire)) {
                    this.close();
                    return false;
                }
                return true;
            }
            if (SysListProxy.isUndefined(this.wire)) {
                this.close();
                return false;
            }
            return true;
        }

        private void nextQuery() {
            try {
                this.wire = this.qa().queryLoad(this.mStatement, this.queryType, null, null, 10, null);
            }
            catch (CacheServerException cacheServerException) {
                this.close();
                if (Logger.debugOn()) {
                    cacheServerException.printFullTrace(Logger.out);
                }
                throw new IllegalStateException("Failed to fetch more objects: " + cacheServerException.getMessage());
            }
        }

        private void close() {
            block2: {
                try {
                    this.mStatement.close();
                }
                catch (SQLException sQLException) {
                    if (!Logger.debugOn()) break block2;
                    sQLException.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                String string = SysListProxy.getString(this.wire);
                if (string == null) {
                    throw new NoSuchElementException("Class Name of the next object is null!");
                }
                int n = SysListProxy.getInteger(this.wire);
                Object object = SysListProxy.getSubList(this.wire, n);
                QuickDatabase quickDatabase = QuickDatabase.this;
                synchronized (quickDatabase) {
                    QuickPersistentObject quickPersistentObject = QuickDatabase.this.processOpenedObject(string, object);
                    return quickPersistentObject.newJavaInstance(true);
                }
            }
            catch (Exception exception) {
                if (Logger.debugOn()) {
                    exception.printStackTrace(Logger.out);
                }
                throw new NoSuchElementException(exception.getMessage());
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Method remove() is not implemented in class com.intersys.cache.quick.QuickDatabase.QueryIterator");
        }
    }
}

