/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.LazyList;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.quick.ColumnBasedField;
import com.intersys.cache.quick.LightDatabase;
import com.intersys.cache.quick.QuickPersistentObject;
import com.intersys.cache.quick.QuickReaderObject;
import com.intersys.cache.quick.QuickStreamObject;
import com.intersys.cache.quick.TableBasedClass;
import com.intersys.classes.CacheRootObject;
import com.intersys.classes.RegisteredObject;
import com.intersys.classes.RelationshipObject;
import com.intersys.jdbc.QuickStatement;
import com.intersys.objects.CacheException;
import com.intersys.objects.Id;
import com.intersys.objects.ObjectClosedException;
import com.intersys.objects.Oid;
import com.intersys.objects.ReferenceCountingException;
import com.intersys.objects.SList;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class QuickCacheObject
implements CacheObject {
    protected static Object UNCHANGED = QuickStatement.UNCHANGED_OBJECT;
    protected TableBasedClass mClass;
    private Object mUserData;
    private int mCount;
    private boolean mAssertNotClosed = false;
    protected int mState;

    protected QuickCacheObject(TableBasedClass tableBasedClass) {
        this.mClass = tableBasedClass;
        this.mCount = 0;
    }

    @Override
    public CacheObject getMe() {
        return this;
    }

    @Override
    public String getTypeName() {
        return this.mClass.getName();
    }

    @Override
    public int getOref() throws ObjectClosedException {
        Id id;
        try {
            id = this.getId();
        }
        catch (CacheException cacheException) {
            id = null;
        }
        if (id == null) {
            return 0;
        }
        try {
            return Integer.parseInt(id.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    @Override
    public final Object getZRef() {
        return new ZRef();
    }

    @Override
    public SysDatabase getDatabase() {
        if (this.mClass == null) {
            return null;
        }
        return this.mClass.getDatabase();
    }

    @Override
    public void setCacheClass(CacheClass cacheClass) throws CacheException {
        throw new CacheException("Call to setCacheClass not allowed in this implementation of CacheObject");
    }

    @Override
    public CacheClass getCacheClass() {
        return this.mClass;
    }

    @Override
    public Id getId() throws CacheException {
        return null;
    }

    @Override
    public Oid getOid() throws CacheException {
        return null;
    }

    @Override
    public int saveRequiredFields() throws CacheException {
        throw new UnsupportedOperationException("Method saveRequiredFields() is not implemented in class com.intersys.cache.quick.QuickCacheObject");
    }

    @Override
    public void delete() throws CacheException {
        this.getDatabase().deleteObject(this.getOid());
    }

    @Override
    public boolean isClosed() {
        return this.mCount < 0;
    }

    @Override
    public void forceClose() throws CacheException {
        Oid oid = this.getOid();
        if (oid != null) {
            ((LightDatabase)this.getDatabase()).closeObject(oid, this);
        }
        this.mCount = -20;
    }

    @Override
    public void increaseReferenceCount() throws CacheException {
        throw new ReferenceCountingException("This is not a reference counting object");
    }

    @Override
    public void decreaseReferenceCount() throws CacheException {
        throw new ReferenceCountingException("This is not a reference counting object");
    }

    @Override
    public Dataholder[] runInstanceMethod(String string, int[] nArray, Dataholder[] dataholderArray, int n) throws CacheException {
        throw new CacheException("Not supported feature. Use full Database implementation.");
    }

    @Override
    public Dataholder runInstanceMethod(String string, Dataholder[] dataholderArray, int n) throws CacheException {
        Dataholder dataholder;
        if (string.endsWith("Get") && (dataholder = this.checkIfCalculatedProperty(string, n)) != null) {
            return dataholder;
        }
        throw new CacheException("Not supported feature. Use full Database implementation.");
    }

    private Dataholder checkIfCalculatedProperty(String string, int n) throws CacheException {
        CacheField cacheField = this.mClass.isGetterForCalculatedProperty(string);
        if (cacheField != null) {
            return this.getProperty(cacheField.getName(), n == 1);
        }
        return null;
    }

    @Override
    public Object newJavaInstance() throws CacheException {
        return this.newJavaInstance(false);
    }

    @Override
    public Object newJavaInstance(boolean bl) throws CacheException {
        CacheClass cacheClass = this.getCacheClass();
        return cacheClass.newInstance(this, bl);
    }

    @Override
    public void setUserData(Object object) {
        this.mUserData = object;
    }

    @Override
    public Object getUserData() {
        return this.mUserData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void increaseCount() throws CacheException {
        LightDatabase lightDatabase;
        LightDatabase lightDatabase2 = lightDatabase = (LightDatabase)this.getDatabase();
        synchronized (lightDatabase2) {
            if (this.mCount < 0) {
                QuickCacheObject.throwClosedException("Increasing count on closed object. Count = " + this.mCount);
            }
            ++this.mCount;
        }
    }

    protected void reinstate() {
        this.mCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decreaseCount() throws CacheException {
        LightDatabase lightDatabase;
        LightDatabase lightDatabase2 = lightDatabase = (LightDatabase)this.getDatabase();
        synchronized (lightDatabase2) {
            --this.mCount;
            if (this.mCount == 0 && this.getOid() != null) {
                this.mCount = -100;
                if (this.mAssertNotClosed) {
                    String string = "Object " + this.toString() + " registered for assertion and is being closed";
                    CacheException cacheException = new CacheException(string);
                    cacheException.printStackTrace();
                    throw cacheException;
                }
                lightDatabase.closeObject(this.getOid(), this);
            }
        }
    }

    protected int getCount() {
        return this.mCount;
    }

    protected void cleanup() {
        this.mCount = this.mCount < 0 ? --this.mCount : -10;
    }

    protected static void throwClosedException(String string) {
        IllegalStateException illegalStateException = new IllegalStateException(string);
        illegalStateException.printStackTrace(System.out);
        illegalStateException.printStackTrace(System.err);
        throw illegalStateException;
    }

    @Override
    public void assertNotClosed(boolean bl) throws CacheException {
        if (bl && this.isClosed()) {
            String string = "Object " + this.toString() + " is already closed";
            CacheException cacheException = new CacheException(string);
            throw cacheException;
        }
        this.mAssertNotClosed = bl;
    }

    @Override
    public String toOrefString() throws CacheException {
        return this.getZRef().toString();
    }

    public boolean equals(Object object) {
        Id id;
        if (this == object) {
            return true;
        }
        if (!(object instanceof QuickCacheObject)) {
            return false;
        }
        try {
            id = this.getId();
        }
        catch (CacheException cacheException) {
            id = null;
        }
        if (id == null) {
            return object == this;
        }
        QuickCacheObject quickCacheObject = (QuickCacheObject)object;
        try {
            return this.mClass.equals(quickCacheObject.mClass) && id.equals(quickCacheObject.getId());
        }
        catch (CacheException cacheException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object valueToSave(ColumnBasedField columnBasedField, Object object, boolean bl) throws CacheException {
        if (object == null) return null;
        if (object.equals(UNCHANGED)) return null;
        if (columnBasedField.isEmbedded()) {
            return null;
        }
        Dataholder dataholder = (Dataholder)object;
        LightDatabase lightDatabase = (LightDatabase)this.getDatabase();
        Object object2 = dataholder.getObject();
        int n = columnBasedField.getCollectionType();
        if (n == 32) {
            QuickStreamObject quickStreamObject = (QuickStreamObject)object2;
            return lightDatabase.wrapBinaryStream(quickStreamObject.getInForSetting(), this);
        }
        if (n == 64) {
            QuickReaderObject quickReaderObject = (QuickReaderObject)object2;
            return lightDatabase.wrapCharacterStream(quickReaderObject.getInForSetting(), this);
        }
        if (n != 0) {
            Object object3 = dataholder.getCollection();
            if (object3 == null) {
                return null;
            }
            String string = columnBasedField.getChildTableName();
            if (string != null) {
                Id id;
                if (!lightDatabase.isClassRegistered(string) && !columnBasedField.isRelationship()) {
                    lightDatabase.createQuickCacheClass(columnBasedField);
                }
                if ((id = this.getId()) == null) {
                    if (!QuickCacheObject.isEmpty(object3)) return UNCHANGED;
                    return null;
                }
                if (n == 8) {
                    lightDatabase.saveChildList(string, id.toString(), (List)object3, bl);
                    return null;
                } else if (n == 21) {
                    if (!(object3 instanceof RelationshipObject)) {
                        if (!QuickCacheObject.isEmpty(object3)) throw new SystemError("Wrong type for relationship!");
                        return null;
                    }
                    List list = ((RelationshipObject)object3).asList();
                    if (list == null) return null;
                    if (list.isEmpty()) return null;
                    if (list instanceof LazyList) {
                        if (!((LazyList)list).isInitialized()) return null;
                    }
                    this.saveOMRelationship(columnBasedField, list, bl);
                    return null;
                } else if (n == 19) {
                    if (!(object3 instanceof RelationshipObject)) {
                        if (!QuickCacheObject.isEmpty(object3)) throw new SystemError("Wrong type for relationship!");
                        return null;
                    }
                    List list = ((RelationshipObject)object3).asList();
                    if (list instanceof LazyList) {
                        if (!((LazyList)list).isInitialized()) return null;
                    }
                    this.savePCRelationship(list, bl);
                    return null;
                } else {
                    if (n != 1) throw new CacheException("Unsupported collection type: " + n);
                    lightDatabase.saveChildArray(string, id.toString(), (Map)object3, bl);
                }
                return null;
            }
            if (columnBasedField.isElementPersistent()) {
                if (columnBasedField.isList()) {
                    return lightDatabase.wrapRefList((List)object3, bl);
                }
                if (n != 1) throw new CacheException("Unsupported collection type: " + n);
                return lightDatabase.wrapRefArray((Map)object3, bl);
            }
            if (columnBasedField.isElementSerial()) {
                if (columnBasedField.isList()) {
                    return lightDatabase.wrapSerialList((List)object3);
                }
                if (n != 1) throw new CacheException("Unsupported collection type: " + n);
                return lightDatabase.wrapSerialArray((Map)object3);
            }
            if (!columnBasedField.isElementDatatype()) throw new CacheException("Unsupported collection element type");
            if (columnBasedField.isList()) {
                if (!"%Library.Currency".equals(columnBasedField.getElementTypeName())) return lightDatabase.wrapPrimList(object3);
                object3 = QuickCacheObject.scaleCurrency((List)object3);
                return lightDatabase.wrapPrimList(object3);
            }
            if (n != 1) throw new CacheException("Unsupported collection type: " + n);
            if (!"%Library.Currency".equals(columnBasedField.getElementTypeName())) return lightDatabase.wrapPrimArray((Map)object3);
            object3 = QuickCacheObject.scaleCurrency((Map)object3);
            return lightDatabase.wrapPrimArray((Map)object3);
        }
        if (columnBasedField.isObject()) {
            if (dataholder.getType() == 1028) {
                return dataholder.getString();
            }
            CacheObject cacheObject = dataholder.getCacheObject();
            if (cacheObject == null) {
                return dataholder;
            }
            if (!this.getDatabase().equals(cacheObject.getDatabase())) {
                throw new CacheException("Attempt to save persistent " + cacheObject + " object from another database: " + cacheObject.getDatabase() + " in " + this.getDatabase());
            }
            object2 = cacheObject.getId();
            if (!bl) {
                if (object2 != null) return object2.toString();
            }
            cacheObject.save(bl);
            object2 = cacheObject.getId();
            return object2.toString();
        }
        if (object2 instanceof SList) {
            return ((SList)object2).getData();
        }
        if (object2 instanceof Collection && columnBasedField.getTypeName().equals("%Library.List")) {
            SList sList = new SList();
            sList.addAll((Collection)object2);
            return sList.getData();
        }
        if (object2 == null) {
            return dataholder;
        }
        if (!(object2 instanceof Character)) return object2;
        String string = columnBasedField.getTypeName();
        if ("%String".equals(string)) return object2.toString();
        if (!"%Library.String".equals(string)) return new Integer(((Character)object2).charValue());
        return object2.toString();
    }

    private static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object.getClass().isArray()) {
            return ((Object[])object).length == 0;
        }
        return ((Map)object).isEmpty();
    }

    private static List scaleCurrency(List list) {
        ArrayList arrayList = new ArrayList(list.size());
        for (Object object : list) {
            if (object instanceof BigDecimal) {
                object = ((BigDecimal)object).setScale(4, 4);
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    private static Map scaleCurrency(Map map) {
        HashMap hashMap = new HashMap(map.size());
        for (Map.Entry entry : map.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof BigDecimal) {
                object = ((BigDecimal)object).setScale(4, 4);
            }
            hashMap.put(entry.getKey(), object);
        }
        return hashMap;
    }

    @Override
    public Object getSerialState(Object object) throws CacheException {
        throw new CacheException("Object of class " + this.mClass.getName() + " is not serializable");
    }

    private void savePCRelationship(List list, boolean bl) throws CacheException {
        for (RegisteredObject registeredObject : list) {
            if (!this.getDatabase().equals(registeredObject.getDatabase())) {
                throw new CacheException("Attempt to save persistent " + registeredObject + " object from another database: " + registeredObject.getDatabase() + " in " + this.getDatabase());
            }
            TableBasedClass tableBasedClass = (TableBasedClass)registeredObject.getCacheClass();
            ColumnBasedField columnBasedField = (ColumnBasedField)tableBasedClass.getParentField();
            QuickPersistentObject quickPersistentObject = (QuickPersistentObject)registeredObject.getProxy();
            if (quickPersistentObject.isClosed()) continue;
            quickPersistentObject.setProperty(columnBasedField, new Dataholder(this), true, false);
            quickPersistentObject.save(bl);
        }
    }

    private void saveOMRelationship(ColumnBasedField columnBasedField, List arrayList, boolean bl) throws CacheException {
        block15: {
            ArrayList arrayList2;
            block13: {
                boolean bl2;
                String string;
                SysDatabase sysDatabase;
                block14: {
                    boolean bl3 = false;
                    arrayList2 = arrayList;
                    String string2 = columnBasedField.getInverseFieldName();
                    sysDatabase = this.getDatabase();
                    string = null;
                    boolean bl4 = true;
                    boolean bl5 = true;
                    bl2 = true;
                    for (Object object : arrayList) {
                        if (!sysDatabase.equals(((CacheRootObject)object).getDatabase())) {
                            throw new CacheException("Attempt to save persistent " + object + " object from another database: " + ((CacheRootObject)object).getDatabase() + " in " + this.getDatabase());
                        }
                        QuickPersistentObject quickPersistentObject = (QuickPersistentObject)((CacheRootObject)object).getProxy();
                        if (quickPersistentObject.isClosed()) {
                            if (!bl3) {
                                arrayList2 = new ArrayList(arrayList);
                            }
                            bl3 = true;
                            arrayList2.remove(object);
                            continue;
                        }
                        TableBasedClass tableBasedClass = (TableBasedClass)((RegisteredObject)object).getCacheClass();
                        ColumnBasedField columnBasedField2 = (ColumnBasedField)tableBasedClass.getField(string2);
                        quickPersistentObject.setProperty(columnBasedField2, new Dataholder(this), true, false);
                        if ((quickPersistentObject.getState() & 0xFF10) != 65296) {
                            if (!bl3) {
                                arrayList2 = new ArrayList(arrayList);
                            }
                            bl3 = true;
                            arrayList2.remove(object);
                            continue;
                        }
                        if (!bl4) continue;
                        if (quickPersistentObject.getId() == null) {
                            bl5 = false;
                        } else {
                            bl2 = false;
                        }
                        if (quickPersistentObject.inSave) {
                            bl4 = false;
                        }
                        if (!bl5 && !bl2) {
                            bl4 = false;
                        }
                        if (string == null) {
                            string = tableBasedClass.getName();
                            continue;
                        }
                        if (string.equals(tableBasedClass.getName())) continue;
                        bl4 = false;
                    }
                    if (bl5 && bl2) {
                        bl4 = false;
                    }
                    if (!bl4) break block13;
                    if (!bl5) break block14;
                    sysDatabase.saveObjects(string, arrayList2);
                    break block15;
                }
                if (!bl2) break block15;
                sysDatabase.createObjects(string, arrayList2);
                break block15;
            }
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                Object object;
                object = (QuickPersistentObject)((RegisteredObject)iterator.next()).getProxy();
                if (((QuickPersistentObject)object).isInSave()) continue;
                ((QuickPersistentObject)object).save(bl);
            }
        }
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public void clearReadState() {
        this.mState &= 0xFFFFFFF0;
    }

    @Override
    public void setStateReadDirty() {
        this.mState |= 0xFF01;
    }

    @Override
    public Object getPojo() {
        return null;
    }

    @Override
    public void setPojo(Object object) throws CacheException {
    }

    protected String getIdValue() throws CacheException {
        Id id = this.getId();
        if (id == null) {
            return null;
        }
        return id.toString();
    }

    @Override
    public Dataholder getProperty(int n, int n2, int n3, String string) throws CacheException {
        return this.getProperty(string, n3 == 1);
    }

    @Override
    public void setProperty(int n, int n2, int n3, int n4, String string, Dataholder dataholder) throws CacheException {
        this.setProperty(string, dataholder);
    }

    public class ZRef {
        public String getClassName() throws CacheException {
            return QuickCacheObject.this.getCacheClass().getName();
        }

        public String getIdString() throws CacheException {
            return QuickCacheObject.this.getIdValue();
        }

        public String toString() {
            try {
                return this.getIdString() + "@" + this.getClassName();
            }
            catch (CacheException cacheException) {
                return cacheException.toString();
            }
        }
    }
}

