/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.ExternalObjectProvider;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.jdbcutil.ConnectionUtils;
import com.intersys.cache.jdbcutil.JDBCAdapter;
import com.intersys.cache.jdbcutil.RDBMSAdapter;
import com.intersys.cache.quick.ColumnBasedField;
import com.intersys.cache.quick.DBAdapter;
import com.intersys.cache.quick.Mappings;
import com.intersys.cache.quick.QuickBulkInsertWorker;
import com.intersys.cache.quick.QuickBulkInsertWorkerPT;
import com.intersys.cache.quick.QuickCacheObject;
import com.intersys.cache.quick.QuickDatabase;
import com.intersys.cache.quick.QuickEmbeddedObject;
import com.intersys.cache.quick.QuickPersistentObject;
import com.intersys.cache.quick.QuickReaderObject;
import com.intersys.cache.quick.QuickStreamObject;
import com.intersys.cache.quick.SQLParser;
import com.intersys.cache.quick.SerialStorage;
import com.intersys.cache.quick.TableBasedClass;
import com.intersys.cache.quick.ThirdPartyDatabase;
import com.intersys.classes.ObjectHandle;
import com.intersys.classes.Persistent;
import com.intersys.classes.RegisteredObject;
import com.intersys.classes.SerialObject;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.ObjectFactory;
import com.intersys.jdbc.QuickStatement;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheInputStream;
import com.intersys.objects.CacheOutputStream;
import com.intersys.objects.CacheReader;
import com.intersys.objects.CacheServerException;
import com.intersys.objects.CacheServerSensitive;
import com.intersys.objects.CacheWriter;
import com.intersys.objects.CandidateKey;
import com.intersys.objects.DatabaseExistsException;
import com.intersys.objects.DatabaseUtilities;
import com.intersys.objects.Id;
import com.intersys.objects.InvalidClassException;
import com.intersys.objects.Logger;
import com.intersys.objects.ObjectServerInfo;
import com.intersys.objects.Oid;
import com.intersys.objects.POJOIterator;
import com.intersys.objects.StatusCode;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheClass;
import com.jalapeno.Utilities;
import com.jalapeno.runtime.DetachedObjectsManager;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public abstract class LightDatabase
extends ExternalObjectProvider
implements SysDatabase,
Mappings,
ObjectFactory {
    protected static final Id UNKNOWN_ID = new Id("UNKNOW_ID");
    protected int mNoLock = 0;
    private static Map databases = null;
    private Map mCache;
    protected boolean amIConnectionOwner;
    protected DBAdapter mAdapter;
    protected Map mClassMap;
    protected Map mTableToClassMap;
    private Map mReverseClassMap;
    protected Map mElementKeyMap;
    protected String mURL;
    private ClassLoader mClassLoader = null;
    protected ObjectServerInfo mInfo;
    protected String mProcess;
    private int mRefCount = 0;
    private boolean isConnectionOpen = false;
    private DetachedObjectsManager mDetachedbjectsManager;
    private Boolean mLazyCollections = null;
    private boolean mBackWithPOJO = false;
    protected Map mPKIdMap;
    private Set mLoadInterceptors = null;
    private int mMaxBatchSize = 1024;
    private QuickBulkInsertWorker mQuickBulkInsertWorker;

    protected LightDatabase() {
    }

    protected LightDatabase(Connection connection, Connection connection2) throws CacheException {
        this.amIConnectionOwner = false;
        try {
            this.mURL = connection.getMetaData().getURL();
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Can not determine Connection URL");
        }
        this.initClientDatabase(connection, connection2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initClientDatabase(Connection connection, Connection connection2) throws CacheException {
        if (databases == null) {
            databases = Collections.synchronizedMap(new HashMap());
        }
        Map map = databases;
        synchronized (map) {
            if (databases.containsKey(connection2)) {
                try {
                    String string = "0";
                    if (connection instanceof CacheConnection) {
                        string = ((CacheConnection)connection).getCacheJobID();
                    }
                    throw new DatabaseExistsException(string);
                }
                catch (SQLException sQLException) {
                    throw new DatabaseExistsException("0");
                }
            }
            this.isConnectionOpen = true;
            this.mClassMap = new HashMap();
            this.mTableToClassMap = new HashMap();
            this.mReverseClassMap = new HashMap();
            this.mElementKeyMap = new HashMap();
            this.mInfo = new ObjectServerInfo();
            this.onInitDatabase(connection);
            try {
                this.myConnection().setAutoCommit(true);
            }
            catch (SQLException sQLException) {
                throw new SystemError(sQLException, "Failed to set autocommit to true.");
            }
            int n = ConnectionUtils.determineCacheType();
            if (n != 0) {
                this.mCache = new HashMap();
                this.mPKIdMap = new HashMap();
            }
            databases.put(connection2, this);
            ++this.mRefCount;
        }
    }

    @Override
    public boolean getDefaultLockMode() {
        return this.mNoLock == 0;
    }

    @Override
    public void setDefaultLockMode(boolean bl) {
        this.mNoLock = bl ? 0 : 1;
    }

    @Override
    public Utilities xmlUtils() {
        throw new UnsupportedOperationException("Method xmlUtils() is not implemented in Light Java Binding. Please use Jalapeno Object Manager");
    }

    protected abstract void onInitDatabase(Connection var1) throws CacheException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LightDatabase getDatabase(Connection connection) throws CacheException {
        Connection connection2 = connection;
        synchronized (connection2) {
            if (databases == null || !databases.containsKey(connection)) {
                return LightDatabase.createDatabase(connection);
            }
            QuickDatabase quickDatabase = (QuickDatabase)databases.get(connection);
            if (!LightDatabase.onTheSameConnection(quickDatabase, connection)) {
                return LightDatabase.createDatabase(connection);
            }
            ++quickDatabase.mRefCount;
            if (Logger.debugOn()) {
                Logger.out.println("Increased ref count for Database " + quickDatabase.mProcess + " it is now " + quickDatabase.mRefCount);
            }
            return quickDatabase;
        }
    }

    private static boolean onTheSameConnection(LightDatabase lightDatabase, Connection connection) throws CacheException {
        try {
            String string;
            if (!(connection instanceof CacheConnection) && "Cache".equalsIgnoreCase(string = connection.getMetaData().getDatabaseProductName())) {
                connection = JDBCAdapter.getCacheConnection(connection);
            }
            if (connection instanceof CacheConnection) {
                String string2;
                string = ((CacheConnection)connection).getCacheJobID();
                return string.equals(string2 = lightDatabase.mProcess);
            }
            return true;
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Attempt to use closed connection to construct Database");
        }
    }

    private static LightDatabase createDatabase(Connection connection) throws CacheException {
        String string;
        if (connection instanceof CacheConnection) {
            return new QuickDatabase((CacheConnection)connection, connection);
        }
        try {
            string = connection.getMetaData().getDatabaseProductName();
        }
        catch (SQLException sQLException) {
            throw new CacheException("Can not determine Database Product.");
        }
        if ("Cache".equalsIgnoreCase(string)) {
            CacheConnection cacheConnection = JDBCAdapter.getCacheConnection(connection);
            return new QuickDatabase(cacheConnection, connection);
        }
        return new ThirdPartyDatabase(connection);
    }

    @Override
    public CacheObject openByKey(String string, CandidateKey candidateKey, int n) throws CacheException {
        Object object;
        int n2;
        Object object2;
        if (this.mPKIdMap != null && (object2 = this.mPKIdMap.get(candidateKey)) != null) {
            if (object2 == UNKNOWN_ID) {
                throw new CacheException("Failed to open object of class " + string + " with primary key " + candidateKey.toString(), 5809);
            }
            if (Logger.debugOn()) {
                System.out.println("OpenByKey: Using cached id: " + candidateKey + " -> " + object2);
            }
            return this.openCacheObject(string, object2.toString());
        }
        object2 = (TableBasedClass)this.getCacheClass(string);
        String string2 = object2.getSchemaName();
        String string3 = object2.getSQLTableName();
        int n3 = n2 = n > 0 ? 0 : 1;
        if (Logger.debugOn()) {
            Logger.out.println("Opening by key: " + candidateKey);
        }
        if ((object = this.myAdapter().loadByKey(string2, string3, candidateKey, n2, (TableBasedClass)object2)) == null) {
            if (this.mPKIdMap != null) {
                this.mPKIdMap.put(candidateKey, UNKNOWN_ID);
            }
            throw new CacheException("Failed to open object of class " + object2.getName() + " with primary key " + candidateKey.toString(), 5809);
        }
        int n4 = object2.getIdField().getColumnIndexForGet();
        String string4 = null;
        try {
            SysListProxy.rewind(object);
            string4 = SysListProxy.getString(object, n4 - 1);
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to determine id of opened object");
        }
        SQLRow sQLRow = new SQLRow(string4, (CacheClass)object2);
        QuickPersistentObject quickPersistentObject = null;
        if (this.mCache != null) {
            quickPersistentObject = (QuickPersistentObject)this.mCache.get(sQLRow);
        }
        if (quickPersistentObject == null) {
            quickPersistentObject = this.createCacheObject(object, (TableBasedClass)object2, null, object2.getName(), string4, n2, 7502);
        }
        if (this.mPKIdMap != null) {
            this.mPKIdMap.put(candidateKey, string4);
        }
        return quickPersistentObject;
    }

    public Object existsByKey(TableBasedClass tableBasedClass, CandidateKey candidateKey, boolean bl) throws CacheException {
        Object object;
        if (this.mPKIdMap != null && (object = this.mPKIdMap.get(candidateKey)) != null) {
            if (object == UNKNOWN_ID) {
                return null;
            }
            return object;
        }
        if (!bl) {
            return null;
        }
        String string = tableBasedClass.getSchemaName();
        String string2 = tableBasedClass.getSQLTableName();
        if (Logger.debugOn()) {
            Logger.out.println("Exists for key: " + candidateKey);
        }
        object = this.myAdapter().existsForKey(string, string2, candidateKey);
        if (this.mPKIdMap != null) {
            if (object == null) {
                this.mPKIdMap.put(candidateKey, UNKNOWN_ID);
            } else {
                this.mPKIdMap.put(candidateKey, object);
            }
        }
        return object;
    }

    private Dataholder[] existsByKey(String string, String string2, Dataholder[] dataholderArray) throws CacheException {
        CandidateKey candidateKey;
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClass(string);
        Object object = this.existsByKey(tableBasedClass, candidateKey = LightDatabase.keyFromMethod(string2, "Exists", tableBasedClass, dataholderArray), true);
        boolean bl = object != null;
        return new Dataholder[]{new Dataholder(bl), Dataholder.create(object)};
    }

    private Dataholder[] openByKey(String string, String string2, Dataholder[] dataholderArray) throws CacheException {
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClass(string);
        CandidateKey candidateKey = LightDatabase.keyFromMethod(string2, "Open", tableBasedClass, dataholderArray);
        CacheObject cacheObject = this.openByKey(string, candidateKey, -1);
        return new Dataholder[]{new Dataholder(cacheObject)};
    }

    private Dataholder[] deleteByKey(String string, String string2, Dataholder[] dataholderArray) throws CacheException {
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClass(string);
        CandidateKey candidateKey = LightDatabase.keyFromMethod(string2, "Delete", tableBasedClass, dataholderArray);
        String string3 = tableBasedClass.getSchemaName();
        String string4 = tableBasedClass.getSQLTableName();
        if (Logger.debugOn()) {
            Logger.out.println("Delete for key: " + candidateKey);
        }
        this.checkPkMappingOnDelete(candidateKey);
        this.myAdapter().deleteByKey(string3, string4, candidateKey, this.mNoLock, tableBasedClass);
        return new Dataholder[]{new Dataholder(1)};
    }

    private static CandidateKey keyFromMethod(String string, String string2, TableBasedClass tableBasedClass, Dataholder[] dataholderArray) throws CacheException {
        int n = string.lastIndexOf(string2);
        String string3 = string.substring(0, n);
        CandidateKey candidateKey = tableBasedClass.createKey(string3);
        int n2 = candidateKey.getLength();
        for (int i = 0; i < dataholderArray.length; ++i) {
            if (i >= n2) continue;
            candidateKey.set(i, dataholderArray[i].getString());
        }
        return candidateKey;
    }

    @Override
    public boolean deleteObject(String string, CandidateKey candidateKey) throws CacheException {
        int n = 0;
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClass(string);
        String string2 = tableBasedClass.getSchemaName();
        String string3 = tableBasedClass.getSQLTableName();
        int n2 = n > 0 ? 0 : 1;
        this.checkPkMappingOnDelete(candidateKey);
        return this.myAdapter().deleteByKey(string2, string3, candidateKey, n2, tableBasedClass);
    }

    @Override
    public DetachedObjectsManager getDetachedObjectsManager() {
        if (this.mDetachedbjectsManager == null) {
            this.mDetachedbjectsManager = DetachedObjectsManager.createDetachedObjectsManager(this);
        }
        return this.mDetachedbjectsManager;
    }

    protected DetachedObjectsManager getDetachedObjectsManagerIfExists() {
        return this.mDetachedbjectsManager;
    }

    @Override
    public CacheObject openCacheObject(String string, byte[] byArray, int n, int n2) throws CacheException {
        if (n2 <= 0) {
            return this.openCacheObject(string, byArray, n);
        }
        throw new CacheException("Timeout is not supported in this implementation of Database interface.");
    }

    @Override
    public CacheObject openCacheObject(String string, byte[] byArray) throws CacheException {
        return this.openCacheObject(string, byArray, -1);
    }

    public CacheObject openCacheObject(Oid oid, int n, int n2) throws CacheException {
        if (n2 > 0) {
            throw new CacheException("Timeout is not supported in this implementation of Database interface.");
        }
        SQLRow sQLRow = new SQLRow(this, oid);
        return this.openObjectByRow(sQLRow, n, null);
    }

    @Override
    public CacheObject openCacheObject(String string, String string2) throws CacheException {
        SQLRow sQLRow = new SQLRow(this, string2, string);
        return this.openObjectByRow(sQLRow, -1, string);
    }

    @Override
    public CacheObject openCacheObject(String string, String string2, int n) throws CacheException {
        SQLRow sQLRow = new SQLRow(this, string2, string);
        return this.openObjectByRow(sQLRow, n, string);
    }

    @Override
    public CacheObject openCacheObject(String string, String string2, int n, int n2) throws CacheException {
        SQLRow sQLRow = new SQLRow(this, string2, string);
        if (n2 > 0) {
            throw new CacheException("Timeout is not supported in this implementation of Database interface.");
        }
        return this.openObjectByRow(sQLRow, n, string);
    }

    @Override
    public CacheObject openCacheObject(String string, byte[] byArray, int n) throws CacheException {
        SQLRow sQLRow;
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClass(string);
        if (tableBasedClass.isSerial()) {
            return this.deserializeObject(string, byArray);
        }
        if (string != null) {
            CacheClass cacheClass = this.getCacheClass(string);
            if (cacheClass == null) {
                throw new InvalidClassException("Cacahe class " + string + " does not exist");
            }
            sQLRow = new SQLRow(byArray, cacheClass, this);
        } else {
            sQLRow = new SQLRow(byArray, null, this);
        }
        return this.openObjectByRow(sQLRow, n, string);
    }

    private CacheObject openObjectByRow(SQLRow sQLRow, int n, String string) throws CacheException {
        QuickPersistentObject quickPersistentObject = null;
        if (this.mCache != null) {
            quickPersistentObject = (QuickPersistentObject)this.mCache.get(sQLRow);
        }
        if (quickPersistentObject != null) {
            return quickPersistentObject;
        }
        if (string == null || string.startsWith("%") && sQLRow.getClassName() != null) {
            string = sQLRow.getClassName();
        }
        int n2 = n <= 0 ? 1 : 0;
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClass(string);
        Object object = this.loadObject(sQLRow, n2, tableBasedClass, false);
        quickPersistentObject = this.createCacheObject(object, tableBasedClass, sQLRow, string, null, n2, 7502);
        return quickPersistentObject;
    }

    private synchronized QuickPersistentObject createCacheObject(Object object, TableBasedClass tableBasedClass, SQLRow sQLRow, String string, String string2, int n, int n2) throws CacheException {
        if (Logger.getDebugCache()) {
            Logger.out.println("Recieved data for object: " + object);
        }
        String string3 = LightDatabase.parseClassName(tableBasedClass, object);
        QuickPersistentObject quickPersistentObject = null;
        if (string3 != null && !string3.equals(string)) {
            if (string2 == null) {
                string2 = sQLRow.getId();
            }
            sQLRow = new SQLRow(this, string2, string3);
            if (Logger.debugOn()) {
                System.out.println("Reloading object because it is instance of subclass: " + string3 + ", ID = " + string2);
            }
            if (this.mCache != null) {
                quickPersistentObject = (QuickPersistentObject)this.mCache.get(sQLRow);
            }
            if (quickPersistentObject != null) {
                if (Logger.debugOn()) {
                    System.out.println("Using Cached instance");
                }
                return quickPersistentObject;
            }
            tableBasedClass = (TableBasedClass)this.getCacheClass(string3);
            object = this.loadObject(sQLRow, n, tableBasedClass, false);
        }
        quickPersistentObject = this.newQuickPersistentObject(tableBasedClass, object, n2);
        this.addToMap(quickPersistentObject, sQLRow, string, string2);
        this.checkObjectCleanState(quickPersistentObject);
        return quickPersistentObject;
    }

    protected QuickPersistentObject processOpenedObject(String string, Object object) throws CacheException {
        if (Logger.getDebugCache()) {
            Logger.out.println("Recieved data for object: [" + string + "] " + object);
        }
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClass(string);
        int n = tableBasedClass.getIdField().getColumnIndexForGet();
        String string2 = null;
        try {
            string2 = SysListProxy.getString(object, n - 1);
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to determine id of opened object");
        }
        SQLRow sQLRow = new SQLRow(string2, tableBasedClass);
        QuickPersistentObject quickPersistentObject = null;
        if (this.mCache != null) {
            quickPersistentObject = (QuickPersistentObject)this.mCache.get(sQLRow);
        }
        if (quickPersistentObject != null) {
            return quickPersistentObject;
        }
        quickPersistentObject = this.newQuickPersistentObject(tableBasedClass, object, 7502);
        this.addToMap(quickPersistentObject, sQLRow, string, string2);
        this.checkObjectCleanState(quickPersistentObject);
        return quickPersistentObject;
    }

    private void checkObjectCleanState(CacheObject cacheObject) throws CacheException {
        Oid oid;
        if (this.mDetachedbjectsManager != null && this.mDetachedbjectsManager.isCleanState(oid = cacheObject.getOid())) {
            cacheObject.clearReadState();
        }
    }

    protected void addToMap(QuickPersistentObject quickPersistentObject, SQLRow sQLRow, String string, String string2) throws CacheException {
        QuickPersistentObject quickPersistentObject2;
        if (this.mCache == null) {
            return;
        }
        if (sQLRow == null) {
            sQLRow = new SQLRow(this, string2, string);
        }
        if ((quickPersistentObject2 = this.mCache.put(sQLRow, quickPersistentObject)) != null && quickPersistentObject2 != quickPersistentObject) {
            throw new IllegalStateException("Replacing an object in Cache!");
        }
    }

    protected void removeFromMap(String string, String string2) throws CacheException {
        if (this.mCache == null) {
            return;
        }
        SQLRow sQLRow = new SQLRow(this, string2, string);
        this.mCache.remove(sQLRow);
    }

    protected String getColumnSQL(TableBasedClass tableBasedClass) throws CacheException {
        return tableBasedClass.getColumnsSQL();
    }

    @Override
    public Iterator openByQuery(String string, String string2) throws CacheException {
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClass(string);
        String string3 = tableBasedClass.getFullSQLTableNameQuoted();
        String string4 = "select " + this.getColumnSQL(tableBasedClass) + " from " + string3;
        if (string2 != null && string2.trim().length() > 0) {
            string4 = string4 + " where " + string2;
        }
        return this.openByQuery(string4, tableBasedClass, null);
    }

    @Override
    public Iterator openByQuery(String string, String string2, Object[] objectArray) throws CacheException {
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClass(string);
        String string3 = tableBasedClass.getFullSQLTableNameQuoted();
        String string4 = "select " + this.getColumnSQL(tableBasedClass) + " from " + string3;
        if (string2 != null && string2.trim().length() > 0) {
            string4 = string4 + " where " + string2;
        }
        return this.openByQuery(string4, tableBasedClass, objectArray);
    }

    protected int countObjects(String string, String string2) throws CacheException {
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClass(string);
        String string3 = tableBasedClass.getFullSQLTableNameQuoted();
        return this.myAdapter().countElements(string3, string2);
    }

    @Override
    public Iterator openByQuery(String string) throws CacheException {
        StringBuffer stringBuffer = new StringBuffer(string);
        TableBasedClass tableBasedClass = (TableBasedClass)SQLParser.forBulkLoad(stringBuffer, this, null);
        return this.openByQuery(stringBuffer.toString(), tableBasedClass, null);
    }

    @Override
    public Iterator openByQuery(String string, Object[] objectArray) throws CacheException {
        StringBuffer stringBuffer = new StringBuffer(string);
        TableBasedClass tableBasedClass = (TableBasedClass)SQLParser.forBulkLoad(stringBuffer, this, null);
        return this.openByQuery(stringBuffer.toString(), tableBasedClass, objectArray);
    }

    private Iterator openByQuery(String string, TableBasedClass tableBasedClass, Object[] objectArray) throws CacheException {
        string = this.adjustSQL(tableBasedClass, string);
        int n = tableBasedClass.getIdField().getColumnIndexForGet() - 1;
        if (Logger.getDebugCache()) {
            Logger.out.println("Opening by query: " + string);
        }
        try {
            PreparedStatement preparedStatement = this.getStatementForOpen(string);
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (object == null) {
                        preparedStatement.setNull(i + 1, 12);
                        continue;
                    }
                    preparedStatement.setObject(i + 1, objectArray[i]);
                }
            }
            ResultSet resultSet = RDBMSAdapter.executeQuery(preparedStatement);
            return this.getResultSetIterator(resultSet, tableBasedClass, n);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to open objects of class " + tableBasedClass.getName() + " by query: " + string);
        }
    }

    public CacheObject getProxyFromCache(CacheClass cacheClass, String string) {
        if (this.mCache == null) {
            return null;
        }
        SQLRow sQLRow = new SQLRow(string, cacheClass);
        return (CacheObject)this.mCache.get(sQLRow);
    }

    protected String adjustSQL(TableBasedClass tableBasedClass, String string) throws CacheException {
        return string;
    }

    protected abstract Iterator getResultSetIterator(ResultSet var1, TableBasedClass var2, int var3) throws CacheException;

    private PreparedStatement getStatementForOpen(String string) throws SQLException {
        PreparedStatement preparedStatement = this.myConnection().prepareStatement(string);
        return preparedStatement;
    }

    public Collection openObjects(String string, Collection collection, int n) throws CacheException {
        ArrayList arrayList = new ArrayList(collection.size());
        Object object = SysListProxy.createSysList(this.getConnectionInfo());
        try {
            if (!this.prepareForBulkLoad(arrayList, object, string, collection)) {
                return arrayList;
            }
            int n2 = n <= 0 ? 1 : 0;
            Object object2 = this.bulkLoad(string, object, n2);
            this.postBulkLoad(arrayList, object, object2, string, n2);
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Error opening a set of object of class " + string);
        }
        return arrayList;
    }

    private boolean prepareForBulkLoad(List list, Object object, String string, Collection collection) throws CacheException, SQLException {
        int n = 0;
        if (this.mCache != null) {
            for (Object object2 : collection) {
                SQLRow sQLRow;
                Object v;
                if (!(object2 instanceof String)) {
                    object2 = object2.toString();
                }
                if ((v = this.mCache.get(sQLRow = new SQLRow(this, (String)object2, string))) != null) {
                    list.add(((CacheObject)v).newJavaInstance());
                    continue;
                }
                SysListProxy.setString(object, (String)object2);
                ++n;
            }
            if (n == 0) {
                return false;
            }
            Object object3 = SysListProxy.createSysList(this.getConnectionInfo());
            SysListProxy.setInteger(object3, n);
            SysListProxy.concatenate(object3, object);
            object = object3;
        } else {
            n = collection.size();
            SysListProxy.setInteger(object, n);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                SysListProxy.setObject(object, iterator.next());
            }
        }
        return true;
    }

    private void postBulkLoad(List list, Object object, Object object2, String string, int n) throws CacheException, SQLException {
        SysListProxy.rewind(object);
        int n2 = SysListProxy.getInteger(object);
        int n3 = 0;
        while (!SysListProxy.atEnd(object2)) {
            Object object3 = SysListProxy.getSubList(object2, 18);
            QuickPersistentObject quickPersistentObject = null;
            TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClass(string);
            String string2 = SysListProxy.getString(object);
            quickPersistentObject = this.createCacheObject(object3, tableBasedClass, null, string, string2, n, 7502);
            list.add(quickPersistentObject.newJavaInstance());
            ++n3;
        }
        if (n3 != n2) {
            throw new SystemError("Only " + n3 + " out of " + n2 + " objects were opened.");
        }
    }

    private static String parseClassName(TableBasedClass tableBasedClass, Object object) throws CacheException {
        String string;
        int n = tableBasedClass.getXClassNameColumn();
        try {
            SysListProxy.rewind(object);
            string = SysListProxy.getString(object, n - 1);
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to determine real class of opened object");
        }
        if (string == null) {
            return null;
        }
        int n2 = string.lastIndexOf(126);
        string = string.substring(0, n2);
        int n3 = string.lastIndexOf(126);
        return string.substring(n3 + 1, n2);
    }

    protected Object loadObject(String string, TableBasedClass tableBasedClass) throws CacheException {
        if (this.mLoadInterceptors != null) {
            for (LoadInterceptor loadInterceptor : this.mLoadInterceptors) {
                Object object = loadInterceptor.process(tableBasedClass, string);
                if (object == null) continue;
                return object;
            }
        }
        SQLRow sQLRow = new SQLRow(string, tableBasedClass);
        return this.loadObject(sQLRow, 1, tableBasedClass, true);
    }

    private Object loadObject(SQLRow sQLRow, int n, TableBasedClass tableBasedClass, boolean bl) throws CacheException {
        Object object;
        if (!bl && this.mLoadInterceptors != null) {
            object = this.mLoadInterceptors.iterator();
            while (object.hasNext()) {
                LoadInterceptor loadInterceptor = (LoadInterceptor)object.next();
                Object object2 = loadInterceptor.process(tableBasedClass, sQLRow.getId());
                if (object2 == null) continue;
                return object2;
            }
        }
        if ((object = this.myAdapter().load(sQLRow.schema, sQLRow.table, sQLRow.getId(), n, tableBasedClass)) == null) {
            throw new CacheException("Failed to open object of class " + sQLRow.getClassName() + " with id " + sQLRow.getId(), 5809);
        }
        return object;
    }

    private Object bulkLoad(String string, Object object, int n) throws CacheException {
        CacheClass cacheClass = this.getCacheClass(string);
        if (cacheClass == null) {
            throw new CacheException("Cache class " + string + " does not exist");
        }
        SQLRow sQLRow = new SQLRow(cacheClass);
        Object object2 = this.myAdapter().bulkLoad(sQLRow.schema, sQLRow.table, object, n);
        if (object2 == null) {
            throw new CacheException("Failed to open set of objects of class " + sQLRow.getClassName(), 5809);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheObject newCacheObject(String string) throws CacheException {
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClass(string);
        Object object = tableBasedClass;
        synchronized (object) {
            if (!tableBasedClass.isVerified()) {
                tableBasedClass.verifyClass();
            }
        }
        if (tableBasedClass.isPersistent()) {
            if (this.mBackWithPOJO) {
                return QuickPersistentObject.createPojoBackedObject(tableBasedClass, null);
            }
            return QuickPersistentObject.createArrayBackedObject(tableBasedClass);
        }
        if (tableBasedClass.hasSerialStorage()) {
            object = new SerialStorage(tableBasedClass, null);
            return new QuickEmbeddedObject((SerialStorage)object);
        }
        return new QuickEmbeddedObject(tableBasedClass);
    }

    private QuickPersistentObject newQuickPersistentObject(TableBasedClass tableBasedClass, Object object, int n) throws CacheException {
        if (this.mBackWithPOJO) {
            return QuickPersistentObject.createPojoBackedObject(tableBasedClass, object, n);
        }
        return QuickPersistentObject.createArrayBackedObject(tableBasedClass, object, n);
    }

    @Override
    public CacheObject deserializeObject(String string, byte[] byArray) throws CacheException {
        return this.deserializeObject(string, SysListProxy.createSysList(byArray, this.getConnectionInfo()));
    }

    @Override
    public CacheObject deserializeObject(String string, Object object) throws CacheException {
        SerialStorage serialStorage = new SerialStorage(this, string, object);
        return new QuickEmbeddedObject(serialStorage);
    }

    @Override
    public Object deserialize(Object object) throws SQLException {
        try {
            if (object == null || SysListProxy.atEnd(object)) {
                return null;
            }
            return this.deserializeObject(null, object).newJavaInstance();
        }
        catch (CacheException cacheException) {
            throw new SQLException(cacheException.getMessage());
        }
    }

    @Override
    public CacheObject newClientObject(String string) throws CacheException {
        return this.newCacheObject(string);
    }

    @Override
    public CacheObject newCacheObject(String string, String string2) throws CacheException {
        if (string2 == null || string2.length() == 0) {
            return this.newCacheObject(string);
        }
        throw new CacheException("Constructor with argument is not  supported in Light mode.");
    }

    protected ArrayList getListOfReferencesAsChildTable(String string, Object object, int n, int n2, int n3) throws CacheException {
        SQLRow sQLRow = new SQLRow(string);
        return this.myAdapter().getListAsChildTable(sQLRow.schema, sQLRow.table, object, n, n2, this.mNoLock, n3);
    }

    protected HashMap getArrayOfReferencesAsChildTable(String string, Object object, int n, int n2, int n3) throws CacheException {
        SQLRow sQLRow = new SQLRow(string);
        return this.myAdapter().getArrayAsChildTable(sQLRow.schema, sQLRow.table, object, n, n2, this.mNoLock, n3);
    }

    @Override
    public void createObjects(String string, Collection collection) throws CacheException {
        this.createObjects(string, collection, false);
    }

    public void createObjects(String string, Collection collection, boolean bl) throws CacheException {
        int n = collection.size();
        if (Logger.getDebugCache()) {
            Logger.out.println("Creating " + n + " objects of type " + string);
        }
        if (this.mMaxBatchSize <= 0 || n <= this.mMaxBatchSize) {
            this.createObjects(string, collection, n, bl);
        } else {
            Iterator iterator = collection.iterator();
            ArrayList arrayList = new ArrayList(this.mMaxBatchSize);
            int n2 = 1;
            while (iterator.hasNext()) {
                int n3;
                for (n3 = 0; iterator.hasNext() && n3 < this.mMaxBatchSize; ++n3) {
                    arrayList.add(iterator.next());
                }
                if (Logger.getDebugCache()) {
                    Logger.out.println(">>> Batch # " + n2 + ": " + n3 + " objects");
                }
                this.createObjects(string, arrayList, n3, bl);
                arrayList.clear();
                ++n2;
            }
        }
    }

    private void createObjects(String string, Collection collection, int n, boolean bl) throws CacheException {
        QuickPersistentObject quickPersistentObject;
        Object object;
        Object object22;
        Object object3 = this.createSysList();
        try {
            SysListProxy.setInteger(object3, n);
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Weird error: empty list is corrupted.");
        }
        int n2 = 0;
        ArrayList arrayList = new ArrayList();
        Object object4 = this.createSysList();
        for (Object object22 : collection) {
            object = object22 instanceof QuickPersistentObject ? (QuickPersistentObject)object22 : (QuickPersistentObject)((Persistent)object22).getProxy();
            if (n2 > 0) {
                SysListProxy.clearList(object4);
            }
            switch (((QuickPersistentObject)object).save(object4, true, false, bl)) {
                case 2: {
                    arrayList.add(object22);
                }
                case 0: 
                case 1: {
                    try {
                        SysListProxy.concatenate(object3, object4);
                        break;
                    }
                    catch (SQLException sQLException) {
                        throw new SystemError(sQLException, "Data is corrupted.");
                    }
                }
                default: {
                    throw new SystemError("Unknown code from save.");
                }
            }
            if (Logger.getDebugCache()) {
                Logger.out.println(n2 + ": values: " + object4.toString());
            }
            ++n2;
        }
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClass(string);
        object = new SQLRow(tableBasedClass);
        object22 = this.myAdapter().bulkCreate(((SQLRow)object).schema, ((SQLRow)object).table, 4, object3, this.mNoLock);
        ColumnBasedField columnBasedField = tableBasedClass.getIdField();
        n2 = 0;
        Object object5 = collection.iterator();
        while (object5.hasNext()) {
            Iterator iterator;
            try {
                iterator = SysListProxy.getObject(object22);
            }
            catch (SQLException sQLException) {
                throw new CacheException(sQLException, "Only " + n2 + " objects were created successfully.");
            }
            Object e = object5.next();
            quickPersistentObject = e instanceof QuickPersistentObject ? (QuickPersistentObject)e : (QuickPersistentObject)((Persistent)e).getProxy();
            quickPersistentObject.setProperty(columnBasedField, Dataholder.create(iterator), false, true);
            if (this.mPKIdMap != null) {
                this.checkPkMappingOnCreate(tableBasedClass, quickPersistentObject, iterator);
            }
            ++n2;
        }
        if (Logger.getDebugCache()) {
            Logger.out.println("Scheduling for second save: " + arrayList.size() + " objects");
        }
        object5 = new LoadInterceptor(tableBasedClass, n, object22);
        this.addLoadInterceptor((LoadInterceptor)object5);
        if (!arrayList.isEmpty()) {
            this.saveObjects(string, arrayList);
        }
        for (Object e : collection) {
            quickPersistentObject = e instanceof QuickPersistentObject ? (QuickPersistentObject)e : (QuickPersistentObject)((Persistent)e).getProxy();
            quickPersistentObject.afterSave(null, true);
        }
    }

    public synchronized QuickBulkInsertWorker getBulkInserter() {
        if (this.mQuickBulkInsertWorker == null) {
            this.mQuickBulkInsertWorker = new QuickBulkInsertWorkerPT(this, this.mNoLock);
        }
        return this.mQuickBulkInsertWorker;
    }

    public void checkBulkInserter() throws Exception {
        if (this.mQuickBulkInsertWorker != null) {
            this.mQuickBulkInsertWorker.checkForException();
        }
    }

    @Override
    public void saveObjects(String string, Collection collection) throws CacheException {
        this.saveObjects(string, collection, true);
    }

    public void saveObjects(String string, Collection collection, boolean bl) throws CacheException {
        if (bl) {
            this.invalidateLoadInterceptors(string);
        }
        int n = collection.size();
        if (Logger.getDebugCache()) {
            Logger.out.println("Saving " + n + " objects of type " + string);
        }
        if (this.mMaxBatchSize <= 0 || n <= this.mMaxBatchSize) {
            this.saveObjects(string, collection, n);
        } else {
            Iterator iterator = collection.iterator();
            ArrayList arrayList = new ArrayList(this.mMaxBatchSize);
            int n2 = 1;
            while (iterator.hasNext()) {
                int n3;
                for (n3 = 0; iterator.hasNext() && n3 < this.mMaxBatchSize; ++n3) {
                    arrayList.add(iterator.next());
                }
                if (Logger.getDebugCache()) {
                    Logger.out.println(">>> Batch # " + n2 + ": " + n3 + " objects");
                }
                this.saveObjects(string, arrayList, n3);
                arrayList.clear();
                ++n2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void saveObjects(String string, Collection collection, int n) throws CacheException {
        Object object;
        Object object2;
        Object object322;
        Object object4 = this.createSysList();
        try {
            SysListProxy.setInteger(object4, n);
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Weird error: empty list is corrupted.");
        }
        int n2 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object5 = SysListProxy.createSysList(this.getConnectionInfo());
        boolean[] blArray = new boolean[n];
        Object object6 = SysListProxy.createSysList(this.getConnectionInfo());
        for (Object object322 : collection) {
            object2 = object322 instanceof QuickPersistentObject ? (QuickPersistentObject)object322 : (QuickPersistentObject)((Persistent)object322).getProxy();
            if (n2 > 0) {
                SysListProxy.clearList(object5);
            }
            try {
                object = ((QuickPersistentObject)object2).getId().toString();
                SysListProxy.setString(object5, (String)object);
                SysListProxy.setString(object6, (String)object);
            }
            catch (SQLException sQLException) {
                throw new SystemError(sQLException, "List is corrupted.");
            }
            switch (((QuickPersistentObject)object2).save(object5, true, false, false)) {
                case 2: {
                    arrayList.add(object322);
                }
                case 1: {
                    blArray[n2] = true;
                }
                case 0: {
                    try {
                        SysListProxy.concatenate(object4, object5);
                        break;
                    }
                    catch (SQLException sQLException) {
                        throw new SystemError(sQLException, "List is corrupted.");
                    }
                }
                default: {
                    throw new SystemError("Unknown code from save.");
                }
            }
            if (Logger.getDebugCache()) {
                Logger.out.println(n2 + ": values: " + object5.toString());
            }
            ++n2;
        }
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClass(string);
        if (tableBasedClass == null) {
            throw new CacheException("Cache class " + string + " does not exist");
        }
        object2 = new SQLRow(tableBasedClass);
        this.myAdapter().bulkStore(((SQLRow)object2).schema, ((SQLRow)object2).table, object4, this.mNoLock);
        if (Logger.getDebugCache()) {
            Logger.out.println("Scheduling for second save: " + arrayList.size() + " objects");
        }
        for (Object object7 : arrayList) {
            object = object7 instanceof QuickPersistentObject ? (QuickPersistentObject)object7 : (QuickPersistentObject)((Persistent)object7).getProxy();
            ((QuickPersistentObject)object).save(false);
        }
        object322 = new LoadInterceptor(tableBasedClass, n, object6);
        this.addLoadInterceptor((LoadInterceptor)object322);
        n2 = 0;
        for (Object e : collection) {
            if (e instanceof QuickPersistentObject) {
                QuickPersistentObject quickPersistentObject = (QuickPersistentObject)e;
            } else {
                QuickPersistentObject quickPersistentObject = (QuickPersistentObject)((Persistent)e).getProxy();
            }
            if (blArray[n2]) {
                void var14_21;
                var14_21.afterSave(null, true);
            }
            ++n2;
        }
    }

    @Override
    public synchronized void saveAllObjects() throws CacheException {
        if (this.mCache == null) {
            return;
        }
        if (Logger.getDebugCache()) {
            Logger.out.println(">>> Saving all modified objects.");
        }
        this.mLoadInterceptors = null;
        for (QuickPersistentObject quickPersistentObject : this.mCache.values()) {
            if ((quickPersistentObject.getState() & 0xFF10) != 65296) continue;
            quickPersistentObject.save(true);
        }
        if (Logger.getDebugCache()) {
            Logger.out.println("<<< Finished saving all modified objects.");
        }
    }

    protected Object create(TableBasedClass tableBasedClass, Object object, QuickPersistentObject quickPersistentObject) throws CacheException {
        SQLRow sQLRow = new SQLRow(tableBasedClass);
        if (Logger.getDebugCache()) {
            Logger.out.println("Creating object of type " + tableBasedClass.getName());
            Logger.out.println("Values: " + object.toString());
        }
        int n = tableBasedClass.getIdField().getJDBCType();
        Object object2 = this.myAdapter().create(sQLRow.schema, sQLRow.table, n, object, this.mNoLock, tableBasedClass);
        if (tableBasedClass.getIdKeyField() != null && object2 == null) {
            object2 = quickPersistentObject.getProperty(tableBasedClass.getIdKeyField());
        }
        if (this.mPKIdMap != null) {
            this.checkPkMappingOnCreate(tableBasedClass, quickPersistentObject, object2);
        }
        return object2;
    }

    private void checkPkMappingOnCreate(TableBasedClass tableBasedClass, QuickPersistentObject quickPersistentObject, Object object) throws CacheException {
        if (tableBasedClass.getBestCandidateKey() == null) {
            return;
        }
        if (tableBasedClass.getIdPlaceholder() != null) {
            return;
        }
        CandidateKey candidateKey = tableBasedClass.createBestCandidateKey();
        quickPersistentObject.setKeyValues(candidateKey);
        Object v = this.mPKIdMap.get(candidateKey);
        if (v == UNKNOWN_ID) {
            this.mPKIdMap.put(candidateKey, object);
        }
    }

    private void checkPkMappingOnDelete(TableBasedClass tableBasedClass, QuickPersistentObject quickPersistentObject) throws CacheException {
        if (tableBasedClass.getBestCandidateKey() == null) {
            return;
        }
        CandidateKey candidateKey = tableBasedClass.createBestCandidateKey();
        quickPersistentObject.setKeyValues(candidateKey);
        this.checkPkMappingOnDelete(candidateKey);
    }

    private void checkPkMappingOnDelete(CandidateKey candidateKey) throws CacheException {
        this.mPKIdMap.remove(candidateKey);
    }

    protected String createChild(CacheClass cacheClass, Object object, Object object2, QuickPersistentObject quickPersistentObject) throws CacheException {
        SQLRow sQLRow = new SQLRow(cacheClass);
        String string = (String)this.saveChildRow(sQLRow, object, 12, object2);
        if (this.mPKIdMap != null) {
            this.checkPkMappingOnCreate((TableBasedClass)cacheClass, quickPersistentObject, string);
        }
        return string;
    }

    protected void save(Oid oid, Object object) throws CacheException {
        this.invalidateLoadInterceptors(oid.getClassName());
        SQLRow sQLRow = new SQLRow(this, oid);
        if (Logger.getDebugCache()) {
            Logger.out.print("Updating object of type " + sQLRow.getClassName());
            Logger.out.println("; id: " + sQLRow.getId());
            Logger.out.println("Values: " + object.toString());
        }
        this.myAdapter().store(sQLRow.schema, sQLRow.table, sQLRow.getId(), object, this.mNoLock, (TableBasedClass)this.getCacheClass(sQLRow.getClassName()));
    }

    protected void saveChildList(String string, String string2, List list, boolean bl) throws CacheException {
        SQLRow sQLRow = new SQLRow(string);
        this.myAdapter().childTableRowRemove(sQLRow.schema, sQLRow.table, string2, this.mNoLock);
        int n = this.getKeyColumn(string);
        int n2 = 0;
        for (Object e : list) {
            this.saveValueAsChild(sQLRow, string2, 4, n, new Integer(++n2), e, bl, true);
        }
    }

    @Override
    public boolean isLightConnection() {
        return true;
    }

    protected void saveChildArray(String string, String string2, Map map, boolean bl) throws CacheException {
        SQLRow sQLRow = new SQLRow(string);
        this.myAdapter().childTableRowRemove(sQLRow.schema, sQLRow.table, string2, this.mNoLock);
        int n = this.getKeyColumn(string);
        for (Map.Entry entry : map.entrySet()) {
            this.saveValueAsChild(sQLRow, string2, 12, n, entry.getKey(), entry.getValue(), bl, false);
        }
    }

    protected int getKeyColumn(String string) throws CacheException {
        TableBasedClass tableBasedClass = (TableBasedClass)this.mClassMap.get(string);
        if (tableBasedClass == null) {
            return -1;
        }
        return tableBasedClass.getKeyColumn();
    }

    private void saveValueAsChild(SQLRow sQLRow, String string, int n, int n2, Object object, Object object2, boolean bl, boolean bl2) throws CacheException {
        try {
            if (object2 instanceof Persistent) {
                this.savePersistentAsChild(sQLRow, string, n, n2, object, (Persistent)object2, bl);
            } else if (object2 instanceof RegisteredObject) {
                this.saveSerialAsChild(sQLRow, string, n, n2, object, (RegisteredObject)object2, bl, bl2);
            } else {
                this.saveDatatypeAsChild(sQLRow, string, n, n2, object, object2);
            }
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Failed to stuff values to SysList");
        }
    }

    private void saveSerialAsChild(SQLRow sQLRow, String string, int n, int n2, Object object, RegisteredObject registeredObject, boolean bl, boolean bl2) throws CacheException, SQLException {
        ColumnBasedField columnBasedField;
        Object object2;
        Iterator iterator;
        TableBasedClass tableBasedClass = this.getCacheClass(registeredObject.getCacheClass().getName(), sQLRow.toString());
        int n3 = 2;
        int n4 = tableBasedClass.getNumberOfCachedElements() - n3;
        Vector<Object> vector = new Vector<Object>(n4);
        vector.setSize(n4);
        for (int i = 1; i < n4; ++i) {
            vector.set(i, QuickStatement.UNCHANGED_OBJECT);
        }
        try {
            if (n2 == 0) {
                vector.set(0, object);
                vector.set(1, QuickStatement.UNCHANGED_OBJECT);
            } else {
                vector.set(0, QuickStatement.UNCHANGED_OBJECT);
                vector.set(1, object);
            }
        }
        catch (Exception exception) {
            throw new SystemError(exception, "Failed to save child object of class " + tableBasedClass.getName() + " with key " + object + " row " + sQLRow.toString() + " (key type: " + n + " key column: " + n2 + " n = " + n4 + ")");
        }
        QuickCacheObject quickCacheObject = (QuickCacheObject)registeredObject.getProxy();
        if (quickCacheObject instanceof QuickEmbeddedObject) {
            iterator = ((QuickEmbeddedObject)quickCacheObject).getAllProperties();
        } else if (quickCacheObject instanceof QuickPersistentObject) {
            iterator = ((QuickPersistentObject)quickCacheObject).getAllProperties();
        } else {
            throw new CacheException("Unsupported type for serial object in child table " + sQLRow.schema + "." + sQLRow.table + ": " + quickCacheObject.getClass().getName());
        }
        while (iterator.hasNext()) {
            object2 = (Map.Entry)iterator.next();
            String string2 = (String)object2.getKey();
            columnBasedField = (ColumnBasedField)tableBasedClass.getField(string2);
            if (columnBasedField == null) continue;
            int n5 = columnBasedField.getColumnIndexForSet() - n3;
            if (bl2 && n5 < 2) continue;
            Object object3 = quickCacheObject.valueToSave(columnBasedField, object2.getValue(), bl);
            if (object3 instanceof Dataholder && ((Dataholder)object3).getObject() == null) {
                object3 = null;
            }
            if (object3 == null) continue;
            vector.set(n5, object3);
        }
        object2 = SysListProxy.createSysList(this.getConnectionInfo());
        SysListProxy.setInteger(object2, n4);
        for (int i = 0; i < n4; ++i) {
            columnBasedField = vector.get(i);
            if (columnBasedField.equals(QuickStatement.UNCHANGED_OBJECT)) {
                SysListProxy.setUndefined(object2);
                continue;
            }
            SysListProxy.setObject(object2, vector.get(i));
        }
        this.saveChildRow(sQLRow, string, n, object2);
    }

    protected TableBasedClass getCacheClass(String string, String string2) throws CacheException {
        TableBasedClass tableBasedClass = (TableBasedClass)this.mClassMap.get(string2);
        if (tableBasedClass == null) {
            throw new SystemError("Metadata for class " + string + " and child table " + string2 + " was not registered.");
        }
        return tableBasedClass;
    }

    protected boolean isClassRegistered(String string) {
        return this.mClassMap.get(string) != null;
    }

    private void savePersistentAsChild(SQLRow sQLRow, String string, int n, int n2, Object object, Persistent persistent, boolean bl) throws CacheException, SQLException {
        Id id = persistent.getId();
        if (id == null) {
            persistent.save(bl);
            id = persistent.getId();
        } else if (bl) {
            persistent.save(bl);
        }
        Object object2 = SysListProxy.createSysList(this.getConnectionInfo());
        SysListProxy.setInteger(object2, 2);
        if (n2 == 0) {
            SysListProxy.setObject(object2, object);
            SysListProxy.setString(object2, id.toString());
        } else {
            SysListProxy.setString(object2, id.toString());
            SysListProxy.setObject(object2, object);
        }
        this.saveChildRow(sQLRow, string, n, object2);
    }

    private Object saveChildRow(SQLRow sQLRow, Object object, int n, Object object2) throws CacheException {
        if (Logger.getDebugCache()) {
            Logger.out.print("Updating child object of type " + sQLRow.getClassName());
            Logger.out.println("; parent id: " + object);
            Logger.out.println("values: " + object2.toString());
        }
        Object object3 = this.myAdapter().childTableRowInsert(sQLRow.schema, sQLRow.table, n, object, object2, this.mNoLock);
        return object3;
    }

    private void saveDatatypeAsChild(SQLRow sQLRow, String string, int n, int n2, Object object, Object object2) throws CacheException, SQLException {
        Object object3 = SysListProxy.createSysList(this.getConnectionInfo());
        SysListProxy.setInteger(object3, 2);
        if (n2 == 0) {
            SysListProxy.setObject(object3, object);
            SysListProxy.setObject(object3, object2);
        } else {
            SysListProxy.setObject(object3, object2);
            SysListProxy.setObject(object3, object);
        }
        this.saveChildRow(sQLRow, string, n, object3);
    }

    protected Object wrapRefList(List list, boolean bl) throws CacheException {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (Persistent persistent : list) {
            if (persistent == null) {
                arrayList.add(null);
                continue;
            }
            if (!this.equals(persistent.getDatabase())) {
                throw new CacheException("Attempt to save persistent " + persistent + " object from another database: " + persistent.getDatabase() + " in " + this.toString());
            }
            Id id = persistent.getId();
            if (bl || id == null) {
                persistent.save();
                id = persistent.getId();
            }
            arrayList.add(id.toString());
        }
        try {
            return SysListProxy.wrapListOfReferences(arrayList, this.getConnectionInfo());
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to wrap list of references");
        }
    }

    protected Object wrapSerialList(List list) throws CacheException {
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        for (SerialObject serialObject : list) {
            arrayList.add(serialObject.serialize());
        }
        try {
            return SysListProxy.wrapListOfDatatypes(arrayList, this.getConnectionInfo());
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to wrap list of serial objects");
        }
    }

    protected Object wrapPrimList(Object object) throws CacheException {
        try {
            if (object instanceof Collection) {
                return SysListProxy.wrapCollectionOfDatatypes((Collection)object, this.getConnectionInfo());
            }
            if (object.getClass().isArray()) {
                return SysListProxy.wrapArrayOfDatatypes(object, this.getConnectionInfo());
            }
            throw new ClassCastException("Class " + object.getClass().getName() + "is neither collection nor an array");
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to wrap list of datatypes");
        }
    }

    protected Object wrapRefArray(Map map, boolean bl) throws CacheException {
        HashMap hashMap = new HashMap(map.size());
        for (Map.Entry entry : map.entrySet()) {
            Persistent persistent = (Persistent)entry.getValue();
            if (!this.equals(persistent.getDatabase())) {
                throw new CacheException("Attempt to save persistent " + persistent + " object from another database: " + persistent.getDatabase() + " in " + this.toString());
            }
            Id id = persistent.getId();
            if (bl || id == null) {
                persistent.save();
                id = persistent.getId();
            }
            hashMap.put(entry.getKey(), id.toString());
        }
        try {
            return SysListProxy.wrapMapOfReferences(hashMap, this.getConnectionInfo());
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to wrap array of references");
        }
    }

    protected Object wrapPrimArray(Map map) throws CacheException {
        try {
            return SysListProxy.wrapMapOfDatatypes(map, this.getConnectionInfo());
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to wrap list of references");
        }
    }

    protected Object wrapSerialArray(Map map) throws CacheException {
        HashMap hashMap = new HashMap(map.size());
        for (Map.Entry entry : map.entrySet()) {
            SerialObject serialObject = (SerialObject)entry.getValue();
            hashMap.put(entry.getKey(), serialObject.serialize());
        }
        try {
            return SysListProxy.wrapMapOfDatatypes(hashMap, this.getConnectionInfo());
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to wrap list of references");
        }
    }

    protected Object wrapBinaryStream(InputStream inputStream, QuickCacheObject quickCacheObject) throws CacheException {
        return this.myAdapter().wrapBinaryStream(inputStream, quickCacheObject);
    }

    protected Object wrapCharacterStream(Reader reader, QuickCacheObject quickCacheObject) throws CacheException {
        return this.myAdapter().wrapCharacterStream(reader, quickCacheObject);
    }

    protected InputStream getJDBCBinaryStream(Object object) throws SQLException {
        return this.myAdapter().getBinaryStream(object);
    }

    protected Reader getJDBCCharacterStream(Object object) throws SQLException {
        return this.myAdapter().getReader(object);
    }

    @Override
    public void deleteObject(Oid oid) throws CacheException {
        this.deleteObject(oid, -1);
    }

    @Override
    public void deleteObject(Oid oid, int n) throws CacheException {
        SQLRow sQLRow = new SQLRow(this, oid);
        this.deleteObject(sQLRow, n, oid.getClassName());
    }

    @Override
    public void deleteObject(String string, Id id) throws CacheException {
        this.deleteObject(string, id, -1);
    }

    @Override
    public void deleteObject(String string, Id id, int n) throws CacheException {
        SQLRow sQLRow = new SQLRow(this, id.toString(), string);
        this.deleteObject(sQLRow, n, string);
    }

    private synchronized void deleteObject(SQLRow sQLRow, int n, String string) throws CacheException {
        QuickPersistentObject quickPersistentObject = null;
        if (this.mCache != null) {
            quickPersistentObject = (QuickPersistentObject)this.mCache.get(sQLRow);
        }
        if (quickPersistentObject != null) {
            quickPersistentObject.objectDeleted();
            TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClass(string);
            this.checkPkMappingOnDelete(tableBasedClass, quickPersistentObject);
        }
        int n2 = n > 0 ? 0 : 1;
        this.myAdapter().remove(sQLRow.schema, sQLRow.table, sQLRow.getId(), n2);
    }

    @Override
    public CacheObject getCacheObjectUnsafe(String string, int n) throws CacheException {
        throw new SystemError("This method never should have been called  in this implementation of Database");
    }

    @Override
    public boolean ensureInMap(int n, String string) throws CacheException {
        throw new SystemError("This method never should have been called  in this implementation of Database");
    }

    @Override
    public void releaseFromMap(int n) throws CacheException {
        throw new SystemError("This method never should have been called  in this implementation of Database");
    }

    @Override
    public int getCacheType() throws CacheException {
        if (this.mCache == null) {
            return 0;
        }
        return 1;
    }

    @Override
    public Dataholder[] runClassMethod(String string, String string2, int[] nArray, Dataholder[] dataholderArray, int n) throws CacheException {
        if (string2.endsWith("Exists")) {
            return this.existsByKey(string, string2, dataholderArray);
        }
        if (string2.endsWith("Open")) {
            return this.openByKey(string, string2, dataholderArray);
        }
        if (string2.endsWith("Delete")) {
            return this.deleteByKey(string, string2, dataholderArray);
        }
        throw new CacheException("Not supported feature. Use full Database implementation.");
    }

    @Override
    public Dataholder runClassMethod(String string, String string2, Dataholder[] dataholderArray, int n) throws CacheException {
        if (string2.endsWith("Exists")) {
            return this.existsByKey(string, string2, dataholderArray)[0];
        }
        if (string2.endsWith("Open")) {
            return this.openByKey(string, string2, dataholderArray)[0];
        }
        if (string2.endsWith("Delete")) {
            return this.deleteByKey(string, string2, dataholderArray)[0];
        }
        throw new CacheException("Not supported feature. Use full Database implementation.");
    }

    @Override
    public void closeObject(int n) throws CacheException {
    }

    @Override
    public void releaseObject(Object object) throws CacheException {
        SQLRow sQLRow = this.rowByZRef(object);
        if (sQLRow == null) {
            return;
        }
        QuickPersistentObject quickPersistentObject = (QuickPersistentObject)this.mCache.get(sQLRow);
        if (quickPersistentObject != null && !quickPersistentObject.isClosed()) {
            quickPersistentObject.invalidate(null, true, true);
        }
    }

    @Override
    public void closeObject(Object object) throws CacheException {
        SQLRow sQLRow = this.rowByZRef(object);
        if (sQLRow == null) {
            return;
        }
        Object v = this.mCache.remove(sQLRow);
        if (v != null && v instanceof QuickPersistentObject) {
            ((QuickPersistentObject)v).cleanup();
        }
    }

    protected void closeObject(Object object, QuickCacheObject quickCacheObject) throws CacheException {
        SQLRow sQLRow;
        if (this.mDetachedbjectsManager != null) {
            boolean bl;
            int n = quickCacheObject.getState();
            boolean bl2 = bl = (n & 0xF) == 0;
            if (bl) {
                this.mDetachedbjectsManager.saveCleanState(quickCacheObject.getOid());
            }
        }
        if ((sQLRow = this.rowByZRef(object)) == null) {
            return;
        }
        Object v = this.mCache.get(sQLRow);
        if (v == null) {
            return;
        }
        quickCacheObject.cleanup();
        if (quickCacheObject != v) {
            throw new IllegalStateException("Object was replaced");
        }
        this.mCache.remove(sQLRow);
    }

    public Object isInCache(Object object) throws CacheException {
        SQLRow sQLRow = this.rowByZRef(object);
        if (sQLRow == null) {
            return object;
        }
        return this.mCache.get(sQLRow);
    }

    @Override
    public synchronized void setCacheObjectReadDirty(Oid oid) throws CacheException {
        if (this.mCache == null) {
            return;
        }
        SQLRow sQLRow = new SQLRow(this, oid);
        CacheObject cacheObject = (CacheObject)this.mCache.get(sQLRow);
        if (cacheObject == null) {
            return;
        }
        cacheObject.setStateReadDirty();
    }

    private SQLRow rowByZRef(Object object) throws CacheException {
        SQLRow sQLRow;
        if (this.mCache == null) {
            return null;
        }
        if (object instanceof Oid) {
            sQLRow = new SQLRow(this, (Oid)object);
        } else if (object instanceof QuickCacheObject.ZRef) {
            QuickCacheObject.ZRef zRef = (QuickCacheObject.ZRef)object;
            String string = zRef.getIdString();
            if (string == null) {
                return null;
            }
            sQLRow = new SQLRow(this, string, zRef.getClassName());
        } else {
            throw new CacheException("Unknown type of Internal Object reference: " + object.getClass().getName());
        }
        return sQLRow;
    }

    @Override
    public CacheInputStream getInputStream(int n) throws CacheException {
        throw new CacheException("Not yet implemented feature.");
    }

    @Override
    public CacheReader getReader(int n) throws CacheException {
        throw new CacheException("Not yet implemented feature.");
    }

    @Override
    public CacheOutputStream getOutputStream(int n) throws CacheException {
        throw new CacheException("Not yet implemented feature.");
    }

    @Override
    public CacheWriter getWriter(int n) throws CacheException {
        throw new CacheException("Not yet implemented feature.");
    }

    @Override
    public CacheInputStream getInputStream(CacheObject cacheObject) throws CacheException {
        QuickStreamObject quickStreamObject = (QuickStreamObject)cacheObject;
        return quickStreamObject.getIn();
    }

    @Override
    public CacheReader getReader(CacheObject cacheObject) throws CacheException {
        QuickReaderObject quickReaderObject = (QuickReaderObject)cacheObject;
        return quickReaderObject.getIn();
    }

    @Override
    public CacheOutputStream getOutputStream(CacheObject cacheObject) throws CacheException {
        QuickStreamObject quickStreamObject = (QuickStreamObject)cacheObject;
        return quickStreamObject.getOut();
    }

    @Override
    public CacheWriter getWriter(CacheObject cacheObject) throws CacheException {
        QuickReaderObject quickReaderObject = (QuickReaderObject)cacheObject;
        return quickReaderObject.getOut();
    }

    @Override
    public ResultSet getCacheResultSet(String string) throws CacheException {
        if (this.myAdapter() instanceof JDBCAdapter) {
            return ((JDBCAdapter)((Object)this.myAdapter())).getCacheResultSet(string);
        }
        throw new CacheException("Getting ResultSet by oref is not supported in this mode.");
    }

    @Override
    public boolean existsObject(Oid oid) throws CacheException {
        SQLRow sQLRow = new SQLRow(this, oid);
        return this.existsObject(sQLRow);
    }

    @Override
    public boolean existsObject(String string, Id id) throws CacheException {
        SQLRow sQLRow = SQLRow.createNoModify(this, id.toString(), string);
        return this.existsObject(sQLRow);
    }

    private boolean existsObject(SQLRow sQLRow) throws CacheException {
        try {
            String string = sQLRow.schema + '.' + sQLRow.table;
            int n = this.myAdapter().countElements(string, "ID='" + sQLRow.getId() + "'");
            if (n == 1) {
                return true;
            }
            if (n == 0) {
                return false;
            }
            throw new SystemError("Unknown error checking object existence");
        }
        catch (CacheServerException cacheServerException) {
            throw new CacheException(cacheServerException, "Failed to check for object existence: table: " + sQLRow.schema + '.' + sQLRow.table + "; id: " + sQLRow.getId());
        }
    }

    @Override
    public Statement createStatement() throws CacheException {
        try {
            return this.myConnection().createStatement();
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to create SQL statement.");
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws CacheException {
        try {
            return this.myConnection().prepareStatement(string);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to prepare SQL statement: " + string);
        }
    }

    @Override
    public CallableStatement prepareCall(String string) throws CacheException {
        return RDBMSAdapter.prepareCall(this.myConnection(), string);
    }

    @Override
    public boolean isLowLevelConnectionClosed() throws CacheException {
        try {
            return this.mAdapter == null || this.mAdapter.getConnection() == null || this.mAdapter.getConnection().isClosed();
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to check whether connection is closed.");
        }
    }

    @Override
    public boolean isOpen() {
        try {
            return this.isConnectionOpen && !this.isLowLevelConnectionClosed();
        }
        catch (CacheException cacheException) {
            return false;
        }
    }

    @Override
    public Object getListBuffer(int n, int n2, int n3) throws CacheException {
        throw new CacheException("Not yet implemented feature.");
    }

    @Override
    public Object getArrayBuffer(int n, String string, int n2, int n3) throws CacheException {
        throw new CacheException("Not yet implemented feature.");
    }

    @Override
    public Object getObjectListBuffer(int n, int n2, int n3) throws CacheException {
        throw new CacheException("Not yet implemented feature.");
    }

    @Override
    public Object getObjectArrayBuffer(int n, String string, int n2, int n3) throws CacheException {
        throw new CacheException("Not yet implemented feature.");
    }

    @Override
    public void registerSensitiveObject(CacheServerSensitive cacheServerSensitive) {
        throw new UnsupportedOperationException("Not supported feature. Use full Database implementation.");
    }

    @Override
    public void registerSensitiveObject(CacheServerSensitive cacheServerSensitive, Set set) throws CacheException {
        throw new CacheException("Not supported feature. Use full Database implementation.");
    }

    @Override
    public void registerSensitiveObject(CacheServerSensitive cacheServerSensitive, ObjectHandle objectHandle) throws CacheException {
        throw new CacheException("Not supported feature. Use full Database implementation.");
    }

    @Override
    public void registerSensitiveObject(CacheServerSensitive cacheServerSensitive, int n) throws CacheException {
        throw new CacheException("Not supported feature. Use full Database implementation.");
    }

    @Override
    public boolean unRegisterSensitiveObject(CacheServerSensitive cacheServerSensitive) throws CacheException {
        throw new CacheException("Not supported feature. Use full Database implementation.");
    }

    @Override
    public void processObjectBuffer(Object object, Object object2, CacheServerSensitive cacheServerSensitive) throws CacheException {
        throw new CacheException("Not supported feature. Use full Database implementation.");
    }

    @Override
    public void decreaseServerReferenceCount(int n, int n2) throws CacheException {
        throw new CacheException("Not supported feature. Use full Database implementation.");
    }

    @Override
    public void onConnectionClosed() {
        if (Logger.debugOn()) {
            Logger.out.println(this.mProcess + ": " + this.toString() + ": Connection closed event received.");
        }
        try {
            this.mRefCount = 0;
            this.close();
        }
        catch (Exception exception) {
            ConnectionUtils.processErrorOnConnectionClose(exception, this, this.mProcess);
        }
    }

    public Map getCache() {
        return new TreeMap(this.mCache);
    }

    @Override
    public void setConnectionOwner(boolean bl) {
        this.amIConnectionOwner = bl;
    }

    @Override
    public Map close() throws CacheException {
        --this.mRefCount;
        if (!ConnectionUtils.processCloseDatabase(this, this.mRefCount, this.mProcess)) {
            return new TreeMap(this.mCache);
        }
        if (!this.isConnectionOpen) {
            throw new CacheException("Attempt to close already closed Database " + this.toString());
        }
        if (this.mDetachedbjectsManager != null) {
            this.mDetachedbjectsManager.close();
        }
        this.closeAllObjects(false);
        this.onClose();
        if (!this.amIConnectionOwner) {
            try {
                this.myConnection().setAutoCommit(true);
            }
            catch (SQLException sQLException) {
                throw new CacheException(sQLException, "Could not reset autocommit");
            }
        }
        this.isConnectionOpen = false;
        this.mAdapter.close(this.amIConnectionOwner);
        databases.remove(this.mAdapter.getConnection());
        return this.mCache;
    }

    protected abstract void onClose();

    @Override
    public synchronized void closeAllObjects(boolean bl) {
        if (this.mDetachedbjectsManager != null) {
            this.mDetachedbjectsManager.clear();
        }
        if (this.mCache == null) {
            return;
        }
        Map map = this.mCache;
        this.mCache = null;
        Map map2 = this.mPKIdMap;
        this.mPKIdMap = null;
        for (Object v : map.values()) {
            if (v == null || !(v instanceof QuickPersistentObject)) continue;
            ((QuickPersistentObject)v).cleanup();
        }
        map.clear();
        this.mCache = map;
        this.mPKIdMap = map2;
        if (this.mPKIdMap != null) {
            this.mPKIdMap.clear();
        }
        if (this.mLoadInterceptors != null) {
            this.mLoadInterceptors.clear();
            this.mLoadInterceptors = null;
        }
    }

    @Override
    public void closeAllObjects() throws CacheException {
        this.closeAllObjects(false);
    }

    @Override
    public void flush() {
    }

    @Override
    public void setProfileOn(int n) {
        this.myAdapter().setProfileOn(n);
    }

    @Override
    public void resetProfile(int n) throws CacheException {
        this.myAdapter().resetProfile(n);
    }

    @Override
    public void setProfileOff(int n) {
        this.myAdapter().setProfileOff(n);
    }

    @Override
    public int getNumberOfOpenObjects() {
        if (this.mCache != null) {
            return this.mCache.size();
        }
        return 0;
    }

    @Override
    public long getServerTime() {
        return this.myAdapter().getServerTime();
    }

    @Override
    public int getNumberOfServerCalls() {
        return this.myAdapter().getNumberServerCalls();
    }

    @Override
    public long getServerTime(int n) {
        return this.myAdapter().getServerTime(n);
    }

    @Override
    public int getNumberOfServerCalls(int n) {
        return this.myAdapter().getNumberServerCalls(n);
    }

    @Override
    public Map getSentMessages(int n) {
        throw new UnsupportedOperationException("Method getSentMessages() is not implemented in class com.intersys.cache.quick.LightDatabase");
    }

    @Override
    public void printStatistics(PrintStream printStream) {
        System.out.println("Not yet implemented feature.");
    }

    @Override
    public void printStatistics() {
        this.printStatistics(System.out);
    }

    @Override
    public ObjectServerInfo getServerInfo() {
        try {
            return (ObjectServerInfo)this.mInfo.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public int parseStatus(StatusCode statusCode) throws CacheException {
        if (!statusCode.isError()) {
            return statusCode.getCode();
        }
        return 0;
    }

    @Override
    public int parseStatus(Dataholder dataholder) throws CacheException {
        StatusCode statusCode = dataholder.getStatusCode();
        if (statusCode.isError()) {
            throw new CacheException("Code: " + statusCode.getCode() + "; Text: " + statusCode.getText(), statusCode.getCode());
        }
        return statusCode.getCode();
    }

    @Override
    public DatabaseUtilities utilities() {
        return new DatabaseUtilities(this);
    }

    @Override
    public void transactionStart() throws CacheException {
        try {
            this.myConnection().setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Failed to set autocommit to false.");
        }
    }

    @Override
    public void transactionCommit() throws CacheException {
        try {
            this.myConnection().commit();
            this.myConnection().setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to commit transaction.");
        }
    }

    @Override
    public void transactionRollback() throws CacheException {
        try {
            this.myConnection().rollback();
            this.myConnection().setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to commit transaction.");
        }
    }

    public void transactionCommitAndRestart() throws CacheException {
        try {
            this.myConnection().commit();
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to commit transaction.");
        }
    }

    public void transactionRollbackAndRestart() throws CacheException {
        try {
            this.myConnection().rollback();
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to commit transaction.");
        }
    }

    @Override
    public synchronized CacheClass getCacheClass(String string) throws CacheException {
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClassIfLoaded(string);
        if (tableBasedClass == null) {
            tableBasedClass = this.createQuickCacheClass(string, true);
        }
        return tableBasedClass;
    }

    public synchronized CacheClass getCacheClassByTableName(String string) throws CacheException {
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClassIfLoadedByTable(string);
        if (tableBasedClass == null) {
            tableBasedClass = this.createQuickCacheClassByTable(string, true);
        }
        return tableBasedClass;
    }

    protected abstract TableBasedClass createQuickCacheClass(String var1, boolean var2) throws CacheException;

    @Override
    public CacheClass getCacheClassIfLoaded(String string) throws CacheException {
        CacheClass cacheClass = (CacheClass)this.mClassMap.get(string);
        return cacheClass;
    }

    public CacheClass getCacheClassIfLoadedByTable(String string) throws CacheException {
        CacheClass cacheClass = (CacheClass)this.mTableToClassMap.get(string);
        return cacheClass;
    }

    @Override
    public void addClass(CacheClass cacheClass, String string) throws CacheException {
        if (string != null) {
            this.mReverseClassMap.put(string, cacheClass.getName());
        }
    }

    public void registerClass(CacheClass cacheClass) {
        this.mClassMap.put(cacheClass.getName(), cacheClass);
    }

    @Override
    public void registerClass(String string, CacheClass cacheClass) {
        this.mClassMap.put(string, cacheClass);
    }

    @Override
    public void removeClass(CacheClass cacheClass) {
        this.mClassMap.remove(cacheClass.getName());
    }

    @Override
    public void removeClass(String string) {
        this.mClassMap.remove(string);
    }

    @Override
    public String getCacheClassName(String string) throws CacheException {
        return (String)this.mReverseClassMap.get(string);
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.mClassLoader != null) {
            return this.mClassLoader;
        }
        return this.getClass().getClassLoader();
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.mClassLoader = classLoader;
    }

    @Override
    public String getProcessNumber() {
        return this.mProcess;
    }

    protected final Object createSysList() {
        Object object = SysListProxy.createSysList(this.getConnectionInfo());
        return object;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof LightDatabase)) {
            return false;
        }
        LightDatabase lightDatabase = (LightDatabase)object;
        return this.myAdapter().equals(lightDatabase.myAdapter());
    }

    @Override
    public String getConnectionString() {
        return this.mURL;
    }

    @Override
    public void setConsoleOutput(PrintStream printStream) {
    }

    @Override
    public boolean addListener(EventListener eventListener) {
        return false;
    }

    @Override
    public boolean removeListener(EventListener eventListener) {
        return false;
    }

    @Override
    public SysDatabase getLightDatabase() throws CacheException {
        return this;
    }

    protected final Connection myConnection() {
        return this.myAdapter().getConnection();
    }

    protected final DBAdapter myAdapter() {
        if (this.isConnectionOpen) {
            return this.mAdapter;
        }
        throw new RuntimeException("Database connection is not open.");
    }

    public void runDummySP() throws CacheServerException, SystemError {
        ((JDBCAdapter)((Object)this.myAdapter())).runReflectionVersionSP();
    }

    public void removeClassFromMap(String string) {
        this.mClassMap.remove(string);
    }

    protected synchronized void addLoadInterceptor(LoadInterceptor loadInterceptor) {
        if (this.mLoadInterceptors == null) {
            this.mLoadInterceptors = new HashSet();
        }
        this.mLoadInterceptors.add(loadInterceptor);
    }

    protected synchronized void invalidateLoadInterceptors(String string) {
        if (this.mLoadInterceptors == null) {
            return;
        }
        Iterator iterator = this.mLoadInterceptors.iterator();
        while (iterator.hasNext()) {
            LoadInterceptor loadInterceptor = (LoadInterceptor)iterator.next();
            if (!loadInterceptor.isForClass(string)) continue;
            iterator.remove();
        }
        if (this.mLoadInterceptors.isEmpty()) {
            this.mLoadInterceptors = null;
        }
    }

    public int getMaxBatchSize() {
        return this.mMaxBatchSize;
    }

    public void setMaxBatchSize(int n) {
        this.mMaxBatchSize = n;
    }

    protected abstract TableBasedClass createQuickCacheClass(ColumnBasedField var1) throws CacheException;

    protected abstract boolean commaSeparatedCollectionsInRS();

    public abstract TableBasedClass createQuickCacheClassByTable(String var1, boolean var2) throws CacheException;

    protected boolean allowLazyCollections() throws CacheException {
        if (this.mLazyCollections == null) {
            String string = System.getProperty("com.intersys.fetch_policy");
            if (string == null) {
                string = System.getProperty("com.jalapeno.fetch_policy");
            }
            if (string == null || "DEFAULT".equalsIgnoreCase(string)) {
                this.mLazyCollections = Boolean.TRUE;
            } else if ("EAGER".equalsIgnoreCase(string)) {
                this.mLazyCollections = Boolean.FALSE;
            } else if ("LAZY".equalsIgnoreCase(string)) {
                this.mLazyCollections = Boolean.TRUE;
            } else {
                throw new CacheException("Unknown Fetch Policy: " + string);
            }
        }
        return this.mLazyCollections;
    }

    public static boolean closeStatement(Iterator iterator) throws SQLException {
        if (iterator instanceof ResultSetIterator) {
            ((ResultSetIterator)iterator).closeStatement();
        } else if (iterator instanceof POJOIterator) {
            ((POJOIterator)iterator).closeStatement();
        } else {
            return false;
        }
        return true;
    }

    private synchronized Object getObjectForIterator(SQLRow sQLRow, Object object, TableBasedClass tableBasedClass) throws CacheException {
        QuickPersistentObject quickPersistentObject = null;
        if (this.mCache != null) {
            quickPersistentObject = (QuickPersistentObject)this.mCache.get(sQLRow);
        }
        if (quickPersistentObject == null) {
            int n = 7506;
            quickPersistentObject = this.createCacheObject(object, tableBasedClass, sQLRow, tableBasedClass.getName(), sQLRow.getId(), 1, n);
        } else if (Logger.getDebugCache()) {
            Logger.out.println("Skipping object " + sQLRow.id);
        }
        return quickPersistentObject.newJavaInstance(true);
    }

    protected class LoadInterceptor {
        private Map mIds;
        private Object mValues;
        private TableBasedClass mClass;
        private int mNumColumns;
        private int mNumObjects;
        private Object mIdList;

        public LoadInterceptor(TableBasedClass tableBasedClass, int n, Object object) throws CacheException {
            this.mClass = tableBasedClass;
            this.mNumColumns = this.mClass.getNumberOfColumnsForGet();
            this.mNumObjects = n;
            this.mIdList = SysListProxy.createSysList(SysListProxy.getBinaryData(object), true, SysListProxy.getConnectionInfo(object));
        }

        public boolean isForClass(String string) {
            return this.mClass.getName().equals(string);
        }

        private void init() throws CacheServerException {
            SQLRow sQLRow = new SQLRow(this.mClass);
            Object object = SysListProxy.createSysList();
            try {
                SysListProxy.setInteger(object, this.mNumObjects);
                SysListProxy.concatenate(object, this.mIdList);
                SysListProxy.rewind(this.mIdList);
                this.mIds = new HashMap();
                int n = 0;
                while (!SysListProxy.atEnd(this.mIdList)) {
                    String string = SysListProxy.getString(this.mIdList);
                    this.mIds.put(string, new Integer(n));
                    ++n;
                }
            }
            catch (SQLException sQLException) {
                throw new CacheServerException(sQLException);
            }
            this.mValues = LightDatabase.this.myAdapter().bulkLoad(sQLRow.schema, sQLRow.table, object, 1);
            if (this.mValues == null) {
                throw new CacheServerException("Failed to load instances of class " + sQLRow.getClassName());
            }
        }

        public Object process(TableBasedClass tableBasedClass, String string) throws CacheServerException {
            Integer n;
            if (!this.mClass.equals(tableBasedClass)) {
                return null;
            }
            if (this.mValues == null) {
                this.init();
            }
            if ((n = (Integer)this.mIds.get(string)) == null) {
                return null;
            }
            int n2 = n * this.mNumColumns;
            try {
                Object object = SysListProxy.getSubList(this.mValues, this.mNumColumns, n2);
                return object;
            }
            catch (SQLException sQLException) {
                throw new CacheServerException(sQLException);
            }
        }
    }

    protected abstract class ResultSetIterator
    implements Iterator {
        private int mIdcol;
        private TableBasedClass mClass;
        protected ResultSet mRS;
        private Object mCur;
        boolean atEnd = false;

        public ResultSetIterator(ResultSet resultSet, TableBasedClass tableBasedClass, int n) {
            this.mRS = resultSet;
            this.mClass = tableBasedClass;
            this.mIdcol = n;
            this.mCur = null;
        }

        @Override
        public boolean hasNext() {
            if (this.mCur != null) {
                return true;
            }
            try {
                return this.nextObject();
            }
            catch (Exception exception) {
                if (Logger.debugOn()) {
                    if (exception instanceof CacheException) {
                        ((CacheException)exception).printFullTrace(Logger.out);
                    } else {
                        exception.printStackTrace(Logger.out);
                    }
                }
                throw new RuntimeException("Fatal Error: " + exception.getMessage());
            }
        }

        public Object next() {
            if (this.mCur == null) {
                try {
                    if (!this.nextObject()) {
                        throw new NoSuchElementException();
                    }
                }
                catch (SQLException sQLException) {
                    if (Logger.debugOn()) {
                        sQLException.printStackTrace(Logger.out);
                    }
                    throw new RuntimeException("Fatal Error: " + sQLException.getMessage());
                }
                catch (CacheException cacheException) {
                    if (Logger.debugOn()) {
                        cacheException.printFullTrace(Logger.out);
                    }
                    throw new RuntimeException("Fatal Error: " + cacheException.getMessage());
                }
            }
            Object object = this.mCur;
            this.mCur = null;
            return object;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private synchronized boolean nextObject() throws SQLException, CacheException {
            if (this.atEnd) {
                return false;
            }
            if (!this.mRS.next()) {
                this.atEnd = true;
                this.closeStatement();
                return false;
            }
            Object object = this.getWire();
            String string = SysListProxy.getString(object, this.mIdcol);
            SQLRow sQLRow = new SQLRow(string, this.mClass);
            this.mCur = LightDatabase.this.getObjectForIterator(sQLRow, object, this.mClass);
            return true;
        }

        protected abstract Object getWire() throws SQLException;

        public void closeStatement() throws SQLException {
            if (this.mRS != null) {
                Statement statement = this.mRS.getStatement();
                this.mRS.close();
                this.mRS = null;
                if (statement != null) {
                    statement.close();
                }
            }
        }

        protected void finalize() throws Throwable {
            this.closeStatement();
            super.finalize();
        }
    }

    private static class SQLRow
    implements Comparable {
        public String schema;
        public String table;
        private String mClassName;
        private String id;
        private int iId = 0;
        private Integer hash = null;

        public SQLRow(LightDatabase lightDatabase, Oid oid) throws CacheException {
            this(lightDatabase.getCacheClass(oid.getClassName()));
            this.setupId(oid.getId().toString());
        }

        public SQLRow(byte[] byArray, CacheClass cacheClass, LightDatabase lightDatabase) throws CacheException {
            try {
                Object object = SysListProxy.createSysList(byArray, false, lightDatabase.getConnectionInfo());
                this.setupId(SysListProxy.getString(object, 0));
                String string = SysListProxy.getString(object, 1);
                if (!(string == null || cacheClass != null && string.equals(cacheClass.getName()))) {
                    cacheClass = lightDatabase.getCacheClass(string);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.mClassName = cacheClass.getName();
            this.setupTable(cacheClass);
        }

        public SQLRow(String string) {
            this.setupTable(string);
        }

        public SQLRow(CacheClass cacheClass) {
            this.mClassName = cacheClass.getName();
            this.setupTable(cacheClass);
        }

        public SQLRow(LightDatabase lightDatabase, String string, String string2) throws CacheException {
            CacheClass cacheClass = lightDatabase.getCacheClass(string2);
            if (cacheClass == null) {
                throw new InvalidClassException("Cache class " + string2 + " does not exist");
            }
            this.setupTable(cacheClass);
            this.setupId(string);
        }

        private static SQLRow createNoModify(LightDatabase lightDatabase, String string, String string2) throws CacheException {
            CacheClass cacheClass = lightDatabase.getCacheClass(string2);
            if (cacheClass == null) {
                throw new InvalidClassException("Cache class " + string2 + " does not exist");
            }
            String string3 = cacheClass.getFullSQLTableName();
            SQLRow sQLRow = new SQLRow(string3);
            sQLRow.setupId(string);
            return sQLRow;
        }

        public SQLRow(String string, CacheClass cacheClass) {
            this.setupTable(cacheClass);
            this.setupId(string);
        }

        public String getId() {
            return this.id;
        }

        public String getClassName() {
            if (this.mClassName == null) {
                this.mClassName = this.schema.replace('_', '.') + "." + this.table;
            }
            return this.mClassName;
        }

        private final void setupId(String string) {
            this.id = string;
            try {
                this.iId = Integer.parseInt(this.id);
            }
            catch (Exception exception) {
                this.iId = -1;
            }
        }

        private final void setupTable(String string) {
            int n = string.lastIndexOf(46);
            if (n < 0) {
                this.table = string;
                this.schema = "";
            } else {
                this.table = string.substring(n + 1);
                this.schema = string.substring(0, n);
            }
        }

        private final void setupTable(CacheClass cacheClass) {
            int n;
            this.table = cacheClass.getSQLTableName();
            if (this.table != null && this.table.charAt(0) == '\"' && this.table.charAt((n = this.table.length()) - 1) == '\"') {
                this.table = this.table.substring(1, n - 1);
            }
            this.schema = cacheClass.getSchemaName();
        }

        public String toString() {
            String string = this.schema + "." + this.table;
            if (this.id != null) {
                string = string + "[" + this.id.toString() + "]";
            }
            return string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof SQLRow)) {
                return false;
            }
            SQLRow sQLRow = (SQLRow)object;
            if (this.id == null && sQLRow.id != null) {
                return false;
            }
            if (this.iId >= 0 && this.iId != sQLRow.iId) {
                return false;
            }
            if (this.id != null && !this.id.equals(sQLRow.id)) {
                return false;
            }
            if (this.table == null && sQLRow.table != null) {
                return false;
            }
            if (this.table != null && !this.table.equals(sQLRow.table)) {
                return false;
            }
            if (this.schema == null && sQLRow.schema != null) {
                return false;
            }
            return this.schema == null || this.schema.equals(sQLRow.schema);
        }

        public int hashCode() {
            if (this.hash == null) {
                String string = (this.table == null ? this.table : "") + (this.schema == null ? this.schema : "");
                int n = string.hashCode();
                if (this.iId > 0) {
                    n += this.iId;
                } else if (this.id != null) {
                    n += this.id.hashCode();
                }
                this.hash = new Integer(n);
            }
            return this.hash;
        }

        public int compareTo(Object object) {
            if (object instanceof SQLRow) {
                SQLRow sQLRow = (SQLRow)object;
                int n = this.getClassName().compareTo(sQLRow.getClassName());
                if (n != 0) {
                    return n;
                }
                if (this.id == null) {
                    if (sQLRow.id == null) {
                        return 0;
                    }
                    return 1;
                }
                return this.id.compareTo(sQLRow.id);
            }
            return this.toString().compareTo(object.toString());
        }
    }
}

