/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.Dataholder;
import com.intersys.cache.quick.ColumnBasedField;
import com.intersys.cache.quick.QuickPersistentObject;
import com.intersys.cache.quick.TableBasedClass;
import com.intersys.objects.CacheException;

public class ArrayBackedStorage
implements QuickPersistentObject.LocalStorage {
    private Object[] mCachedValues;
    private QuickPersistentObject mParent;

    public ArrayBackedStorage(QuickPersistentObject quickPersistentObject) {
        this.mParent = quickPersistentObject;
    }

    @Override
    public Dataholder getCachedId() throws CacheException {
        Object object = this.getInternalCachedValue(this.mParent.mClass.getIdField());
        return (Dataholder)object;
    }

    @Override
    public void setCachedId(Dataholder dataholder) throws CacheException {
        this.setInternalCachedValue(this.mParent.mClass.getIdField(), dataholder);
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    @Override
    public boolean cachedValuesNotNull() {
        return this.mCachedValues != null;
    }

    @Override
    public Object getInternalCachedValue(ColumnBasedField columnBasedField) throws CacheException {
        int n = columnBasedField.getColumnIndexForSet();
        return this.mCachedValues[n];
    }

    @Override
    public void setInternalCachedValue(ColumnBasedField columnBasedField, Object object) throws CacheException {
        int n = columnBasedField.getColumnIndexForSet();
        this.mCachedValues[n] = object;
    }

    @Override
    public void initCachedValues() {
        int n = this.mParent.mClass.getNumberOfCachedElements();
        this.mCachedValues = new Object[n];
    }

    @Override
    public void cleanupCachedValues() {
        this.mCachedValues = null;
    }

    @Override
    public QuickPersistentObject instantiate(TableBasedClass tableBasedClass, Object object, int n) throws CacheException {
        return QuickPersistentObject.createArrayBackedObject(tableBasedClass, object, n);
    }
}

