/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.jbind;

import com.intersys.cache.Dataholder;
import com.intersys.cache.jbind.CacheIface;
import com.intersys.cache.jbind.TmpObjPropertyKey;
import com.intersys.cache.jbind.ZObjectValueKey;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.Logger;
import com.intersys.objects.SystemError;
import java.sql.SQLException;
import java.util.Map;
import java.util.TreeMap;

class UnsetProperties {
    private Map mPrimProperties = new TreeMap();
    private Map mObjProperties = new TreeMap();
    private Map mTmpObjProperties = new TreeMap();

    public synchronized void setProperty(int n, int n2, boolean bl, String string, Dataholder dataholder) throws CacheException {
        if (bl) {
            this.mObjProperties.put(new ZObjectValueKey(n, n2), dataholder);
            this.mTmpObjProperties.put(new TmpObjPropertyKey(n, string), dataholder);
        } else {
            this.mPrimProperties.put(new ZObjectValueKey(n, n2), dataholder);
        }
    }

    public synchronized boolean find(int n, int n2, boolean bl) {
        if (bl) {
            return this.mObjProperties.containsKey(new ZObjectValueKey(n, n2));
        }
        return this.mPrimProperties.containsKey(new ZObjectValueKey(n, n2));
    }

    public synchronized boolean has(int n, int n2) {
        boolean bl = this.mObjProperties.containsKey(new ZObjectValueKey(n, n2));
        if (bl) {
            bl = this.mPrimProperties.containsKey(new ZObjectValueKey(n, n2));
        }
        return bl;
    }

    public synchronized Dataholder getProperty(int n, int n2, boolean bl) throws CacheException {
        Map map = bl ? this.mObjProperties : this.mPrimProperties;
        Dataholder dataholder = (Dataholder)map.get(new ZObjectValueKey(n, n2));
        if (dataholder == null) {
            throw new CacheException("Property not found: oref=" + n + ", %i=" + n2);
        }
        return dataholder;
    }

    public synchronized void makeSetZList(Object object, CacheIface cacheIface) throws CacheException {
        try {
            Dataholder dataholder;
            Comparable comparable;
            SysListProxy.setInteger(object, this.mPrimProperties.size());
            for (Map.Entry entry : this.mPrimProperties.entrySet()) {
                comparable = (ZObjectValueKey)entry.getKey();
                ((ZObjectValueKey)comparable).appendToSysList(object);
                dataholder = (Dataholder)entry.getValue();
                SysListProxy.setInteger(object, ((ZObjectValueKey)comparable).getII());
                dataholder.stuff(object);
                if (!Logger.getDebugCache()) continue;
                Logger.out.println("Setting prim: " + comparable + " <- " + dataholder);
            }
            SysListProxy.setInteger(object, this.mObjProperties.size());
            for (Map.Entry entry : this.mTmpObjProperties.entrySet()) {
                comparable = (TmpObjPropertyKey)entry.getKey();
                ((TmpObjPropertyKey)comparable).appendToSysList(object);
                dataholder = (Dataholder)entry.getValue();
                dataholder.stuff(object);
                if (!Logger.getDebugCache()) continue;
                Logger.out.println("Setting obj: " + ((TmpObjPropertyKey)comparable).toString(dataholder));
            }
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Failed to get property from local cache");
        }
        this.clear();
    }

    protected synchronized void clear() {
        this.mPrimProperties.clear();
        this.mObjProperties.clear();
        this.mTmpObjProperties.clear();
    }
}

