/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.jbind;

import com.intersys.cache.jbind.StatisticObject;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.TreeMap;

class Statistics {
    private TreeMap m_map = new TreeMap();
    private int m_intPreCalls = 0;
    private int m_intPostCalls = 0;

    public void insertObject(int n, String string) {
        this.m_map.put(new Integer(n), new StatisticObject(string));
    }

    public void deleteObject(int n) {
        this.m_map.remove(new Integer(n));
    }

    public StatisticObject getObject(int n) {
        return (StatisticObject)this.m_map.get(new Integer(n));
    }

    public void incrementPreCalls() {
        ++this.m_intPreCalls;
    }

    public void incrementPostCalls() {
        ++this.m_intPostCalls;
    }

    public void clear() {
        this.m_intPreCalls = 0;
        this.m_intPostCalls = 0;
        Iterator iterator = this.m_map.values().iterator();
        while (iterator.hasNext()) {
            ((StatisticObject)iterator.next()).clear();
        }
    }

    public void print(PrintStream printStream) {
        printStream.println("Statistics of cache usage:");
        printStream.println();
        printStream.println("number of extra calls before invoking a method: " + this.m_intPreCalls);
        printStream.println("number of extra calls after invoking a method: " + this.m_intPostCalls);
        printStream.println();
        printStream.println("Statistics specific to a particular object:");
        printStream.println();
        for (Integer n : this.m_map.keySet()) {
            StatisticObject statisticObject = (StatisticObject)this.m_map.get(n);
            printStream.println("object reference: " + n);
            printStream.println("type: " + statisticObject.getType());
            printStream.println("number of Java calls: " + statisticObject.getJavaCalls());
            printStream.println("number of Cache calls: " + statisticObject.getCacheCalls());
            printStream.println();
        }
    }

    public void print() {
        this.print(System.out);
    }
}

