/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.jbind;

import com.intersys.cache.AbstractCacheObject;
import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.jbind.JBindDatabase;
import com.intersys.cache.jbind.ZObjectValueRep;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.intersys.objects.Logger;
import com.intersys.objects.Oid;
import com.intersys.objects.ReferenceCountingException;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;

public final class JBindCacheObject
extends AbstractCacheObject {
    private ZObjectValueRep mZobjVal = null;

    private JBindCacheObject(Database database, String string, int n) throws CacheException {
        super(database, string, n);
        ((JBindDatabase)database).addObjectToMap(this.getOref(), this);
        ((JBindDatabase)database).insertStatisticObject(this.getOref(), string);
    }

    static JBindCacheObject create(Database database, String string, int n) throws CacheException {
        return new JBindCacheObject(database, string, n);
    }

    @Override
    public final Object getZRef() throws CacheException {
        int n = this.getOref();
        String string = this.getCacheClass().getName();
        return String.valueOf(n) + "@" + string;
    }

    @Override
    public void delete() throws CacheException {
        this.mDB.deleteObject(this.getOid());
    }

    @Override
    public Dataholder getProperty(int n, int n2, int n3, String string) throws CacheException {
        return this.getProperty(string, n3 == 1);
    }

    @Override
    public Dataholder getProperty(String string, boolean bl) throws CacheException {
        CacheClass cacheClass = this.getCacheClass();
        CacheField cacheField = cacheClass.getField(string);
        if (cacheField == null) {
            return null;
        }
        int n = cacheField.getII();
        return this.getProperty(string, n, bl, cacheField);
    }

    protected final Dataholder getPropertyFromZobjVal(int n, boolean bl) throws CacheException {
        Dataholder dataholder = null;
        if (this.isZobjvalCached() && this.isValidNode(n)) {
            dataholder = bl && !this.isSwizzled(n) ? null : this.mZobjVal.getProperty(n);
        }
        if (dataholder != null && bl && dataholder.getType() != 1026) {
            dataholder = this.getCacheObject(dataholder, true);
        }
        return null;
    }

    private Dataholder getProperty(String string, int n, boolean bl, CacheField cacheField) throws CacheException {
        JBindDatabase jBindDatabase = (JBindDatabase)this.getDatabase();
        Dataholder dataholder = this.getPropertyFromZobjVal(n, bl);
        if (dataholder == null) {
            int n2 = bl ? 1 : 0;
            dataholder = jBindDatabase.getProperty(this.getOref(), n, n2, string);
        }
        if (bl && dataholder.getType() != 1026 && dataholder.getObject() != null) {
            dataholder = this.getCacheObject(dataholder, false);
        }
        if (dataholder != null && dataholder.getType() == 1026) {
            CacheObject cacheObject;
            String string2 = cacheField.getElementTypeName();
            String string3 = cacheField.getTypeName();
            if (string2 != null && string2.length() != 0 && (string3.equals("%Library.ListOfDataTypes") || string3.equals("%Library.ArrayOfDataTypes") || string3.startsWith("%Collection")) && (cacheObject = dataholder.getCacheObject()) != null && cacheObject.getUserData() == null) {
                cacheObject.setUserData(string2);
            }
        }
        return dataholder;
    }

    private boolean isCollection(String string) throws CacheException {
        CacheClass cacheClass = this.getCacheClass();
        CacheField cacheField = cacheClass.getField(string);
        return cacheField.isCollection();
    }

    private Dataholder getCacheObject(Dataholder dataholder, boolean bl) throws CacheException {
        JBindDatabase jBindDatabase = (JBindDatabase)this.getDatabase();
        String string = dataholder.getString();
        if (string == null || string.length() == 0) {
            return new Dataholder(1026, null);
        }
        int n = string.indexOf(64);
        if (n >= 0) {
            int n2 = Integer.parseInt(string.substring(0, n));
            if (bl && !jBindDatabase.isObjectAlive(n2)) {
                return null;
            }
            String string2 = string.substring(n + 1);
            CacheObject cacheObject = this.getDatabase().getCacheObjectUnsafe(string2, n2);
            cacheObject.setCacheClass(this.getDatabase().getCacheClass(string2));
            dataholder = new Dataholder(cacheObject);
        } else {
            int n3 = Integer.parseInt(string);
            if (bl && !jBindDatabase.isObjectAlive(n3)) {
                return null;
            }
            CacheObject cacheObject = this.getDatabase().getCacheObjectUnsafe("", n3);
            dataholder = new Dataholder(cacheObject);
        }
        return dataholder;
    }

    @Override
    public void setProperty(int n, int n2, int n3, int n4, String string, Dataholder dataholder) throws CacheException {
        this.setProperty(string, dataholder);
    }

    @Override
    public void setProperty(String string, Dataholder dataholder) throws CacheException {
        boolean bl;
        CacheClass cacheClass = this.getCacheClass();
        CacheField cacheField = cacheClass.getField(string);
        if (cacheField == null) {
            return;
        }
        int n = cacheField.getII();
        boolean bl2 = bl = !cacheField.isLiteral();
        if (bl && dataholder.getObject() == null && this.isCollection(string)) {
            this.setCollection(n, string, null, cacheField);
            return;
        }
        if (dataholder.getType() == 2048) {
            this.setCollection(n, string, dataholder.getCollection(), cacheField);
            return;
        }
        if (dataholder.getType() == 1026 && dataholder.getObject() != null && !this.getDatabase().equals(dataholder.getCacheObject().getDatabase())) {
            throw new CacheException("Object is not open on the server.");
        }
        int n2 = bl ? 1 : 0;
        ((JBindDatabase)this.getDatabase()).setProperty(this.getOref(), n, n2, string, dataholder);
        if (this.mZobjVal != null) {
            this.invalidateNode(n);
        }
        this.mState |= 0xFF10;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setCollection(int n, String string, Object object, CacheField cacheField) throws CacheException {
        Dataholder dataholder = this.getProperty(string, n, true, cacheField);
        CacheObject cacheObject = dataholder.getCacheObject();
        Object object2 = cacheObject.newJavaInstance();
        if (object == null) {
            if (object2 == null) {
                return;
            }
            if (object2 instanceof Collection) {
                ((Collection)object2).clear();
                return;
            } else {
                if (!(object2 instanceof Map)) throw new SystemError("Property " + string + " of object " + this.getCacheClass().getName() + "[" + this.getId() + "]" + " is not a collection but " + object2.getClass().getName());
                ((Map)object2).clear();
            }
            return;
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object2;
            collection.clear();
            collection.addAll((Collection)object);
            return;
        } else {
            if (!(object instanceof Map)) throw new SystemError("Can not set value of class " + object.getClass().getName() + " to a collection property " + string);
            Map map = (Map)object2;
            map.clear();
            map.putAll((Map)object);
        }
    }

    @Override
    public Dataholder[] runInstanceMethod(String string, int[] nArray, Dataholder[] dataholderArray, int n) throws CacheException {
        return ((JBindDatabase)this.getDatabase()).runMethod(this.getOref(), "", string, nArray, dataholderArray, n);
    }

    protected boolean isZobjvalCached() {
        return this.mZobjVal != null;
    }

    protected void invalidateZobjval() {
        this.mZobjVal = null;
    }

    private void invalidateNode(int n) {
        this.mZobjVal.makeNodeInvalid(n);
    }

    private boolean isValidNode(int n) {
        return this.mZobjVal.isValidNode(n);
    }

    private boolean isSwizzled(int n) throws CacheException {
        return this.mZobjVal.isSwizzled(n);
    }

    @Override
    public Oid getOid() throws CacheException {
        Oid oid = null;
        if (this.mZobjVal != null) {
            oid = this.mZobjVal.getOid();
        }
        if (oid == null || oid.undefined()) {
            oid = this.getOidInternal();
        }
        return oid;
    }

    public Oid getOidWithoutCall() {
        Oid oid = null;
        if (this.mZobjVal != null) {
            oid = this.mZobjVal.getOid();
        }
        return oid;
    }

    public String[] dumpZobjVal() throws CacheException, SQLException {
        return this.dumpZobjVal(false);
    }

    public String[] dumpZobjVal(boolean bl) throws CacheException, SQLException {
        String string;
        int n;
        Object[][] objectArray = ((JBindDatabase)this.getDatabase()).getZobjVal(this.getOref());
        int n2 = objectArray[0].length;
        String[] stringArray = new String[n2];
        int n3 = 0;
        for (n = 1; n < n2; ++n) {
            int n4 = (Integer)objectArray[1][n];
            string = (String)objectArray[0][n];
            stringArray[n] = "[" + n4 + "] " + string;
            if (bl || stringArray[n].length() <= n3) continue;
            n3 = stringArray[n].length();
        }
        if (!bl) {
            n = 1;
            while (n < n2) {
                String string2 = "";
                for (int i = stringArray[n].length(); i < n3; ++i) {
                    string2 = string2 + " ";
                }
                string = this.mZobjVal.mValueMap.get(new Integer(n));
                int n5 = n++;
                stringArray[n5] = stringArray[n5] + string2 + " | " + string;
            }
        }
        return stringArray;
    }

    protected boolean isOidSet() {
        if (this.mZobjVal == null) {
            return false;
        }
        return this.mZobjVal.getOid() != null;
    }

    protected void setOid(Oid oid) {
        this.mZobjVal.setOid(oid);
    }

    protected void setZobjval(ZObjectValueRep zObjectValueRep) {
        this.mZobjVal = zObjectValueRep;
        this.mState |= 0xFF01;
    }

    protected ZObjectValueRep getZobjval() {
        return this.mZobjVal;
    }

    @Override
    protected synchronized void close() throws CacheException {
        if (this.mServerSideReferences <= 0) {
            throw new ReferenceCountingException("Attempt to close closed object");
        }
        JBindDatabase jBindDatabase = (JBindDatabase)this.getDatabase();
        jBindDatabase.decreaseServerReferenceCount(this.getOref(), this.mServerSideReferences);
        this.mServerSideReferences = 0;
        if (Logger.getDebugReferenceCountLevel() > 0) {
            Logger.out.println("Closed oref = " + this.getOref());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finalize() throws Throwable {
        if (this.mServerSideReferences > 0 && this.mDB != null) {
            SysDatabase sysDatabase = this.mDB;
            synchronized (sysDatabase) {
                this.close();
            }
        }
        super.finalize();
    }
}

