/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache;

import com.intersys.objects.CacheException;
import com.intersys.objects.Logger;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class LazyList
extends AbstractSequentialList
implements Serializable {
    private Iterator mFeeder;
    private int mSize = -1;
    private int mMaxIndex;
    private boolean mLoaded;
    private ArrayList mContent;
    private Transformer mTransformer;
    private Initializer mInitializer;

    public LazyList() {
        this.mContent = new ArrayList();
    }

    public LazyList(Iterator iterator, Transformer transformer) {
        this.mTransformer = transformer;
        this.mContent = new ArrayList();
        this.setFeeder(iterator);
    }

    public LazyList(Initializer initializer, Transformer transformer) {
        this.mTransformer = transformer;
        this.mInitializer = initializer;
        this.mContent = new ArrayList();
        this.mMaxIndex = -1;
        this.mSize = -1;
        this.mLoaded = false;
    }

    @Override
    public ListIterator listIterator(int n) {
        this.init();
        return new I(n);
    }

    @Override
    public void clear() {
        this.mSize = 0;
        if (!this.mLoaded) {
            if (this.mFeeder == null) {
                this.mLoaded = true;
                return;
            }
            this.mFeeder = null;
            this.mLoaded = true;
        }
        this.mContent.clear();
        this.mMaxIndex = -1;
        super.clear();
    }

    @Override
    public int size() {
        this.init();
        if (this.mSize < 0) {
            return Integer.MAX_VALUE;
        }
        return this.mSize;
    }

    public int loadedSize() {
        return this.mMaxIndex + 1;
    }

    public boolean isLoaded() {
        return this.mLoaded;
    }

    public boolean isInitialized() {
        return this.mLoaded || this.mFeeder != null && this.mMaxIndex >= 0;
    }

    public void setFeeder(Iterator iterator) {
        this.mFeeder = iterator;
        this.mMaxIndex = -1;
        this.mSize = -1;
        this.mLoaded = false;
    }

    public void setSize(int n) {
        this.mSize = n;
    }

    public void setTransformer(Transformer transformer) {
        this.mTransformer = transformer;
    }

    public void setInitializer(Initializer initializer) {
        this.mFeeder = null;
        this.mInitializer = initializer;
        this.mLoaded = false;
    }

    public void setInitializer(List list) {
        this.mFeeder = null;
        this.mInitializer = new ChainedInitializer(list);
        this.mLoaded = false;
    }

    public void injectInitializerData(Object object) {
        if (this.mInitializer != null) {
            this.mInitializer.injectData(object);
        }
    }

    public void fetchNext(int n) {
        this.init();
        for (int i = 0; i < n; ++i) {
            if (!this.mFeeder.hasNext()) {
                if (this.mSize < 0) {
                    this.mSize = this.mMaxIndex + 1;
                }
                this.markAsLoaded();
                return;
            }
            Object object = this.mFeeder.next();
            ++this.mMaxIndex;
            object = this.transform(object);
            this.mContent.add(object);
        }
    }

    public LazyList fetchAll() {
        if (this.mLoaded) {
            return this;
        }
        this.init();
        while (this.mFeeder.hasNext()) {
            Object object = this.mFeeder.next();
            object = this.transform(object);
            this.mContent.add(object);
            ++this.mMaxIndex;
        }
        if (this.mSize < 0) {
            this.mSize = this.mMaxIndex + 1;
        }
        this.markAsLoaded();
        return this;
    }

    @Override
    public Object[] toArray() {
        this.fetchAll();
        return super.toArray();
    }

    private Object transform(Object object) {
        if (this.mTransformer != null) {
            try {
                object = this.mTransformer.transform(object);
            }
            catch (CacheException cacheException) {
                if (Logger.debugOn()) {
                    cacheException.printFullTrace(Logger.out);
                }
                throw new NoSuchElementException(cacheException.getMessage());
            }
            catch (Exception exception) {
                if (Logger.debugOn()) {
                    exception.printStackTrace(Logger.out);
                }
                throw new NoSuchElementException(exception.getMessage());
            }
        }
        return object;
    }

    private void init() {
        if (!this.mLoaded && this.mFeeder == null) {
            try {
                this.setFeeder(this.mInitializer.init());
                this.mInitializer.postInit(this);
            }
            catch (CacheException cacheException) {
                if (Logger.debugOn()) {
                    cacheException.printFullTrace(Logger.out);
                }
                throw new NoSuchElementException(cacheException.getMessage());
            }
            catch (Exception exception) {
                if (Logger.debugOn()) {
                    exception.printStackTrace(Logger.out);
                }
                throw new NoSuchElementException(exception.getMessage());
            }
        }
    }

    private void markAsLoaded() {
        this.mLoaded = true;
        this.mFeeder = null;
        this.mInitializer = null;
        this.mTransformer = null;
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (!this.isLoaded()) {
            this.fetchAll();
        }
        return this.mContent;
    }

    private class I
    implements ListIterator {
        private int mIdx;

        public I(int n) {
            this.mIdx = n - 1;
        }

        @Override
        public boolean hasNext() {
            if (this.mIdx < LazyList.this.mMaxIndex) {
                return true;
            }
            if (LazyList.this.isLoaded()) {
                return false;
            }
            if (LazyList.this.mFeeder == null) {
                throw new Error("LazyList is corrupted.");
            }
            boolean bl = LazyList.this.mFeeder.hasNext();
            if (!bl) {
                if (LazyList.this.mSize < 0) {
                    LazyList.this.mSize = LazyList.this.mMaxIndex + 1;
                }
                LazyList.this.markAsLoaded();
            }
            return bl;
        }

        @Override
        public Object next() {
            if (this.mIdx < LazyList.this.mMaxIndex) {
                ++this.mIdx;
                if (this.mIdx >= LazyList.this.mContent.size()) {
                    throw new Error("LazyList is corrupted.");
                }
                return LazyList.this.mContent.get(this.mIdx);
            }
            if (LazyList.this.mSize >= 0 && this.mIdx >= LazyList.this.mSize) {
                throw new NoSuchElementException("List Index Out of Range: " + this.mIdx + " >= " + LazyList.this.mSize);
            }
            if (LazyList.this.mFeeder == null) {
                throw new Error("LazyList is corrupted.");
            }
            Object object = null;
            while (LazyList.this.mMaxIndex <= this.mIdx) {
                object = LazyList.this.mFeeder.next();
                object = LazyList.this.transform(object);
                LazyList.this.mContent.add(object);
                LazyList.this.mMaxIndex++;
            }
            ++this.mIdx;
            return object;
        }

        @Override
        public boolean hasPrevious() {
            return this.mIdx > 0;
        }

        public Object previous() {
            if (this.mIdx < 0) {
                throw new NoSuchElementException();
            }
            --this.mIdx;
            return LazyList.this.mContent.get(this.mIdx);
        }

        @Override
        public int nextIndex() {
            return this.mIdx + 1;
        }

        @Override
        public int previousIndex() {
            return this.mIdx - 1;
        }

        @Override
        public void remove() {
            LazyList.this.fetchAll();
            LazyList.this.mContent.remove(this.mIdx);
            if (LazyList.this.mSize >= 0) {
                LazyList.this.mSize--;
            }
            LazyList.this.mMaxIndex--;
        }

        public void set(Object object) {
            LazyList.this.fetchAll();
            LazyList.this.mContent.set(this.mIdx, object);
        }

        public void add(Object object) {
            LazyList.this.fetchAll();
            LazyList.this.mContent.add(this.mIdx + 1, object);
            if (LazyList.this.mSize >= 0) {
                LazyList.this.mSize++;
            }
            LazyList.this.mMaxIndex++;
        }
    }

    private static class ChainedInitializer
    implements Initializer {
        private List mParent;

        public ChainedInitializer(List list) {
            this.mParent = list;
        }

        @Override
        public Iterator init() throws Exception {
            return this.mParent.iterator();
        }

        @Override
        public void postInit(LazyList lazyList) throws Exception {
            lazyList.setSize(this.mParent.size());
        }

        @Override
        public void injectData(Object object) {
        }
    }

    public static interface Initializer {
        public Iterator init() throws Exception;

        public void postInit(LazyList var1) throws Exception;

        public void injectData(Object var1);
    }

    public static interface Transformer {
        public Object transform(Object var1) throws Exception;
    }
}

